package com.xdja.poc.sdk.business;

import android.content.Context;
import android.content.Intent;

import com.xdja.poc.sdk.POCClient;
import com.xdja.poc.common.event.CancelNotification;
import com.xdja.poc.sdk.bean.POCMemberInfo;
import com.xdja.poc.sdk.business.bean.POCCallMessage;
import com.xdja.poc.sdk.event.GroupEvent;
import com.xdja.poc.sdk.event.GroupListEvent;
import com.xdja.poc.sdk.event.UpdateNotification;
import com.xdja.poc.common.utils.GlobalContext;
import com.xdja.poc.sdk.config.Constants;
import com.xdja.poc.sdk.config.GroupConfig;
import com.xdja.poc.sdk.db.entity.DBGroupEntity;

import org.greenrobot.eventbus.EventBus;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * janus-gateway-android-master
 * 功能  子进程系向主进程发消息的代理类,负责传递消息
 * 描述
 * created by Wwq : 2018/8/31
 */

@SuppressWarnings("ALL")
public class MessageProxy {
    public static final String USER_ID = "userId";
    public static final String ROOM_ID = "roomId";
    public static final String POC_GROUP = "poc_group";
    public static final String GROUP_EVENT_TYPE = "group_event_type";
    public static final String SWITCH_MUTE_STATUS = "switch_mute_status";
    /*录音*/
    public static final String MP3_RECORD_URI = "mp3_record_uri";
    public static final String UPLOAD_MP3_FILEID = "mp3_upload_fileid";
    public static final String UPLOAD_MP3_EOORCODE = "mp3_record_error";


    /**
     * 发送本地获取的所有频道
     * <p>
     * 主进程
     *
     * @param mList
     */
    public static void sendGetPocAllRoom(ArrayList<DBGroupEntity> mList) {
        EventBus.getDefault().post(new GroupListEvent(mList));
    }


    /**
     * 子进程
     * 自己离开频道时的回调,用于删除临时频道
     *
     * @param context
     * @param roomId
     * @param memberList
     */
    public static void sendSelfLeaveEvent(Context context, String roomId, List<String> memberList) {
        Intent intent = new Intent(PocBroadReceiver.ACTION);
        intent.setPackage(context.getPackageName());
        intent.putExtra(MessageProxy.ROOM_ID, roomId);
        String memberInfos = POCClient.getInstance().generateListString(memberList);
        intent.putExtra(PocBroadReceiver.FLAG, PocBroadReceiver.UPDATE_POC_CONVERSION_SELF_LEAVE);
        intent.putExtra(PocBroadReceiver.MEMBER_INFO, memberInfos);
        intent.putExtra(MessageProxy.GROUP_EVENT_TYPE, 0);
        context.sendBroadcast(intent);
    }

    /**
     * 子进程
     *
     * @param context
     * @param roomId
     * @param memberList
     */
    public static void sendUserChanged(Context context, String roomId, List<String> memberList) {
        Intent intent = new Intent(PocBroadReceiver.ACTION);
        intent.setPackage(context.getPackageName());
        intent.putExtra(MessageProxy.ROOM_ID, roomId);
        String memberInfos = POCClient.getInstance().generateListString(memberList);
        intent.putExtra(PocBroadReceiver.FLAG, PocBroadReceiver.UPDATE_POC_CONVERSION_SELF_LEAVE);
        intent.putExtra(PocBroadReceiver.MEMBER_INFO, memberInfos);
        context.sendBroadcast(intent);
    }

    /**
     * 发送用户在频道的行为(离开,加入等)广播,进行UI通信
     *
     * @param context
     * @param roomId
     * @param memberList
     * @param eventType
     */
    public static void sendUserChanged(Context context, String roomId, List<String> memberList, int eventType) {
        Intent intent = new Intent(PocBroadReceiver.ACTION);
        intent.setPackage(context.getPackageName());
        intent.putExtra(MessageProxy.ROOM_ID, roomId);
        String memberInfos = POCClient.getInstance().generateListString(memberList);
        intent.putExtra(PocBroadReceiver.FLAG, PocBroadReceiver.UPDATE_POC_GROUP_EVENT_CHANGED);
        intent.putExtra(PocBroadReceiver.MEMBER_INFO, memberInfos);
        int status = GroupConfig.GROUP_HANGUP;
        int behavior = 0;
        switch (eventType) {
            case Constants.ROOM_LEAVE_SUCCESS:
                status = GroupConfig.GROUP_FREE;
                behavior = PocBroadReceiver.ROOM_USER_LEAVE_SUCCESS;
                break;
            case Constants.ROOM_JOIN_SUCCESS:
                status = GroupConfig.GROUP_FREE;
                behavior = PocBroadReceiver.ROOM_USER_JOIN_SUCCESS;
                break;
            case Constants.ROOM_OTHER_TBCP_REQUEST_SUCCESS:
                status = GroupConfig.GROUP_BUSY;
                behavior = 0;
                break;
            case Constants.ROOM_OTHER_TBCP_RELEASE_SUCCESS:
                status = GroupConfig.GROUP_FREE;
                behavior = 0;
                break;
            case Constants.ROOM_SEVER_DISCONNECT:
                status = GroupConfig.GROUP_HANGUP;
                behavior = Constants.ROOM_SEVER_CONNECT_FAILED;
                break;
            case Constants.ROOM_DESTROY_SUCCESS:
                status = GroupConfig.GROUP_HANGUP;
                behavior = 0;//Constants.ROOM_SEVER_CONNECT_FAILED;
                break;
            case Constants.ROOM_SEVER_CONNECT_FAILED:
                status = GroupConfig.GROUP_HANGUP;
                behavior = Constants.ROOM_SEVER_CONNECT_FAILED;
                break;
            case Constants.ROOM_SERVER_LOAD_FAILED:
                status = GroupConfig.GROUP_HANGUP;
                behavior = Constants.ROOM_SEVER_CONNECT_FAILED;
                //Constants.ROOM_SEVER_CONNECT_FAILED;
                break;
        }
        intent.putExtra(MessageProxy.GROUP_EVENT_TYPE, status);
        intent.putExtra(PocBroadReceiver.STATUS_ROOM_USER_LEAVE_OR_JOIN, behavior);
        context.sendBroadcast(intent);
    }

    public static void sendUserIncomeOrLeave(Context context, String roomId, String userId, int flag) {
        Intent intent = new Intent(PocBroadReceiver.ACTION);
        intent.setPackage(context.getPackageName());
        intent.putExtra(MessageProxy.ROOM_ID, roomId);
        intent.putExtra(PocBroadReceiver.MEMBER_INFO, userId);
        int behavior = 0;
        switch (flag) {
            case Constants.ROOM_LEAVE_SUCCESS:
                behavior = PocBroadReceiver.ROOM_USER_LEAVE_SUCCESS;
                break;
            case Constants.ROOM_JOIN_SUCCESS:
                behavior = PocBroadReceiver.ROOM_USER_JOIN_SUCCESS;
                break;

        }
        intent.putExtra(PocBroadReceiver.FLAG, PocBroadReceiver.FLAG_USER_INCOME_OR_LEAVE);
        intent.putExtra(PocBroadReceiver.STATUS_ROOM_USER_LEAVE_OR_JOIN, behavior);
        context.sendBroadcast(intent);
    }

    public static void sendMeIncomingRoom(Context context, List<String> memberList, String roomId) {
        Intent intent = new Intent(PocBroadReceiver.ACTION);
        intent.setPackage(context.getPackageName());
        String memberInfos = POCClient.getInstance().generateListString(memberList);
        intent.putExtra(PocBroadReceiver.FLAG, PocBroadReceiver.FLAG_ME_INCOMING_ROOM);
        intent.putExtra(PocBroadReceiver.MEMBER_INFO, memberInfos);
        intent.putExtra(MessageProxy.ROOM_ID, roomId);
        context.sendBroadcast(intent);
    }


    public static void reBindService(Context context) {
        Intent intent = new Intent(PocBroadReceiver.ACTION);
        intent.setPackage(context.getPackageName());
        intent.putExtra(PocBroadReceiver.FLAG, PocBroadReceiver.FLAG_REBIND_SERVICE);
        context.sendBroadcast(intent);
    }

    /**
     * 发送通知栏的状态
     *
     * @param isShow false:消失 true 显示
     */
    public static void sendNotificationStaus(boolean isShow) {
        CancelNotification cancelNotification = new CancelNotification(isShow);
        EventBus.getDefault().post(cancelNotification);
    }

    /**
     * 这个方法只适用于 "非对讲声音"  "将要进来时" "对对讲频道静音" 以及 "在这个声音结束后恢复原来的状态"
     * 发送切换频道mute状态广播
     *
     * @param enable true:静音 false: 恢复原来状态
     */
    public static void sendSwitchMuteStatus(boolean enable) {
        Intent intent = new Intent();
        intent.setAction(POCService.ACTION_POC_SWITCH_MUTE_STATUS);
        intent.putExtra(SWITCH_MUTE_STATUS, enable);
        intent.setPackage(GlobalContext.getContext().getPackageName());
        GlobalContext.getContext().sendBroadcast(intent);
    }

    public static void updateNotificationCallMessage(Context context, POCCallMessage userName, boolean isRing) {
        EventBus.getDefault().post(new UpdateNotification(isRing, userName));
    }

    /**
     * 通知退出
     */
    public static void notifyUserLogOut() {
        EventBus.getDefault().post(new UpdateNotification(false));
    }

    /**
     * 生成频道时间所需要的数据对象
     *
     * @param code
     * @param position
     * @param roomId
     * @param type
     * @return
     */
    public static GroupEvent generateGroupEvent(int code, int position, String roomId, int type, String memberIds, Map<String, POCMemberInfo> userInfos) {
        GroupEvent event = new GroupEvent();
        event.setCode(code);
        event.setPosition(position);
        event.setRoomId(roomId);
        event.setEventTyep(type);
        event.setUserInfo(userInfos);
        event.setMembers(memberIds);
        return event;
    }

    /**
     * 发送录音完成广播
     *
     * @param context
     * @param roomId
     * @param mp3RecordUri
     */
    public static void sendRecordCompletedBroadcast(Context context, String roomId, String mp3RecordUri) {
        Intent target = new Intent(PocBroadReceiver.ACTION);
        target.setPackage(context.getPackageName());
        target.putExtra(MessageProxy.ROOM_ID, roomId);
        target.putExtra(PocBroadReceiver.FLAG, PocBroadReceiver.CUSTOM_RECORD_COMPLETED);
        target.putExtra(MessageProxy.MP3_RECORD_URI, mp3RecordUri);
        target.putExtra(PocBroadReceiver.BEHAVIOR, PocBroadReceiver.CUSTOM_RECORD_COMPLETED);
        context.sendBroadcast(target);
    }

    /**
     * 发送录音上传完成广播
     *
     * @param context
     * @param fileId
     * @param mp3RecordUri
     * @param errorCode
     */
    public static void sendUploadRecordResultBroadcast(Context context, String fileId, String mp3RecordUri, int errorCode) {
        Intent target = new Intent(PocBroadReceiver.ACTION);
        target.setPackage(context.getPackageName());
        target.putExtra(MessageProxy.UPLOAD_MP3_FILEID, fileId);
        target.putExtra(PocBroadReceiver.FLAG, PocBroadReceiver.CUSTOM_RECORD_UPLOAD_COMPLETED);
        target.putExtra(MessageProxy.MP3_RECORD_URI, mp3RecordUri);
        target.putExtra(MessageProxy.UPLOAD_MP3_EOORCODE, errorCode);
        target.putExtra(PocBroadReceiver.BEHAVIOR, PocBroadReceiver.CUSTOM_RECORD_UPLOAD_COMPLETED);
        context.sendBroadcast(target);
    }

    /**
     * 发送提交录音记录广播
     *
     * @param context
     * @param mp3RecordUri
     * @param errorCode
     */
    public static void sendCommitRecordResultBroadcast(Context context, String mp3RecordUri, int errorCode) {
        Intent target = new Intent(PocBroadReceiver.ACTION);
        target.setPackage(context.getPackageName());
        target.putExtra(PocBroadReceiver.FLAG, PocBroadReceiver.CUSTOM_RECORD_COMMIT_COMPLETED);
        target.putExtra(MessageProxy.MP3_RECORD_URI, mp3RecordUri);
        target.putExtra(MessageProxy.UPLOAD_MP3_EOORCODE, errorCode);
        target.putExtra(PocBroadReceiver.BEHAVIOR, PocBroadReceiver.CUSTOM_RECORD_COMMIT_COMPLETED);
        context.sendBroadcast(target);
    }
}
