package com.xdja.poc.sdk.record.http;

import java.util.Map;

import okhttp3.Request;

/**
 * Created by gouhao on 1/16/2018.
 */

@SuppressWarnings("ALL")
public interface IHttpClient {
    int E_IO = -1;
    int E_RESPONSE_BODY = -2;

    /**
     * method type
     */
    String METHOD_TYPE_POST = "POST";
    String METHOD_TYPE_GET = "GET";
    String METHOD_TYPE_PUT = "PUT";
    String METHOD_TYPE_DELETE = "DELETE";
    String METHOD_TYPE_PATHCH = "PATCH";

    interface Callback {
        void onSuccess(int requestId, String response);

        void onFailed(int requestId, int code, String msg);
    }

    interface UploadFileCallback extends Callback {
        void onProgress(int requestId, long uploadSize, long totalSize);
    }

    /**
     * 执行网络请求，默认POST方法
     *
     * @param url
     * @param params
     * @param headers
     * @param callback
     * @deprecated use {@link #request(HttpRequest, Callback)}
     */
    int exec(String url, Map<String, Object> params, Map<String, String> headers, Callback callback);

    /**
     * 识别method的请求操作
     *
     * @param methodType
     * @param url
     * @param obj        parms
     * @param headers
     * @param callback
     * @deprecated use {@link #request(HttpRequest, Callback)}
     */
    int exec(String methodType, String url, Object obj, Map<String, String> headers, Callback callback);

    /**
     * @param url
     * @param params
     * @param headers
     * @param callback
     * @deprecated use {@link #request(HttpRequest, Callback)}
     */
    int execFormData(String url, Map<String, String> params, Map<String, String> headers, Callback callback);

    /**
     * @deprecated use {@link #request(HttpRequest, Callback)}
     */
    int execGet(String url, Map<String, String> headers, Callback callback);


    /**
     * 取消请求
     *
     * @param requestId
     */
    void cancelRequest(int requestId);

    int request(HttpRequest request, Callback callback);

    int uploadFile(HttpUploadFileRequest request, UploadFileCallback callback);

    int downloadFile(Request request, okhttp3.Callback callback);
}
