package com.xdja.poc.sdk.ui.conversion;

import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentManager;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;

import com.xdja.poc.common.annotation.BindEventBus;
import com.xdja.poc.common.annotation.TitleViewAnnotation;
import com.xdja.poc.common.event.NetWorkConnectEvent;
import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.common.utils.PreferenceHelper;
import com.xdja.poc.common.utils.StringUtils;
import com.xdja.poc.common.utils.ToastUtils;
import com.xdja.poc.sdk.POCClient;
import com.xdja.poc.sdk.R;
import com.xdja.poc.sdk.bean.POCMemberInfo;
import com.xdja.poc.sdk.business.EventPropxy;
import com.xdja.poc.sdk.business.webrtc.apprtc.AppRTCAudioManager;
import com.xdja.poc.sdk.config.Constants;
import com.xdja.poc.sdk.config.GroupConfig;
import com.xdja.poc.sdk.config.UserConfig;
import com.xdja.poc.sdk.db.entity.DBGroupEntity;
import com.xdja.poc.sdk.manager.AMnager;
import com.xdja.poc.sdk.proxy.IChannelInfoIntoDBCallBack;
import com.xdja.poc.sdk.proxy.POCUiKitProxyImpl;
import com.xdja.poc.sdk.record.play.MediaManger;
import com.xdja.poc.sdk.ui.main.fragment.POCConversationFragment;
import com.xdja.poc.sdk.utils.GroupUtils;
import com.xdja.poc.sdk.utils.PocUtils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;

/**
 * janus-gateway-android-master
 * 功能 poc对讲主界面
 * 描述 实现对讲流程
 */
@SuppressWarnings("ALL")
@BindEventBus
@TitleViewAnnotation
public class POCConversionActivity extends BaseScreenActivity {
    private String TAG = "POCConversionActivity";
    private POCConversationFragment pocConversationFragment;
    public DBGroupEntity group;
    private String mUserId;
    private String channelName;
    private boolean isCallMember = false;
    private Disposable mDisposable;
    public List<String> mCallUserIdList = new ArrayList<>();
    private boolean isDestroy = false;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    @Override
    protected int getTranslucentStatusBarColor() {
        return getResources().getColor(R.color.common_main_color);
    }

    @Override
    protected void initView() {
        super.initView();
        mUserId = PreferenceHelper.getString(UserConfig.LOGIN_ACCOUNT, "");
//        initAudio();
        getTitleBarView().setTextSize(20);
        getTitleBarView().setBackgroundRecource(com.xdja.poc.sdk.R.color.poc_bg_color_blue);
        getTitleBarView().setTitleColor(getResources().getColor(com.xdja.poc.sdk.R.color.poc_btn_text_press));
        getTitleBarView().setLeftViewRecource(com.xdja.poc.sdk.R.drawable.poc_tiltebar_left);
        getTitleBarView().setLeftViewClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                onBackPressed();
            }
        });
//        getTitleBarView().setRightViewRecource(R.mipmap.poc_iv_set_icon);
        getTitleBarView().setRightText(getString(R.string.poc_menu_set));
        getTitleBarView().setRightTextColor(getResources().getColor(com.xdja.poc.sdk.R.color.common_white_color));
        getTitleBarView().setRightTextSize(16);
        group = (DBGroupEntity) getIntent().getSerializableExtra("group");
        isCallMember = getIntent().getBooleanExtra("isCallMember", false);

        channelName = getIntent().getStringExtra(GroupConfig.CHANNEL_NAME);
        updateChannelName(channelName);
        pocConversationFragment = POCConversationFragment.newInstance();
        Bundle bundle = new Bundle();
        bundle.putSerializable("DBGroupEntity", group);
        pocConversationFragment.setArguments(bundle);
        FragmentManager fm = getSupportFragmentManager();
        fm.beginTransaction()
                .add(com.xdja.poc.sdk.R.id.content, pocConversationFragment)
                .commit();
        pocConversationFragment.setUpdateListener(new POCConversationFragment.IUpdateGroupListener() {
            @Override
            public void onPttKey(boolean pttStatus) {
                if (group != null) {
                    group.setIsPttKey(pttStatus ? 1 : 0);
                }
            }

            @Override
            public void onUpdateName(String channelName1) {
                if (group != null) {
                    group.setRoomName(channelName1);
                }
                channelName = channelName1;
                getTitleBarView().setTile(channelName);
            }

            @Override
            public void onUpdatePwd(String channelPwd) {
                if (group != null) {
                    group.setChannelPwd(channelPwd);
                }
            }

            @Override
            public void onUpdatePwdMode(boolean channelPwdMode) {
                if (group != null) {
                    group.setChannelPwdMode(channelPwdMode ? 1 : 0);
                }
            }
        });
        registerCallBack();

    }

    private void updateChannelName(String channelName) {
        if (channelName == null) {
            return;
        }
        if (channelName.equals(UserConfig.UN_DEFINE)) {
            List<POCMemberInfo> memberInfoList = POCClient.getInstance().generateStringToList(group.getMemeberIds());
            //            group.setRoomName(strings[1]);
            channelName = GroupUtils.generateGroupMemberTempRoomName((ArrayList<POCMemberInfo>) memberInfoList);
        }
        this.channelName = channelName;
        group.setRoomName(channelName);
        getTitleBarView().setTile(channelName);
    }

    @Override
    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        init();
        group = (DBGroupEntity) intent.getSerializableExtra("group");
        channelName = intent.getStringExtra(GroupConfig.CHANNEL_NAME);
        isCallMember = intent.getBooleanExtra("isCallMember", false);
        updateChannelName(channelName);
        pocConversationFragment.initData(group);
        registerCallBack();
    }

    private void registerCallBack() {
        pocConversationFragment.setCallBack(new ICallBack() {
            @Override
            public void onCallBack(DBGroupEntity entity) {
                int status = group.getStatus();
                if (StringUtils.isEmpty(entity.getRoomName()) || entity.getRoomName().equals(UserConfig.UN_DEFINE)) {
                    channelName = group.getRoomName();
                } else {
                    channelName = entity.getRoomName();
                }
                group = entity;
                group.setStatus(status);
                group.setRoomName(channelName);
                getTitleBarView().setTile(channelName);
            }
        });

        if (isCallMember) {
            List<String> mTemp = new ArrayList<>();
            if (!StringUtils.isEmpty(group.getMemeberIds())) {
                List<POCMemberInfo> memberInfoList = POCClient.getInstance().generateStringToList(group.getMemeberIds());
                if (memberInfoList != null && memberInfoList.size() > 0) {
                    for (POCMemberInfo info : memberInfoList) {
                        mTemp.add(info.getAccount());
                    }
                }
            }
            handleCallMessage(isCallMember, mTemp, group.getRooomId());
        }

    }

    @Override
    protected void initEvent() {
        getTitleBarView().setRightTVClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                POCUiKitProxyImpl.getInstance().notifyConversionViewMenuClick(group, channelName);
            }
        });
        /**
         * 等待服务端数据入库后的通知
         */
        POCUiKitProxyImpl.getInstance().setmChannelInfoDBCallBack(new IChannelInfoIntoDBCallBack() {
            @Override
            public void onChnnelInfoIntoDB() {
                new Handler(getMainLooper()).post(new Runnable() {
                    @Override
                    public void run() {
                        LogUtils.DLog(TAG, "onChnnelInfoIntoDB: " + POCConversionActivity.this.isDestroyed());
                        if (POCConversionActivity.this.isDestroyed() || isDestroy) {
                            return;
                        }
                        EventPropxy.postSetPttKey(group.getRooomId(), true);
                    }
                });

            }
        });
    }

    @Override
    protected int generateLayout() {
        return com.xdja.poc.sdk.R.layout.poc_conversation_activity;
    }

    @Override
    public void onBackPressed() {
        super.onBackPressed();
        if (getPackageName().equals(UserConfig.AN_TONG_PACKNAME)) {
            AMnager.startPOCMainActivity(this, true, "");
        }
        finish();
        //        if (!isContainsMainActivity()) {
//        } else {
//        }
    }

    @Override
    public void finish() {
        super.finish();
    }

    @Override
    protected void onPause() {
        super.onPause();
        LogUtils.ILog("onPause....");
        releaseTbcp();
    }

    private void releaseTbcp() {
        if (isPressDown && isRequestTbcp) {
            pocConversationFragment.releaseTbcp();
        }
        isPressDown = false;
        isRequestTbcp = false;
    }

    @Override
    protected void onResume() {
        super.onResume();
        LogUtils.ILog("onResume....");
        if (Constants.isReject) {
            onBackPressed();
        }
    }

    @Override
    public boolean dispatchTouchEvent(MotionEvent ev) {
        pocConversationFragment.dispatchTouchEvent(POCConversionActivity.this, ev);
        return super.dispatchTouchEvent(ev);
    }

    /**
     * 初始化音频
     */
    public void initAudio() {
        AppRTCAudioManager audioManager = AppRTCAudioManager.create(this);
        audioManager.setDefaultAudioDevice(AppRTCAudioManager.AudioDevice.SPEAKER_PHONE);
        audioManager.start(new AppRTCAudioManager.AudioManagerEvents() {
            // This method will be called each time the number of available audio
            // devices has changed.
            @Override
            public void onAudioDeviceChanged(AppRTCAudioManager.AudioDevice audioDevice, Set<AppRTCAudioManager.AudioDevice> availableAudioDevices) {
                LogUtils.DLog(TAG, "onAudioManagerDevicesChanged: " + availableAudioDevices + ", "
                        + "selected: " + audioDevice);
            }
        });
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
//        audioManager.stop();
        isDestroy = true;
        Constants.isScreenOn = false;
        POCUiKitProxyImpl.getInstance().setmChannelInfoDBCallBack(null);
        release();
        LogUtils.ELog("Zhangs", "121 : activity onDestroy");
        cancel();
    }

    @Override
    protected void onNetChanged(NetWorkConnectEvent netWorkConnectEvent) {
        super.onNetChanged(netWorkConnectEvent);
        if ((boolean) netWorkConnectEvent.getT()) {
            POCUiKitProxyImpl.getInstance().notifyRefreshChannelMembersInfo(group);
        } else {
            group.setStatus(GroupConfig.GROUP_HANGUP);
        }
    }


    public interface ICallBack {
        void onCallBack(DBGroupEntity entity);
    }

    public void removeFromCallList(String speakerId, String userName) {
        boolean isExistCallMember = false;
        if (mCallUserIdList != null && mCallUserIdList.size() > 0) {
            Iterator<String> iterator = mCallUserIdList.iterator();
            while (iterator.hasNext()) {
                String userId = iterator.next();
                if (!StringUtils.isEmpty(userId) && !StringUtils.isEmpty(speakerId)) {
                    if (speakerId.equals(userId)) {
                        iterator.remove();
                        isExistCallMember = true;
                    }
                }
            }
            if (mCallUserIdList.size() <= 0) {
                mCallUserIdList.clear();
                cancel();
            }
        } else {
            cancel();
        }
        if (isExistCallMember && !TextUtils.isEmpty(userName)) {
//            ToastUtils.showToast(userName + getString(R.string.poc_user_busy));
            LogUtils.DLog(TAG, userName + getString(R.string.poc_user_busy));
        }
    }

    public void handleCallMessage(boolean isCall, List<String> mUserIds, String channelId) {
        if (isCall) {
            if (mDisposable != null && !mDisposable.isDisposed()) {
                mDisposable.dispose();
            }
            if (mUserIds == null || mUserIds.size() <= 0) {
                return;
            }
            Iterator<String> iterator = mUserIds.iterator();
            while (iterator.hasNext()) {
                String next = iterator.next();
                if (next.equals(mUserId)) {
                    iterator.remove();
                    break;
                }
            }
            mCallUserIdList.clear();
            mCallUserIdList.addAll(mUserIds);
            Observable.timer(PreferenceHelper.getInt(UserConfig.CALL_WAITING_TIME, 30), TimeUnit.SECONDS)
                    .observeOn(AndroidSchedulers.mainThread())
                    .subscribe(new Observer<Long>() {
                        @Override
                        public void onSubscribe(@io.reactivex.annotations.NonNull Disposable d) {
                            mDisposable = d;
                        }

                        @Override
                        public void onNext(@io.reactivex.annotations.NonNull Long aLong) {
                            // TODO: 2018/10/19 SDK: 发送延迟推送
                            if (mCallUserIdList != null && mCallUserIdList.size() > 0) {
                                Map<String, POCMemberInfo> userInfos = pocConversationFragment.getUserInfos();
                                String userId = mCallUserIdList.get(mCallUserIdList.size() - 1);
                                String userName = userId;
                                if (userInfos != null && userInfos.size() > 0 && userInfos.containsKey(userId)) {
                                    userName = userInfos.get(userId).getName();
                                } else {
                                    if (UserConfig.userNameMap != null && UserConfig.userNameMap.size() > 0 && UserConfig.userNameMap.containsKey(channelId)) {
                                        Map<String, POCMemberInfo> map = UserConfig.userNameMap.get(group.getRooomId());
                                        if (map != null && map.size() > 0 && map.containsKey(userId)) {
                                            userName = map.get(userId).getName();
                                            assert userInfos != null;
                                            userInfos.put(userId, map.get(userId));
                                        }

                                    }
                                }
//                                showMessage(userName + getString(R.string.poc_user_busy));
                                LogUtils.DLog(TAG, userName + getString(R.string.poc_user_busy));
                            }
                            cancel();
                        }

                        @Override
                        public void onError(@io.reactivex.annotations.NonNull Throwable e) {
                            cancel();
                        }

                        @Override
                        public void onComplete() {
                            cancel();
                        }
                    });
        }
    }

    /**
     * 取消
     */
    private void cancel() {
        if (mDisposable != null && !mDisposable.isDisposed()) {
            mDisposable.dispose();
        }
        mDisposable = null;
    }

    private long lastTime;
    private boolean isPressDown = false;//是否按下音量键
    private boolean isRequestTbcp = false;//是否已经发起过takeTbcp

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        // 是否拦截音量侧键
        if (!PocUtils.isInterceptVolumKey()) {
            return super.onKeyDown(keyCode, event);
        }
        //add by wwq ,headset condition
        if (Build.MODEL.equals(Constants.EXCLUDE_PHONE_MODEL)) {
            return super.onKeyDown(keyCode, event);
        }
        if (MediaManger.getInstance().isHeadsetOn()) {
            MediaManger.getInstance().setReceiverModeOn();
            return super.onKeyDown(keyCode, event);
        }
        if (AppRTCAudioManager.create(this).hasWiredHeadset()) {
            return super.onKeyDown(keyCode, event);
        }
        if (PreferenceHelper.getInt(mUserId + "_" + UserConfig.PTT_KEY_CODE, 0) == keyCode) {
            if (!isPressDown) {
                isPressDown = true;
                // bug50964:多端登录，执法仪强插状态下，按下PTT不能抢占手机端话语权
                // 解决策略：执法仪版本自己在讲话中不做特殊处理，与手机端保持一致
//                if (getPackageName().contains("zfy")) {
//                    if (POCClient.getInstance().isSelfSpeaking(mUserId, group.getRooomId())) {
////                        String tips = PreferenceHelper.getString(UserConfig.POC_SELF_SPEAKING_TIPS, getString(R.string.poc_current_self_speaking));
////                        ToastUtils.showToast(tips);
//                        return super.onKeyDown(keyCode, event);
//                    }
//                }
                boolean roomForceInsertStatus = POCClient.getRoomForceInsertStatus(group.getRooomId());
                if (!roomForceInsertStatus) {
                    if (POCClient.getAllSpeakers() != null && POCClient.getAllSpeakers().containsKey(group.getRooomId())) {
                        // TODO: 2019/2/21 如果有人在讲话，则直接return
                        isPressDown = false;
                        isRequestTbcp = false;
                        return super.onKeyDown(keyCode, event);
                    }
                }
                if (!POCUiKitProxyImpl.getInstance().isCanTalk()) {
                    String desc = PreferenceHelper.getString(UserConfig.TOAST_TALKING_DESC, getString(R.string.poc_audio_focus_busy));
                    ToastUtils.showToast(desc);
                    return super.onKeyDown(keyCode, event);
                }
                isRequestTbcp = true;
                pocConversationFragment.takeTbcp();
//                if (POCClient.isSpeaking(group.getRooomId(), mUserId)) {
//                    isRequestTbcp = true;
//                    pocConversationFragment.takeTbcp();
//                } else {
//                    return super.onKeyDown(keyCode, event);
//                }
            } else {
                return isRequestTbcp || super.onKeyDown(keyCode, event);
            }
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    @Override
    public boolean onKeyUp(int keyCode, KeyEvent event) {
        releaseTbcp();
        return super.onKeyUp(keyCode, event);
    }
}
