package com.xdja.poc.sdk.ui.main.holder;

import android.annotation.SuppressLint;
import android.support.annotation.IdRes;
import android.text.Html;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.jude.easyrecyclerview.adapter.BaseViewHolder;
import com.xdja.poc.common.utils.PreferenceHelper;
import com.xdja.poc.common.utils.StringUtils;
import com.xdja.poc.sdk.POCClient;
import com.xdja.poc.sdk.R;
import com.xdja.poc.sdk.bean.POCMemberInfo;
import com.xdja.poc.sdk.business.PocBroadReceiver;
import com.xdja.poc.sdk.config.Constants;
import com.xdja.poc.sdk.config.GroupConfig;
import com.xdja.poc.sdk.db.entity.DBGroupEntity;

import java.util.List;

/**
 * janus-gateway-android-master
 * 功能
 * 描述
 * created by Wwq : 2018/9/3
 */

@SuppressWarnings("ALL")
public class PocSearchGroupListHolder extends BaseViewHolder<DBGroupEntity> {
    private TextView tvGroupName;
    private TextView tvMemberStatus;
    private ImageView ivAudioSwitch;
    private TextView tvMemberCount;
    private String keyWords = "";
    private ImageView ivGroupAvatar;
    private TextView tvPttView;
    private LinearLayout itemRootView;
    private RelativeLayout rlAudioSwitch;
    private onViewClickListener mListener;

    public PocSearchGroupListHolder(ViewGroup itemView, String keyWords, onViewClickListener onViewClickListener) {
        super(itemView, R.layout.poc_fragment_group_list_item);
        this.mListener = onViewClickListener;
        tvGroupName = $(R.id.tv_group_name);
        tvMemberStatus = $(R.id.tv_member_status);
        ivAudioSwitch = $(R.id.iv_audio_switch);
        tvMemberCount = $(R.id.tv_member_count);
        rlAudioSwitch = $(R.id.rl_audio_switch);
        this.keyWords = keyWords;
        ivGroupAvatar = $(R.id.iv_group_avatar);
        tvPttView = $(R.id.iv_ptt_view);
        itemRootView = $(R.id.rl_item_root);
    }


    @SuppressLint("SetTextI18n")
    @Override
    public void setData(DBGroupEntity data) {
        super.setData(data);
        tvGroupName.setText(StringUtils.getSpanned(data.getRoomName(), keyWords, getContext()));
        String memberStatus;
        itemView.setBackgroundColor(data.getIsTopStick() ?
                getContext().getResources().getColor(R.color.poc_item_bg) :
                getContext().getResources().getColor(R.color.common_white_color));

        if (data.getIsSilence()) {
            ivAudioSwitch.setImageResource(R.drawable.poc_audio_off);
        } else {
            ivAudioSwitch.setImageResource(R.drawable.poc_audio_on);
        }
        if (data.getIsPttKey() && PreferenceHelper.getBoolean(Constants.IS_CUSTOM_PTT_TIPS, true)) {
            tvPttView.setVisibility(View.VISIBLE);
        } else {
            tvPttView.setVisibility(View.GONE);
        }
        ivGroupAvatar.setBackgroundResource(R.mipmap.poc_iv_temp_group_avatar);
//        if (data.getGroupType() == 1) {
//        } else {
//            ivGroupAvatar.setBackgroundResource(R.mipmap.poc_iv_fixed_group_avatar);
//        }
        String memeberIds = data.getMemeberIds();
        List<POCMemberInfo> allCountList = POCClient.getInstance().generateStringToList(memeberIds);
        int[] memberOnLineCount = new int[2];
        memberOnLineCount[0] = data.getOnLineCount();
        memberOnLineCount[1] = allCountList == null ? 0 : allCountList.size();
        String memberOnLineCountStatus = getContext().getResources().getString(R.string.poc_member_online_count_status);
        if (memberOnLineCount[0] <= 0 || data.getStatus() == GroupConfig.GROUP_HANGUP) {
            memberOnLineCount[0] = 0;
            data.setStatus(0);
        }
        if (data.getStatus() == GroupConfig.GROUP_HANGUP) {
            tvMemberStatus.setText(getContext().getResources().getString(R.string.poc_channel_hanup));
            itemRootView.setBackground(getContext().getDrawable(R.drawable.poc_list_select_off_bg));
            tvMemberStatus.setBackgroundResource(R.drawable.poc_drawable_bg_red);
            tvMemberStatus.setTextColor(getContext().getResources().getColor(R.color.poc_red));
        } else if (data.getStatus() == PocBroadReceiver.ROOM_OTHER_RELEASE_TBCP_SUCCESS || data.getStatus() == GroupConfig.GROUP_FREE) {
            tvMemberStatus.setText(getContext().getResources().getString(R.string.poc_channel_free));
            itemRootView.setBackground(getContext().getDrawable(R.drawable.poc_list_select_on_bg));
            tvMemberStatus.setBackgroundResource(R.drawable.poc_bg_green);
            tvMemberStatus.setTextColor(getContext().getResources().getColor(R.color.poc_green));
        } else if (data.getStatus() == GroupConfig.GROUP_BUSY) {
            itemRootView.setBackground(getContext().getDrawable(R.drawable.poc_list_select_on_bg));
            if (!TextUtils.isEmpty(data.getSpeakerUserName())) {
                if (data.getSpeakerUserName().contains("其他设备")) {
                    tvMemberStatus.setText("您正在其他设备讲话");
                } else {
                    tvMemberStatus.setText(StringUtils.splitDisplayName(3, data.getSpeakerUserName()) + "  正在讲话");
                }
            }
            tvMemberStatus.setBackgroundResource(R.drawable.poc_bg_green);
            tvMemberStatus.setTextColor(getContext().getResources().getColor(R.color.poc_green));
        }
        if (memberOnLineCount[0] > memberOnLineCount[1]) {
            memberOnLineCount[0] = memberOnLineCount[1];
        }
        memberStatus = "<font color='#808080'>" + memberOnLineCountStatus + "</font> " + "<font color='#7eb606'><strong>" + memberOnLineCount[0] + "</strong></font> / " + "<font color='#808080'>" + memberOnLineCount[1] + "</font>";
        tvMemberCount.setText(Html.fromHtml(memberStatus));
        rlAudioSwitch.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                mListener.onClick(v.getId(), getAdapterPosition());
            }
        });
    }

    public void setSearchKey(String searchKey) {
        this.keyWords = searchKey;
    }

    public interface onViewClickListener {
        void onClick(@IdRes int id, int position);
    }
}
