package com.xdja.poc.sdk.utils;

import android.text.TextUtils;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.common.utils.PinyinUtil;
import com.xdja.poc.common.utils.PreferenceHelper;
import com.xdja.poc.common.utils.StringUtils;
import com.xdja.poc.sdk.POCClient;
import com.xdja.poc.sdk.bean.POCMemberInfo;
import com.xdja.poc.sdk.config.Constants;
import com.xdja.poc.sdk.config.GroupConfig;
import com.xdja.poc.sdk.config.UserConfig;
import com.xdja.poc.sdk.db.entity.DBGroupEntity;
import com.xdja.poc.sdk.db.entity.User;
import com.xdja.poc.sdk.proxy.POCUiKitProxyImpl;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * janus-gateway-android-master
 * 功能 频道业务Utils
 * 描述  可以将相关业务抽取成方法,统一调用
 * created by Wwq : 2018/9/3
 */

@SuppressWarnings("ALL")
public class GroupUtils {

    /**
     * 获取在线人数和总人数
     *
     * @param memeberIds
     * @return int[]  [0] :为在线人数 [1]:为总人数
     */
    @Deprecated
    public static int[] getMemberOnLineCount(String memeberIds) {
        int[] mm = new int[2];
        int totalMemberCount = 0;
        int onLineMembersCount = 0;
        if (!StringUtils.isEmpty(memeberIds)) {
            List<POCMemberInfo> memberList = POCClient.getInstance().generateStringToList(memeberIds);
            if (memberList != null && memberList.size() > 0) {
                totalMemberCount = memberList.size();
                for (POCMemberInfo info : memberList) {
                    if (info.isOnLine()) {
                        onLineMembersCount++;
                    }
                }
            }
        }
        mm[0] = onLineMembersCount;
        mm[1] = totalMemberCount;
        return mm;
    }

    /**
     * 获取包含关键字的list
     *
     * @param data
     * @param keyWords
     * @return
     */
    public static List<DBGroupEntity> getPocGroupMatchKey(List<DBGroupEntity> data, String keyWords) {
        List<DBGroupEntity> result = new ArrayList<>();
        try {
            for (DBGroupEntity group : data) {
                if (StringUtils.isEmpty(group.getRoomName()) || StringUtils.isEmpty(keyWords)) {
                    continue;
                }
                if (group.getRoomName().contains(keyWords)) {
                    result.add(group);
                }
            }
            return result;
        } catch (Throwable throwable) {
            LogUtils.ELog(throwable);
        }
        return null;
    }

    /**
     * 对讲界面查询包含关键字的list
     *
     * @param data
     * @param keyWords
     * @return
     */
    public static List<POCMemberInfo> getPocConversationSearchResult(List<POCMemberInfo> data, String keyWords) {
        List<POCMemberInfo> result = new ArrayList<>();
        try {
            for (POCMemberInfo group : data) {
                if (TextUtils.isEmpty(group.getName())) {
                    continue;
                }
                if (group.getName().contains(keyWords) || group.getAccount().contains(keyWords) || PinyinUtil.getPingYin(group.getName()).contains(keyWords) || PinyinUtil.getFirstSpell(group.getName()).contains(keyWords)) {
                    result.add(group);
                }
            }
            return result;
        } catch (Throwable throwable) {
            LogUtils.ELog(throwable);
        }
        return null;
    }

    /**
     * 生成poc频道表的主键key
     *
     * @param userId
     * @param roomId
     * @return
     */
    public static String generatePOCGroupDbKey(String userId, String roomId) {
        if (StringUtils.isEmpty(userId) || StringUtils.isEmpty(roomId)) {
            return "";
        }
        return userId + "_" + roomId;
    }

    @Deprecated
    public static String generateMemberInfos(POCMemberInfo group, String memeberIds) {
        boolean isContains = false;
        List<POCMemberInfo> mList = new ArrayList<>();
        if (!StringUtils.isEmpty(memeberIds)) {
            mList = POCClient.getInstance().generateStringToList(memeberIds);
            for (POCMemberInfo info : mList) {
                if (info.getId().equalsIgnoreCase(group.getId())) {
                    isContains = true;
                    info.setOnLine(group.isOnLine());
                }
            }
            if (!isContains) {
                mList.add(group);
            }
        } else {
            mList.add(group);
        }
        return POCClient.getInstance().generateListString(mList);
    }

    /**
     * 生成频道成员List集合并转string
     *
     * @param memberIds 逗号隔开的id 字符传
     * @param roomId
     * @return
     */
    public static String generateMemberInfosListring(String memberIds, String roomId) {
        String result;
        if (StringUtils.isEmpty(memberIds)) {
            result = "";
        } else {
            List<POCMemberInfo> memberInfoList = new ArrayList<>();//从通讯里哪里获取数据
            List<POCMemberInfo> mList = new ArrayList<>();
            String[] split = memberIds.split(",");
            for (String string : split) {
                POCMemberInfo info = new POCMemberInfo();
                for (POCMemberInfo memberInfo : memberInfoList) {
                    if (string.equalsIgnoreCase(memberInfo.getAccount())) {
                        info.setMobile(memberInfo.getMobile());
                        info.setIcon(memberInfo.getIcon());
                        info.setDeptName(memberInfo.getDeptName());
                        info.setName(memberInfo.getName());
                        info.setImei(memberInfo.getImei());
                        break;
                    }
                }
                info.setId(string);
                info.setRoomId(roomId);
                mList.add(info);
            }
            result = POCClient.getInstance().generateListString(mList);
        }
        LogUtils.ILog("createRoom members: " + result);
        return result;
    }


    /**
     * 生成临时频道的频道id:  roomId
     *
     * @return
     */
    public static String generateTempGroupRoomId() {
        return String.valueOf(System.currentTimeMillis());
    }


    /**
     * 生成创建临时频道时需要的用户id集合 以及临时频道频道名称,
     * 群成员list集合 并转string
     *
     * @param mSelectedMemberList 群成员list
     * @return
     */
    public static String[] generateGroupMemberIdsAndTempRoomId(String mUserId, ArrayList<POCMemberInfo> mSelectedMemberList) {
        String[] strings = new String[2];
        StringBuilder sbUserId = new StringBuilder();
        StringBuilder roomNameSb = new StringBuilder();
        sbUserId.append(mUserId);
        String userName = PreferenceHelper.getString(UserConfig.USER_INFO_NAME, "");
        roomNameSb.append(StringUtils.isEmpty(userName) ? mUserId : userName);
        if (mSelectedMemberList != null && mSelectedMemberList.size() > 0) {
            sbUserId.append(",");
            roomNameSb.append(",");
            for (int m = 0; m < mSelectedMemberList.size(); m++) {
                sbUserId.append(mSelectedMemberList.get(m).getAccount());
                roomNameSb.append(mSelectedMemberList.get(m).getName());
                if (m < mSelectedMemberList.size() - 1) {
                    sbUserId.append(",");
                    roomNameSb.append(",");
                }
            }
        }
//        sbUserId.append(",").append(mUserId);
        strings[0] = sbUserId.toString();
        strings[1] = roomNameSb.toString();
        return strings;
    }

    /**
     * 生成创建临时频道时需要的用户id集合 以及临时频道频道名称,
     * 群成员list集合 并转string
     *
     * @param mSelectedMemberList 群成员list
     * @return
     */
    public static String generateGroupMemberTempRoomName(ArrayList<POCMemberInfo> mSelectedMemberList) {
        Map<String, POCMemberInfo> userInfo = POCUiKitProxyImpl.getInstance().getUserInfosCache();
        StringBuilder roomNameSb = new StringBuilder();
        int size = mSelectedMemberList.size();
        if (size > 3) {
            size = 3;
        }
        for (int m = 0; m < size; m++) {
            String name;
            if (userInfo != null && userInfo.containsKey(mSelectedMemberList.get(m).getAccount())) {
                name = userInfo.get(mSelectedMemberList.get(m).getAccount()).getName();
            } else {
                name = mSelectedMemberList.get(m).getName();
            }
            roomNameSb.append(name);
            if (m < size - 1) {
                roomNameSb.append(",");
            }
        }
        return roomNameSb.toString();
    }

    /**
     * 生成临时频道对象
     *
     * @return
     */
//    public static DBGroupEntity generateTempGroupEntity(String userId, String roomId, String memberInfoList, String roomName, String ownerId) {
//        DBGroupEntity entity = new DBGroupEntity();
//        entity.setGroupType(GroupConfig.STICK_GROUP);//临时频道
//        entity.setUserId(userId);
//        entity.setRoomName(roomId);
//        entity.setOwnerId(ownerId);
//        entity.setRoomName(StringUtils.generateContent(roomName));
//        entity.setRooomId(roomId);
//        entity.setPinyin(PinyinUtil.getLetterChar(roomName));
//        entity.setKey(GroupUtils.generatePOCGroupDbKey(userId, roomId));
//        entity.setMemeberIds(memberInfoList);
//        List<POCMemberInfo> strings = POCClient.getInstance().generateStringToList(memberInfoList);
//        Map<String, String> nameMap = new HashMap<>();
//        for (POCMemberInfo info : strings) {
//            if (UserConfig.userNameMap != null) {
//                nameMap.put(info.getId(), UserConfig.userNameMap.get(info.getId()));
//            }
//        }
//        entity.setUserNames(new Gson().toJson(nameMap));
//        return entity;
//    }
    public static Map<String, String> generateStringToMap(String userNames) {
        return new Gson().fromJson(userNames, new TypeToken<Map<String, String>>() {
        }.getType());
    }

    public static Map<String, String> generateUserMap(List<User> usersList) {
        if (usersList == null) {
            return null;
        }
        Map<String, String> userMaps = new HashMap<>();
        for (User user : usersList) {
            if (user != null) {
                if (!StringUtils.isEmpty(user.getNickName())) {
                    userMaps.put(user.getAccount(), user.getNickName());
                } else {
                    userMaps.put(user.getAccount(), user.getName());
                }
            }
        }
        return userMaps;
    }

    /**
     * 重置当前频道状态
     *
     * @param entity
     * @return
     */
    public static boolean resetGroupStatus(DBGroupEntity entity) {
        List<String> onLineMemberList = POCClient.getOnLineMemberList(Long.valueOf(entity.getRooomId()));
        entity.setStatus(GroupConfig.GROUP_HANGUP);
        return onLineMemberList != null && onLineMemberList.size() > 0;

    }

    public static List<String> jsonToList(String json) {
        if (TextUtils.isEmpty(json)) {
            return null;
        }
        JSONArray array;
        try {
            array = new JSONArray(json);
            ArrayList<String> strings = new ArrayList<>();
            for (int i = 0; i < array.length(); i++) {
                JSONObject pub = array.getJSONObject(i);
                String userid = pub.getString("display");
                strings.add(userid);
            }
            return strings;
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return null;
    }

    /**
     * 判断在线频道是否达到上限
     *
     * @return
     */
    public static boolean isMaxRoomCount() {
        List<String> onLineRoomCount = POCClient.getReconnectRoom();
        return onLineRoomCount != null && onLineRoomCount.size() >= 5;
    }

    public static String generatePinYin(DBGroupEntity entity) {
        String channelName = entity.getRoomName();
//        String membersId = entity.getMemeberIds();
//        if ((!StringUtils.isEmpty(channelName) && channelName.equals(UserConfig.UN_DEFINE)) || StringUtils.isEmpty(channelName)) {
//            List<POCMemberInfo> memberInfoList = POCClient.getInstance().generateStringToList(membersId);
//            String strings = GroupUtils.generateGroupMemberTempRoomName((ArrayList<POCMemberInfo>) memberInfoList);
//            channelName = strings;
//        }
        String pinyin = PinyinUtil.getPingYin(channelName);
        if (StringUtils.isEmpty(pinyin)) {
            pinyin = "#";
        } else {
            String first = pinyin.substring(0, 1);
            if (!first.matches("[A-Za-z]")) {
                pinyin = "#";
            }
        }
        return pinyin;
    }

    public static String generatePinYin(String content) {
        String pinyin = PinyinUtil.getPingYin(content);
        if (StringUtils.isEmpty(pinyin)) {
            pinyin = "#";
        } else {
            String first = pinyin.substring(0, 1);
            if (!first.matches("[A-Za-z]")) {
                pinyin = "#";
            }
        }
        return pinyin;
    }

    public static String convertString(String content) {
        if (StringUtils.isEmpty(content)) {
            return "";
        }
        if (content.contains("\"null\"")) {
            return content.replaceAll("\"null\"", "null");
        }
        return content;
    }

    public static boolean isSelfSpeakButOnlyLisener(String roomId) {
//        if (Constants.isSelfRequestOnOtherDevice == null) {
//            Constants.isSelfRequestOnOtherDevice = new HashMap<>();
//            return false;
//        } else if (Constants.isSelfRequestOnOtherDevice.get(roomId) != null) {
//            return Constants.isSelfRequestOnOtherDevice.get(roomId);
//        }
        return Constants.isSelfRequestOnOtherDevice;
    }

    /**
     * 自己作为第三方听着的状态重置
     *
     * @param roomId
     * @param b
     */
    public static void signSelfSpeakStatus(String roomId, boolean b) {
//        if (Constants.isSelfRequestOnOtherDevice == null) {
//            Constants.isSelfRequestOnOtherDevice = new HashMap<>();
//        }
//        Constants.isSelfRequestOnOtherDevice.put(roomId, true);
        Constants.isSelfRequestOnOtherDevice = b;
    }
}
