package com.xdja.poc.sdk.record;

import android.support.annotation.Keep;

import org.greenrobot.greendao.annotation.Entity;
import org.greenrobot.greendao.annotation.Generated;
import org.greenrobot.greendao.annotation.Id;

import java.io.Serializable;

/**
 * 录音消息
 * Created by xdjaxa on 2019/1/7.
 */
@SuppressWarnings("ALL")
@Keep
@Entity(nameInDb = "record_table")
public class RecordMessage implements Serializable {

    private static final long serialVersionUID = 536871100L;

    @Id
    String recordUri; //本地录音uri
    String recordRemoteUrl; //上传录音url
    String recordRoom; //录音roomId
    String recordName; //录音文件名
    String recordSize; //录音文件大小
    String recordTimeLen; //录音文件时长
    String recordMessageId; //上传之后返回消息id

    @Generated(hash = 599712464)
    public RecordMessage(String recordUri, String recordRemoteUrl,
                         String recordRoom, String recordName, String recordSize,
                         String recordTimeLen, String recordMessageId) {
        this.recordUri = recordUri;
        this.recordRemoteUrl = recordRemoteUrl;
        this.recordRoom = recordRoom;
        this.recordName = recordName;
        this.recordSize = recordSize;
        this.recordTimeLen = recordTimeLen;
        this.recordMessageId = recordMessageId;
    }

    @Generated(hash = 1116586503)
    public RecordMessage() {
    }

    public String getRecordUri() {
        return recordUri;
    }

    public void setRecordUri(String recordUri) {
        this.recordUri = recordUri;
    }

    public String getRecordRemoteUrl() {
        return recordRemoteUrl;
    }

    public void setRecordRemoteUrl(String recordRemoteUrl) {
        this.recordRemoteUrl = recordRemoteUrl;
    }

    public String getRecordRoom() {
        return recordRoom;
    }

    public void setRecordRoom(String recordRoom) {
        this.recordRoom = recordRoom;
    }

    public String getRecordName() {
        return recordName;
    }

    public void setRecordName(String recordName) {
        this.recordName = recordName;
    }

    public String getRecordSize() {
        return recordSize;
    }

    public void setRecordSize(String recordSize) {
        this.recordSize = recordSize;
    }

    public String getRecordTimeLen() {
        return recordTimeLen;
    }

    public void setRecordTimeLen(String recordTimeLen) {
        this.recordTimeLen = recordTimeLen;
    }

    public String getRecordMessageId() {
        return recordMessageId;
    }

    public void setRecordMessageId(String recordMessageId) {
        this.recordMessageId = recordMessageId;
    }
}
