package com.xdja.poc.sdk.ui.main.mvp;

import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.ValueAnimator;
import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.HandlerThread;
import android.text.TextUtils;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.LinearInterpolator;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;

import com.jude.easyrecyclerview.adapter.RecyclerArrayAdapter;
import com.xdja.poc.common.utils.GlobalContext;
import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.common.utils.PreferenceHelper;
import com.xdja.poc.common.utils.StringUtils;
import com.xdja.poc.common.utils.ToastUtils;
import com.xdja.poc.sdk.POCClient;
import com.xdja.poc.sdk.R;
import com.xdja.poc.sdk.bean.POCMemberInfo;
import com.xdja.poc.sdk.business.PocBroadReceiver;
import com.xdja.poc.sdk.config.GroupConfig;
import com.xdja.poc.sdk.config.UserConfig;
import com.xdja.poc.sdk.db.entity.DBGroupEntity;
import com.xdja.poc.sdk.event.CheckChannelIsExistEvent;
import com.xdja.poc.sdk.event.GroupEvent;
import com.xdja.poc.sdk.event.POCConverationTbcpStatusEvent;
import com.xdja.poc.sdk.event.POCConversationMeIncomeRoom;
import com.xdja.poc.sdk.event.POCConversationUserChangeEvent;
import com.xdja.poc.sdk.event.POCMemberEvent;
import com.xdja.poc.sdk.event.POCSelfLeaveEvent;
import com.xdja.poc.sdk.proxy.IPOCChannelInfoCallBack;
import com.xdja.poc.sdk.proxy.POCUiKitProxyImpl;
import com.xdja.poc.sdk.utils.GroupUtils;

import org.greenrobot.eventbus.EventBus;
import org.json.JSONArray;
import org.json.JSONException;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import io.reactivex.disposables.Disposable;

@SuppressWarnings("ALL")
public class POCConversationPersenter implements POCConversationContract.IPOCConversationPersenter {
    private static final String TAG = "POCConverationPersenter";
    private POCConversationContract.IPOCConversationView mView;
    private Context mContext;
    private DBGroupEntity group;
    private volatile boolean bWaitingTakenTBCP = false;
    private volatile boolean bWaitingReleaseTBCP = false;
    public volatile boolean bNeedReleaseTBCP = false;
    public boolean releaseStaus = false;
    private boolean releasedButAgainRequest = false;
    public volatile boolean bTakenTBCP = false;
    private final int TBCP_REQUEST_TIMEOUT = 1000;
    //private static final int MSG_SEARCH_DELAY = 1;
    private AsyncTask<String, Void, List<POCMemberInfo>> searchTask = null;
    private int TotalCount = 0;
    private String roomId;
    private String mUserId;
    private String talkingUserID;
    private Handler handler = null;
    private static ValueAnimator animator;
    private ArrayList<POCMemberInfo> mSelectedMemberList;
    private volatile boolean bPressVolumeDown;
    private ProgressDialog mProgressDialog;
    private volatile boolean bPressTalk;
    public volatile boolean bPeopleTalking; //频道是否有其他人在讲话
    private Disposable mDisposable;
    private Map<String, POCMemberInfo> mAccountToName = new HashMap<>();
    private int lastKeyCode = 0;//
    HandlerThread tbcpTimeout;


    public POCConversationPersenter(POCConversationContract.IPOCConversationView view, Context context, DBGroupEntity entity, Map<String, POCMemberInfo> userNameInfo) {
        this.mView = view;
        this.mContext = context;
        this.group = entity;
        this.roomId = entity.getRooomId();
        mUserId = PreferenceHelper.getString(UserConfig.LOGIN_ACCOUNT, "");
        mAccountToName = userNameInfo;
        if (mAccountToName == null) {
            mAccountToName = new HashMap<>();
        }
        if (handler != null) {
            handler = null;
        }
        tbcpTimeout = new HandlerThread("TbcpTimeout");
        tbcpTimeout.start();
        handler = new Handler(tbcpTimeout.getLooper());
        mSelectedMemberList = new ArrayList<>();
        delayCancel(false);
        initEvent();
    }

    private void initEvent() {
        POCUiKitProxyImpl.getInstance().addPttKeyEventCallBack(pttEventCallBack);

    }

    public IPOCChannelInfoCallBack pttEventCallBack = new IPOCChannelInfoCallBack() {
        @Override
        public void onPttKeyEvent(String channelId, boolean pttStatus) {
            if (group != null)
                group.setIsPttKey(pttStatus ? 1 : 0);
            if (checkViewIsValid()) {
                mView.setPttKey(pttStatus);
            }
        }

        @Override
        public void onChannelNameEvent(String channelId, String channelName) {
            if (group != null)
                group.setRoomName(channelName);
            if (checkViewIsValid())
                mView.setRoomName(channelName);
        }

        @Override
        public void onChannelPwdEvent(String channelId, String channelPwd) {
            if (group != null)
                group.setChannelPwd(channelPwd);
            if (checkViewIsValid()) {
                mView.setChannelPwd(channelPwd);
            }
        }

        @Override
        public void onChannelPwdModeEvent(String channelId, boolean channelPwdMode) {
            if (group != null)
                group.setChannelPwdMode(channelPwdMode ? 1 : 0);
            if (checkViewIsValid()) {
                mView.setChannelPwdMode(channelPwdMode);
            }
        }
    };

    /**
     * 选择人员后,点击取消呼叫,重置列表状态
     */
    @Override
    public void resetAdapter(RecyclerArrayAdapter<POCMemberInfo> madapter) {
        mSelectedMemberList.clear();
        List<POCMemberInfo> allData = madapter.getAllData();
        for (POCMemberInfo info : allData) {
            info.setChecked(false);
        }
        madapter.notifyDataSetChanged();
    }

    /**
     * 列表的点击事件
     */
    @Override
    public void setSelectMemeber(RecyclerArrayAdapter<POCMemberInfo> mAdapter, int position) {
        if (position == -1) {
            LogUtils.ELog(TAG, "setSelectMemeber: position=-1");
            return;
        }
        POCMemberInfo pocMemberInfo = mAdapter.getAllData().get(position);
        if (pocMemberInfo.isChecked()) {
            pocMemberInfo.setChecked(false);
            if (checkViewIsValid()) {
                mView.searchNotifyMemberAdapterToUpdate(mAdapter, pocMemberInfo, false);
            }
            if (mSelectedMemberList.size() >= 0) {
                mSelectedMemberList.remove(pocMemberInfo);
            }
        } else {
            pocMemberInfo.setChecked(true);
            if (checkViewIsValid()) {
                mView.searchNotifyMemberAdapterToUpdate(mAdapter, pocMemberInfo, true);
            }
            mSelectedMemberList.add(pocMemberInfo);
        }
        mAdapter.notifyItemChanged(position);
        if (checkViewIsValid()) {
            mView.setSelectMember(mSelectedMemberList);
        }
    }


    /**
     * 请求tvcp
     */
    @Override
    public boolean requestTbcp(boolean isForce) {
//        if (bPressVolumeDown) {
//            return false;
//        }
        requestTbcp(false, isForce);

        bPressTalk = true;
        return true;
    }

    /**
     * 释放tbcp
     */
    @Override
    public boolean releaseTbcp() {
        LogUtils.DLog(TAG, "releaseTbcp  bPressVolumeDown= " + bPressVolumeDown);
//        if (bPressVolumeDown) {
//            return false;
//        }
        bPressTalk = false;
        return requestReleaseTbcp(false);
    }

    /**
     * 隐藏软键盘
     */
    @Override
    public void hideSoftKeyboard(Activity activity, MotionEvent ev) {
        hideInputWhenTouchOtherView(activity, ev, activity.getCurrentFocus());
    }

    /**
     * 按住说话的动画
     */
    @Override
    public void startTalkAnimate(View target) {
        if (animator == null) {
            PropertyValuesHolder scaleX = PropertyValuesHolder.ofFloat(View.SCALE_X, 0.85f, 1.03f, 1.08f);
            PropertyValuesHolder scaleY = PropertyValuesHolder.ofFloat(View.SCALE_Y, 0.85f, 1.03f, 1.08f);
            PropertyValuesHolder alpha = PropertyValuesHolder.ofFloat(View.ALPHA, 1f, 0.7f, 0.4f);
            animator = ObjectAnimator.ofPropertyValuesHolder(target, scaleX, scaleY, alpha).setDuration(1600);
            animator.setInterpolator(new LinearInterpolator());
            animator.setRepeatCount(-1);
            animator.setRepeatMode(ObjectAnimator.RESTART);
            animator.start();
        } else {
            releaseTalkAnimate(target);
            animator.start();
        }

    }

    /**
     * 释放动画
     */
    @Override
    public void releaseTalkAnimate(View target) {
        if (animator != null) {
            animator.cancel();
            target.setScaleX(1f);
            target.setScaleY(1f);
            target.setAlpha(1f);
        }
    }

    /**
     * 重置状态
     */
    @Override
    public void resetButton(final String talkStatus) {
        ((Activity) mContext).runOnUiThread(new Runnable() {
            @Override
            public void run() {
                LogUtils.ILog("resetButton: timeoutRunnable is  timeout ");
                resetControlParmeter();
                if (checkViewIsValid()) {
                    mView.setTalkStatus(talkStatus);//poc_conversation_talk_status_free //poc_conversation_request_tbcp_timeout
                    mView.resetButton();
                }
                POCClient.releaseTBCP(roomId);
            }
        });
    }


    /**
     * 对列表进行排序
     */
    @Override
    public void sortAdapter(RecyclerArrayAdapter<POCMemberInfo> mMemberInfoAdapter) {
        List<POCMemberInfo> allData = mMemberInfoAdapter.getAllData();
        for (POCMemberInfo info : allData) {
            if (StringUtils.isEmpty(info.getPinyin())) {
                info.setPinyin(GroupUtils.generatePinYin(info.getName()));
            }
        }
        generateSortData(allData);
        mMemberInfoAdapter.clear();
        mMemberInfoAdapter.addAll(allData);
        mMemberInfoAdapter.notifyDataSetChanged();
//        initUserNames(mMemberInfoAdapter.getAllData());
    }

    private void generateSortData(List<POCMemberInfo> allData) {
        Collections.sort(allData, new Comparator<POCMemberInfo>() {
            @Override
            public int compare(POCMemberInfo o1, POCMemberInfo o2) {
                if (o1.isOnLine() && o2.isOnLine()) {
                    if (o1.getPinyin().equals("#") && !o2.getPinyin().equals("#")) {
                        return 1;
                    } else if (!o1.getPinyin().equals("#") && o2.getPinyin().equals("#")) {
                        return -1;
                    } else {
                        return o1.getPinyin().compareToIgnoreCase(o2.getPinyin());
                    }
                } else {
                    if (o1.isOnLine()) {
                        return -1;
                    } else if (o2.isOnLine()) {
                        return 1;
                    } else {
                        if (o1.getPinyin().equals("#") && !o2.getPinyin().equals("#")) {
                            return 1;
                        } else if (!o1.getPinyin().equals("#") && o2.getPinyin().equals("#")) {
                            return -1;
                        } else {
                            return o1.getPinyin().compareToIgnoreCase(o2.getPinyin());
                        }
                    }
                }
            }
        });
        POCMemberInfo selfInfo = null;
        for (POCMemberInfo info : allData) {
            if (info.getAccount().equals(mUserId)) {
                selfInfo = info;
                allData.remove(info);
                break;
            }
        }
        if (selfInfo != null) {
            allData.add(0, selfInfo);
        }
    }

//    /**
//     * 缓存userId -> userName 数据
//     *
//     * @param mMemberInfoAdapter
//     */
//    private void initUserNames(List<POCMemberInfo> mMemberInfoAdapter) {
//        mAccountToName.clear();
//        for (POCMemberInfo info : mMemberInfoAdapter) {
//            mAccountToName.put(info.getAccount(), StringUtils.isEmpty(info.getNickName()) ? info.getName() : info.getNickName());
//        }
//    }

    /**
     * tbcp状态变化
     */
    @Override
    public void subscribeRoomTbcpStatusChange(POCConverationTbcpStatusEvent receiverMessage) {
        if (!receiverMessage.getRoomId().equals(roomId)) {
            return;
        }
        GroupUtils.signSelfSpeakStatus(roomId, false);
        LogUtils.DLog("[POC_LOG]", "receiverMessage.getUserBehavior():" + receiverMessage.getUserBehavior());
        switch (receiverMessage.getUserBehavior()) {
            case PocBroadReceiver.ROOM_OTHER_REQUEST_TBCP_SUCCESS:
                removeTimeoutRunnable("PocBroadReceiver.ROOM_OTHER_REQUEST_TBCP_SUCCESS");
                talkingUserID = receiverMessage.getUserId();
                bPeopleTalking = true;
                String speakerId = receiverMessage.getUserId();
                String speakerName = generateUserName(speakerId);
                if (speakerId.equals(mUserId)) {
                    GroupUtils.signSelfSpeakStatus(roomId, true);
                } else {
                    GroupUtils.signSelfSpeakStatus(roomId, false);
                }
                if (checkViewIsValid()) {
                    mView.resetReleaseStatus(true);
                    mView.showSpeakStatus(speakerId, speakerName, receiverMessage.getUserBehavior());
                    mView.roomOtherRequestTbcpSuccess(talkingUserID);
                }
                LogUtils.DLog(TAG, "other_request_tbcp  speakerId:　" + speakerId + " speakerName: " + speakerName + " releaseStaus: " + releaseStaus);
                releaseStaus = true;
                LogUtils.DLog(TAG, "bWaitingTakenTBCP: " + bWaitingTakenTBCP);
                resetControlParmeter();
                break;
            case PocBroadReceiver.ROOM_OTHER_RELEASE_TBCP_SUCCESS:
                removeTimeoutRunnable("PocBroadReceiver.ROOM_OTHER_RELEASE_TBCP_SUCCESS");
                if (checkViewIsValid()) {
                    mView.resetReleaseStatus(true);
                }
                //set talking false
                bPeopleTalking = false;
                resetControlParmeter();
                releaseStaus = true;
                if (checkViewIsValid()) {
                    mView.roomOtherReleaseTbcpSuccess();
                    mView.setTalkStatus(GlobalContext.getContext().getString(R.string.poc_conversation_talk_status_free));
                }
                break;
            case PocBroadReceiver.ROOM_RELEASE_TBCP_FAILED:
//                lastKeyCode = LAST_KEY_UP;
                if (checkViewIsValid()) {
                    mView.resetReleaseStatus(true);
                }
                removeTimeoutRunnable("PocBroadReceiver.ROOM_RELEASE_TBCP_FAILED");
                //set talking false
                bPeopleTalking = false;
                resetControlParmeter();
                if (checkViewIsValid()) {
                    mView.setTalkStatus(GlobalContext.getContext().getString(R.string.poc_conversation_talk_status_free));
                    mView.roomSelfReleaseTbcpFailed();
                }
                String speakerId_ = receiverMessage.getUserId();
                break;
            case PocBroadReceiver.ROOM_RELEASE_TBCP_SUCCESS:
//                lastKeyCode = LAST_KEY_UP;
                if (checkViewIsValid()) {
                    mView.resetReleaseStatus(true);
                }
                removeTimeoutRunnable("PocBroadReceiver.ROOM_RELEASE_TBCP_SUCCESS");
                bPeopleTalking = false;
                resetControlParmeter();
                if (checkViewIsValid()) {
                    mView.setTalkStatus(GlobalContext.getContext().getString(R.string.poc_conversation_talk_status_free));
                    mView.roomSelfReleaseTbcpSuccess();
                }
                releaseStaus = true;
                break;
            case PocBroadReceiver.ROOM_REQUEST_TBCP_SUCCESS:
                releaseStaus = false;
                if (bWaitingReleaseTBCP) {//|| (lastKeyCode == LAST_KEY_UP)
                    bNeedReleaseTBCP = true;//release again.
                    bWaitingReleaseTBCP = false;
                }
                removeTimeoutRunnable("PocBroadReceiver.ROOM_REQUEST_TBCP_SUCCESS");
                talkingUserID = receiverMessage.getUserId();

                //set talking false
                bPeopleTalking = false;
                bWaitingTakenTBCP = false;
                bPressTalk = false;

                //set taken tbcp
                bTakenTBCP = true;

                //bPressVolumeDown = true;
                if (checkViewIsValid()) {
                    mView.resetReleaseStatus(true);
                }
                if (againReleaseTbcp()) return;
                if (checkViewIsValid()) {
                    mView.showSpeakStatus(mUserId, "您", receiverMessage.getUserBehavior());
                    mView.roomSelfRequestTbcpSuccess(talkingUserID);
                    List<String> onLineMemberList = POCClient.getOnLineMemberList(Long.parseLong(roomId));
                    mView.setOnLineCount(onLineMemberList != null ? onLineMemberList.size() : 0, TotalCount);
                }
                break;
            case PocBroadReceiver.ROOM_REQUEST_TBCP_FAILED:
                removeTimeoutRunnable("PocBroadReceiver.ROOM_REQUEST_TBCP_FAILED");
                if (!bPeopleTalking) {
                    if (checkViewIsValid()) {
                        mView.setTalkStatus(GlobalContext.getContext().getString(R.string.poc_conversation_talk_status_free));
                        mView.resetButton();
                    }
                }
                //set talking false
                bPeopleTalking = false;
                resetControlParmeter();
                if (checkViewIsValid()) {
                    mView.roomSelfRequestTbcpFailed();
                }
                break;
            default:
                break;
        }
    }

    private boolean againReleaseTbcp() {
        LogUtils.DLog(TAG, "againReleaseTbcp bNeedReleaseTBCP : " + bNeedReleaseTBCP + " lastKeyCode:" + lastKeyCode);
        if (bNeedReleaseTBCP) {
            bNeedReleaseTBCP = false;
            bWaitingReleaseTBCP = true;
            //mRelTalkOrEnd.setPressed(false);
            if (checkViewIsValid()) {
                mView.setTalkStatus(GlobalContext.getContext().getString(R.string.poc_conversation_talk_status_free));
                mView.resetButton();
            }
            POCClient.releaseTBCP(roomId);
            removeTimeoutRunnable("PocBroadReceiver.ROOM_REQUEST_TBCP_SUCCESS====bNeedReleaseTBCP");
            handler.postDelayed(releaseTimeoutRunnable, TBCP_REQUEST_TIMEOUT);
            return true;
        }
        return false;
    }

    /**
     * 由于群主强插操作是当有群主强插时，成员收到消息后要释放tbcp，所以会回调相应的事件，
     * 这个时机要做些处理，因为群主在讲话，view上要显示出来
     *
     * @param speakerId
     * @param speakerName
     * @param roomId
     */
    private void resetStatus(String speakerId, String speakerName, String roomId) {
        Map<String, String> allSpeakers = POCClient.getAllSpeakers();
        if (allSpeakers != null && allSpeakers.containsKey(roomId)) {
            for (String userId : allSpeakers.keySet()) {
                if (!TextUtils.isEmpty(userId) && !userId.equals(mUserId)) {
                    if (checkViewIsValid()) {
                        mView.showSpeakStatus(speakerId, speakerName, -1);
                    }
                    break;
                }
            }
        }
    }

    public void resetControlParmeter() {
        bWaitingReleaseTBCP = false;
        bWaitingTakenTBCP = false;
        bTakenTBCP = false;
        bPressVolumeDown = false;
        bPressTalk = false;
        bPressVolumeDown = false;
        releaseStaus = false;

    }

    private void roomMute() {
//        if (group.getIsSilence()) {
//        POCClient.muteAndNotifyUI(Long.valueOf(roomId), group.getIsSilence());
//        mView.updateMute(group);
//        }
    }

    /**
     * 发起新的对讲界面
     */
    @Override
    public void startNewConversionActivity() {
    }


    /**
     * 取消延时
     */
    public void delayCancel(boolean isDestroy) {
        if (animator != null) {
            animator.cancel();
        }
        if (isDestroy) {
            if (tbcpTimeout != null && tbcpTimeout.isAlive()) {
                tbcpTimeout.getLooper().quit();
            }
        }
        animator = null;
        if (mDisposable != null && !mDisposable.isDisposed()) {
            mDisposable.dispose();
            mDisposable = null;
        }
        if (handler != null)
            handler.removeCallbacks(connectRunnable);
        LogUtils.DLog(TAG, "delayCancel: removeCallbacks(connectRunnable)");
        POCUiKitProxyImpl.getInstance().removePttKeyEventCallBack(pttEventCallBack);
    }

    /**
     * 用户离开
     */
    @Override
    public void subscribeSelfLeaveEvent(POCSelfLeaveEvent selfLeaveEvent) {
        String eventRoomId = selfLeaveEvent.getRoomId();
        if (roomId.equalsIgnoreCase(eventRoomId)) {
            if (checkViewIsValid()) {
                mView.setTalkStatus(GlobalContext.getContext().getResources().getString(R.string.poc_conversation_network_interrupt));
                mView.subscribeSelfLeaveEvent();
            }
        }
    }

    @Override
    public void onMyPause() {
        if (handler != null) {
            handler.removeCallbacksAndMessages(null);

        }
        if (bTakenTBCP) {
            releaseTbcp();
        }
        ToastUtils.cancleToast();
        bPressVolumeDown = false;
        if (checkViewIsValid()) {
            mView.onMyPause();
        }
    }

    /**
     * 监听自己进入频道
     */
    @Override
    public void subscribeSelfEnterRoom(POCConversationMeIncomeRoom pocConversationMeIncomeRoom) {
        LogUtils.DLog(TAG, "subscribeSelfEnterRoom: removeCallbacks(connectRunnable)");
        if (!pocConversationMeIncomeRoom.getRoomId().equals(roomId)) {
            return;
        }
        try {
            if (TextUtils.isEmpty(pocConversationMeIncomeRoom.getMemberInfos())) return;
            roomMute();
            JSONArray array = new JSONArray(pocConversationMeIncomeRoom.getMemberInfos());
            for (int i = 0; i < array.length(); i++) {
                String s = array.optString(i);
                if (s.equals(mUserId)) {
                    if (checkViewIsValid()) {
                        mView.setTalkStatus(GlobalContext.getContext().getString(R.string.poc_conversation_talk_status_free));
                    }                    
					if (group != null && group.getStatus() == GroupConfig.GROUP_BUSY) {
                        if (checkViewIsValid()) {
                            mView.showSpeakStatus(null, group.getSpeakerUserName(), -1);
                        }
                    } else {
                        if (checkViewIsValid()) {
                            mView.resetButton();
                        }
                    }
                    if (checkViewIsValid()) {
                        mView.updateOnLineMember();
                        mView.subscribeSelfEnterRoom();
                    }
                    break;
                }
            }
        } catch (JSONException e) {
            LogUtils.ELog(TAG, "subscribeSelfEnterRoom: e: " + e.getLocalizedMessage());
        }
    }

    @Override
    public void subscribeUserChange(POCConversationUserChangeEvent event) {
        if (event != null && !event.getRoomId().equals(roomId)) return;
        assert event != null;
        if (PocBroadReceiver.ROOM_USER_JOIN_SUCCESS == event.getStatus()) {
            String speakerId = event.getUserId();
            String speakerName = generateUserName(speakerId);
            if (!StringUtils.isEmpty(speakerName)) {
                ToastUtils.showToast(String.format(GlobalContext.getContext().getString(R.string.poc_conversation_who_has_enter_the_room), speakerName));
                if (checkViewIsValid()) {
                    mView.removeFromCallList(speakerId, "");
                }
            }
        } else if (event.getStatus() == PocBroadReceiver.ROOM_USER_LEAVE_SUCCESS) {
            String speakerName = generateUserName(event.getUserId());
            if (!StringUtils.isEmpty(speakerName)) {
                if (checkViewIsValid()) {
                    EventBus.getDefault().post(new CheckChannelIsExistEvent(event.getRoomId(),speakerName));
                    mView.leaveRoom(speakerName);
                    mView.removeFromCallList(event.getUserId(), "");
                }
            }
            if (event.getUserId().equals(talkingUserID)) {
                if (checkViewIsValid()) {
                    mView.setTalkStatus(GlobalContext.getContext().getString(R.string.poc_conversation_talk_status_free));
                    mView.resetButton();
                    mView.subscribeUserChange();
                }
                bPressVolumeDown = false;
            }
        }
    }

    @Override
    public String generateUserName(String speakerId) {
        String speakerName = speakerId;
        if (mAccountToName != null && mAccountToName.size() > 0 && mAccountToName.containsKey(speakerId)) {
            speakerName = StringUtils.splitDisplayName(6, mAccountToName.get(speakerId).getName());
        } else {
            if (UserConfig.userNameMap != null && UserConfig.userNameMap.containsKey(roomId)
                    && UserConfig.userNameMap.get(roomId) != null && UserConfig.userNameMap.get(roomId).containsKey(speakerId)) {
                POCMemberInfo info = UserConfig.userNameMap.get(roomId).get(speakerId);
                speakerName = info.getName();
                mAccountToName.put(speakerId, info);
            }
        }
        return speakerName;
    }

    /**
     * 正在连接的超时
     *
     * @param roomId
     */
    @Override
    public void handleTimeOut(String roomId) {
        handler.removeCallbacks(connectRunnable);
        handler.postDelayed(connectRunnable, 60 * 1000);
    }

    @Override
    public void cancelConnectTimeOut() {
        if (handler != null)
            handler.removeCallbacks(connectRunnable);
        LogUtils.DLog(TAG, "cancelConnectTimeOut: removeCallbacks(connectRunnable)");
    }

    private Runnable connectRunnable = new Runnable() {
        @Override
        public void run() {
            LogUtils.ELog(TAG, "try connect timeout ");
            if (checkViewIsValid()) {
                mView.onConnectTimeOut();
            }
        }
    };

    /**
     * 更新在线人员
     *
     * @param infos 人员列表数据
     */
    @Override
    public synchronized void updateOnLineMember(POCMemberEvent event, List<POCMemberInfo> infos) {
        if (event != null && !event.getRoomId().equals(roomId)) return;
        List<String> onLineMemberList = POCClient.getOnLineMemberList(Long.parseLong(roomId));
        if (onLineMemberList != null && onLineMemberList.size() > 0) {
            if (checkViewIsValid()) {
                mView.setOnlineNumerCount(String.format(GlobalContext.getContext().getString(R.string.poc_conversation_participants_count), String.valueOf(onLineMemberList.size()), String.valueOf(TotalCount)));
                mView.setOnLineCount(onLineMemberList.size(), TotalCount);
            }
            if (event != null && !TextUtils.isEmpty(event.getMemberInfos())) {
                JSONArray jsonArray;
                try {
                    jsonArray = new JSONArray(event.getMemberInfos());
                    if (event.getUserBehavior() == PocBroadReceiver.ROOM_USER_JOIN_SUCCESS) {
                        updateMemberStatus(infos, jsonArray, true);
//                        mView.updateMute(group);
                    } else if (event.getUserBehavior() == PocBroadReceiver.ROOM_USER_LEAVE_SUCCESS) {
                        updateMemberStatus(infos, jsonArray, false);
                    }
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            } else {
                updateMemberStatus(onLineMemberList, infos);
            }
            if (checkViewIsValid()) {
                mView.updateOnLineMember();
            }
        } else {
            if (checkViewIsValid()) {
                mView.updateOnLineMember();
            }
        }
    }

    @Override
    public void setAdapterData() {
        List<POCMemberInfo> pocMemberInfos = POCClient.getInstance().generateStringToList(group.getMemeberIds());
        for (POCMemberInfo memberInfo : pocMemberInfos) {
            memberInfo.setPinyin(GroupUtils.generatePinYin(memberInfo.getName()));
            if (mAccountToName != null && mAccountToName.containsKey(memberInfo.getAccount())) {
                POCMemberInfo info = mAccountToName.get(memberInfo.getAccount());
                memberInfo.setName(info.getName());
                if (memberInfo.getAccount().equals(mUserId)) {
                    if (group.getStatus() == GroupConfig.GROUP_HANGUP) {
                        memberInfo.setOnLine(false);
                    } else {
                        memberInfo.setOnLine(true);
                    }
                }
                memberInfo.setPinyin(GroupUtils.generatePinYin(memberInfo.getName()));
                if (memberInfo.getAccount().equals(mUserId) && !StringUtils.isEmpty(info.getIcon())) {
                    memberInfo.setIcon(info.getIcon());
                }
            }
        }
        //        String[] strings = new String[pocMemberInfos.size()];
//        for (int i = 0; i < pocMemberInfos.size(); i++) {
//            strings[i] = pocMemberInfos.get(i).getId();
//        }
        //TODO: 2018/10/19 SDK :需要由提供一个返回PocMemberInfo的List集合
//        POCContactUtils pocContactUtils = new POCContactUtils(new POCContactUtils.Callback() {
//            @Override
//            public void getMemberSuccess(List<POCMemberInfo> infos) {
//                mView.setAdapterData(infos);
//                updateOnLineMember(null, infos);
//            }
//        });
//        List<POCMemberInfo> pocGroupUserInfos = POCUiKitProxyImpl.getInstance().getPOCGroupUserInfos(strings);
        generateSortData(pocMemberInfos);
        if (checkViewIsValid()) {
            mView.setAdapterData(pocMemberInfos);
        }
        List<String> onLineMemberList = POCClient.getOnLineMemberList(Long.parseLong(roomId));
        int onLineCount = 0;
        if (onLineMemberList != null) {
            onLineCount = onLineMemberList.size();
        }
        refreshAdapter(onLineCount, pocMemberInfos);
    }

    public void refreshAdapter(int onLineCount, List<POCMemberInfo> pocMemberInfos) {
        updateOnLineMember(null, pocMemberInfos);
//        pocContactUtils.getPocMembers(strings);
        TotalCount = pocMemberInfos.size();
        if (checkViewIsValid()) {
            mView.setOnlineNumerCount(String.format(GlobalContext.getContext().getString(R.string.poc_conversation_participants_count), String.valueOf(onLineCount), String.valueOf(TotalCount)));
            mView.setOnLineCount(onLineCount, TotalCount);
        }
    }

    @Override
    public void netChanged() {
        if (mSelectedMemberList != null && mSelectedMemberList.size() > 0) {
            mSelectedMemberList.clear();
        }
    }

    @Override
    public void deleteRoom(DBGroupEntity entity) {
        if (entity != null && entity.getOwnerId().equals(mUserId)) {
        }
    }

    @Override
    public void addMembers(GroupEvent event) {

    }

    @Override
    public void updateMemberInfo(DBGroupEntity entity) {
        group = entity;

    }

    @Override
    public void setUserInfo(Map<String, POCMemberInfo> userInfosCache) {
        this.mAccountToName = userInfosCache;
    }

    /**
     * 搜索
     *
     * @param searchKey 搜索词
     * @param data      搜索的列表
     */
    @Override
    public void doSearch(String searchKey, List<POCMemberInfo> data) {
        if (searchTask != null) {
            searchTask.cancel(true);
            searchTask = null;
        }
        searchTask = new SearchTask(this, data).execute(searchKey);
    }

    public void updateTotalCount(int size) {
        TotalCount = size;
    }

    public void setLastCode() {
//        lastKeyCode=LAST_KEY_UP;
    }

    @SuppressWarnings("CanBeFinal")
    private static class SearchTask extends AsyncTask<String, Void, List<POCMemberInfo>> {
        private WeakReference<POCConversationPersenter> mWefs;
        private List<POCMemberInfo> mData;

        public SearchTask(POCConversationPersenter chooseFriendsPresenter, List<POCMemberInfo> data) {
            this.mWefs = new WeakReference<>(chooseFriendsPresenter);
            this.mData = data;
        }

        @Override
        protected List<POCMemberInfo> doInBackground(String... strings) {
            if (mWefs != null && mWefs.get() != null) {
                return GroupUtils.getPocConversationSearchResult(mData, strings[0]);
            }
            return null;
        }

        @Override
        protected void onPostExecute(List<POCMemberInfo> pocGroups) {
            super.onPostExecute(pocGroups);
            if (mWefs != null && mWefs.get() != null) {
                final POCConversationPersenter mPocConversation = mWefs.get();
                mPocConversation.mView.getSearchResult(pocGroups);
            }
        }
    }

    private void updateMemberStatus(List<String> onLineMemberList, List<POCMemberInfo> allData) {
        if (allData == null) {
            return;
        }
        int onLineCount = 0;
        if (onLineMemberList != null) {
            onLineCount = onLineMemberList.size();
            for (int i = 0; i < onLineMemberList.size(); i++) {
                for (int j = 0; j < allData.size(); j++) {
                    if (onLineMemberList.get(i).equals(allData.get(j).getAccount())) {
                        allData.get(j).setOnLine(true);
                        break;
                    }
                }
            }
        }
        TotalCount = allData.size();
        if (checkViewIsValid()) {
            mView.setOnlineNumerCount(String.format(GlobalContext.getContext().getString(R.string.poc_conversation_participants_count), String.valueOf(onLineCount), String.valueOf(TotalCount)));
            mView.setOnLineCount(onLineCount, TotalCount);
        }
    }

    private void updateMemberStatus(List<POCMemberInfo> allData, JSONArray jsonArray, boolean isOnline) throws JSONException {
        if (allData == null) {
            return;
        }
        for (int i = 0; i < jsonArray.length(); i++) {
            for (int j = 0; j < allData.size(); j++) {
                if (jsonArray.getString(i).equals(allData.get(j).getAccount())) {
                    allData.get(j).setOnLine(isOnline);
                    if (mAccountToName != null && mAccountToName.containsKey(allData.get(j).getAccount())) {
                        allData.get(j).setName(mAccountToName.get(allData.get(j).getAccount()).getName());
                        allData.get(j).setPinyin(GroupUtils.generatePinYin(allData.get(j).getName()));
                    }
                }
            }
        }
    }

    public void removeTimeoutRunnable(String reason) {
        Log.d("zlq", "zlq remove timeoutRunnable.=====" + reason);
        handler.removeCallbacks(requstTimeoutRunnable);
        handler.removeCallbacks(releaseTimeoutRunnable);
    }

    private Runnable requstTimeoutRunnable = new Runnable() {
        @Override
        public void run() {
            LogUtils.DLog("[POC_LOG]", "zlq timeoutRunnable.");
            resetButton(GlobalContext.getContext().getString(R.string.poc_conversation_request_tbcp_timeout));
        }
    };

    private Runnable releaseTimeoutRunnable = new Runnable() {
        @Override
        public void run() {
            LogUtils.DLog("[POC_LOG]", "zlq timeoutRunnable.");
            resetButton(GlobalContext.getContext().getString(R.string.poc_conversation_talk_status_free));
        }
    };

    /**
     * 当点击其他View时隐藏软键盘
     *
     * @param excludeViews 点击这些View不会触发隐藏软键盘动作
     */
    private void hideInputWhenTouchOtherView(Activity activity, MotionEvent ev, View excludeViews) {
        if (ev.getAction() == MotionEvent.ACTION_DOWN) {
            if (excludeViews != null) {
                if (isTouchView(excludeViews, ev)) {
                    return;
                }
            }
            View v = activity.getCurrentFocus();
            if (isShouldHideInput(v, ev)) {
                InputMethodManager inputMethodManager = (InputMethodManager)
                        activity.getSystemService(Context.INPUT_METHOD_SERVICE);
                if (inputMethodManager != null) {
                    inputMethodManager.hideSoftInputFromWindow(v.getWindowToken(), 0);
                }
            }
        }
    }

    private boolean isTouchView(View view, MotionEvent event) {
        if (view == null || event == null) {
            return false;
        }
        int[] leftTop = {0, 0};
        view.getLocationInWindow(leftTop);
        int left = leftTop[0];
        int top = leftTop[1];
        int bottom = top + view.getHeight();
        int right = left + view.getWidth();
        return event.getRawX() > left && event.getRawX() < right
                && event.getRawY() > top && event.getRawY() < bottom;
    }

    private boolean isShouldHideInput(View v, MotionEvent event) {
        return v != null && (v instanceof EditText) && !isTouchView(v, event);
    }

    private synchronized boolean requestTbcp(boolean value, boolean isForce) {
        lastKeyCode = 1;
        if (!isForce && bWaitingReleaseTBCP || bWaitingTakenTBCP || bPressTalk) {
            LogUtils.DLog("[POC_LOG]", "bWaitingReleaseTBCP:" + bWaitingReleaseTBCP
                    + ", bWaitingTakenTBCP:" + bWaitingTakenTBCP
                    + ", bNeedReleaseTBCP:" + bNeedReleaseTBCP
                    + ", bPressTalk:" + bPressTalk);
            return false;
        }
        //mTvTalkStatus.setText(getString(R.string.poc_conversation_request_tbcp_droit));
        bWaitingTakenTBCP = true;
        POCClient.takenTBCP(roomId, isForce ? 1 : 0);
        removeTimeoutRunnable("requestTbcp");
        handler.postDelayed(requstTimeoutRunnable, TBCP_REQUEST_TIMEOUT);
        return value;
    }

    private synchronized boolean requestReleaseTbcp(boolean value) {
        lastKeyCode = 2;
        if (bWaitingReleaseTBCP || bWaitingTakenTBCP) {
//            bNeedReleaseTBCP = true;
//            bNeedReleaseTBCP = true;
            if (bWaitingTakenTBCP) {
                bNeedReleaseTBCP = true;
            }
            LogUtils.DLog("[POC_LOG]", "requestReleaseTbcp bWaitingReleaseTBCP:" + bWaitingReleaseTBCP
                    + ", bWaitingTakenTBCP:" + bWaitingTakenTBCP
                    + ", bNeedReleaseTBCP:" + bNeedReleaseTBCP
                    + ", bPressTalk:" + bPressTalk);
            if (checkViewIsValid()) {
                mView.resetReleaseStatus(false);
            }
            return false;
        }

        if (!bTakenTBCP) {
            if (bPressTalk) {
                bNeedReleaseTBCP = true;
            }
            LogUtils.DLog("[POC_LOG]", "--bWaitingReleaseTBCP:" + bWaitingReleaseTBCP
                    + ", bWaitingTakenTBCP:" + bWaitingTakenTBCP
                    + ", bPressTalk:" + bPressTalk
                    + ", bTakenTBCP:" + bTakenTBCP
                    + ", bNeedReleaseTBCP:" + bNeedReleaseTBCP);
            if (checkViewIsValid()) {
                mView.setTalkStatus(GlobalContext.getContext().getString(R.string.poc_conversation_talk_status_free));
                mView.resetButton();
                mView.resetReleaseStatus(false);
            }
            return false;
        }
        //mTvTalkStatus.setText(getString(R.string.poc_conversation_release_tbcp_droit));
        bWaitingReleaseTBCP = true;
        bPressVolumeDown = false;
        POCClient.releaseTBCP(roomId);
        removeTimeoutRunnable("requestReleaseTbcp");
        handler.postDelayed(releaseTimeoutRunnable, TBCP_REQUEST_TIMEOUT);
        return value;

    }

    private void showProgressDialog() {
        mProgressDialog = new ProgressDialog(mContext);
        mProgressDialog.setIndeterminateDrawable(GlobalContext.getContext().getResources().getDrawable(R.drawable.poc_progressbar));
        mProgressDialog.setMessage(GlobalContext.getContext().getString(R.string.poc_conversation_creating_room));
        mProgressDialog.setIndeterminate(true);
        mProgressDialog.setCancelable(false);
        if (mProgressDialog != null && !mProgressDialog.isShowing()) {
            // 让ProgressDialog显示
            mProgressDialog.show();
        }
    }

    private void hideProgressDialog() {
        if (mProgressDialog != null) {
            mProgressDialog.cancel();
            mProgressDialog = null;
        }
    }

    public void setGroup(DBGroupEntity group) {
        this.group = group;
    }

    private boolean checkViewIsValid() {
        return mView != null && mView.isExist();
    }
}
