package com.xdja.poc.sdk.utils;

import android.text.TextUtils;
import android.util.Base64;

import com.xdja.poc.common.utils.LogUtils;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Locale;

/**
 * Created by xdjaxa on 2018/8/30.
 */

@SuppressWarnings("ALL")
public class Utils {


    public static String key = "xdja";
    public static long offset_localTime_serverTime=0;

    public static String genToken(String encryptText) {

        try {
            //说明：token有效期是5minutes
            //offset_localTime_serverTime >0: 说明当前时间比系统时间快，应该减去偏差时间;同理 <0 当前时间比系统时间慢，应给加上偏差时间
            LogUtils.DLog("janus", "constant offset of phoneTime with serverTime:" + offset_localTime_serverTime);
            long expiry_time = System.currentTimeMillis() / 1000 - offset_localTime_serverTime + 5 * 60;
            String realm = "janus";

            StringBuilder sb = new StringBuilder();
            sb.append(expiry_time).append(",").append(realm).append(",").append("janus.plugin.pocroom").append(",").append(md5(encryptText));
            byte signature[] = HMACSHA1.HmacSHA1Encrypt(sb.toString(), key);
            String strBase64 = Base64.encodeToString(signature, Base64.NO_WRAP);
            sb.append(":").append(strBase64);
            return sb.toString();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String md5(String string) {

        if (TextUtils.isEmpty(string)) {

            return "";

        }

        MessageDigest md5;

        try {

            md5 = MessageDigest.getInstance("MD5");

            byte[] bytes = md5.digest(string.getBytes());

            StringBuilder result = new StringBuilder();

            for (byte b : bytes) {

                String temp = Integer.toHexString(b & 0xff);

                if (temp.length() == 1) {

                    temp = "0" + temp;

                }

                result.append(temp);

            }

            return result.toString();

        } catch (NoSuchAlgorithmException e) {

            e.printStackTrace();

        }

        return "";

    }
    private static final int MIN_CLICK_DELAY_TIME = 500;
    private static long lastClickTime;

    public static boolean isFastClick(int duration) {
        boolean flag = false;
        long curClickTime = System.currentTimeMillis();
        if ((curClickTime - lastClickTime) >= duration) {
            flag = true;
        }
        lastClickTime = curClickTime;
        return flag;
    }

    /**
     * 将用户给定的时间以指定的时间格式进行格式化。
     *
     * @param dateTime 时间
     * @param dateTimeFmat 时间格式
     * @return String - 格式化后的时间内容
     */
    public static String fmatLongToString(long dateTime, String dateTimeFmat) {
        return new SimpleDateFormat(dateTimeFmat, Locale.CHINA).format(dateTime);
    }

}
