package com.xdja.poc.sdk.business.webrtc.janusclientapi;

import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.os.PersistableBundle;
import android.util.Log;

import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.sdk.business.JobSchedulerService;
import com.xdja.poc.sdk.business.webrtc.apprtc.PeerConnectionClient;

import org.json.JSONException;
import org.json.JSONObject;
import org.webrtc.EglBase;
import org.webrtc.VideoSink;

import java.lang.ref.WeakReference;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

/**
 * Created by ben.trent on 5/7/2015.
 */
@SuppressWarnings({"ALL", "EmptyCatchBlock", "TryWithIdenticalCatches"})
public class JanusServer implements Runnable, IJanusMessageObserver, IJanusSessionCreationCallbacks, IJanusAttachPluginCallbacks {
    public static final String API_KEY = "xdja_api_abc";
    public static final String TOKEN_ERROR = "token error";

    public static class RandomString {
        final String str = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
        final Random rnd = new Random();

        public String randomString(Integer length) {
            StringBuilder sb = new StringBuilder(length);
            for (int i = 0; i < length; i++) {
                sb.append(str.charAt(rnd.nextInt(str.length())));
            }
            return sb.toString();
        }
    }

    public String serverUri;
    private static volatile ConcurrentHashMap<Integer, JanusServer> serverMap;
    private static volatile ConcurrentHashMap<Integer, BigInteger> serverSessionIdMap;

    private int lastCode = 0;
    private String lastString;
    private List<IJanusGatewayCallbacks> gatewayCallbacksList = new ArrayList<>();
    private final RandomString stringGenerator = new RandomString();
    private ConcurrentHashMap<BigInteger, JanusPluginHandleWithWebrtc> attachedPlugins = new ConcurrentHashMap<>();
    // private Object attachedPluginsLock = new Object();
    private HashMap<String, ITransactionCallbacks> transactions = new HashMap<>();
    private final Object transactionsLock = new Object();
    //    static private BigInteger sessionId  = new BigInteger("-1");
    private volatile boolean connected;
    private volatile boolean connecting;
    private volatile boolean opened = false;
    private IJanusMessenger serverConnection;
    private volatile Thread keep_alive;
    private volatile boolean peerConnectionFactoryInitialized = false;
    private boolean isCreatePeerConnection;
    private HandlerThread monitorThread = new HandlerThread("monitor_thread");
    private volatile Handler monitorHandler = null;

    private final int CONNECT_TIMEOUT_MSG = 1;
    private final int CONNECT_TIMEOUT_SECOND_VALUE = 10000;//ms
    private volatile int reconnectTimes = 0;
    private final int MAX_RETRY_TIMES = 3;
    JobScheduler mJobScheduler;

    @SuppressWarnings("TryWithIdenticalCatches")
    private static class AsyncAttach extends AsyncTask<IJanusPluginCallbacks, Void, Void> {

        private final WeakReference<JanusServer> janusServerWeakReference;

        public AsyncAttach(JanusServer janusServer) {
            janusServerWeakReference = new WeakReference<>(janusServer);

        }

        protected Void doInBackground(IJanusPluginCallbacks... cbs) {
            IJanusPluginCallbacks cb = cbs[0];
            if (janusServerWeakReference.get() != null) {
                JanusServer janusServer = janusServerWeakReference.get();
                if (!janusServer.connected || janusServer.connecting) {
                    cb.onCallbackError("AsyncAttach failed, for connected:" + janusServer.connected + ",connecting:" + janusServer.connecting);
                    return null;
                }
                try {
                    JSONObject obj = new JSONObject();
                    obj.put("janus", JanusMessageType.attach);
                    obj.put("plugin", cb.getPlugin());
                    obj.put("apisecret", API_KEY);
                    BigInteger sessionId = getSessionId(janusServer.serverUri);
                    if (janusServer.serverConnection.getMessengerType() == JanusMessengerType.websocket && sessionId != null && sessionId.intValue() != -1) {
                        obj.put("session_id", sessionId);
                    }
                    ITransactionCallbacks tcb = JanusTransactionCallbackFactory.createNewTransactionCallback(janusServer, TransactionType.attach, cb.getPlugin(), cb);
                    String transaction = janusServer.putNewTransaction(tcb);
                    obj.put("transaction", transaction);
                    janusServer.serverConnection.sendMessage(obj.toString(), sessionId);
                } catch (JSONException ex) {
                    cb.onCallbackError(ex.getMessage());
                } catch (Exception ex) {
                    cb.onCallbackError(ex.getMessage());
                }
            }

            return null;
        }

        @Override
        protected void onPostExecute(Void aVoid) {
            super.onPostExecute(aVoid);
            LogUtils.ELog("AsyncAttach", "cancel");
            try {
                this.cancel(true);
            } catch (Exception e) {
                LogUtils.ELog(e);
            }

        }
    }

    private static ConcurrentHashMap<Integer, JanusServer> getJanusServerMap() {
        if (serverMap == null) {
            serverMap = new ConcurrentHashMap<>();
        }
        return serverMap;
    }

    private static void putSessionID(String serverUri, BigInteger sessionId) {
        if (serverSessionIdMap == null) {
            serverSessionIdMap = new ConcurrentHashMap<>();
        }
        serverSessionIdMap.remove(serverUri.hashCode());
        serverSessionIdMap.put(serverUri.hashCode(), sessionId);
    }

    private static BigInteger getSessionId(String serverUri) {
        if (serverSessionIdMap == null) {
            return null;
        }
        return serverSessionIdMap.get(serverUri.hashCode());
    }

    private static void removeSessionId(String serverUri) {
        if (serverSessionIdMap == null) {
            return;
        }
        serverSessionIdMap.remove(serverUri.hashCode());
    }

    public static JanusServer getJanusServer(String serverUri) {
        if (getJanusServerMap().get(serverUri.hashCode()) != null) {
            return getJanusServerMap().get(serverUri.hashCode());
        }
        JanusServer janusServer = new JanusServer(serverUri);
        getJanusServerMap().put(serverUri.hashCode(), janusServer);
        return janusServer;
    }

    public synchronized void removeCallback(IJanusGatewayCallbacks callback) {
        if (gatewayCallbacksList != null && gatewayCallbacksList.contains(callback)) {
            Log.d(JanusServer.class.getName(), "poc room is removed==" + serverUri.hashCode() + ", serverUri:" + serverUri);
            gatewayCallbacksList.remove(callback);
        }
    }

    public synchronized void addCallback(IJanusGatewayCallbacks callback) {
        if (gatewayCallbacksList == null) {
            gatewayCallbacksList = new ArrayList<>();
        }
        gatewayCallbacksList.add(callback);
        Log.d(JanusServer.class.getName(), "poc room add==" + serverUri + ", serverUri.hashCode():" + serverUri.hashCode());
    }

    private JanusServer(String serverUri) {
        System.setProperty("java.net.preferIPv6Addresses", "false");
        System.setProperty("java.net.preferIPv4Stack", "true");
        this.connected = false;
        this.opened = false;
//        BigInteger sessionId = new BigInteger("-1");
//        putSessionID(serverUri, sessionId);
        this.serverUri = serverUri;
        this.serverConnection = JanusMessagerFactory.createMessager(serverUri, this);
        initMonitorThread();
    }

    private String putNewTransaction(ITransactionCallbacks transactionCallbacks) {
        String transaction = stringGenerator.randomString(12);
        synchronized (transactionsLock) {
            while (transactions.containsKey(transaction))
                transaction = stringGenerator.randomString(12);
            transactions.put(transaction, transactionCallbacks);
        }
        return transaction;
    }

    private void createSession() {
        monitorHandler.removeMessages(CONNECT_TIMEOUT_MSG);
        monitorHandler.removeCallbacksAndMessages(null);

        try {
            JSONObject obj = new JSONObject();
            obj.put("janus", JanusMessageType.create);
            ITransactionCallbacks cb = JanusTransactionCallbackFactory.createNewTransactionCallback(this, TransactionType.create);
            String transaction = putNewTransaction(cb);

            BigInteger sessionId = getSessionId(serverUri);
            if (sessionId != null && sessionId.intValue() != -1) {
                obj.put("id", sessionId);
            }
            obj.put("apisecret", API_KEY);
            obj.put("transaction", transaction);
            serverConnection.sendMessage(obj.toString());
        } catch (JSONException ex) {
            onCallbackError(ex.getMessage());
        }
    }

    public static final int MY_BACKGROUND_JOB = 0;
    Context mContext;
    PeerConnectionClient.PeerConnectionParameters peerConnectionParameters;
    VideoSink localVideoSink, remoteVideoSink;
    EglBase eglBase;

    public boolean initializeMediaContext(Context context, boolean audio, boolean video, boolean videoHwAcceleration, PeerConnectionClient.PeerConnectionParameters peerConnectionParameters) {
//        if (!PeerConnectionFactory.initializeAndroidGlobals(context, audio, video, videoHwAcceleration, eglContext))
//            return false;
//        PeerConnectionFactory.initialize();
        mContext = context;
        this.peerConnectionParameters = peerConnectionParameters;

        peerConnectionFactoryInitialized = true;
        return true;
    }

    public boolean initializeMediaContext(Context context, VideoSink localVideoSink, VideoSink remoteVideoSink, EglBase eglBase, PeerConnectionClient.PeerConnectionParameters peerConnectionParameters) {
        mContext = context;
        this.eglBase = eglBase;
        this.peerConnectionParameters = peerConnectionParameters;
        this.localVideoSink = localVideoSink;
        this.remoteVideoSink = remoteVideoSink;

        peerConnectionFactoryInitialized = true;
        return true;
    }

    public void run() {
        long waitTime = 60000;
        int retryTimes = 0;
        int maxRetryTimes = 5;

        Thread thisThread = Thread.currentThread();
        LogUtils.DLog(JanusServer.class.getName(), "Run start check:" + serverUri + ",this:" + this);
        while (keep_alive == thisThread) {
            if (!connected || serverConnection.getMessengerType() != JanusMessengerType.websocket) {
                LogUtils.ELog(JanusServer.class.toString(), "[1]heartbeat check not connected ");
                break;
            }
            try {
                synchronized (JanusServer.this) {
                    JanusServer.this.wait(waitTime);
                }
//                thisThread.sleep(60000);//120000
            } catch (Exception ex) {
            }
            LogUtils.ELog(JanusServer.class.toString(), "connected: " + connected + "  serverConnection.getMessengerType(): " + serverConnection.getMessengerType() + ",this:" + this);
            if (!connected || serverConnection.getMessengerType() != JanusMessengerType.websocket) {
                LogUtils.ELog(JanusServer.class.toString(), "[2]heartbeat check not connected ");
                break;
            }
            JSONObject obj = new JSONObject();
            try {
                BigInteger sessionId = getSessionId(serverUri);
                obj.put("janus", JanusMessageType.keepalive.toString());
                if (serverConnection.getMessengerType() == JanusMessengerType.websocket && sessionId != null && sessionId.intValue() != -1) {
                    obj.put("session_id", sessionId);
                }
                obj.put("apisecret", API_KEY);
                obj.put("transaction", stringGenerator.randomString(12));
                serverConnection.sendMessage(obj.toString(), sessionId);
                retryTimes = 0;
                waitTime = 60000;
            } catch (Exception ex) {
                LogUtils.ELog(JanusServer.class.toString(), "ex:" + ex.getMessage());
                retryTimes++;
                waitTime = 2000;
                if (retryTimes >= maxRetryTimes) {
                    onCallbackError(JanusWebSocketClient.NETWORK_ERROR, ex.getMessage());
                    connected = false;
                    break;
                }
            }
        }
        connected = false;
        connecting = false;

        LogUtils.ELog(JanusServer.class.getName(), "Run end, remove serverUri from map:" + serverUri + ", hashcode:" + serverUri.hashCode());
        removeSessionId(serverUri);

//        onCallbackError(JanusWebSocketClient.NETWORK_ERROR,"connection failed");
//        onCallbackError("can not connect server.");
    }

    public boolean isConnected() {
        return connected;
    }

    public boolean peerConnectionFactoryInitialized() {
        return peerConnectionFactoryInitialized;
    }

    public BigInteger getSessionId() {
        return getSessionId(serverUri);
    }

    public void Attach(IJanusPluginCallbacks callbacks, boolean flag) {
        isCreatePeerConnection = flag;
        if (!peerConnectionFactoryInitialized) {
            callbacks.onCallbackError("Peerconnection factory is not initialized, please initialize via initializeMediaContext connected:" + connected + ",connecting:" + connecting);
            return;
        }
        new AsyncAttach(this).execute(callbacks);
    }

    public static void disconnectServer() {
        for (ConcurrentHashMap.Entry<Integer, JanusServer> server : getJanusServerMap().entrySet()) {
            server.getValue().destroy();
        }
    }

    public void destroy() {
        try {
            monitorHandler.removeMessages(CONNECT_TIMEOUT_MSG);
            monitorHandler.removeCallbacksAndMessages(null);
            if (monitorThread != null && monitorThread.isAlive()) {
                monitorThread.getLooper().quit();//quit thread
            }
            getJanusServerMap().remove(serverUri.hashCode());
            removeSessionId(serverUri);
        } catch (Exception ex) {
            LogUtils.ELog(JanusServer.class.toString(), "destroy():" + ex.getMessage());
        }

        if (connected) {
            for (HashMap.Entry<BigInteger, JanusPluginHandleWithWebrtc> handle : attachedPlugins.entrySet()) {
                handle.getValue().detach();
            }
            serverConnection.disconnect();
        }
        synchronized (JanusServer.this) {
            JanusServer.this.notifyAll();//notify the current thread end.
        }

//        stopJob();//lyz@xdja.com

        keep_alive = null;
        connected = false;

        synchronized (transactionsLock) {
            for (Object trans : transactions.entrySet())
                transactions.remove(trans);
        }
        gatewayCallbacksList.clear();
        //callback
        onDestroy();
    }

    public synchronized boolean connect() {
        if (connected) {
            LogUtils.ELog(JanusServer.class.toString(), "connect() connected");
            return true;
        }
        if (connecting) {
            LogUtils.ELog(JanusServer.class.toString(), "connect() connecting");
            return true;
        }
        Log.v(JanusServer.class.toString(), "start connect()");
        reconnectTimes = 0;
        connecting = true;
        reconnectTimes = 0;
        lastCode = 0;//reset
        try {
            // lyj 重连之前不为空则断开连接，重新建立连接，防止内存泄漏
            if (serverConnection != null) {
                serverConnection.disconnect();
                Log.e(JanusServer.class.toString(), "connect: disconnect");
            }
            serverConnection = JanusMessagerFactory.createMessager(serverUri, JanusServer.this);
            serverConnection.connect();
            monitorHandler.sendEmptyMessageDelayed(CONNECT_TIMEOUT_MSG, CONNECT_TIMEOUT_SECOND_VALUE);
        } catch (Exception ex) {
            onCallbackError("connect failed:" + ex.getMessage());
            return false;
        }
        return true;
    }

    private void initMonitorThread() {
        try {
            monitorThread.start();
            monitorHandler = new Handler(monitorThread.getLooper()) {
                @Override
                public void handleMessage(Message msg) {
                    super.handleMessage(msg);
                    switch (msg.what) {
                        case CONNECT_TIMEOUT_MSG:
                            LogUtils.ELog(JanusServer.class.toString(), "CONNECT_TIMEOUT_MSG, reconnect:" + reconnectTimes);
                            if (reconnectTimes > MAX_RETRY_TIMES) {
                                connecting = false;
                                onCallbackError("can not connect server.");
                                return;
                            }
                            connecting = true;
                            reconnectTimes++;
                            serverConnection.disconnect();
                            serverConnection = JanusMessagerFactory.createMessager(serverUri, JanusServer.this);
                            serverConnection.connect();
                            monitorHandler.sendEmptyMessageDelayed(CONNECT_TIMEOUT_MSG, CONNECT_TIMEOUT_SECOND_VALUE);
                            break;
                        default:
                            break;
                    }
                }
            };
        } catch (Exception ex) {
            LogUtils.ELog(JanusServer.class.toString(), "monitorHandler.sendEmptyMessageDelayed ex:" + ex.getMessage());
        }
    }

    public void newMessageForPlugin(String message, BigInteger plugin_id) {
        JanusPluginHandleWithWebrtc handle;
        handle = attachedPlugins.get(plugin_id);
        if (handle != null) {
            handle.onMessage(message);
        }
    }

    public void sendMessage(JSONObject msg, JanusMessageType type, BigInteger handle) {
        try {
            if (!connected) {
                LogUtils.ELog(JanusServer.class.toString(), "sendMessage not connected");
                return;
            }
            msg.put("janus", type.toString());
            BigInteger sessionId = getSessionId(serverUri);
            if (serverConnection.getMessengerType() == JanusMessengerType.websocket && sessionId != null && sessionId.intValue() != -1) {
                msg.put("session_id", sessionId);
            }
            msg.put("apisecret", API_KEY);
            msg.put("handle_id", handle);
            msg.put("transaction", stringGenerator.randomString(12));
            if (connected) {
                serverConnection.sendMessage(msg.toString(), sessionId, handle);
            }
            if (type == JanusMessageType.detach) {
                if (attachedPlugins.containsKey(handle))
                    attachedPlugins.remove(handle);
            }
        } catch (JSONException ex) {
            //onCallbackError(JanusWebSocketClient.JSON_ERROR, ex.getMessage());
            LogUtils.ELog(JanusServer.class.toString(), "ex:" + ex.getMessage());
        }
    }

    //TODO not sure if the send message functions should be Asynchronous

    public void sendMessage(TransactionType type, BigInteger handle, IPluginHandleSendMessageCallbacks callbacks, JanusSupportedPluginPackages plugin) {
        if (!connected) {
            callbacks.onCallbackError("websocket not connected.");
            return;
        }
        JSONObject msg = callbacks.getMessage();
        if (msg != null) {
            try {
                JSONObject newMessage = new JSONObject();
                newMessage.put("janus", JanusMessageType.message.toString());
                newMessage.put("apisecret", API_KEY);

                BigInteger sessionId = getSessionId(serverUri);
                if (serverConnection.getMessengerType() == JanusMessengerType.websocket && sessionId != null && sessionId.intValue() != -1) {
                    newMessage.put("session_id", sessionId);
                }
                newMessage.put("handle_id", handle);
                ITransactionCallbacks cb = JanusTransactionCallbackFactory.createNewTransactionCallback(this, TransactionType.plugin_handle_message, plugin, callbacks);
                String transaction = putNewTransaction(cb);
                newMessage.put("transaction", transaction);
                if (msg.has("message")) {
                    newMessage.put("body", msg.getJSONObject("message"));
                }
                if (msg.has("jsep")) {
                    newMessage.put("jsep", msg.getJSONObject("jsep"));
                }
                serverConnection.sendMessage(newMessage.toString(), sessionId, handle);
            } catch (JSONException ex) {
                callbacks.onCallbackError(ex.getMessage());
            } catch (Exception ex) {
                callbacks.onCallbackError(ex.getMessage());
            }
        }
    }

    public void sendMessage(TransactionType type, BigInteger handle, IPluginHandleWebRTCCallbacks callbacks, JanusSupportedPluginPackages plugin) {
        if (!connected) {
            callbacks.onCallbackError("websocket not connected.");
            return;
        }

        try {
            JSONObject msg = new JSONObject();
            msg.put("janus", JanusMessageType.message.toString());
            msg.put("apisecret", API_KEY);
            BigInteger sessionId = getSessionId(serverUri);
            if (serverConnection.getMessengerType() == JanusMessengerType.websocket && sessionId != null && sessionId.intValue() != -1) {
                msg.put("session_id", sessionId);
                msg.put("handle_id", handle);
            }
            ITransactionCallbacks cb = JanusTransactionCallbackFactory.createNewTransactionCallback(this, TransactionType.plugin_handle_webrtc_message, plugin, callbacks);
            String transaction = putNewTransaction(cb);
            msg.put("transaction", transaction);
            if (callbacks.getJsep() != null) {
                msg.put("jsep", callbacks.getJsep());
            }
            serverConnection.sendMessage(msg.toString(), sessionId, handle);
        } catch (JSONException ex) {
            callbacks.onCallbackError(ex.getMessage());
        }
    }

    void onCallbackError(int code, String error) {
        LogUtils.ELog(JanusServer.class.toString(), "code:" + code + " , lastCode: " + lastCode + " , err:" + error + ", reconnectTimes:" + reconnectTimes);
        if (reconnectTimes > 0 && reconnectTimes < MAX_RETRY_TIMES) {
            return;
        }
        connected = false;
        connecting = false;
        synchronized (JanusServer.this) {
            JanusServer.this.notifyAll();//notify the current thread end.
        }

//        if (code == JanusWebSocketClient.NETWORK_ERROR && lastCode == JanusWebSocketClient.NETWORK_ERROR){
//            return;
//        }
        lastCode = code;
        try {
            if (gatewayCallbacksList == null) {
                return;
            }
            for (IJanusGatewayCallbacks callback : gatewayCallbacksList) {
                callback.onCallbackError(error);
            }
            gatewayCallbacksList.clear();//no need callback left.
        } catch (Exception ex) {
            // TODO: 2018/10/17
            LogUtils.ELog(JanusServer.class.toString(), "e:" + ex.getMessage());
        }
        try {
            if (monitorThread != null && monitorThread.isAlive()) {
                monitorThread.getLooper().quit();//quit thread
            }
            getJanusServerMap().remove(serverUri.hashCode());
        } catch (Exception ex) {
            LogUtils.ELog(JanusServer.class.toString(), "destroy():" + ex.getMessage());
        }
    }

    synchronized void onCallbackSuccess() {
        lastCode = 0;
        if (gatewayCallbacksList == null) {
            return;
        }
        for (IJanusGatewayCallbacks callback : gatewayCallbacksList) {
            callback.onSuccess();
        }
    }

    synchronized void onDestroy() {
        if (gatewayCallbacksList == null) {
            return;
        }
        for (IJanusGatewayCallbacks callback : gatewayCallbacksList) {
            callback.onDestroy();
        }
    }

    //region MessageObserver
    @Override
    public void receivedNewMessage(JSONObject obj) {
        try {
//            LogUtils.DLog("Zhangs","306 : "+obj);
            JanusMessageType type = JanusMessageType.fromString(obj.getString("janus"));
            String transaction = null;
            BigInteger sender = null;
            if (obj.has("transaction")) {
                transaction = obj.getString("transaction");
            }
            if (obj.has("sender")) {
                sender = new BigInteger(obj.getString("sender"));
            }
            JanusPluginHandleWithWebrtc handle = null;
            if (sender != null) {
                handle = attachedPlugins.get(sender);
            }
            switch (type) {
                case keepalive:
                    break;
                case ack:
                case success:
                case error: {
                    if (transaction != null) {
                        ITransactionCallbacks cb;
                        synchronized (transactionsLock) {
                            cb = transactions.get(transaction);
                            if (cb != null)
                                transactions.remove(transaction);
                        }
                        if (cb != null) {
                            if (obj.has("error")) {
                                JSONObject error = obj.getJSONObject("error");
                                LogUtils.ELog(JanusServer.class.toString(), "error : " + error.toString());
                                if (error.has("code")) {
                                    int errorCode = error.getInt("code");
                                    if (errorCode == 468) {
                                        //Session ID already in use
                                        BigInteger sessionId = new BigInteger("-1");
                                        putSessionID(serverUri, sessionId);
                                        try {
                                            if (monitorHandler != null) {
                                                monitorHandler.postDelayed(new Runnable() {
                                                    @Override
                                                    public void run() {
                                                        //just delay.
                                                        createSession();
                                                    }
                                                }, 1000);
                                            }

                                        } catch (IllegalStateException ex) {

                                        }
                                        return;
                                    } else if (errorCode == 403 || errorCode == 405) {
                                        //token error（wrong or missing secret/token'）
                                        LogUtils.ELog(JanusServer.class.getName(), error.get("reason") + "");
                                        onCallbackError(JanusWebSocketClient.TOKEN_ERROR, TOKEN_ERROR);
                                        return;
                                    } else if (errorCode == 458) {
                                        /*
                                        "code": 458,"reason": "No such session 18446744073709551615"
                                         */
                                        if (!connected || connecting) {
                                            createSession();
                                        } else {
                                            //call the user the status error
                                            onCallbackError(JanusWebSocketClient.TOKEN_ERROR, "session error");
                                        }
                                        return;
                                    }
                                }
                            }
                            cb.reportSuccess(obj);
                        }
                    }
                    break;
                }
                case hangup:
                case detached: {
                    if (handle != null) {
                        handle.onDetached();
                        handle.detach();
                    }
                    break;
                }
                case event: {
                    if (handle != null) {
                        LogUtils.DLog(JanusServer.class.getName(), "handle input event.");
                        JSONObject plugin_data = null;
                        if (obj.has("plugindata"))
                            plugin_data = obj.getJSONObject("plugindata");
                        if (plugin_data != null) {
                            JSONObject data = null;
                            JSONObject jsep = null;
                            if (plugin_data.has("data"))
                                data = plugin_data.getJSONObject("data");
                            if (obj.has("jsep"))
                                jsep = obj.getJSONObject("jsep");
                            LogUtils.DLog(JanusServer.class.getName(), "handle input event:" + jsep);
                            handle.onMessage(data, jsep);
                        }
                    }
                }
            }
        } catch (JSONException ex) {
            LogUtils.ELog(JanusServer.class.toString(), "ex:" + ex.getMessage());
            //onCallbackError(JanusWebSocketClient.JSON_ERROR, ex.getMessage());
        }
    }

    @Override
    public void onOpen() {
        LogUtils.ILog(JanusServer.class.toString(), "onOpen: connect ok:" + opened);
        if (opened) {
            return;
        }
        opened = true;
        createSession();
    }

    @Override
    public void onClose() {
        opened = false;
        connected = false;
        onCallbackError(0, "Connection to janus server is closed");
    }

    @Override
    public void onError(int errorCode, String message) {
        connected = false;
        opened = false;
        onCallbackError(errorCode, message);
    }
    //endregion

    //region SessionCreationCallbacks
    @Override
    public void onCallbackError(String msg) {
        LogUtils.ELog(JanusServer.class.toString(), "Create session faild,onCallbackError:" + msg);
        connecting = false;
        connected = false;
//        stopJob();
        reconnectTimes = 0;
        if (monitorHandler != null) {
            monitorHandler.removeMessages(CONNECT_TIMEOUT_MSG);
        }

        onCallbackError(JanusWebSocketClient.NETWORK_ERROR, msg);
    }

    @Override
    public void onSessionCreationSuccess(JSONObject obj) {
        Log.v(JanusServer.class.toString(), "onSessionCreationSuccess: connect ok");
        if (monitorHandler != null) {
            monitorHandler.removeMessages(CONNECT_TIMEOUT_MSG);
        }

        reconnectTimes = 0;
        try {
            BigInteger sessionId = new BigInteger(obj.getJSONObject("data").getString("id"));
            putSessionID(serverUri, sessionId);
            keep_alive = new Thread(this, "KeepAlive");
            connected = true;
            connecting = false;
            keep_alive.start();
//            scheduleJob();//lyz@xdja.com add for tick .
            //TODO do we want to keep track of multiple sessions and servers?
            onCallbackSuccess();
        } catch (Exception ex) {
            onCallbackError(JanusWebSocketClient.JSON_ERROR, ex.getMessage());
        }
    }
    //endregion
    //region AttachPluginCallbacks

    @Override
    public void attachPluginSuccess(JSONObject obj, JanusSupportedPluginPackages plugin, IJanusPluginCallbacks pluginCallbacks) {
        try {
            BigInteger handle = new BigInteger(obj.getJSONObject("data").getString("id"));
            JanusPluginHandleWithWebrtc pluginHandle = new JanusPluginHandleWithWebrtc(this, plugin, handle, pluginCallbacks, mContext, peerConnectionParameters, localVideoSink, remoteVideoSink, eglBase, isCreatePeerConnection);

            attachedPlugins.put(handle, pluginHandle);
            pluginCallbacks.success(pluginHandle);
        } catch (JSONException ex) {
            //or do we want to use the pluginCallbacks.error(ex.getMessage());
            pluginCallbacks.onCallbackError(ex.getMessage());
        }
    }

    //endregion
    public static void doAllSchedule() {
        LogUtils.ILog(JanusServer.class.toString(), "doAllSchedule");
        for (HashMap.Entry<Integer, JanusServer> handle : serverMap.entrySet()) {
            handle.getValue().doSchedule(handle.getValue().serverUri);
        }
    }

    public boolean doSchedule(String serveruri) {
        LogUtils.ILog(JanusServer.class.toString(), "doSchedule: connect:" + connected + ",serveruri:" + serveruri + ",this:" + this);
        if (!connected) {
            LogUtils.ILog(JanusServer.class.toString(), "doSchedule:reconnect server");
            connect();
            return false;
        }
        synchronized (JanusServer.this) {
            JanusServer.this.notifyAll();//notify the current thread end.
        }
        return true;
    }

    private void scheduleJob() {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            //5.0+
            mJobScheduler = (JobScheduler) mContext.getSystemService(Context.JOB_SCHEDULER_SERVICE);
            JobInfo.Builder builder = new JobInfo.Builder(MY_BACKGROUND_JOB,
                    new ComponentName(mContext.getPackageName(), JobSchedulerService.class.getName()));
            builder.setRequiredNetworkType(JobInfo.NETWORK_TYPE_ANY);
            builder.setBackoffCriteria(TimeUnit.MILLISECONDS.toMillis(10), JobInfo.BACKOFF_POLICY_LINEAR);
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
                builder.setMinimumLatency(120 * 1000);
            } else {
                builder.setPeriodic(60 * 1000);
            }
            PersistableBundle persiBundle = new PersistableBundle();
            persiBundle.putString(JobSchedulerService.SERVER_URI, serverUri);
            builder.setExtras(persiBundle);
            mJobScheduler.schedule(builder.build());
        }
    }

    private void stopJob() {
        mJobScheduler.cancelAll();
    }

}
