package com.xdja.poc.sdk.receiver;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;
import android.widget.Toast;

import com.xdja.poc.common.base.BaseActivity;
import com.xdja.poc.common.utils.GlobalContext;
import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.common.utils.PreferenceHelper;
import com.xdja.poc.common.utils.StringUtils;
import com.xdja.poc.common.utils.UiUtils;
import com.xdja.poc.sdk.R;
import com.xdja.poc.sdk.business.MessageProxy;
import com.xdja.poc.sdk.business.ringplay.RingPlayer;
import com.xdja.poc.sdk.config.Constants;
import com.xdja.poc.sdk.config.UserConfig;
import com.xdja.poc.sdk.event.HomeOrRecentEvent;
import com.xdja.poc.sdk.manager.AMnager;

import org.greenrobot.eventbus.EventBus;

@SuppressWarnings("ALL")
public class HomeKeyReceiver extends BroadcastReceiver {
    static HomeKeyReceiver homeKeyReceiver = new HomeKeyReceiver();
    private static boolean isRegister = false;

    @SuppressLint("ShowToast")
    @Override
    public void onReceive(Context context, Intent intent) {
        if (intent == null || TextUtils.isEmpty(intent.getAction()))
            return;
        switch (intent.getAction()) {
            case Intent.ACTION_CLOSE_SYSTEM_DIALOGS:
                String extra = intent.getStringExtra(Constants.SYSTEM_REASON);
                if (!BaseActivity.isSelfActivity || TextUtils.isEmpty(extra)) {
                    return;
                }
//                if (TextUtils.isEmpty(extra)) {
//                    return;
//                }
                if (Constants.SYSTEM_HOME_KEY.toUpperCase().equals(extra.toUpperCase())) {
                    if (UiUtils.isMainThread()) {
                        if (PreferenceHelper.getBoolean(UserConfig.IS_SHOW_HOME_TOAST, true)) {
                            Toast toast = Toast.makeText(GlobalContext.getContext(), "", Toast.LENGTH_LONG);
                            LayoutInflater inflate = (LayoutInflater) GlobalContext.getContext().getSystemService(Context.LAYOUT_INFLATER_SERVICE);
                            assert inflate != null;
                            View v = inflate.inflate(com.xdja.poc.common.R.layout.common_toast_layout, null);
                            TextView tv = v.findViewById(com.xdja.poc.common.R.id.message);
                            tv.setText(context.getResources().getString(R.string.poc_run_in_background));
                            toast.setView(v);
                            toast.show();
                        }
                    }
                    String account = PreferenceHelper.getString(UserConfig.LOGIN_ACCOUNT, "");
                    BaseActivity.isSelfActivity = false;
                    if (!StringUtils.isEmpty(account)) {
                    }
                    MessageProxy.sendNotificationStaus(true);
                    EventBus.getDefault().post(new HomeOrRecentEvent());
                }
                //适配：华为mate10 pro 手势导航发送的key recentApps 正常为recentapps
                if (Constants.SYSTEM_RECENT_KEY.toUpperCase().equals(extra.toUpperCase())) {
                    //按了最近任务列表
                    boolean stop = RingPlayer.getInstance(context).isStop();
                    String TAG = "HomeKeyReceiver";
                    LogUtils.ILog(TAG, "stop: " + stop);
                    if (!stop) {
                        EventBus.getDefault().post(new HomeOrRecentEvent());
                    }
                    MessageProxy.sendNotificationStaus(true);
                }
                break;
            case "com.xdja.poc.login":
                AMnager.startLogin(context);
                break;
        }
    }

    public static void registerHomeReceiver() {
        if (isRegister) {
            return;
        }
        isRegister = true;
        IntentFilter filter = new IntentFilter();
        filter.addAction(Intent.ACTION_CLOSE_SYSTEM_DIALOGS);
        filter.addAction("com.xdja.poc.login");
        GlobalContext.getContext().registerReceiver(homeKeyReceiver, filter);
    }

    public static void unRegisterHomeReceiver() {
        try {
            if (homeKeyReceiver != null && isRegister) {
                GlobalContext.getContext().unregisterReceiver(homeKeyReceiver);
            }
        } catch (Exception ignored) {
        }
    }
}