package com.xdja.poc.sdk.record.play;

import android.annotation.SuppressLint;
import android.content.Context;
import android.media.AudioManager;
import android.os.Build;
import android.os.PowerManager;

import com.xdja.poc.common.utils.GlobalContext;
import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.sdk.config.Constants;
import com.xdja.poc.sdk.ui.history.HistoryVoicePlayer;

/**
 * @Package: com.xdja.im.common.media
 * @Author: xdjaxa
 * @Creation: 2017-09-15 10:51
 * @Version V1.0
 * @Description:媒体播放器管理类
 */
@SuppressWarnings("ALL")
public class MediaManger {

    private static String TAG = "MediaManger";

    private static final int VERSION = Build.VERSION.SDK_INT;

    private AudioManager mAudioManager;

    private PowerManager.WakeLock mWakeLock;

    /**
     * 是否熄灭屏幕
     */
    private boolean isWakeAcquire = false;

    private boolean isReceiverMode = false;

    private boolean isHeadsetOn = false;

    public boolean isReceiverMode() {
        return isReceiverMode;
    }

    public void setReceiverMode(boolean receiverMode) {
        isReceiverMode = receiverMode;
    }

    private static class SingletonInstance {
        private static final MediaManger mInstance = new MediaManger();
    }

    @SuppressLint("InlinedApi")
    private MediaManger() {
        try {
            Context context = GlobalContext.getContext();
            //音频管理模块
            mAudioManager = (AudioManager) context.getSystemService(Context.AUDIO_SERVICE);
            if (VERSION >= Build.VERSION_CODES.LOLLIPOP) {
                //电源管理模块
                PowerManager pManager = (PowerManager) context
                        .getSystemService(Context.POWER_SERVICE);
                mWakeLock = pManager.newWakeLock(PowerManager.PROXIMITY_SCREEN_OFF_WAKE_LOCK, TAG);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static MediaManger getInstance() {
        return SingletonInstance.mInstance;
    }

    /**
     * 设置耳机插入状态
     *
     * @param headsetOn true:插入耳机  false 未插入
     */
    public void setHeadsetOn(boolean headsetOn) {
        isHeadsetOn = headsetOn;
    }

    /**
     * 听筒模式切换
     *
     * @param isReceiverMode 是否为听筒模式
     */
    public void onSensorChanged(boolean isReceiverMode) {

        if (!HistoryVoicePlayer.getInstance().isPlaying()) {
            if (isWakeAcquire) {
                wakeLockBrightRelease();
            }
            LogUtils.DLog(TAG, "onSensorChanged return");
            return;
        }

        if (isReceiverMode) {
            setReceiverModeOn();
        } else {
            setReceiverModeOff();
        }
    }

    /**
     * 线控耳机是否插入
     *
     * @return
     */
    public boolean isHeadsetOn() {
        return Constants.IS_HEADSET_PLUG ||
                mAudioManager.isWiredHeadsetOn();
    }

    /**
     * 打开听筒模式
     */
    public void setReceiverModeOn() {
        //设置为通话模式
        mAudioManager.setMode(AudioManager.MODE_IN_COMMUNICATION);
        mAudioManager.setSpeakerphoneOn(false);
    }

    /**
     * 关闭听筒模式
     */
    public void setReceiverModeOff() {
        setSpeakOn();
        mAudioManager.setMode(AudioManager.MODE_NORMAL);
    }

    public void setSpeakOn() {
        if (!isHeadsetOn)
            mAudioManager.setSpeakerphoneOn(true);
    }

    /**
     * 申请设备电源锁，灭屏
     */
    public void wakeLockBrightAcquire() {
        if (mWakeLock != null && !mWakeLock.isHeld()) {
            isWakeAcquire = true;
            mWakeLock.setReferenceCounted(false);
            mWakeLock.acquire(10 * 60 * 1000L /*10 minutes*/);
        }
    }

    /**
     * 释放电源设备锁，亮屏
     */
    public void wakeLockBrightRelease() {
        if (mWakeLock != null && mWakeLock.isHeld()) {
            isWakeAcquire = false;
            mWakeLock.release();
        }
    }

    public void releaseWakeLock() {
        if (mWakeLock != null && mWakeLock.isHeld()) {
            isWakeAcquire = false;
            mWakeLock.release(); // 释放设备电源锁
        }
    }

    /**
     * 是否熄灭屏幕
     *
     * @return
     */
    public boolean isWakeAcquire() {
        return isWakeAcquire;
    }
}
