package com.xdja.poc.sdk.ui.conversion;

import android.annotation.SuppressLint;
import android.app.KeyguardManager;
import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.PowerManager;
import android.view.WindowManager;

import com.xdja.poc.common.base.BaseActivity;
import com.xdja.poc.sdk.config.Constants;
import com.xdja.poc.sdk.manager.ScreenObserverManager;

/**
 * Created by gouhao on 1/8/2018.
 */

@SuppressWarnings("ALL")
public abstract class BaseScreenActivity extends BaseActivity implements
        ScreenObserverManager.OnScreenStateUpdateListener, SensorEventListener {
    private static final String TAG = BaseScreenActivity.class.getSimpleName();

    protected PowerManager.WakeLock wakeLock;
    protected SensorManager sensorManager;
    protected KeyguardManager keyguardManager;
    protected Sensor mSensor;
    protected boolean isInLockScreen = false;
    private ScreenObserverManager mScreenObserverManager;

    @Override
    protected void initView() {
        init();
    }

    public void init() {
        PowerManager mPowerManager = ((PowerManager) getSystemService(Context.POWER_SERVICE));
        assert mPowerManager != null;
        wakeLock = mPowerManager.newWakeLock(PowerManager.SCREEN_BRIGHT_WAKE_LOCK
                | PowerManager.ACQUIRE_CAUSES_WAKEUP, TAG);
        sensorManager = (SensorManager) getSystemService(Context.SENSOR_SERVICE);
        assert sensorManager != null;
        mSensor = sensorManager.getDefaultSensor(Sensor.TYPE_PROXIMITY);
        keyguardManager = (KeyguardManager) getSystemService(Context.KEYGUARD_SERVICE);
        updateWindowFlags();
        mScreenObserverManager = new ScreenObserverManager(this);
        mScreenObserverManager.register(this);
    }

    private void updateWindowFlags() {
        if (keyguardManager.inKeyguardRestrictedInputMode()) {
            getWindow().addFlags(WindowManager.LayoutParams.FLAG_DISMISS_KEYGUARD |
                    WindowManager.LayoutParams.FLAG_TURN_SCREEN_ON |
                    WindowManager.LayoutParams.FLAG_SHOW_WHEN_LOCKED);
            isInLockScreen = true;
        } else {
            getWindow().clearFlags(WindowManager.LayoutParams.FLAG_DISMISS_KEYGUARD |
                    WindowManager.LayoutParams.FLAG_TURN_SCREEN_ON |
                    WindowManager.LayoutParams.FLAG_SHOW_WHEN_LOCKED);
            isInLockScreen = false;
        }
    }

    @Override
    protected void onResume() {
        super.onResume();
        if (Constants.isScreenOn) {
            screenOn();
        }
    }

    @Override
    protected void onPause() {
        super.onPause();
        screenOff();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        release();
    }

    @SuppressLint("WakelockTimeout")
    private void screenOn() {
        if (wakeLock != null) {
            if (!wakeLock.isHeld()) {
                wakeLock.acquire();
            }
        }
        if (sensorManager != null) {
            sensorManager.registerListener(this, mSensor, SensorManager.SENSOR_DELAY_NORMAL);
        }
    }

    private void screenOff() {
        if (wakeLock != null) {
            if (wakeLock.isHeld()) {
                wakeLock.release();
            }
        }
        if (sensorManager != null) {
            sensorManager.unregisterListener(this);
        }
    }

    public void release() {
        screenOff();
        wakeLock = null;
        if (isInLockScreen) {
            updateWindowFlags();
        }
        if (mScreenObserverManager != null) {
            mScreenObserverManager.unregister(this);
            mScreenObserverManager = null;
        }
    }

    @SuppressLint("WakelockTimeout")
    @Override
    public void onSensorChanged(SensorEvent event) {
        float[] its = event.values;
        if (its != null && event.sensor.getType() == Sensor.TYPE_PROXIMITY) {
            if (its[0] == 0.0) {
                if (wakeLock != null && wakeLock.isHeld()) {
                } else {
                    if (wakeLock != null) {
                        wakeLock.acquire();
                    }
                }
            } else {
                if (wakeLock != null && wakeLock.isHeld()) {
                } else {
                    if (wakeLock != null) {
                        wakeLock.setReferenceCounted(false);
                        wakeLock.release();
                    }
                }
            }
        }
    }

    @Override
    public void onAccuracyChanged(Sensor sensor, int accuracy) {

    }

    @Override
    public void onScreenOn() {

    }

    @Override
    public void onScreenOff() {

    }

    @Override
    public void onUserPresent() {

    }
}
