package com.xdja.poc.sdk.ui.main.mvp;

import com.xdja.net.RetrofitUtil;
import com.xdja.net.observer.CommonObserver;
import com.xdja.net.throwable.HttpThrowable;
import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.sdk.config.Constants;
import com.xdja.poc.sdk.greendao.HistoryMessageDBHelper;
import com.xdja.poc.sdk.record.api.RecordBusiness;
import com.xdja.poc.sdk.record.api.bean.BaseRecordResponse;
import com.xdja.poc.sdk.record.api.bean.SynctimeMessageRequest;
import com.xdja.poc.sdk.ui.history.POCHistoryMessage;

import java.util.List;

/**
 * Created by xdjaxa on 2019/1/10.
 */

@SuppressWarnings("ALL")
public class POCHistoryMessagePresenter implements POCHistoryMessageContract.IPresenter {

    private static final String TAG = POCHistoryMessagePresenter.class.getSimpleName();
    private POCHistoryMessageContract.IView view;

    public POCHistoryMessagePresenter(POCHistoryMessageContract.IView view) {
        this.view = view;
    }

    /**
     * 本地加载
     *
     * @param room
     * @param pageSize
     * @param synctime
     */
    public void loadLocalMessage(String room, int pageSize, long synctime) {
        LogUtils.DLog(TAG, "loadLocalMessage");
        List<POCHistoryMessage> result = HistoryMessageDBHelper.getInstance().getAllData(room);
        if (view != null && view.isExist()) {
            view.loadMessageSuccess(result, -1, true, true);
        }
    }

    /**
     * 调用同步时间加载
     * 上拉加载更多，升序返回
     *
     * @param order    up 下拉，down 上滑
     * @param pageSize
     * @param room
     * @param syncTime
     */
    @Override
    public void syncHistoryMessage(String order, int pageSize, String room, long syncTime) {
        LogUtils.DLog(TAG, "syncHistoryMessage");
        LogUtils.DLog(TAG, "room = " + room + " order= " + order);
        SynctimeMessageRequest request = new SynctimeMessageRequest();
        request.setOrder(order);
        request.setPageSize(pageSize);
        request.setGroupUri(room);
        request.setSyncTime(syncTime);
        RetrofitUtil.request(RecordBusiness.gettTalkGroupMessageBySynctime(request), new CommonObserver<BaseRecordResponse<List<POCHistoryMessage>>>() {
            @Override
            public void onResult(BaseRecordResponse<List<POCHistoryMessage>> result) {
                if (Constants.RESPONSE_SUCCESS.equals(result.getResult())) {
                    HistoryMessageDBHelper.getInstance().insertOrUpdate(result.getData());
                    if (view != null && view.isExist()) {
//                        List<POCHistoryMessage> allData = HistoryMessageDBHelper.getInstance().getAllData(room);
                        boolean isToBottom = !order.equals("up");
                        boolean isHasServerData = !(result.getData() == null || result.getData().size() <= 0);
                        view.loadMessageSuccess(result.getData(), result.getTotalRecord(), isHasServerData, isToBottom);
                    }
                    return;
                }
                if (view != null && view.isExist()) {
                    view.loadMessageFailed();
                }
            }

            @Override
            public void onError(HttpThrowable httpThrowable) {
                if (view != null && view.isExist()) {
                    view.loadMessageFailed();
                }
            }
        });
    }
}
