package com.xdja.poc.sdk.utils;

import android.app.Fragment;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.Log;
import android.widget.ImageView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.resource.bitmap.BitmapTransformation;
import com.bumptech.glide.request.animation.GlideAnimation;
import com.bumptech.glide.request.target.SimpleTarget;
import com.xdja.poc.sdk.R;
import com.xdja.poc.sdk.record.fdfs.FdfsService;
import com.xdja.poc.sdk.record.http.HttpsUtils;

import java.io.File;
import java.util.Calendar;


@SuppressWarnings("ALL")
public class GlideUtils {
    private static final String TAG = GlideUtils.class.getSimpleName();
    public static void setImageUseFile(Context context, String fileUri, ImageView view) {
        Glide.with(context)
                .load(new File(fileUri))
                .error(R.drawable.poc_icon_default_avatar)
                .placeholder(R.drawable.poc_icon_default_avatar)
                //.diskCacheStrategy( DiskCacheStrategy.NONE )
                .into(view);
    }
    public static void setImageUseNetWithCircle(Context context, String NetUri, ImageView view) {
        Glide.with(context)
                .load(NetUri)
                .bitmapTransform(new GlideCircleTransform(context))
                .error(R.drawable.poc_icon_default_avatar)
                .placeholder(R.drawable.poc_icon_default_avatar)
                .into(view);
    }

    public static void setImageUseNet(Fragment context, String NetUri, ImageView view) {
        Glide.with(context)
                .load(NetUri)
                .error(R.drawable.poc_icon_default_avatar)
                .placeholder(R.drawable.poc_icon_default_avatar)
                .diskCacheStrategy(DiskCacheStrategy.NONE)
                .into(view);
    }

    /**
     * 获取 图片bitmap数据
     * @param context
     * @param source
     * @param size
     * @return
     */
    public static void transformImageToBitmap(Context context,String source,Callback callback) {
        if (TextUtils.isEmpty(source) || callback == null) {
            return;
        }

        Glide.with(context).load(source).asBitmap().into(new SimpleTarget<Bitmap>() {

            @Override
            public void onResourceReady(Bitmap resource, GlideAnimation<? super Bitmap> glideAnimation) {
                Bitmap bitmap = getRoundedCornerBitmap(resource);
                Log.d(TAG,"testBitmap onResourceReady "+bitmap);
                if (bitmap != null){
                    callback.onSuccess(bitmap);
                }else {
                    callback.onFailed("transform failed");
                }
            }

            @Override
            public void onLoadFailed(Exception e, Drawable errorDrawable) {
                super.onLoadFailed(e, errorDrawable);
                callback.onFailed("transform failed");
            }
        });
    }

    public static Bitmap getRoundedCornerBitmap(Bitmap bitmap) {
        try {
            Bitmap output = Bitmap.createBitmap(bitmap.getWidth(),
                    bitmap.getHeight(), Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(output);
            final Paint paint = new Paint();
            final Rect rect = new Rect(0, 0, bitmap.getWidth(),
                    bitmap.getHeight());
            final RectF rectF = new RectF(new Rect(0, 0, bitmap.getWidth(),
                    bitmap.getHeight()));


            // 拿到bitmap宽或高的小值
            int bSize = Math.min(bitmap.getWidth(), bitmap.getHeight());
            final float roundPx = (float) (bSize / 2);
            paint.setAntiAlias(true);
            canvas.drawARGB(0, 0, 0, 0);
            paint.setColor(Color.BLACK);
            canvas.drawRoundRect(rectF, roundPx, roundPx, paint);
            paint.setXfermode(new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));

            final Rect src = new Rect(0, 0, bitmap.getWidth(),
                    bitmap.getHeight());

            canvas.drawBitmap(bitmap, src, rect, paint);
            return output;
        } catch (Exception e) {
            return bitmap;
        }
    }


    private static class GlideCircleTransform extends BitmapTransformation {
        GlideCircleTransform(Context context) {
            super(context);
        }

        @Override
        protected Bitmap transform(BitmapPool pool, Bitmap toTransform, int outWidth, int outHeight) {
            return circleCrop(pool, toTransform);
        }

        private Bitmap circleCrop(BitmapPool pool, Bitmap source) {
            if (source == null) return null;

            int size = Math.min(source.getWidth(), source.getHeight());
            int x = (source.getWidth() - size) / 2;
            int y = (source.getHeight() - size) / 2;

            // TODO this could be acquired from the pool too
            Bitmap squared = Bitmap.createBitmap(source, x, y, size, size);

            Bitmap result = pool.get(size, size, Bitmap.Config.ARGB_8888);
            if (result == null) {
                result = Bitmap.createBitmap(size, size, Bitmap.Config.ARGB_8888);
            }

            Canvas canvas = new Canvas(result);
            Paint paint = new Paint();
            paint.setShader(new BitmapShader(squared, BitmapShader.TileMode.CLAMP, BitmapShader.TileMode.CLAMP));
            paint.setAntiAlias(true);
            float r = size / 2f;
            canvas.drawCircle(r, r, r, paint);
            return result;
        }

        @Override
        public String getId() {
            return getClass().getName();
        }
    }


    /**
     * 检测图片地址，加载mis/fast-dfs 地址
     * @param imageUrl
     * @return
     */
    public static String checkImagePath(String imageUrl){
        String path = imageUrl;
        if (!TextUtils.isEmpty(imageUrl)&& !imageUrl.startsWith("http")) {
            boolean isMisUrl = imageUrl.startsWith("/mis/");
            path = isMisUrl ? IPHost.getMisServer() + imageUrl : IPHost.getFastDfsUrl() + File.separator + imageUrl;
        }
        //添加鉴权
        path = dealImageUrl(path);
        return path;
    }

    /**
     * 处理图片地址，fast-dfs地址  添加鉴权信息
     * @param imageUrl
     * @return
     */
    public static String dealImageUrl(String imageUrl){
        if (TextUtils.isEmpty(imageUrl)){return "";}
        if (isSignUrl(imageUrl)){return imageUrl;}
        return addSignUrl(imageUrl);
    }


    public static String addSignUrl(String pictureUrl){
        if (TextUtils.isEmpty(pictureUrl)){return "";}
        ///storage/emulated/0/DCIM/Camera/***.jpg
        if(!pictureUrl.startsWith("http")){
            //本地文件
            return pictureUrl;
        }
        return pictureUrl + createAuthInfo();
    }


    /**
     * 是否带鉴权消息
     * @param path
     * @return
     */
    public static boolean isSignUrl(String path){
        if (TextUtils.isEmpty(path)){return false;}
        if (path.contains(FdfsService.PARAM_USERID) &&
                path.contains(FdfsService.PARAM_TS) &&
                path.contains(FdfsService.PARAM_SIGN)){
            return true;
        }
        return false;
    }

    public static String createAuthInfo() {
        StringBuilder stringBuilder = new StringBuilder();
        long timeStamp;
        //构造时间戳
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(System.currentTimeMillis());
        calendar.add(Calendar.MINUTE, 10);
        timeStamp = calendar.getTimeInMillis();


        //生成签名字符串
        String originalStr = IPHost.getFastDfsAppId() + timeStamp;
        String sign = HttpsUtils.getSignature(IPHost.getFastDfsSecret(), originalStr);
        stringBuilder.append("?" + FdfsService.PARAM_USERID).append(IPHost.getFastDfsAppId()).append("&" + FdfsService.PARAM_TS).append(timeStamp).append("&" + FdfsService.PARAM_SIGN).append(sign);
        return stringBuilder.toString();
    }


    public static interface Callback{
        void onSuccess(Bitmap bitmap);
        void onFailed(String msg);
    }
}
