package com.xdja.poc.sdk.db.manager;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;

import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.sdk.db.DBConstant;

/**
 * Created by Administrator on 2018/2/5 10:17.
 */

@SuppressWarnings("ALL")
public class POCSQLiteOpenHelper extends SQLiteOpenHelper {
    private static final String TAG = "POCSQLiteOpenHelper";
    private static String DB_NAME = "channel_db";
    private static int version = 5;

    public POCSQLiteOpenHelper(Context context) {
        super(context, DB_NAME, null, version);
    }

    @Override
    public void onCreate(SQLiteDatabase db) {
        try {
            LogUtils.DLog(TAG,"POCSQLiteOpenHelper onCreate");
            db.execSQL(DBConstant.TABLE_SQL);
        } catch (Exception e) {
            LogUtils.ELog(e);
        }
    }

    @Override
    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        LogUtils.DLog(TAG,"POCSQLiteOpenHelper onUpgrade db "+db + " oldVersion = "+oldVersion +" newVersion ="+newVersion);
        //v2.0--->3.0
        if (newVersion > oldVersion) {
            if (oldVersion == 1) {
                String sql = "alter table " + DBConstant.CHANNEL_TABLE + " add column maxInviteMembersCount INTEGER DEFAULT 0";
                db.execSQL(sql);
            }else if (oldVersion == 4){
                db.execSQL(DBConstant.TABLE_SQL);
                String sql = "alter table " + DBConstant.CHANNEL_TABLE + " add column createTime text";
                db.execSQL(sql);
            }
        }
    }
}
