package com.xdja.poc.sdk.greendao.manager;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;

import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.sdk.greendao.dao.DaoMaster;

/**
 * Created by Administrator on 2018/2/5 10:17.
 */

@SuppressWarnings("ALL")
public class SQLiteOpenHelper extends DaoMaster.DevOpenHelper {
    public SQLiteOpenHelper(Context context, String name, SQLiteDatabase.CursorFactory factory) {
        super(context, name, factory);
    }
    public SQLiteOpenHelper(Context context, String name) {
        super(context, name);
    }

    @Override
    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        super.onUpgrade(db, oldVersion, newVersion);
        if (oldVersion == newVersion) {
            LogUtils.ELog("onUpgrade", "数据库是最新版本,无需升级");
            return;
        }
        if (oldVersion < newVersion) {
            LogUtils.ELog("onUpgrade", "开始数据库升级");
        }
    }
}
