package com.xdja.poc.sdk;

import android.annotation.SuppressLint;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.ServiceConnection;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.os.Build;
import android.os.IBinder;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.support.v4.app.NotificationCompat;
import android.text.TextUtils;
import android.util.Log;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.xdja.poc.POCMediaAidlInterface;
import com.xdja.poc.common.utils.GlobalContext;
import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.common.utils.PreferenceHelper;
import com.xdja.poc.common.utils.StringUtils;
import com.xdja.poc.common.utils.ToastUtils;
import com.xdja.poc.sdk.bean.POCMemberInfo;
import com.xdja.poc.sdk.business.POCService;
import com.xdja.poc.sdk.business.PocBroadReceiver;
import com.xdja.poc.sdk.business.PocNotificationService;
import com.xdja.poc.sdk.business.bean.POCCallMessage;
import com.xdja.poc.sdk.config.Constants;
import com.xdja.poc.sdk.config.GroupConfig;
import com.xdja.poc.sdk.config.POCConfig;
import com.xdja.poc.sdk.config.UserConfig;
import com.xdja.poc.sdk.db.entity.DBGroupEntity;
import com.xdja.poc.sdk.db.entity.User;
import com.xdja.poc.sdk.db.manager.PocDaoGroupManager;
import com.xdja.poc.sdk.event.POCMemberEvent;
import com.xdja.poc.sdk.manager.AMnager;
import com.xdja.poc.sdk.proxy.IPOCGroupLongClickCallBack;
import com.xdja.poc.sdk.proxy.IPOCGroupRefreshCallBack;
import com.xdja.poc.sdk.proxy.IPOCMemberInfoCallBack;
import com.xdja.poc.sdk.proxy.IPOCPushMessageCallBack;
import com.xdja.poc.sdk.proxy.IPOCRecordCallBack;
import com.xdja.poc.sdk.proxy.IPOCUserCacheCallBack;
import com.xdja.poc.sdk.proxy.IPOCUserClickCallBack;
import com.xdja.poc.sdk.proxy.POCUiKitProxyImpl;
import com.xdja.poc.sdk.receiver.HomeKeyReceiver;
import com.xdja.poc.sdk.record.RecordMessage;
import com.xdja.poc.sdk.utils.GlideUtils;
import com.xdja.poc.sdk.utils.ProcessUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

import static com.xdja.poc.common.utils.UiUtils.getCurrentProcessName;
import static com.xdja.poc.sdk.business.POCService.ACTION_POC_START_WAITING_ACTIVITY;


/**
 * Created by Administrator on 2018/8/23.
 */

@SuppressWarnings("ALL")
public class POCClient {
    private static String TAG = "POCClient";
    private WeakHashMap<Context, ServiceBinder> mConnectionMap;
    private POCMediaAidlInterface mService = null;
    private Gson gson;
    private Context mContext;
    private volatile boolean isInited = false;//是否初始化完成
    private static boolean isBinding = false;
    /**
     * 自己被移除集合（收到移除推送未处理）
     */
    private List<String> removedCacheList;
    private ServiceToken serviceToken;


    private static class SingletonHolder {
        @SuppressLint("StaticFieldLeak")
        static final POCClient sInstance = new POCClient();
    }

    private POCClient() {

    }

    public static POCClient getInstance() {
        return SingletonHolder.sInstance;
    }

    /**
     * 初始化SDK
     *
     * @param context
     * @param pocConfig
     * @return
     */
    public POCClient initSDK(Context context, POCConfig.Configuration pocConfig) {
        GlobalContext.setContext(context);
        mConnectionMap = new WeakHashMap<>();
        mContext = context.getApplicationContext();
        ToastUtils.initToast();
        if (pocConfig != null) {
            LogUtils.isOpen = pocConfig.isDebug();
            PreferenceHelper.setInt(UserConfig.CALL_WAITING_TIME, pocConfig.callWaitTime);
            PreferenceHelper.setInt(UserConfig.MAX_CHANNEL_COUNT, pocConfig.maxChannelCount);
            PreferenceHelper.setInt(UserConfig.MAX_MEMBER_COUNT, pocConfig.maxMeberCount);
            PreferenceHelper.setInt(UserConfig.APP_ICON, pocConfig.iconId);
            PreferenceHelper.setInt(UserConfig.NOTIFICATION_ICON, pocConfig.notificationId);
            if (TextUtils.isEmpty(pocConfig.routerScheme)) {
                throw new IllegalArgumentException("the way of initSDK , routerScheme cant null");
            }
            PreferenceHelper.setString(UserConfig.ROUTER_SCHEME, pocConfig.routerScheme);
            PreferenceHelper.setString(UserConfig.APP_NAME, pocConfig.appName);
            PreferenceHelper.setBoolean(UserConfig.IS_SHOW_NOTIFICATION, pocConfig.isShowNotification);
            PreferenceHelper.setBoolean(UserConfig.IS_SHOW_HOME_TOAST, pocConfig.isShowHomeToast);
            PreferenceHelper.setString(UserConfig.TOAST_TALKING_DESC, pocConfig.toastTalkingDesc);
            PreferenceHelper.setBoolean(UserConfig.POC_IS_SHOW_HISTORY_RECORD_ENTER, pocConfig.isShowHistoryRecord);
            PreferenceHelper.setBoolean(UserConfig.POC_IS_SAVE_RECORD, pocConfig.isSaveRecord);
            PreferenceHelper.setString(UserConfig.POC_SELF_SPEAKING_TIPS, pocConfig.selfSpeakingTips);
            PreferenceHelper.setBoolean(UserConfig.POC_IS_INTERCEPT_VOLUM_KEY, pocConfig.isInterceptVolumKey);
            PreferenceHelper.setString(UserConfig.POC_NOTIFY_CHANNEL_NAME, pocConfig.notifyChannelName);
            PreferenceHelper.setString(UserConfig.POC_NOTIFY_CHANNEL_ID, pocConfig.notifyChannelId);
            PreferenceHelper.setBoolean(UserConfig.POC_PRODUCT, pocConfig.pocProduct);
        } else {
            LogUtils.isOpen = false;
        }
        if (PreferenceHelper.getBoolean(UserConfig.IS_SHOW_NOTIFICATION, true)) {
            Intent intent = new Intent(mContext, PocNotificationService.class);
            mContext.startService(intent);
        }
        HomeKeyReceiver.registerHomeReceiver();
        gson = new Gson();
        return this;
    }

    public void initConfig() {
        User userInfo = POCUiKitProxyImpl.getInstance().getUserInfo();
        if (userInfo != null) {
            PreferenceHelper.setString(UserConfig.LOGIN_ACCOUNT, userInfo.getAccount());
            PreferenceHelper.setString(UserConfig.USER_INFO_NAME, userInfo.getName());
            PreferenceHelper.setString(UserConfig.PREF_KEY_TOKEN, userInfo.getToken());
            PreferenceHelper.setString(UserConfig.COMPANY_CODE, userInfo.getCompanyCode());
            PreferenceHelper.setString(UserConfig.DEVICE_IMEI, userInfo.getImei());
            // lyj更新Service进程token
            if (bindIsVaild()) {
                try {
                    mService.setToken(userInfo.getToken());
                } catch (RemoteException e) {
                    e.printStackTrace();
                }
            }
        }
        if (isInited) {
            return;
        }
        isInited = true;
//        if (PreferenceHelper.getBoolean(UserConfig.IS_SHOW_NOTIFICATION, true)) {
        LogUtils.ILog(TAG, "Thread.currentThread().getName(): " + getCurrentProcessName(mContext));
        PocBroadReceiver.isRegister = false;
        PocBroadReceiver.registerPushReceiver(mContext);
        initNotification();
//        PushClient.init(mContext, PushConstants.PRE_TOPIC + DeviceUtils.getImei(mContext), false);
//        String policeTopic = String.format("%s%s%s", PushConstants.PRE_TOPIC, DeviceUtils.getImei(mContext), PushConstants.END_TOPIC);
//        int i = PushClient.subTopic(mContext, policeTopic, 0);
//        String companyTopic = String.format("%s%s%s", "xdja/d/", "8888888888", "/police_video");
//        PushClient.subTopic(mContext, companyTopic, 0);
//        String offlineTopic = String.format("%s%s%s", "xdja/d/", imei, "/police_video_offline");
//        PushClient.subTopicQos(mContext, offlineTopic, 2);
    }

    private boolean bindIsVaild() {
        if (!ProcessUtils.pocessIsExist()) {
            mService = null;
            isBinding = false;
            Log.e(TAG, "bindIsVaild: :poc进程不存在，重新绑定POCService");
        }
        return mService != null;
    }

    private static NotificationManager mNotificationManager;
    private String channelId;
    public static int TRYCALL_POC_BANK = 700;

    public NotificationCompat.Builder getBuilder() {
        NotificationCompat.Builder mBuilder;
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            mBuilder = new NotificationCompat.Builder(GlobalContext.getContext(), channelId);
        } else {
            mBuilder = new NotificationCompat.Builder(GlobalContext.getContext());
        }
        return mBuilder;
    }

    private void initNotification() {
        mNotificationManager = (NotificationManager) GlobalContext.getContext().getSystemService(Context.NOTIFICATION_SERVICE);
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            // start lyj 修改channel名称
            channelId = PreferenceHelper.getString(UserConfig.POC_NOTIFY_CHANNEL_ID, "");
            if (channelId.length() > 0) {
                return;
            }
            String customChannelName = PreferenceHelper.getString(UserConfig.POC_NOTIFY_CHANNEL_NAME, "");
            NotificationChannel notificationChannel = new NotificationChannel(GlobalContext.getContext().getPackageName(),
                    customChannelName.length() > 0 ? customChannelName : GlobalContext.getContext().getString(R.string.poc_notification_channel_name),
                    NotificationManager.IMPORTANCE_DEFAULT);
            notificationChannel.enableLights(true);//是否在桌面icon右上角展示小圆点
            notificationChannel.setLightColor(Color.RED); //小圆点颜色
            notificationChannel.setShowBadge(true); //是否在久按桌面图标时显示此渠道的通知
            mNotificationManager.createNotificationChannel(notificationChannel);
            // end
        }
    }

    /**
     * 以下 poc 相关
     */
    public void showPOCNofitication(POCCallMessage callMessage) {
        NotificationCompat.Builder mBuilder = getBuilder();
        Intent intent = new Intent(ACTION_POC_START_WAITING_ACTIVITY);
        intent.putExtra(AMnager.INTENT_KEY_CALL_WAITING_DATE, callMessage);
        PendingIntent pendingIntent = PendingIntent.getBroadcast(GlobalContext.getContext(), 0,
                intent, PendingIntent.FLAG_UPDATE_CURRENT);
        mBuilder.setWhen(System.currentTimeMillis())// 通知产生的时间，会在通知信息里显示
                .setTicker("新消息")
                .setPriority(Notification.PRIORITY_DEFAULT)// 设置该通知优先级
                .setOngoing(false)
                .setAutoCancel(true)
                .setContentTitle(callMessage.getUserName())
                .setContentText("正在呼叫你")
                .setContentIntent(pendingIntent);
        int iconId = PreferenceHelper.getInt(UserConfig.NOTIFICATION_ICON, R.drawable.poc_icon_default_avatar);
        mBuilder.setSmallIcon(iconId);
        mBuilder.setLargeIcon(BitmapFactory.decodeResource(GlobalContext.getContext().getResources(), R.drawable.poc_icon_default_avatar));
        //头像显示在LargeIcon 上
        String icon = callMessage.getIcon();
        if (!TextUtils.isEmpty(icon)) {
            icon = GlideUtils.checkImagePath(icon);
        }
        if (!TextUtils.isEmpty(icon)){
            GlideUtils.transformImageToBitmap(GlobalContext.getContext(), icon, new GlideUtils.Callback() {
                @Override
                public void onSuccess(Bitmap bitmap) {
                    mBuilder.setLargeIcon(bitmap);
                    mNotificationManager.notify(TRYCALL_POC_BANK, mBuilder.build());
                }

                @Override
                public void onFailed(String msg) {
                    mBuilder.setLargeIcon(BitmapFactory.decodeResource(GlobalContext.getContext().getResources(), R.drawable.poc_icon_default_avatar));
                }
            });
        }
        Notification notify = mBuilder.build();
        mNotificationManager.notify(TRYCALL_POC_BANK, notify);
    }

    /**
     * 清除当前创建的通知栏
     */
    public void clearNotify(int notifyId) {
        if (mNotificationManager == null) {
            mNotificationManager = (NotificationManager) mContext.getSystemService(Context.NOTIFICATION_SERVICE);
        }
        assert mNotificationManager != null;
        mNotificationManager.cancel(notifyId);// 删除一个特定的通知ID对应的通知
    }

    private final ServiceBinder binder = new ServiceBinder();

    /**
     * 绑定service
     *
     * @param context
     * @return ServiceToken
     */
    private ServiceToken bindToService(final Context context) {
        if (mConnectionMap.size() > 0 && serviceToken != null) {
            return serviceToken;
        }
        final ContextWrapper contextWrapper = new ContextWrapper(context);
        contextWrapper.startService(new Intent(contextWrapper, POCService.class));
        if (contextWrapper.bindService(
                new Intent().setClass(contextWrapper, POCService.class), binder, Context.BIND_AUTO_CREATE)) {
            mConnectionMap.put(contextWrapper, binder);
            isBinding = false;
            return new ServiceToken(contextWrapper);
        }
        return null;
    }

    public void bindService() {
        mContext = GlobalContext.getContext();
        initConfig();
        serviceToken = bindToService(mContext);
    }

    /**
     * 解绑service
     */
    public void unbindFromService() {
//        HomeKeyReceiver.unRegisterHomeReceiver();
        unbindFromService(serviceToken);
        PocDaoGroupManager.getInstance(GlobalContext.getContext()).close();
        isInited = false;
    }

    /**
     * 解绑service
     *
     * @param token
     */
    private void unbindFromService(final ServiceToken token) {
        //退出时销毁所有房间
        _destroyAllRooms();
        if (token == null) {
            return;
        }
        isBinding = false;
        final ContextWrapper mContextWrapper = token.mWrappedContext;
        final ServiceBinder mBinder = mConnectionMap.remove(mContextWrapper);
        if (mBinder == null) {
            return;
        }
        if (mConnectionMap.isEmpty()) {
            mService = null;
        }
        mConnectionMap.clear();
        serviceToken = null;
        mContextWrapper.unbindService(mBinder);
        mContext.stopService(new Intent(mContext, POCService.class));
    }

    public class ServiceBinder implements ServiceConnection {
        public ServiceBinder() {
        }

        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            mService = POCMediaAidlInterface.Stub.asInterface(service);
            try {
                isBinding = false;
                mService.initParams();
                mService.setToken(PreferenceHelper.getString(UserConfig.PREF_KEY_TOKEN, ""));
                // 偶现Binder异常，DeadObjectException
                mService.asBinder().linkToDeath(new IBinder.DeathRecipient() {
                    @Override
                    public void binderDied() {
                        isBinding = false;
                        mService = null;
                        Log.e(TAG, "binderDied: set mService is null");
                    }
                }, -1);
            } catch (RemoteException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void onServiceDisconnected(ComponentName name) {
            isBinding = false;
            mService = null;
        }
    }

    public static final class ServiceToken {
        public final ContextWrapper mWrappedContext;

        public ServiceToken(final ContextWrapper context) {
            mWrappedContext = context;
        }
    }


    /**
     * 离开频道
     *
     * @param userId 用户账号
     * @param roomId 房间id
     */
    public static void leaveRoom(String userId, String roomId) {
        POCClient.getInstance()._leaveRoom(userId, roomId);
    }

    /**
     * 挂断电话
     *
     * @param roomId 房间id
     */
    public static void hangUpRoom(String roomId) {
        POCClient.getInstance()._hangUpRoom(roomId);
    }

    private void _hangUpRoom(String roomId) {
        try {
            if (bindIsVaild()) {
                mService.hangUpRoom(roomId);
            } else {
                if (isBinding) {
                    return;
                }
                mConnectionMap.clear();
                POCClient.getInstance().bindService();
                LogUtils.ELog(TAG, "_hangUpRoom: service is null");
            }
        } catch (final RemoteException ignored) {
            LogUtils.ELog(TAG, ignored.getMessage());
        }
    }

    /**
     * 离开房间
     *
     * @param userId 用户账号
     * @param roomId 房间id
     */
    private void _leaveRoom(String userId, String roomId) {
        try {
            if (bindIsVaild()) {
                mService.leaveRoom(userId, roomId);
            } else {
                if (isBinding) {
                    return;
                }
                mConnectionMap.clear();
                POCClient.getInstance().bindService();
                LogUtils.ELog(TAG, "leaveRoom: service is null");
            }
        } catch (final RemoteException ignored) {
            LogUtils.ELog(TAG, ignored.getMessage());
        }
    }

    /**
     * 从断网重连的缓存中移除不重连的房间
     *
     * @param roomId 房间id
     */
    public static void removeFromReconnectCache(String roomId) {
        POCClient.getInstance()._removeFromReconnectCache(roomId);
    }

    private void _removeFromReconnectCache(String roomId) {
        try {
            if (bindIsVaild()) {
                mService.removeFromReconnectCache(roomId);
            } else {
                if (isBinding) {
                    return;
                }
                mConnectionMap.clear();
                POCClient.getInstance().bindService();
                LogUtils.ELog(TAG, "removeFromReconnectCache: service is null");
            }
        } catch (final RemoteException ignored) {
            LogUtils.ELog(TAG, ignored.getMessage());
        }
    }

    /**
     * 销毁频道
     *
     * @param userId 用户账号
     * @param roomId 房间id
     */
    public static void destroyRoom(String userId, String roomId) {
        POCClient.getInstance()._destroyRoom(userId, roomId);
    }

    private void _destroyRoom(String userId, String roomId) {
        try {
            if (bindIsVaild()) {
                mService.destroyRoom(userId, roomId);
            } else {
                if (isBinding) {
                    return;
                }
                mConnectionMap.clear();
                POCClient.getInstance().bindService();
                LogUtils.ELog(TAG, "destroyRoom: service is null");
            }
        } catch (final RemoteException ignored) {
            LogUtils.ELog(TAG, ignored.getMessage());
        }
    }

    /**
     * 销毁所有房间
     */
    public static void destroyAllRoom() {
        POCClient.getInstance()._destroyAllRoom();
    }

    private void _destroyAllRoom() {
        try {
            if (bindIsVaild())
                mService.destroyAllRoom();
            else {
                if (isBinding) {
                    return;
                }
                mConnectionMap.clear();
                POCClient.getInstance().bindService();
                LogUtils.ELog(TAG, "destroyRoom: service is null");
            }

            PocBroadReceiver.unregisterPushReceiver(GlobalContext.getContext());
        } catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    /**
     * 销毁房间，不再启动service
     */
    private void _destroyAllRooms() {
        try {
            if (bindIsVaild())
                mService.destroyAllRoom();
            else {
                mConnectionMap.clear();
                LogUtils.ELog(TAG, "destroyRoom: service is null");
            }
            PocBroadReceiver.unregisterPushReceiver(GlobalContext.getContext());
        } catch (RemoteException e) {
            e.printStackTrace();
        }
    }

//    /**
//     * 强制剔除频道
//     *
//     * @param userId
//     * @param targetId 被踢的人Id
//     * @param roomId   主动剔的人Id
//     */
//    public static void forceQuitRoom(String userId, String targetId, String roomId) {
//        try {
//            if (mService != null) {
//                mService.forceQuitRoom(userId, targetId, roomId);
//            }
//        } catch (final RemoteException ignored) {
//            LogUtils.ELog(TAG, ignored.getMessage());
//        }
//    }

//    /**
//     * 从服务器删除频道:
//     *
//     * @param userId
//     * @param roomId
//     */
//    public static void deletePocRoomFromServer(String userId, String roomId) {
//        try {
//            if (mService != null) {
//                mService.deletePocRoomFromServer(userId, roomId);
//            }
//        } catch (final RemoteException ignored) {
//            LogUtils.ELog(TAG, ignored.getMessage());
//        }
//    }

//    /**
//     * 修改频道窗状态:静音还是收听
//     *
//     * @param roomId
//     * @param isSilence true:静音  false  收听
//     */
//    public static void controlRoomStatus(String roomId, boolean isSilence) {
//
//        try {
//            if (mService != null) {
//                mService.controlRoomStatus(roomId, isSilence);
//            }
//        } catch (final RemoteException ignored) {
//            LogUtils.ELog(TAG, ignored.getMessage());
//        }
//    }

    /**
     * 删除本地缓存频道(临时频道)
     *
     * @param roomId 房间id
     */
    public static void deleteLocalRoomById(String userId, String roomId) {
        POCClient.getInstance()._deleteLocalRoomById(userId, roomId);
    }

    private void _deleteLocalRoomById(String userId, String roomId) {
        try {
            if (bindIsVaild()) {
                mService.deleteRoomByRoomId(userId, roomId);
            } else {
                if (isBinding) {
                    return;
                }
                mConnectionMap.clear();
                POCClient.getInstance().bindService();
                LogUtils.ELog(TAG, "destroyRoom: service is null");
            }
        } catch (Throwable throwable) {
            LogUtils.ELog(throwable);
        }
    }

//    public static void deleteRoomByIdWithNotifyUI(String userId, String roomId, int position) {
////        try {
////            if (mService != null) {
////                mService.deleteRoomByIdWithNotifyUI(userId, roomId, position);
////            } else {
////                mConnectionMap.clear();
////                POCClient.getInstance().bindService();
////                LogUtils.ELog(TAG, "destroyRoom: service is null");
////            }
////        } catch (Throwable throwable) {
////            LogUtils.ELog(throwable);
////        }
//    }

//    /**
//     * 获取PocMemberList 成员列表
//     *
//     * @param userId
//     */
//    public static void getPocMemberList(String userId, String roomId) {
//        try {
//
//        } catch (Throwable throwable) {
//            LogUtils.ELog(throwable);
//        }
//    }


    /**
     * 释放话语权
     *
     * @param roomId 房间id
     */
    public static void releaseTBCP(String roomId) {
        LogUtils.ELog(TAG, "POCClient releaseTBCP... ");
        POCClient.getInstance()._releaseTBCP(roomId);
    }

    private void _releaseTBCP(String roomId) {
        try {
            if (bindIsVaild()) {
                mService.releaseTBCP(roomId);
            } else {
                if (isBinding) {
                    return;
                }
                mConnectionMap.clear();
                POCClient.getInstance().bindService();
                LogUtils.ELog(TAG, "releaseTBCP: service is null");
            }
        } catch (final RemoteException ignored) {
            LogUtils.ELog(TAG, ignored.getMessage());
        }
    }

    /**
     * 更新房间强插状态
     *
     * @param roomId        房间id
     * @param isForceInsert 是否强插
     */
    public static void updateForceInsert(String roomId, boolean isForceInsert) {
        POCClient.getInstance()._updateForceInsert(roomId, isForceInsert);
    }

    private void _updateForceInsert(String roomId, boolean isForceInsert) {
        try {
            if (bindIsVaild()) {
                mService.updateForceInsert(roomId, isForceInsert);
            } else {
                if (isBinding) {
                    return;
                }
                mConnectionMap.clear();
                POCClient.getInstance().bindService();
                LogUtils.ELog(TAG, "updateForceInsert: service is null");
            }
        } catch (final RemoteException ignored) {
            LogUtils.ELog(TAG, ignored.getMessage());
        }
    }

    /**
     * 获取房间是否强插的状态值
     *
     * @param roomId 房间 id
     * @return true 有强插属性 false 无强插属性
     */
    public static boolean getRoomForceInsertStatus(String roomId) {
        return POCClient.getInstance()._getRoomForceInsertStatus(roomId);
    }

    private boolean _getRoomForceInsertStatus(String roomId) {
        try {
            if (bindIsVaild()) {
                return mService.getRoomForceInsertStatus(roomId);
            } else {
                if (isBinding) {
                    return false;
                }
                mConnectionMap.clear();
                POCClient.getInstance().bindService();
                LogUtils.ELog(TAG, "getRoomForceInsertStatus: service is null");
            }
        } catch (final RemoteException ignored) {
            LogUtils.ELog(TAG, ignored.getMessage());
        }
        return false;
    }

    /**
     * 抢占话语权
     *
     * @param roomId  房间id
     * @param isForce 是否强插
     */
    public static void takenTBCP(String roomId, int isForce) {
        POCClient.getInstance()._takenTBCP(roomId, isForce);
    }

    /**
     * 获取房间讲话的分贝值
     *
     * @param roomId 房间id
     * @return 讲话声音的分贝值
     */
    public static double getAudioVolumn(String roomId) {
        return POCClient.getInstance()._getAudioVolumn(roomId);
    }

    private double _getAudioVolumn(String roomId) {
        try {
            if (bindIsVaild()) {
                return mService.getAudioVolumn(roomId);
            } else {
                if (isBinding) {
                    return 0;
                }
                mConnectionMap.clear();
                POCClient.getInstance().bindService();
                LogUtils.ELog(TAG, "_getAudioVolumn: service is null");
            }
        } catch (Exception e) {
            LogUtils.ELog(TAG, "e: " + e.getLocalizedMessage());
        }
        return 0;
    }

    /**
     * 获取话语权
     *
     * @param roomId  房间id
     * @param isForce 是否强插
     */
    public void _takenTBCP(String roomId, int isForce) {
        try {
            if (bindIsVaild()) {
                mService.takenTBCP(roomId, isForce);
            } else {
                if (isBinding) {
                    return;
                }
                //刚杀进程点击,service为空
                POCMemberEvent pocMemberEvent = new POCMemberEvent();
                pocMemberEvent.setMemberInfos(null);
                pocMemberEvent.setRoomId(roomId);
                pocMemberEvent.setStatus(GroupConfig.GROUP_HANGUP);
                pocMemberEvent.setUserBehavior(Constants.ROOM_SEVER_CONNECT_FAILED);
                POCUiKitProxyImpl.getInstance().notifyMemberEvent(pocMemberEvent);
                mConnectionMap.clear();
                POCClient.getInstance().bindService();
                LogUtils.ELog(TAG, "takenTBCP: service is null");
            }
        } catch (final RemoteException ignored) {
            LogUtils.ELog(TAG, ignored.getMessage());
        }
    }

    /**
     * 加入房间，目前上层没用到
     *
     * @param roomId   房间id
     * @param userId   用户账号
     * @param userName 用户姓名
     * @param pin      房间pin码 ，默认xdja_1234
     * @param token    房间token POCRoom对象里生成
     */
    public static void joinRoom(long roomId, @Nullable Integer userId, String userName, String pin, String token) {
        POCClient.getInstance()._joinRoom(roomId, userId, userName, pin, token);
    }

    public void _joinRoom(long roomId, @Nullable Integer userId, String userName, String pin, String token) {
        try {
            if (bindIsVaild()) {
                mService.joinRoom(roomId, userId, userName, pin, token);
            } else {
                if (isBinding) {
                    return;
                }
                mConnectionMap.clear();
                POCClient.getInstance().bindService();
                LogUtils.ELog(TAG, "joinRoom: service is null");
            }
        } catch (final RemoteException ignored) {
            LogUtils.ELog(TAG, ignored.getMessage());
        }
    }

    /**
     * 创建房间
     *
     * @param roomId      房间id
     * @param secret      默认xdja_1234
     * @param pin         默认xdja_1234
     * @param userId      用户账号
     * @param userName    用户姓名
     * @param description 传入房间名称
     * @param permanent   默认false
     * @param isPrivate   默认false
     */
    public static void createRoom(long roomId, String secret, String pin, String userId, String userName,
                                  String description, @Nullable Boolean permanent, @Nullable Boolean isPrivate) {
        POCClient.getInstance()._createRoom(roomId, secret, pin, userId, userName, description, permanent, isPrivate);
    }

    public void _createRoom(long roomId, String secret, String pin, String userId, String userName,
                            String description, @Nullable Boolean permanent, @Nullable Boolean isPrivate) {
        try {
            if (bindIsVaild()) {
                mService.createRoom(roomId, secret, pin, userId, userName, description, permanent, isPrivate);
            } else {
                if (isBinding) {
                    return;
                }
                mConnectionMap.clear();
                POCClient.getInstance().bindService();
                LogUtils.ELog(TAG, "createRoom: service is null");
            }
        } catch (final RemoteException ignored) {
            LogUtils.ELog(TAG, ignored.getMessage());
        }
    }

//    public static void initParams() {
//        if (mService != null) {
//            try {
//                mService.initParams();
//            } catch (RemoteException ignored) {
//                LogUtils.ELog(TAG, ignored.getMessage());
//            }
//        }
//    }

//    public static void editRoom(long roomid, String secret, String newDescription,
//                                String newSecret, String newPin, @Nullable Boolean newIsPrivated, @Nullable Boolean newRequirePrivated,
//                                @Nullable Integer newBitrate, @Nullable Integer newFirFreq, @Nullable Integer newPublishers, @Nullable Boolean permanent) {
//        try {
//            if (mService != null) {
//                mService.editRoom(roomid, secret, newDescription, newSecret, newPin, newIsPrivated, newRequirePrivated, newBitrate, newFirFreq, newPublishers, permanent);
//            } else {
//                mConnectionMap.clear();
//                POCClient.getInstance().bindService();
//                LogUtils.ELog(TAG, "editRoom: service is null");
//            }
//        } catch (final RemoteException ignored) {
//            LogUtils.ELog(TAG, ignored.getMessage());
//        }
//    }

//    public static void newDestroyRoom(long roomId, String secret) {
//        try {
//            if (mService != null) {
//                mService.destroyRoom(Long.toString(roomId), secret);
//            }
//        } catch (final RemoteException ignored) {
//            LogUtils.ELog(TAG, ignored.getMessage());
//        }
//    }

//    public static void existsRoom(long roomId) {
//        try {
//            if (mService != null) {
//                mService.existRoom(roomId);
//            } else {
//                mConnectionMap.clear();
//                POCClient.getInstance().bindService();
//                LogUtils.ELog(TAG, "existsRoom: service is null");
//            }
//        } catch (final RemoteException ignored) {
//            LogUtils.ELog(TAG, ignored.getMessage());
//        }
//    }

//    public static void kickPerson(long roomId, int userId, String secret) {
//        try {
//            if (mService != null) {
//                mService.kickPerson(roomId, userId, secret);
//            } else {
//                mConnectionMap.clear();
//                POCClient.getInstance().bindService();
//                LogUtils.ELog(TAG, "kickPerson: service is null");
//            }
//        } catch (final RemoteException ignored) {
//            LogUtils.ELog(TAG, ignored.getMessage());
//        }
//    }

//    public static void listRooms(long roomId) {
//        try {
//            if (mService != null) {
//                mService.listRooms(roomId);
//            } else {
//                mConnectionMap.clear();
//                POCClient.getInstance().bindService();
//                LogUtils.ELog(TAG, "listRooms: service is null");
//            }
//        } catch (final RemoteException ignored) {
//            LogUtils.ELog(TAG, ignored.getMessage());
//        }
//    }

//    public static void listParticipants(long roomId) {
//        try {
//            if (mService != null) {
//                mService.listPeoples(roomId);
//            }
//        } catch (final RemoteException ignored) {
//            LogUtils.ELog(TAG, ignored.getMessage());
//        }
//    }

//    public static void publish(long roomId, boolean audio, boolean video, boolean data, String audioCode, String videoCode,
//                               int bitrate, boolean record, String fileName, String display) {
//        try {
//            if (mService != null) {
//                mService.publish(roomId, audio, video, data, audioCode, videoCode, bitrate, record, fileName, display);
//            }
//        } catch (final RemoteException ignored) {
//            LogUtils.ELog(TAG, ignored.getMessage());
//        }
//    }
//
//    public static void unpublish(long roomId) {
//        try {
//            if (mService != null) {
//                mService.unpublish(roomId);
//            }
//        } catch (final RemoteException ignored) {
//            LogUtils.ELog(TAG, ignored.getMessage());
//        }
//    }

//    public static void configure(long roomId, boolean audio, boolean video, boolean data, int bitrate, boolean record, String fileName, String display) {
//        try {
//            if (mService != null) {
//                mService.configure(roomId, audio, video, data, bitrate, record, fileName, display);
//            }
//        } catch (final RemoteException ignored) {
//            LogUtils.ELog(TAG, ignored.getMessage());
//        }
//    }
//
//    public static void subscriberJoin(long roomId, int feedId, String pin, int privateId, boolean closePc,
//                                      boolean audio, boolean video, boolean data, boolean offerAudio, boolean offerVideo, boolean offerData) {
//        try {
//            if (mService != null) {
//                mService.subscriberJoin(roomId, feedId, pin, privateId, closePc, audio, video, data, offerAudio, offerVideo, offerData);
//            }
//        } catch (final RemoteException ignored) {
//            LogUtils.ELog(TAG, ignored.getMessage());
//        }
//    }
//
//    public static void startMedia(long roomId) {
//        try {
//            if (mService != null) {
//                mService.startMedia(roomId);
//            }
//        } catch (final RemoteException ignored) {
//            LogUtils.ELog(TAG, ignored.getMessage());
//        }
//    }
//
//    public static void pauseMedia(long roomId) {
//        try {
//            if (mService != null) {
//                mService.pauseMedia(roomId);
//            }
//        } catch (final RemoteException ignored) {
//            LogUtils.ELog(TAG, ignored.getMessage());
//        }
//    }
//
//    public static void switchSubscriber(long roomId, int feed, boolean audio, boolean video, boolean data) {
//        try {
//            if (mService != null) {
//                mService.switchSubscriber(roomId, feed, audio, video, data);
//            }
//        } catch (final RemoteException ignored) {
//            LogUtils.ELog(TAG, ignored.getMessage());
//        }
//    }

    /**
     * 对某一频道静音模式设置,不更新UI
     *
     * @param roomId 房间id
     * @param enable true 静音 false 不静音
     */
    public static void mute(long roomId, boolean enable) {
        POCClient.getInstance()._mute(roomId, enable);
    }

    public void _mute(long roomId, boolean enable) {
        try {
            if (bindIsVaild()) {
                mService.mute(roomId, enable);
            } else {
                if (isBinding) {
                    return;
                }
                mConnectionMap.clear();
                POCClient.getInstance().bindService();
                LogUtils.ELog(TAG, "_mute: service is null");
            }
        } catch (final RemoteException ignored) {
            LogUtils.ELog(TAG, ignored.getMessage());
        }
    }

    /**
     * 对某一频道静音模式设置,会更新UI
     *
     * @param roomId 房间id
     * @param enable true 静音 false 不静音
     */
    public static void muteAndNotifyUI(long roomId, boolean enable) {
        POCClient.getInstance()._muteAndNotifyUI(roomId, enable);
    }

    public void _muteAndNotifyUI(long roomId, boolean enable) {
        try {
            if (bindIsVaild()) {
                mService.muteAndNotifyUI(roomId, enable);
            } else {
                if (isBinding) {
                    return;
                }
                mConnectionMap.clear();
                POCClient.getInstance().bindService();
                LogUtils.ELog(TAG, "muteAndNotifyUI: service is null");
            }
        } catch (final RemoteException ignored) {
            LogUtils.ELog(TAG, ignored.getMessage());
        }
    }


    /**
     * 恢复上次的mute状态
     */
    public static void reMuteLastStatus() {
        POCClient.getInstance()._reMuteLastStatus();
    }

    public void _reMuteLastStatus() {
        try {
            if (bindIsVaild())
                mService.reMuteLastStatus();
            else {
                if (isBinding) {
                    return;
                }
                mConnectionMap.clear();
                POCClient.getInstance().bindService();
                LogUtils.ELog(TAG, "_reMuteLastStatus: service is null");
            }
        } catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    /**
     * 对所有房间静音模式设置，不更新UI
     *
     * @param enable    true静音 false 非静音
     * @param channelId 无用
     */
    public static void muteAllRoomStatus(boolean enable, String channelId) {
        POCClient.getInstance()._muteAllRoomStatus(enable, channelId);
    }

    public void _muteAllRoomStatus(boolean enable, String channelId) {
        try {
            if (bindIsVaild()) {
                mService.muteAllRoomStatus(enable, channelId);
            } else {
                if (isBinding) {
                    return;
                }
                mConnectionMap.clear();
                POCClient.getInstance().bindService();
                LogUtils.ELog(TAG, "_muteAllRoomStatus: service is null");
            }
        } catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    /**
     * 网络连接失败时去全部从缓存移出,对之前已经加入的频道的做缓存后续处理
     */
    public static void handleNetConnectFailed() {
        POCClient.getInstance()._handleNetConnectFailed();
    }

    public void _handleNetConnectFailed() {
        try {
            if (bindIsVaild())
                mService.handleNetConnectFailed();
            else {
                if (isBinding) {
                    return;
                }
                mConnectionMap.clear();
                POCClient.getInstance().bindService();
                LogUtils.ELog(TAG, "_muteAllRoomStatus: service is null");
            }
        } catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    /**
     * 网络连接后处理方法
     */
    public static void handleNetConnectSuccess() {
        POCClient.getInstance()._handleNetConnectSuccess();
    }

    public void _handleNetConnectSuccess() {

        try {
            if (bindIsVaild())
                mService.handleNetConnectSuccess();
            else {
                if (isBinding) {
                    return;
                }
                mConnectionMap.clear();
                POCClient.getInstance().bindService();
                LogUtils.ELog(TAG, "handleNetConnectSuccess: service is null");
            }
        } catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    /**
     * 获取指定频道的在线人员列表
     *
     * @param roomId 房间id
     * @return 获取当前房间的在线成员的账号的集合
     */
    public static List<String> getOnLineMemberList(long roomId) {
        return POCClient.getInstance()._getOnLineMemberList(roomId);
    }

    public List<String> _getOnLineMemberList(long roomId) {
        try {
            if (bindIsVaild()) {
                return mService.getMemberList(roomId);
            } else {
                if (isBinding) {
                    return null;
                }
                mConnectionMap.clear();
                POCClient.getInstance().bindService();
                LogUtils.ELog(TAG, "getOnLineMemberList: service is null");
            }
        } catch (final RemoteException ignored) {
            LogUtils.ELog(TAG, ignored.getMessage());
        }
        return null;

    }

    /**
     * 如果未创建成功,则从缓存中移出
     * 废弃方法
     *
     * @param userId 用户账号
     * @param roomId 房间id
     */
    @Deprecated
    public void removeRoomFromCache(String userId, String roomId) {
        try {
            if (bindIsVaild()) {
                mService.removeRoomFromCache(userId, roomId);
            } else {
                if (isBinding) {
                    return;
                }
                mConnectionMap.clear();
                POCClient.getInstance().bindService();
                LogUtils.ELog(TAG, "removeRoomFromCache: service is null");
            }
        } catch (final RemoteException ignored) {
            LogUtils.ELog(TAG, ignored.getMessage());
        }
    }

    /**
     * 从缓存中移出:未创建成功的/未加入成功的room
     * 废弃方法
     */
    @Deprecated
    public void removeRommListFromCache() {
        try {
            if (bindIsVaild()) {
                mService.removeRoomListFromCache();
            } else {
                if (isBinding) {
                    return;
                }
                mConnectionMap.clear();
                POCClient.getInstance().bindService();
                LogUtils.ELog(TAG, "removeRommListFromCache: service is null");
            }
        } catch (final RemoteException ignored) {
            LogUtils.ELog(TAG, ignored.getMessage());
        }
    }

//    /**
//     * 发起成员呼叫信令
//     *
//     * @param json
//     * @param userIds
//     */
//    public static void sendPocCallMember(String json, String userIds, String roomId) {
//        if (mService != null) {
//            try {
//                mService.sendPocCallMember(json, userIds, roomId);
//            } catch (RemoteException e) {
//                e.printStackTrace();
//            }
//        }
//    }

//    /**
//     * 发送忙（正在通话或正在等待接听）信令
//     *
//     * @param json
//     * @param userId
//     * @param roomId
//     */
//    public static void sendPocUserBusy(String json, String userId, String roomId) {
//        if (mService != null) {
//            try {
//                mService.sendPocUserBusy(json, userId, roomId);
//            } catch (RemoteException e) {
//                e.printStackTrace();
//            }
//        }
//
//    }
//
//    /**
//     * 发送拒绝信令
//     *
//     * @param json
//     */
//    public static void sendPocRejectCall(String json, String senderUserId, String roomId) {
//        if (mService != null) {
//            try {
//                mService.sendPocRejectCall(json, senderUserId, roomId);
//            } catch (RemoteException e) {
//                e.printStackTrace();
//            }
//        }
//    }

//    /**
//     * 发送接收信令
//     *
//     * @param json
//     */
//    public static void sendPocAcceptCall(String json, String senderUserId, String roomId) {
//        try {
//            if (mService != null)
//                mService.sendPocAcceptCall(json, senderUserId, roomId);
//        } catch (RemoteException e) {
//            e.printStackTrace();
//        }
//    }
//
//    /**
//     * 发送延时信令
//     *
//     * @param json
//     */
//    public static void sendPocDelayCall(String json, String senderUserId, String roomId) {
//        try {
//            if (mService != null)
//                mService.sendPocDelayCall(json, senderUserId, roomId);
//        } catch (RemoteException e) {
//            e.printStackTrace();
//        }
//    }
//
//    /**
//     * db 插入临时组
//     *
//     * @param roomId
//     * @param memberInfos
//     */
//    public static void insertTempGroupData(String roomId, String groupName, String memberInfos, String ownerId) {
//        try {
//            if (mService != null)
//                mService.insertTempGroupData(roomId, groupName, memberInfos, ownerId);
//        } catch (Throwable throwable) {
//
//        }
//    }

//    /**
//     * 创建本地临时频道
//     *
//     * @param selectList
//     * @param userId
//     * @param sendUserName
//     */
//    public static void createTempRoom(ArrayList<POCMemberInfo> selectList, String userId, String sendUserName) {
//        String[] strings = GroupUtils.generateGroupMemberIdsAndTempRoomId(userId, selectList);
//        String sbUserId = strings[0];
//        String groupName = strings[1];
//        String tempRoomId = GroupUtils.generateTempGroupRoomId();
//        if (StringUtils.isEmpty(tempRoomId)) {
//            POCUiKitProxyImpl.getInstance().notifyTempRoomCreated(null, false);
//            return;
//        }
//        // TODO: 2018/10/19 SD/K呼叫群成员
////        POCClient.sendPocCallMember(PushProxy.generateCallMemberJson(userId, sendUserName, tempRoomId, sbUserId, groupName,userId), sbUserId,tempRoomId);
////        AMnager.startPOCConversionActivity(context, entity, -1);
//    }

//
//    public static void updateGroupMuteStatus(String userId, String roomId, boolean status) {
//        try {
//            if (mService != null) {
//                mService.updateGroupMuteStatus(userId, roomId, status);
//            }
//        } catch (Throwable throwable) {
//            LogUtils.ELog(throwable);
//        }
//    }

    /**
     * 获取当前用户在线的频道总数
     *
     * @return 获取在线房间的集合
     */
    public static List<String> getOnLineRoom() {
        return POCClient.getInstance()._getOnLineRoom();
    }

    public List<String> _getOnLineRoom() {
        try {
            if (bindIsVaild())
                return mService.getOnLineRoom();
            else {
                if (isBinding) {
                    return null;
                }
                mConnectionMap.clear();
                POCClient.getInstance().bindService();
                LogUtils.ELog(TAG, "_getOnLineRoom: service is null");
            }
            return null;
        } catch (RemoteException e) {
            e.printStackTrace();
        }
        return null;
    }

    /**
     * 获取断网后缓存的待重连的频道数
     *
     * @return
     */
    public static List<String> getReconnectRoom() {
        return POCClient.getInstance()._getReconnectRoom();
    }

    public List<String> _getReconnectRoom() {
        try {
            if (bindIsVaild())
                return mService.getReconnectRoom();
            else {
                if (isBinding) {
                    return null;
                }
                mConnectionMap.clear();
                POCClient.getInstance().bindService();
                LogUtils.ELog(TAG, "_getReconnectRoom: service is null");
            }
            return null;
        } catch (RemoteException e) {
            e.printStackTrace();
        }
        return null;
    }

    /**
     * List  To JsonString
     *
     * @param mList
     * @return
     */
    public <T> String generateListString(List<T> mList) {
        if (gson == null) {
            gson = new Gson();
        }
        if (mList == null || mList.size() <= 0) {
            return "";
        }
        return gson.toJson(mList);
    }

    /**
     * JsonString To  List
     *
     * @param content
     * @return
     */
    public List<POCMemberInfo> generateStringToList(String content) {
        if (gson == null) {
            gson = new Gson();
        }
        if (StringUtils.isEmpty(content)) {
            return null;
        }
        return gson.fromJson(content, new TypeToken<List<POCMemberInfo>>() {
        }.getType());
    }

    /**
     * 获取所有房间当前讲话人的账号集合
     *
     * @return Map<Roomid, userAccount>
     */
    public static Map<String, String> getAllSpeakers() {
        return POCClient.getInstance()._getAllSpeakers();
    }

    public Map<String, String> _getAllSpeakers() {
        if (bindIsVaild())
            try {
                return mService.getAllSpeakers();
            } catch (RemoteException e) {
                e.printStackTrace();
            }
        else {
            if (isBinding) {
                return null;
            }
            mConnectionMap.clear();
            POCClient.getInstance().bindService();
            LogUtils.ELog(TAG, "getAllSpeakers: service is null");
        }
        return null;
    }
//
//    public static void switchAudioTrack() {
//        if (mService != null)
//            try {
//                mService.switchAudioTrack();
//            } catch (RemoteException e) {
//                e.printStackTrace();
//            }
//    }

    /**
     * JsonString To  List
     *
     * @param content
     * @return
     */
    public List<String> generateStringToListString(String content) {
        if (gson == null) {
            gson = new Gson();
        }
        if (StringUtils.isEmpty(content)) {
            return null;
        }
        return gson.fromJson(content, new TypeToken<List<String>>() {
        }.getType());
    }

    /**
     * 同步获取数据库所有的频道信息
     *
     * @param context
     * @param userId  用户账号
     * @return
     */
    public static List<DBGroupEntity> getAllChannel(Context context, String userId) {
        return PocDaoGroupManager.getInstance(context).getAllPocGroup(userId);
    }

    /**
     * 通过频道id获取本地的频道信息
     *
     * @param context
     * @param channelId 房间id
     * @return
     */
    public static DBGroupEntity getChannelInfoByChannelId(Context context, String channelId) {
        return PocDaoGroupManager.getInstance(context).getChannelInfoByChannelId(channelId);
    }

    /**
     * 注册获取用户信息缓存的回调
     *
     * @param callBack
     */
    public static void registerPOCUserCacheCallBack(IPOCUserCacheCallBack callBack) {
        POCUiKitProxyImpl.getInstance().setUserCacheCallBack(callBack);
    }

    /**
     * 注册获取用户信息缓存的回调
     *
     * @param callBack
     */
    public static void unregisterPOCUserCacheCallBack(IPOCUserCacheCallBack callBack) {
        POCUiKitProxyImpl.getInstance().removeUserCacheCallBack(callBack);
    }

    /**
     * 注册获取用户信息的回调
     *
     * @param callBack
     */
    @Deprecated
    public static void registerPOCMemberInfoCallBack(IPOCMemberInfoCallBack callBack) {
        POCUiKitProxyImpl.getInstance().setMemberInfoCallBack(callBack);
    }

    @Deprecated
    public static void unregisterPOCMemberInfoCallBack(IPOCMemberInfoCallBack callBack) {
        POCUiKitProxyImpl.getInstance().removeMemberInfoCallBack(callBack);
    }

    /**
     * 刷新频道列表
     */
    public static void registerPOCGroupRefreshCallBack(IPOCGroupRefreshCallBack callBack) {
        POCUiKitProxyImpl.getInstance().setPOCGroupRefreshCallBack(callBack);
    }

    public static void unregisterPOCGroupRefreshCallBack(IPOCGroupRefreshCallBack callBack) {
        POCUiKitProxyImpl.getInstance().removePOCGroupRefreshCallBack(callBack);
    }

    /**
     * 用户点击行为的回调
     *
     * @param clickCallBack
     */
    public static void registerUserClickCallBack(IPOCUserClickCallBack clickCallBack) {
        POCUiKitProxyImpl.getInstance().addUserClickCallBack(clickCallBack);
    }

    public static void unregisterUserClickCallBack(IPOCUserClickCallBack clickCallBack) {
        POCUiKitProxyImpl.getInstance().removeUserClickCallBack(clickCallBack);
    }

    /**
     * 频道列表长按时间的注册回调
     */
    public static void registerPOCGroupItemLongClickCallBack(IPOCGroupLongClickCallBack callBack) {
        POCUiKitProxyImpl.getInstance().setPOCGroupItemLongClickCallBack(callBack);
    }

    public static void unregisterPOCGroupItemLongClickCallBack(IPOCGroupLongClickCallBack callBack) {
        POCUiKitProxyImpl.getInstance().removePOCGroupItemLongClickCallBack(callBack);
    }

//    /**
//     * 通知app层主动行为的回调
//     */
//    public static void registerPOCRequestCallBack(IPOCRequestCallBack callBack) {
//        POCUiKitProxyImpl.getInstance().setRequestCallBack(callBack);
//    }
//
//    public static void unregisterPOCRequestCallBack(IPOCRequestCallBack callBack) {
//        POCUiKitProxyImpl.getInstance().removeRequestCallBack(callBack);
//    }

    /**
     * 提供注册收到消息后的来电等待界面的部分回调
     */

    public static void registerPushMessageCallBack(IPOCPushMessageCallBack callBack) {
        POCUiKitProxyImpl.getInstance().setPushMessageCallBack(callBack);
    }

    public static void unregisterPushMessageCallBack(IPOCPushMessageCallBack callBack) {
        POCUiKitProxyImpl.getInstance().removePushMessageCallBack(callBack);
    }

    /*录音*/
    public static void registerRecordCallBack(IPOCRecordCallBack callBack) {
        POCUiKitProxyImpl.getInstance().setRecordCallBack(callBack);
    }

    public static void unregisterRecordCallBack(IPOCRecordCallBack callBack) {
        POCUiKitProxyImpl.getInstance().removeRecordCallBack(callBack);
    }

    public void uploadRecord(RecordMessage recordMessage) {
        if (bindIsVaild() && recordMessage != null) {
            try {
                mService.uploadRecord(recordMessage.getRecordUri());
            } catch (RemoteException e) {
                e.printStackTrace();
            }
        }
    }

    /**
     * 设置按键键值
     *
     * @param userId
     * @param ptKeytCode
     */
    public void setPttKeytCode(String userId, int ptKeytCode) {
        PreferenceHelper.setInt(userId + "_" + UserConfig.PTT_KEY_CODE, ptKeytCode);
    }

    /**
     * 获取当前设置的按键键值
     *
     * @param userId 用户account
     * @return
     */
    public int getPttCode(String userId) {
        return PreferenceHelper.getInt(userId + "_" + UserConfig.PTT_KEY_CODE, 0);
    }

    /**
     * 获取ptt的频道信息
     *
     * @param context
     * @param mUserId 用户account
     * @return
     */
    public DBGroupEntity getPttChannelInfo(Context context, String mUserId) {
        return PocDaoGroupManager.getInstance(context).getPttChannel(mUserId);
    }

    /**
     * 判断自己是否在讲话中
     *
     * @param userId 用户account
     * @return
     */
    public boolean isSelfSpeaking(String userId, String currentRoomId) {
        Map<String, String> map = POCClient.getInstance()._getAllSpeakers();
        if (map != null) {
            for (String roomId : map.keySet()) {
                if (!TextUtils.isEmpty(roomId) &&
                        currentRoomId.equals(roomId) &&
                        map.get(roomId) != null &&
                        map.get(roomId).equals(userId)) {
                    return true;
                }
            }
        }
        return false;
    }

    /**
     * 由于发起对讲的入口增多，用于判断需不需要发起takeTbcp
     *
     * @param roomId
     * @return false 不请求  true：请求
     * 1.自己在讲，则不请求tbcp
     * 2.如果不是自己在讲，则判断是否是强插 :如果是强插，则请求, 如果不是强插则不请求
     * 3.没人讲，则正常请求
     */
    public static boolean isSpeaking(String roomId, String mUserId) {
        boolean isForceInsert = POCClient.getRoomForceInsertStatus(roomId);
        if (POCClient.getAllSpeakers() != null && POCClient.getAllSpeakers().containsKey(roomId)) {
            if (POCClient.getAllSpeakers().get(roomId).equals(mUserId)) {
                //自己在讲
                return false;
            } else {
                // 不是自己在讲
                if (isForceInsert) {
                    // 是强插
                    return true;
                }
                // 不是强插
                return false;
            }
        }
        return true;
    }

    /**
     * 离开所有房间
     */
    public void leaveAllRoom(String curRoomId) {
        List<String> onLineRoom = POCClient.getOnLineRoom();
        if (onLineRoom == null) {
            return;
        }
        if (onLineRoom.size() == 1 && onLineRoom.get(0).equals(curRoomId)) {
            return;
        }
        for (String roomId : onLineRoom) {
            POCClient.leaveRoom(PreferenceHelper.getString(UserConfig.LOGIN_ACCOUNT, ""), roomId);
            POCClient.removeFromReconnectCache(roomId);
            releaseTBCP(roomId);
        }
    }

    /**
     * 添加到被移除集合(用来保存自己被某个房间移除)
     * @param roomId
     */
    public void addRemoved(String roomId) {
        if (TextUtils.isEmpty(roomId)) return;
        LogUtils.ILog(TAG,"addRemoved roomId "+roomId);
        if (removedCacheList == null) {
            removedCacheList = new ArrayList<>();
        }
        if (!removedCacheList.contains(roomId)){
            removedCacheList.add(roomId);
        }
    }

    /**
     * 自己是否被此ROOM移除
     * @param roomId
     * @return
     */
    public boolean wasRemoved(String roomId) {
        LogUtils.ILog(TAG,"wasRemoved roomId "+roomId +" removedCacheList "+(removedCacheList == null? "null":removedCacheList.size()));
        if (removedCacheList != null) {
            boolean isContains = removedCacheList.contains(roomId);
            if (isContains){
                removedCacheList.remove(roomId);
            }
            return isContains;
        }
        return false;
    }

    /**
     * 从被删除房间缓存中移除
     * @param roomId
     */
    public void removeCacheRoom(String roomId){
        LogUtils.ILog(TAG,"removeCacheRoom roomId:"+roomId);
        if (TextUtils.isEmpty(roomId)) return;
        if (removedCacheList != null) {
            removedCacheList.remove(roomId);
        }
    }
    
    public void removeAllCacheRoom(){
        if (removedCacheList != null) {
            removedCacheList.clear();
        }
    }

}
