package com.xdja.poc.sdk.business;

import com.xdja.poc.sdk.bean.GroupList;
import com.xdja.poc.sdk.bean.POCMemberInfo;
import com.xdja.poc.sdk.config.GroupConfig;
import com.xdja.poc.sdk.db.entity.DBGroupEntity;
import com.xdja.poc.sdk.event.GroupDeleteEvent;
import com.xdja.poc.sdk.event.GroupEvent;
import com.xdja.poc.sdk.event.GroupMemberAddEvent;
import com.xdja.poc.sdk.event.GroupRefreshAdapterEvent;
import com.xdja.poc.sdk.event.POCCallEvent;
import com.xdja.poc.sdk.event.POCChannelInfoResult;
import com.xdja.poc.sdk.event.POCGroupUpdateEvent;
import com.xdja.poc.sdk.event.ResetChannelStatus;
import com.xdja.poc.sdk.event.UpdateMemberInfoEvent;
import com.xdja.poc.sdk.event.UpdateUserInfoEvent;
import com.xdja.poc.sdk.proxy.POCUiKitProxyImpl;

import org.greenrobot.eventbus.EventBus;

import java.util.ArrayList;
import java.util.Map;

/**
 * POC-Sdk
 * 功能
 * 描述
 * created by Wwq : 2018/10/23
 */

@SuppressWarnings("ALL")
public class EventPropxy {
    /**
     * 更新频道列表数据
     * 包括:1.手动创建频道成功 2.收到被呼叫邀请时
     *
     * @param mGroupList
     */
    public static void postUpdateGroupListData(ArrayList<GroupList.GroupData> mGroupList, int viewType, boolean isReconect) {
        POCGroupUpdateEvent updateEvent = new POCGroupUpdateEvent(mGroupList);
        updateEvent.setViewType(viewType);
        updateEvent.setReconnect(isReconect);
        EventBus.getDefault().post(updateEvent);
//        Intent intent = new Intent("update_poc_group_list");
//        intent.putExtra("mGroupList", mGroupList);
//        intent.putExtra("isReconnect", isReconect);
//        GlobalContext.getContext().sendBroadcast(intent);
    }

    /**
     *
     */
    public static void postDoRefreshChannelListData(int currentPage, int pageSize, int groupType) {
        POCUiKitProxyImpl.getInstance().notifyRefreshGroupList(currentPage, pageSize, groupType);
    }

    /**
     * 刷新频道列表的adapter数据
     * 频道列表:由于删除是由app层接口调用,所以删除成功后通知SDK更新UI
     *
     * @param roomId
     */
    public static void postRefreshAdapter(String roomId) {
        GroupRefreshAdapterEvent adapterEvent = new GroupRefreshAdapterEvent();
        adapterEvent.setRoomId(roomId);
        EventBus.getDefault().post(adapterEvent);
    }

    /**
     * 删除频道的事件通知
     * 通知SDK删除该频道:这里注意下:由于是要先离开频道,
     * 离开成功后才调删除接口,所以首先得通知SDK离开频道
     *
     * @param entity
     */
    @Deprecated
    public static void postDeleteRoom(DBGroupEntity entity) {
        GroupDeleteEvent deleteEvent = new GroupDeleteEvent();
        deleteEvent.setT(entity);
        EventBus.getDefault().post(deleteEvent);
    }

    /**
     * 通知频道被删除
     *
     * @param code
     * @param position
     * @param roomId
     */
    public static void postChannelDeleted(int code, int position, String roomId, String from) {
        GroupEvent groupEvent = MessageProxy.generateGroupEvent(code, position, roomId, GroupConfig.TYPE_DELETE_SERVER_ROOM, "", null);
        groupEvent.setFrom(from);
        POCUiKitProxyImpl.getInstance().notifyServerRoomDeleted(groupEvent, (code == 200));
    }

    /**
     * 通知频道成员被移除
     *
     * @param from
     * @param members
     * @param roomId
     */
    public static void postChannelRemoveMembers(String from, String roomId, String members) {
        GroupEvent groupEvent = MessageProxy.generateGroupEvent(200, -1, roomId, GroupConfig.TYPE_REMOVE_MEMBERS, members, null);
        groupEvent.setFrom(from);
        POCUiKitProxyImpl.getInstance().notifyRemoveMembers(groupEvent, true);
    }

    /**
     * 通知SDK添加成员
     *
     * @param roomId
     * @param members
     */
    public static void postAddMembers(String roomId, String[] members) {
        GroupMemberAddEvent addEvent = new GroupMemberAddEvent();
        addEvent.setRoomId(roomId);
        addEvent.setMemberIds(members);
        EventBus.getDefault().post(addEvent);
    }


    /**
     * 通知频道新增成员
     *
     * @param code
     * @param position
     * @param roomId
     */
    public static void postChannelMemberAdded(int code, int position, String roomId, String memberIds, Map<String, POCMemberInfo> userInfos) {
        GroupEvent groupEvent = MessageProxy.generateGroupEvent(code, -1, roomId, GroupConfig.TYPE_ADD_MEMBERS, memberIds, userInfos);
        POCUiKitProxyImpl.getInstance().notifyAddMembers(groupEvent, (code == 200));
    }


    /**
     * 通知频道成员信息更新
     *
     * @param code
     * @param position
     * @param roomId
     * @param memberIds
     */
    public static void postChannelMembersUpdate(int code, int position, String roomId, String memberIds) {
        GroupEvent groupEvent = MessageProxy.generateGroupEvent(code, -1, roomId, GroupConfig.TYPE_REMOVE_MEMBERS, memberIds, null);
        POCUiKitProxyImpl.getInstance().notifyUpdateMembers(groupEvent, (code == 200));
    }

    /**
     * 设置当前频道为ptt键
     *
     * @param channelId
     * @param pttStatus
     */
    public static void postSetPttKey(String channelId, boolean pttStatus) {
        POCUiKitProxyImpl.getInstance().notifyPttKeyEvent(channelId, pttStatus);
    }

    /**
     * 更新频道名称
     *
     * @param channelId
     * @param channelName
     */
    public static void postUpdateChannelName(String channelId, String channelName) {
        POCUiKitProxyImpl.getInstance().notifyChannelNameEvent(channelId, channelName);
    }

    /**
     * 更新频道口令
     *
     * @param channelId
     * @param channelPwd
     */
    public static void postUpdateChannelPwdCode(String channelId, String channelPwd) {
        POCUiKitProxyImpl.getInstance().notifyChannelPwqEvent(channelId, channelPwd);
    }

    /**
     * 更新频道口令是否开启
     *
     * @param channelId
     * @param channelPwdMode true:开启 false:关闭
     */
    public static void postUpdateChannelPwdMode(String channelId, boolean channelPwdMode) {
        POCUiKitProxyImpl.getInstance().notifyChannelPwdModeEvent(channelId, channelPwdMode);
    }

    public static void postNotifyCallWaitingActivityResult(boolean result) {
        POCUiKitProxyImpl.getInstance().notifyChannelInfoResult(result);
        EventBus.getDefault().post(new POCChannelInfoResult(result));
    }

    /**
     * 更新频道详情UI
     *
     * @param entity
     */
    public static void postUpdateMembersInfo(DBGroupEntity entity, boolean isChannelExist) {
        UpdateMemberInfoEvent updateMemberInfoEvent = new UpdateMemberInfoEvent(entity);
        updateMemberInfoEvent.setChannelExist(isChannelExist);
        EventBus.getDefault().post(updateMemberInfoEvent);
    }

    /**
     * 更新用户缓存信息（备注啊等等）
     */
    public static void postUpdateUserInfo(POCMemberInfo memberInfo) {
        EventBus.getDefault().post(new UpdateUserInfoEvent(memberInfo));
    }

    /**
     * 呼叫超时
     *
     * @param roomId
     * @param userId
     */
    public static void postPOCCallDelayEvent(String roomId, String userId) {
        POCCallEvent callEvent = new POCCallEvent();
        callEvent.setRoomId(roomId);
        callEvent.setUserId(userId);
        callEvent.setEventType(POCCallEvent.POC_CALL_DELAY);
        EventBus.getDefault().post(callEvent);
    }

    /**
     * 呼叫拒绝
     *
     * @param roomId
     * @param userId
     */
    public static void postPOCCallRejectEvent(String roomId, String userId) {
        POCCallEvent callEvent = new POCCallEvent();
        callEvent.setRoomId(roomId);
        callEvent.setUserId(userId);
        callEvent.setEventType(POCCallEvent.POC_CALL_REJECT);
        EventBus.getDefault().post(callEvent);
    }

    /**
     * 由于网络数据未及时返回，第一时间先重置频道列表数据
     *
     * @param channelId
     */
    public static void postResetChannelStatus(String channelId) {
        EventBus.getDefault().post(new ResetChannelStatus(channelId));
    }

}
