package com.xdja.poc.sdk.db.manager;


import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;

import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.common.utils.PreferenceHelper;
import com.xdja.poc.common.utils.StringUtils;
import com.xdja.poc.sdk.POCClient;
import com.xdja.poc.sdk.bean.POCMemberInfo;
import com.xdja.poc.sdk.config.UserConfig;
import com.xdja.poc.sdk.db.DBConstant;
import com.xdja.poc.sdk.db.entity.DBGroupEntity;
import com.xdja.poc.sdk.utils.GroupUtils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * Created by Administrator on 2018/2/5 10:17.
 */

@SuppressWarnings("ALL")
public class PocDaoGroupManager {
    private static PocDaoGroupManager mInstance;
    private POCSQLiteOpenHelper mHelper;
    private SQLiteDatabase db;
    private String TAG = "PocDaoGroupManager";

    public static PocDaoGroupManager getInstance(Context context) {
        if (mInstance == null) {
            synchronized (PocDaoGroupManager.class) {
                if (mInstance == null) {
                    mInstance = new PocDaoGroupManager(context);
                }
            }
        }
        return mInstance;
    }

    private PocDaoGroupManager(Context context) {
        if (mInstance == null) {
            mHelper = new POCSQLiteOpenHelper(context);
            db = mHelper.getWritableDatabase();
        }
    }

    /**
     * 插入或替换数据
     *
     * @return
     */
    public synchronized void insertOrReplaceGroup(List<DBGroupEntity> groups) {
        Cursor cursor = null;
        try {
            for (DBGroupEntity group : groups) {
                cursor = db.rawQuery("SELECT * FROM " + DBConstant.CHANNEL_TABLE + " WHERE key=?",
                        new String[]{group.getKey()});
                if (cursor == null || !cursor.moveToFirst()) {
                    if (!StringUtils.isEmpty(group.getRoomName()) && group.getRoomName().equals(UserConfig.UN_DEFINE)) {
                        List<POCMemberInfo> memberInfoList = POCClient.getInstance().generateStringToList(group.getMemeberIds());
                        String strings = GroupUtils.generateGroupMemberTempRoomName((ArrayList<POCMemberInfo>) memberInfoList);
                        group.setRoomName(strings);
                    }
                    group.setRoomName(GroupUtils.convertString(group.getRoomName()));

                    db.execSQL(
                            "INSERT INTO " + DBConstant.CHANNEL_TABLE
                                    + " (" +
                                    DBConstant.USERID + "," +
                                    DBConstant.KEY + "," +
                                    DBConstant.OWNERID + "," +
                                    DBConstant.ACTIVEUSERID + "," +
                                    DBConstant.ROOMID + "," +
                                    DBConstant.ROOMNAME + "," +
                                    DBConstant.MEMEBERIDS + "," +
                                    DBConstant.ONLINECOUNT + "," +
                                    DBConstant.ISSILENCE + "," +
                                    DBConstant.SPEAKERUSERID + "," +
                                    DBConstant.SPEAKERUSERNAME + "," +
                                    DBConstant.STATUS + "," +
                                    DBConstant.ISTOPSTICK + "," +
                                    DBConstant.TOPSTICKINDEX + "," +
                                    DBConstant.TOPSTICKTIME + "," +
                                    DBConstant.GROUPTYPE + "," +
                                    DBConstant.USERNAMES + "," +
                                    DBConstant.ISPTTKEY + "," +
                                    DBConstant.CHANNELPWD + "," +
                                    DBConstant.MAXINVITEMEMBERSCOUNT + "," +
                                    DBConstant.CHANNELPWDMODE +"," +
                                    DBConstant.CREATETIME +
                                    ")"
                                    + "VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)",
                            new Object[]{
                                    group.getUserId(),
                                    group.getKey(),
                                    group.getOwnerId(),
                                    group.getActiveUserId(),
                                    group.getRooomId(),
                                    group.getRoomName(),
                                    group.getMemeberIds(),
                                    group.getOnLineCount(),
                                    0,
                                    group.getSpeakerUserId(),
                                    group.getSpeakerUserName(),
                                    group.getStatus(),
                                    group.getIsTopStick(),
                                    group.getTopStickIndex(),
                                    group.getTopStickTime(),
                                    group.getGroupType(),
                                    group.getUserNames(),
                                    group.getIsPttKey(),
                                    group.getChannelPwd(),
                                    group.getMaxInviteMembersCount(),
                                    group.getChannelPwdMode(),
                                    group.getCreateTime()
                            });
                } else {
                    ContentValues values = new ContentValues();
                    values.put(DBConstant.ISSILENCE, cursor.getInt(cursor.getColumnIndex(DBConstant.ISSILENCE)));
                    values.put(DBConstant.TOPSTICKTIME, cursor.getString(cursor.getColumnIndex(DBConstant.TOPSTICKTIME)));
                    values.put(DBConstant.ISTOPSTICK, cursor.getInt(cursor.getColumnIndex(DBConstant.ISTOPSTICK)));
                    String channelName = GroupUtils.convertString(group.getRoomName());
                    values.put(DBConstant.ROOMNAME, channelName);
                    values.put(DBConstant.MEMEBERIDS, group.getMemeberIds());
                    values.put(DBConstant.CHANNELPWDMODE, group.getChannelPwdMode());
                    values.put(DBConstant.CHANNELPWD, group.getChannelPwd());
                    values.put(DBConstant.MAXINVITEMEMBERSCOUNT, group.getMaxInviteMembersCount());
                    values.put(DBConstant.STATUS, cursor.getInt(cursor.getColumnIndex(DBConstant.STATUS)));
                    values.put(DBConstant.ISPTTKEY, cursor.getInt(cursor.getColumnIndex(DBConstant.ISPTTKEY)));
                    values.put(DBConstant.CREATETIME, cursor.getString(cursor.getColumnIndex(DBConstant.CREATETIME)));
                    db.update(DBConstant.CHANNEL_TABLE, values, "key='" + group.getKey() + "'", null);
                }
                LogUtils.ILog(TAG, " insertOrReplaceGroup success");
            }
        } catch (Exception e) {
            LogUtils.ELog(e);
        } finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    /**
     * 根据主键删除数据库数据
     *
     * @param key
     */
    public void deleteGroup(String key) {
        try {
            db.execSQL("DELETE FROM " + DBConstant.CHANNEL_TABLE + " WHERE key=?", new String[]{key});
            LogUtils.ILog("delete group success");
        } catch (Throwable throwable) {
            LogUtils.ELog(throwable);
        }
    }

    /**
     * 获取该用户下的所有频道数据
     *
     * @param userId
     * @return
     */
    public synchronized List<DBGroupEntity> getAllPocGroup(String userId) {
        Cursor cursor = null;
        List<DBGroupEntity> adInfos;
        try {
            cursor = this.db.rawQuery("SELECT * FROM " + DBConstant.CHANNEL_TABLE + " WHERE userId=?", new String[]{userId});
            if (cursor != null && cursor.getCount() > 0 && cursor.moveToFirst()) {
                adInfos = new ArrayList<>();
                for (int m = 0; m < cursor.getCount(); m++) {
                    DBGroupEntity entity = new DBGroupEntity();
                    entity.setKey(cursor.getString(cursor.getColumnIndex(DBConstant.KEY)));
                    entity.setUserId(cursor.getString(cursor.getColumnIndex(DBConstant.USERID)));
                    entity.setOwnerId(cursor.getString(cursor.getColumnIndex(DBConstant.OWNERID)));
                    entity.setActiveUserId(cursor.getString(cursor.getColumnIndex(DBConstant.ACTIVEUSERID)));
                    entity.setRooomId(cursor.getString(cursor.getColumnIndex(DBConstant.ROOMID)));
                    String channelName = cursor.getString(cursor.getColumnIndex(DBConstant.ROOMNAME));
                    String membersId = cursor.getString(cursor.getColumnIndex(DBConstant.MEMEBERIDS));
                    if ((!StringUtils.isEmpty(channelName) && channelName.equals(UserConfig.UN_DEFINE)) || StringUtils.isEmpty(channelName)) {
                        List<POCMemberInfo> memberInfoList = POCClient.getInstance().generateStringToList(membersId);
                        channelName = GroupUtils.generateGroupMemberTempRoomName((ArrayList<POCMemberInfo>) memberInfoList);
                    }
                    entity.setRoomName(channelName);
                    entity.setMemeberIds(membersId);
                    int maxMemberCount = cursor.getInt(cursor.getColumnIndex(DBConstant.MAXINVITEMEMBERSCOUNT));
                    entity.setMaxInviteMembersCount(maxMemberCount);
                    entity.setOnLineCount(cursor.getInt(cursor.getColumnIndex(DBConstant.ONLINECOUNT)));
                    entity.setIsSilence(cursor.getInt(cursor.getColumnIndex(DBConstant.ISSILENCE)));
                    entity.setSpeakerUserId(cursor.getString(cursor.getColumnIndex(DBConstant.SPEAKERUSERID)));
                    entity.setSpeakerUserName(cursor.getString(cursor.getColumnIndex(DBConstant.SPEAKERUSERNAME)));
                    entity.setStatus(cursor.getInt(cursor.getColumnIndex(DBConstant.STATUS)));
                    entity.setIsTopStick(cursor.getInt(cursor.getColumnIndex(DBConstant.ISTOPSTICK)));
                    entity.setTopStickIndex(cursor.getInt(cursor.getColumnIndex(DBConstant.TOPSTICKINDEX)));
                    entity.setTopStickTime(Long.valueOf(cursor.getString(cursor.getColumnIndex(DBConstant.TOPSTICKTIME))));
                    entity.setGroupType(cursor.getInt(cursor.getColumnIndex(DBConstant.GROUPTYPE)));
                    entity.setUserNames(cursor.getString(cursor.getColumnIndex(DBConstant.USERNAMES)));
                    entity.setIsPttKey(cursor.getInt(cursor.getColumnIndex(DBConstant.ISPTTKEY)));
                    entity.setChannelPwd(cursor.getString(cursor.getColumnIndex(DBConstant.CHANNELPWD)));
                    entity.setChannelPwdMode(cursor.getInt(cursor.getColumnIndex(DBConstant.CHANNELPWDMODE)));
                    entity.setCreateTime(cursor.getString(cursor.getColumnIndex(DBConstant.CREATETIME)));
                    adInfos.add(entity);
                    cursor.moveToNext();
                }
                return adInfos;
            }
        } catch (Throwable throwable) {
            LogUtils.ELog(TAG, "getAllPocGroup: " + Arrays.toString(throwable.getStackTrace()));
        } finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return null;
    }

    /**
     * 获取该用户下的所有频道数据
     *
     * @param channelId
     * @return
     */
    public synchronized DBGroupEntity getChannelInfoByChannelId(String channelId) {
        Cursor cursor = null;
        String userId = PreferenceHelper.getString(UserConfig.LOGIN_ACCOUNT, "");
        DBGroupEntity entity;
        try {
            String key = GroupUtils.generatePOCGroupDbKey(userId, channelId);
            cursor = this.db.rawQuery("SELECT * FROM " + DBConstant.CHANNEL_TABLE + " WHERE key=?", new String[]{key});
            if (cursor != null && cursor.getCount() > 0 && cursor.moveToFirst()) {
                entity = new DBGroupEntity();
                entity.setKey(cursor.getString(cursor.getColumnIndex(DBConstant.KEY)));
                entity.setUserId(cursor.getString(cursor.getColumnIndex(DBConstant.USERID)));
                entity.setOwnerId(cursor.getString(cursor.getColumnIndex(DBConstant.OWNERID)));
                entity.setActiveUserId(cursor.getString(cursor.getColumnIndex(DBConstant.ACTIVEUSERID)));
                entity.setRooomId(cursor.getString(cursor.getColumnIndex(DBConstant.ROOMID)));
                String channelName = cursor.getString(cursor.getColumnIndex(DBConstant.ROOMNAME));
                String membersId = cursor.getString(cursor.getColumnIndex(DBConstant.MEMEBERIDS));
                if ((!StringUtils.isEmpty(channelName) && channelName.equals(UserConfig.UN_DEFINE)) || StringUtils.isEmpty(channelName)) {
                    List<POCMemberInfo> memberInfoList = POCClient.getInstance().generateStringToList(membersId);
                    channelName = GroupUtils.generateGroupMemberTempRoomName((ArrayList<POCMemberInfo>) memberInfoList);
                }
                int maxMemberCount = cursor.getInt(cursor.getColumnIndex(DBConstant.MAXINVITEMEMBERSCOUNT));
                entity.setMaxInviteMembersCount(maxMemberCount);
                entity.setRoomName(channelName);
                entity.setMemeberIds(membersId);
                entity.setOnLineCount(cursor.getInt(cursor.getColumnIndex(DBConstant.ONLINECOUNT)));
                entity.setIsSilence(cursor.getInt(cursor.getColumnIndex(DBConstant.ISSILENCE)));
                entity.setSpeakerUserId(cursor.getString(cursor.getColumnIndex(DBConstant.SPEAKERUSERID)));
                entity.setSpeakerUserName(cursor.getString(cursor.getColumnIndex(DBConstant.SPEAKERUSERNAME)));
                entity.setStatus(cursor.getInt(cursor.getColumnIndex(DBConstant.STATUS)));
                entity.setIsTopStick(cursor.getInt(cursor.getColumnIndex(DBConstant.ISTOPSTICK)));
                entity.setTopStickIndex(cursor.getInt(cursor.getColumnIndex(DBConstant.TOPSTICKINDEX)));
                entity.setTopStickTime(Long.valueOf(cursor.getString(cursor.getColumnIndex(DBConstant.TOPSTICKTIME))));
                entity.setGroupType(cursor.getInt(cursor.getColumnIndex(DBConstant.GROUPTYPE)));
                entity.setUserNames(cursor.getString(cursor.getColumnIndex(DBConstant.USERNAMES)));
                entity.setIsPttKey(cursor.getInt(cursor.getColumnIndex(DBConstant.ISPTTKEY)));
                entity.setChannelPwd(cursor.getString(cursor.getColumnIndex(DBConstant.CHANNELPWD)));
                entity.setChannelPwdMode(cursor.getInt(cursor.getColumnIndex(DBConstant.CHANNELPWDMODE)));
                entity.setCreateTime(cursor.getString(cursor.getColumnIndex(DBConstant.CREATETIME)));
                return entity;
            }
        } catch (Throwable throwable) {
            LogUtils.ELog(TAG, "getAllPocGroup: " + Arrays.toString(throwable.getStackTrace()));
        } finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return null;
    }

    /**
     * 更新频道是否静音
     *
     * @param userId
     * @param roomId
     * @param isSilence
     */
    public void updateGroupIsSilence(String userId, String roomId, boolean isSilence) {
        Cursor cursor = null;
        try {
            String key = GroupUtils.generatePOCGroupDbKey(userId, roomId);
            cursor = this.db.rawQuery("SELECT * FROM " + DBConstant.CHANNEL_TABLE + " WHERE key=?", new String[]{key});
            if (cursor != null && cursor.moveToFirst()) {
                ContentValues values = new ContentValues();
                values.put(DBConstant.ISSILENCE, isSilence ? 1 : 0);
                db.update(DBConstant.CHANNEL_TABLE, values, "key='" + key + "'", null);
            }
        } catch (Throwable throwable) {
            LogUtils.ELog(TAG, "updateGroupIsSilence: " + throwable.getLocalizedMessage());
        } finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    /**
     * 更新频道是为ptt key
     *
     * @param entitieList
     * @param channelId
     * @param isPtt
     */
    public synchronized void updateGroupIsPttKey(List<DBGroupEntity> entitieList, String userId, String channelId, boolean isPtt) {
        Cursor cursor = null;
        try {
            for (DBGroupEntity entity : entitieList) {
                if (entity.getIsPttKey()) {
                    String key = GroupUtils.generatePOCGroupDbKey(entity.getUserId(), entity.getRooomId());
                    cursor = this.db.rawQuery("SELECT * FROM " + DBConstant.CHANNEL_TABLE + " WHERE key=?", new String[]{key});
                    if (cursor != null && cursor.moveToFirst()) {
                        ContentValues values = new ContentValues();
                        values.put(DBConstant.ISPTTKEY, 0);
                        db.update(DBConstant.CHANNEL_TABLE, values, "key='" + key + "'", null);
                    }
                }
            }
            String key = GroupUtils.generatePOCGroupDbKey(userId, channelId);
            cursor = this.db.rawQuery("SELECT * FROM " + DBConstant.CHANNEL_TABLE + " WHERE key=?", new String[]{key});
            if (cursor != null && cursor.moveToFirst()) {
                ContentValues values = new ContentValues();
                values.put(DBConstant.ISPTTKEY, isPtt ? 1 : 0);
                db.update(DBConstant.CHANNEL_TABLE, values, "key='" + key + "'", null);
            }
        } catch (Throwable throwable) {
            LogUtils.ELog(throwable);
        } finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    /**
     * 更新频道是否置顶
     *
     * @param userId
     * @param roomId
     * @param isStick
     */
    public void updateGroupIsTopStick(String userId, String roomId, boolean isStick) {
        Cursor cursor = null;
        try {
            String key = GroupUtils.generatePOCGroupDbKey(userId, roomId);
            cursor = this.db.rawQuery("SELECT * FROM " + DBConstant.CHANNEL_TABLE + " WHERE key=?", new String[]{key});
            if (cursor != null && cursor.moveToFirst()) {
                ContentValues values = new ContentValues();
                values.put(DBConstant.ISTOPSTICK, isStick ? 1 : 0);
                values.put(DBConstant.TOPSTICKTIME, String.valueOf(System.currentTimeMillis()));
                db.update(DBConstant.CHANNEL_TABLE, values, "key='" + key + "'", null);
            }
        } catch (Throwable throwable) {
            LogUtils.ELog(throwable);
        } finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }


    /**
     * 插入或替换临时频道数据
     *
     * @param group
     * @return
     */
    public synchronized String insertOrReplaceTempGroup(DBGroupEntity group) {
        Cursor cursor = null;
        try {
            cursor = db.rawQuery("SELECT * FROM " + DBConstant.CHANNEL_TABLE + " WHERE key=?",
                    new String[]{group.getKey()});
            if (cursor != null && !cursor.moveToFirst()) {
                db.execSQL(
                        "INSERT INTO " + DBConstant.CHANNEL_TABLE
                                + " (" +
                                DBConstant.USERID + "," +
                                DBConstant.KEY + "," +
                                DBConstant.OWNERID + "," +
                                DBConstant.ACTIVEUSERID + "," +
                                DBConstant.ROOMID + "," +
                                DBConstant.ROOMNAME + "," +
                                DBConstant.MEMEBERIDS + "," +
                                DBConstant.ONLINECOUNT + "," +
                                DBConstant.ISSILENCE + "," +
                                DBConstant.SPEAKERUSERID + "," +
                                DBConstant.SPEAKERUSERNAME + "," +
                                DBConstant.STATUS + "," +
                                DBConstant.ISTOPSTICK + "," +
                                DBConstant.TOPSTICKINDEX + "," +
                                DBConstant.TOPSTICKTIME + "," +
                                DBConstant.GROUPTYPE + "," +
                                DBConstant.USERNAMES + "," +
                                DBConstant.ISPTTKEY + "," +
                                DBConstant.CHANNELPWD + "," +
                                DBConstant.MAXINVITEMEMBERSCOUNT + "," +
                                DBConstant.CHANNELPWDMODE +"," +
                                DBConstant.CREATETIME +
                                ")"
                                + "VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)",
                        new Object[]{group.getUserId(),
                                group.getKey(), group.getOwnerId(), group.getActiveUserId(),
                                group.getRooomId(), group.getRoomName(), group.getMemeberIds(),
                                group.getOnLineCount(), group.getIsSilence(), group.getSpeakerUserId(),
                                group.getSpeakerUserName(),
                                group.getStatus(), group.getIsTopStick(),
                                group.getTopStickIndex(), group.getTopStickTime(),
                                group.getGroupType(), group.getUserNames(), group.getIsPttKey(), group.getChannelPwd(),
                                group.getMaxInviteMembersCount(),
                                group.getChannelPwdMode(),group.getCreateTime()
                        });
            } else {
                ContentValues values = new ContentValues();
                values.put(DBConstant.ISTOPSTICK, 0);
                values.put(DBConstant.TOPSTICKTIME, String.valueOf(System.currentTimeMillis()));
                db.update(DBConstant.CHANNEL_TABLE, values, "key='" + group.getKey() + "'", null);
            }

            LogUtils.ILog(TAG, " insertOrReplaceGroup success");
            return group.getMemeberIds();
        } catch (Exception e) {
            LogUtils.ELog(e);
        } finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return "";
    }

    /**
     * 更新频道名称
     *
     * @param userId
     * @param roomId
     * @param groupName
     */
    public void updateGroupNanme(String userId, String roomId, String groupName) {
        Cursor cursor = null;
        try {
            String key = GroupUtils.generatePOCGroupDbKey(userId, roomId);
            cursor = this.db.rawQuery("SELECT * FROM " + DBConstant.CHANNEL_TABLE + " WHERE key=?", new String[]{key});
            if (cursor != null && cursor.moveToFirst()) {
                ContentValues values = new ContentValues();
                values.put(DBConstant.ROOMNAME, groupName);
                db.update(DBConstant.CHANNEL_TABLE, values, "key='" + key + "'", null);

            }
        } catch (Exception e) {
            LogUtils.ELog(e);
        } finally {
            if (cursor != null) {
                cursor.close();
            }
        }

    }

    /**
     * 更新频道口令
     *
     * @param userId
     * @param roomId
     * @param pwd
     */
    public void updateGroupPwd(String userId, String roomId, String pwd) {
        Cursor cursor = null;
        try {
            String key = GroupUtils.generatePOCGroupDbKey(userId, roomId);
            cursor = this.db.rawQuery("SELECT * FROM " + DBConstant.CHANNEL_TABLE + " WHERE key=?", new String[]{key});
            if (cursor != null && cursor.moveToFirst()) {
                ContentValues values = new ContentValues();
                values.put(DBConstant.CHANNELPWD, pwd);
                db.update(DBConstant.CHANNEL_TABLE, values, "key='" + key + "'", null);

            }
        } catch (Exception e) {
            LogUtils.ELog(e);
        } finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    /**
     * 更新频道口令模式
     *
     * @param userId
     * @param roomId
     * @param channelPwdMode
     */
    public void updateGroupPwdMode(String userId, String roomId, boolean channelPwdMode) {
        Cursor cursor = null;
        try {
            String key = GroupUtils.generatePOCGroupDbKey(userId, roomId);
            cursor = this.db.rawQuery("SELECT * FROM " + DBConstant.CHANNEL_TABLE + " WHERE key=?", new String[]{key});
            if (cursor != null && cursor.moveToFirst()) {
                ContentValues values = new ContentValues();
                values.put(DBConstant.CHANNELPWDMODE, channelPwdMode ? 1 : 0);
                db.update(DBConstant.CHANNEL_TABLE, values, "key='" + key + "'", null);
            }
        } catch (Exception e) {
            LogUtils.ELog(e);
        } finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    /**
     * 获取ptt设置的频道信息
     *
     * @return
     */
    public DBGroupEntity getPttChannel(String userId) {
        Cursor cursor = null;
        try {
            cursor = this.db.rawQuery("SELECT * FROM " + DBConstant.CHANNEL_TABLE + " WHERE isPttKey=? and userId=?", new String[]{"1", userId});
            if (cursor != null && cursor.getCount() > 0 && cursor.moveToFirst()) {
                DBGroupEntity dbGroupEntity = new DBGroupEntity();
                String channelId = cursor.getString(cursor.getColumnIndex(DBConstant.ROOMID));
                dbGroupEntity.setRooomId(channelId);
                dbGroupEntity.setStatus(cursor.getInt(cursor.getColumnIndex(DBConstant.STATUS)));
                return dbGroupEntity;
            }
        } catch (Exception e) {
            LogUtils.ELog(e);
        } finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return null;
    }

    /**
     * 当服务器返回数据为空时,清空该用户本地的所有数据
     *
     * @param mUserId
     */
    public void clearChannelInfo(String mUserId) {
        try {
            db.execSQL("DELETE FROM " + DBConstant.CHANNEL_TABLE + " WHERE userId=?", new String[]{mUserId});
            LogUtils.ELog(TAG, "db clearChannelInfo success");
        } catch (Exception e) {
            LogUtils.ELog(e);
        }

    }

    public void close() {
        try {
            if (db != null) {
                db.close();
            }
            if (mHelper != null) {
                mHelper.close();
            }
            mInstance = null;
        } catch (Exception e) {
            LogUtils.ELog(e);
        }
    }
}
