package com.xdja.poc.sdk.record;

import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.sdk.record.fdfs.FdfsService;
import com.xdja.poc.sdk.record.fdfs.IFdfsService;
import com.xdja.poc.sdk.record.fdfs.ThreadPoolManager;

/**
 * 上传录音文件
 * Created by xdjaxa on 2019/1/7.
 */

@SuppressWarnings("JavaDoc")
public class UploadRecordHelper {

    private static final String TAG = UploadRecordHelper.class.getSimpleName();
    private IFdfsService fdfsService;
    private long uploadId;
    private String waitUploadUri;
    private UploadRecordCallBack uploadRecordCallBack;

    private UploadRecordHelper() {
    }

    private static final UploadRecordHelper instance = new UploadRecordHelper();

    public static UploadRecordHelper getInstance() {
        ThreadPoolManager.getInstance().init();
        return instance;
    }

    /**
     * 开始上传录音文件
     *
     * @param recordUri
     */
    public void startUploadRecord(String recordUri) {
        this.waitUploadUri = recordUri;
        if (fdfsService == null) {
            FdfsService fdfsService = new FdfsService();
            fdfsService.onCreate();
            this.fdfsService = (IFdfsService) fdfsService.getBinder();
        }
        if (fdfsService == null) {
            return;
        }
        uploadId = 1000L;
        LogUtils.ELog(TAG, Thread.currentThread().getName());
        fdfsService.upload(uploadId, recordUri, null, new FdfsService.UploadCallback() {
            @Override
            public void onProgress(long uploadId, long uploadSize, long totalSize) {
                LogUtils.DLog(TAG, "上传录音onProgress: " + uploadId + "-" + uploadSize + "-" + totalSize);
            }

            @Override
            public void onSuccess(long uploadId, String fileId) {
                LogUtils.DLog(TAG, "上传录音onSuccess: " + uploadId + "-" + fileId);
                if (uploadRecordCallBack != null) {
                    uploadRecordCallBack.onUploadRecordSuccess(fileId, waitUploadUri);
                }
            }

            @Override
            public void onError(long uploadId, int errorCode) {
                LogUtils.DLog(TAG, "上传录音onError: " + uploadId + "-" + errorCode);
                if (uploadRecordCallBack != null) {
                    uploadRecordCallBack.onUploadRecordFailed(errorCode, waitUploadUri);
                }
            }
        });
    }

    /**
     * 停止上传录音文件
     */
    public void stopUploadRecord() {
        if (fdfsService != null) {
            fdfsService.stopUpload(uploadId);
            fdfsService = null;
        }
        ThreadPoolManager.getInstance().shutDown();
        waitUploadUri = null;
    }

    public void setUploadRecordCallBack(UploadRecordCallBack uploadRecordCallBack) {
        this.uploadRecordCallBack = uploadRecordCallBack;
    }

    /**
     * 上传回调接口
     */
    public interface UploadRecordCallBack {

        void onUploadRecordSuccess(String fileId, String fileUri);

        void onUploadRecordFailed(int errorCode, String fileUri);
    }
}
