package com.xdja.poc.sdk.ui.main.fragment;

import android.Manifest;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.support.v4.app.FragmentActivity;
import android.support.v7.widget.LinearLayoutManager;
import android.text.Html;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.jude.easyrecyclerview.EasyRecyclerView;
import com.jude.easyrecyclerview.adapter.BaseViewHolder;
import com.jude.easyrecyclerview.adapter.RecyclerArrayAdapter;
import com.jude.easyrecyclerview.decoration.DividerDecoration;
import com.xdja.poc.common.base.BaseFragment;
import com.xdja.poc.common.event.NetWorkConnectEvent;
import com.xdja.poc.common.utils.DisplayUtil;
import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.common.utils.GlobalContext;
import com.xdja.poc.common.utils.NetUtils;
import com.xdja.poc.common.utils.PinyinUtil;
import com.xdja.poc.common.utils.PreferenceHelper;
import com.xdja.poc.common.utils.StringUtils;
import com.xdja.poc.common.utils.ToastUtils;
import com.xdja.poc.common.view.ISearchCallBack;
import com.xdja.poc.common.view.SearchEditView;
import com.xdja.poc.common.view.WarningDialog;
import com.xdja.poc.sdk.POCClient;
import com.xdja.poc.sdk.R;
import com.xdja.poc.sdk.bean.POCMemberInfo;
import com.xdja.poc.sdk.business.EventPropxy;
import com.xdja.poc.sdk.business.PocBroadReceiver;
import com.xdja.poc.sdk.config.Constants;
import com.xdja.poc.sdk.config.GroupConfig;
import com.xdja.poc.sdk.config.UserConfig;
import com.xdja.poc.sdk.db.entity.DBGroupEntity;
import com.xdja.poc.sdk.event.ChannelIsExistEvent;
import com.xdja.poc.sdk.event.DimissDialogEvent;
import com.xdja.poc.sdk.event.GroupEvent;
import com.xdja.poc.sdk.event.GroupMemberAddEvent;
import com.xdja.poc.sdk.event.POCCallEvent;
import com.xdja.poc.sdk.event.POCChannelInfoResult;
import com.xdja.poc.sdk.event.POCConverationTbcpStatusEvent;
import com.xdja.poc.sdk.event.POCConversationMeIncomeRoom;
import com.xdja.poc.sdk.event.POCConversationUserChangeEvent;
import com.xdja.poc.sdk.event.POCMemberEvent;
import com.xdja.poc.sdk.event.POCMuteEvent;
import com.xdja.poc.sdk.event.POCSelfLeaveEvent;
import com.xdja.poc.sdk.event.UpdateMemberInfoEvent;
import com.xdja.poc.sdk.event.UpdateUserInfoEvent;
import com.xdja.poc.sdk.manager.AMnager;
import com.xdja.poc.sdk.proxy.IPOCAbstractRoomEventCallBack;
import com.xdja.poc.sdk.proxy.IPOCRecordCallBack;
import com.xdja.poc.sdk.proxy.POCUiKitProxyImpl;
import com.xdja.poc.sdk.ui.conversion.POCConversionActivity;
import com.xdja.poc.sdk.ui.conversion.audioview.AudioEffectPresenter;
import com.xdja.poc.sdk.ui.dialog.ChannelDeletedTipDialog;
import com.xdja.poc.sdk.ui.history.POCHistoryMessageActivity;
import com.xdja.poc.sdk.ui.main.holder.PocConversationSearchHolder;
import com.xdja.poc.sdk.ui.main.holder.PocMemberInfoListHolder;
import com.xdja.poc.sdk.ui.main.mvp.POCConversationContract.IPOCConversationView;
import com.xdja.poc.sdk.ui.main.mvp.POCConversationPersenter;
import com.xdja.poc.sdk.ui.main.mvp.POCGroupListPresenter;
import com.xdja.poc.sdk.utils.GlideUtils;
import com.xdja.poc.sdk.utils.GroupUtils;
import com.xdja.poc.sdk.utils.Utils;

import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/**
 * Created by zhangsen on 2018/9/28.
 */

@SuppressWarnings("ALL")
public class POCConversationFragment extends BaseFragment implements View.OnClickListener, IPOCConversationView {
    private String TAG = "POCConversationFragment";
    private Context mContext;
    private FragmentActivity activity;
    private String roomId;
    private String mUserId;
    private TextView mTvTalkStatus;
    private TextView mTvPeopleCount;
    private TextView mTvShowPeople;
    private TextView tvSpeanBtnStatus;// mTvPressOrUnpress,mImgMicrophone,mImgSingleCircle;
    private ImageView mImgHungUp, mImgCancelPhone, mImgAnswerPhone, mImgMute, mImgServeralCircle;
    private LinearLayout llAddMembers;
    private EasyRecyclerView mRecycleView;
    private ImageView ivForceInsert;
    private SearchEditView mSearchView;
    private View mConsAnswerOrHungupPhone, mFramePressTalk;
    private ImageView mRelTalkOrEnd;
    private DBGroupEntity group;
    private RecyclerArrayAdapter<POCMemberInfo> mMemberInfoAdapter;
    private RecyclerArrayAdapter<POCMemberInfo> mSearchAdapter;
    private PocConversationSearchHolder mSearchHolder;
    private PocMemberInfoListHolder mMemberHolder;
    private POCConversationPersenter mPocPresenter;
    private IUpdateGroupListener mListener;
    private Map<String, POCMemberInfo> userInfosCache = new HashMap<>();
    private ChannelDeletedTipDialog roomDestroyDialog;
    private boolean isDialogShowing = false;
    private boolean isForceInsert = false;
    private boolean isOwner = false;
    private boolean isSelfSpeaking = false;
    private boolean isExecuteReleaseTbcp = true;
    private boolean isOnPause = false;
    private AudioEffectPresenter audioEffectPresenter;
    private LinearLayout llAudioAnim;
    private ImageView ivAudioEffect;
    private TextView tvDelayTime;
    private final int DELAY_MAX_INTERVAL = 60;
    private int currentDelayInterval = DELAY_MAX_INTERVAL;

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        Bundle arguments = getArguments();
        group = (DBGroupEntity) arguments.getSerializable("DBGroupEntity");
        mContext = context;
        activity = getActivity();
    }

    @Override
    protected void initView() {
        mUserId = PreferenceHelper.getString(UserConfig.LOGIN_ACCOUNT, "");
        mTvTalkStatus = $(R.id.text_talk_status);
        mTvPeopleCount = $(R.id.text_people_count);
        mTvShowPeople = $(R.id.tv_show_people);
        TextView tvForceInsert = $(R.id.tv_poc_force_insert);
        llAudioAnim = $(R.id.ll_audio_anim);
        ivAudioEffect = $(R.id.wait_result_imageview);
        mImgHungUp = $(R.id.img_hungup);
        mSearchView = $(R.id.search_edit_view);
        mRecycleView = $(R.id.recycleView_member);
        mRelTalkOrEnd = $(R.id.img_microphone);
        mImgServeralCircle = $(R.id.img_several_circle);
        mConsAnswerOrHungupPhone = $(R.id.cons_answer_or_hungup_phone);
        mFramePressTalk = $(R.id.rel_talk_and_back_and_mute);
        mImgCancelPhone = $(R.id.img_hungup_phone);
        mImgAnswerPhone = $(R.id.img_answer_phone);
        llAddMembers = $(R.id.ll_add_members);
        ivForceInsert = $(R.id.iv_force_insert);
        tvSpeanBtnStatus = $(R.id.tv_speak_btn_status);
        ImageView ivHistoryAudio = $(R.id.iv_audio_history);
        mImgMute = $(R.id.img_mute);
        tvDelayTime = $(R.id.tv_delay_time);
        mSearchView.setSHintText(getString(R.string.poc_conversation_input_member_name));
        tvForceInsert.setText("是否\n强插");
        mRecycleView.setLayoutManager(new LinearLayoutManager(mContext));
        DividerDecoration decoration = new DividerDecoration(getResources().getColor(R.color.common_item_divider_bg), 1, 0, 0);
        decoration.setDrawLastItem(true);
        mRecycleView.addItemDecoration(decoration);
        mRecycleView.getRecyclerView().setOverScrollMode(View.OVER_SCROLL_NEVER);
//        mPocPresenter = new POCConversationPersenter(this, mContext, group);
        initRecycleView();
        initData(group);
        if (PreferenceHelper.getBoolean(UserConfig.POC_IS_SHOW_HISTORY_RECORD_ENTER, true)) {
            ivHistoryAudio.setVisibility(View.VISIBLE);
            ivHistoryAudio.setOnClickListener(this);
        }
    }

    private void initRecycleView() {
        mSearchAdapter = new RecyclerArrayAdapter<POCMemberInfo>(mContext) {
            @Override
            public BaseViewHolder OnCreateViewHolder(ViewGroup parent, int viewType) {
                mSearchHolder = new PocConversationSearchHolder(parent, new PocConversationSearchHolder.IHolderClickLinstener() {
                    @Override
                    public void OnClick(int id, int position) {
                        if (id == R.id.img_is_select) {
                            mPocPresenter.setSelectMemeber(mSearchAdapter, position);
                        } else if (id == R.id.img_head_icon) {
                            if (position == -1) {
                                return;
                            }
                            POCUiKitProxyImpl.getInstance().notigyUserDetailsClick(getActivity(), mSearchAdapter.getAllData().get(position));
                        }
                    }
                });
                return mSearchHolder;
            }
        };
        mSearchView.addTextChangeWatcher(new ISearchCallBack() {
            @Override
            public void onStartSearch(String keyWords) {
                mPocPresenter.doSearch(keyWords, mMemberInfoAdapter.getAllData());
            }

            @Override
            public void onEndSearch() {
                mRecycleView.setEmptyView(R.layout.poc_group_list_empty);
                mRecycleView.setAdapter(mMemberInfoAdapter);
                mMemberInfoAdapter.notifyDataSetChanged();
            }
        });
        mMemberInfoAdapter = new RecyclerArrayAdapter<POCMemberInfo>(mContext) {
            @Override
            public BaseViewHolder OnCreateViewHolder(ViewGroup parent, int viewType) {
                mMemberHolder = new PocMemberInfoListHolder(parent, new PocMemberInfoListHolder.IHolderClickLinstener() {
                    @Override
                    public void OnClick(int id, int position) {
                        if (id == R.id.img_is_select) {
                            mPocPresenter.setSelectMemeber(mMemberInfoAdapter, position);
                        } else if (id == R.id.img_head_icon) {
                            if (position == -1) {
                                LogUtils.ELog(TAG, "click header position=-1");
                                return;
                            }
                            POCUiKitProxyImpl.getInstance().notigyUserDetailsClick(getActivity(), mMemberInfoAdapter.getAllData().get(position));
                        }

                    }
                });
                return mMemberHolder;
            }
        };
        mRecycleView.setAdapter(mMemberInfoAdapter);

    }

    public void initData(DBGroupEntity group) {
        this.group = group;
        //如果最大房间数为1则离开所有房间
        if (PreferenceHelper.getInt(UserConfig.MAX_CHANNEL_COUNT, -1) <= 1) {
            POCClient.getInstance().leaveAllRoom(this.group.getRooomId());
        }
        try {
            Map<String, String> allSpeakers = POCClient.getAllSpeakers();
            if (allSpeakers != null && allSpeakers.size() > 0) {
                for (String roomId : allSpeakers.keySet()) {
                    if (!roomId.equals(group.getRooomId())) {
                        String s = allSpeakers.get(roomId);
                        if (s.equals(mUserId)) {
                            POCClient.releaseTBCP(roomId);
                        }
                    }
                }
            }
        } catch (Exception e) {
            LogUtils.ELog(e);
        }

        if (group != null) {
            isOwner = group.getOwnerId().equals(mUserId);
        }
        if (mPocPresenter != null) {
            mPocPresenter = null;
        }
        userInfosCache = POCUiKitProxyImpl.getInstance().getUserInfosCache();
        llAddMembers.setVisibility(group.isFixedGroup() ? View.GONE : View.VISIBLE);
        mPocPresenter = new POCConversationPersenter(this, mContext, group, userInfosCache);
        checkPermision(Manifest.permission.RECORD_AUDIO);
        PocBroadReceiver.registerPushReceiver(getActivity());
    }

    private void recoverData(boolean isCreate) {
        if (group != null) {
            mPocPresenter.setAdapterData();
            mImgMute.setSelected(group.getIsSilence());
            if (group.isFixedGroup()){
                ivForceInsert.setImageResource(R.drawable.poc_insert_un);
            }else {
                if (group.getOwnerId().equals(mUserId)) {
                    ivForceInsert.setImageResource(R.drawable.poc_bg_insert_selector);
                } else {
                    ivForceInsert.setImageResource(R.drawable.poc_insert_un);
                }
            }
            if (group.getStatus() == GroupConfig.GROUP_HANGUP) {
//                if (!NetUtils.isConnectedByState(mContext)) {
//                    onNetChanged(false);
//                    LogUtils.ELog(TAG, "network is disconnect");
//                    return;
//                }
                canTalk(false);
                mPocPresenter.handleTimeOut(roomId);
                if (isCreate) {
                    mTvTalkStatus.setText(getString(R.string.poc_conversation_on_connection));
                    //add by cga 已被移除出此房间，直接提醒被移除
                    if (POCClient.getInstance().wasRemoved(group.getRooomId())){
                        if (isOnPause) {
                            getActivity().finish();
                        }
                        POCConversationFragment.this.showWarningDialog(group.getRooomId(), getString(R.string.poc_force_remove_from_channel));
                        return;
                    }
                    //end
                    LogUtils.DLog(TAG, "recoverData isCreate is true,connction");
                    POCClient.createRoom(Long.valueOf(roomId), Constants.SECRET, Constants.PIN, mUserId, PreferenceHelper.getString(UserConfig.LOGIN_ACCOUNT, ""), group.getRoomName(), false, false);
                } else {
                    LogUtils.ELog(TAG, "isCreate is false,is no need reconnect from view");
                }
            } else if (group.getStatus() == GroupConfig.GROUP_BUSY) {
                canTalk(false);
                boolean isMute = group.getIsSilence();
                setMute(isMute, false);
//                if (!TextUtils.isEmpty(group.getSpeakerUserName()) && group.getSpeakerUserName().contains("其他设备")) {
//                    setTalkStatus("您正在其他设备讲话");
//                } else {
//                    showSpeakStatus(null, StringUtils.splitDisplayName(6, group.getSpeakerUserName()));
//                }
                initForceInsertStatus();
                if (POCGroupListPresenter.selfSpeakRoomInfo != null && POCGroupListPresenter.selfSpeakRoomInfo.containsKey(roomId)) {
                    resetSpeakView(false);
                }

            } else {
                canTalk(true);
                boolean isMute = group.getIsSilence();
                setMute(isMute, false);
                mTvTalkStatus.setText(getString(R.string.poc_conversation_talk_status_free));
                initForceInsertStatus();
            }
        } else {
            mPocPresenter.handleTimeOut(roomId);
            LogUtils.ELog(TAG, "recoverData: group is null");
        }

    }

    /**
     * 初始化强插view及属性
     */
    private void initForceInsertStatus() {
        boolean roomForceInsertStatus = POCClient.getRoomForceInsertStatus(roomId);
        if (isOwner && roomForceInsertStatus) {
            isForceInsert = true;
            ivForceInsert.setSelected(true);
            mRelTalkOrEnd.setBackground(GlobalContext.getContext().getDrawable(R.drawable.poc_conversation_press_talk_or_end_selector));
            mRelTalkOrEnd.setEnabled(true);
            tvSpeanBtnStatus.setText(R.string.poc_start_speak);
        }
    }

    @Override
    public void showSpeakStatus(String speakerId, String speakerName, int userBehavior) {
        if (speakerId != null) {
            if (speakerId.equals(mUserId)) {
                speakerName = "您";
            }
        }
        setTalkStatus(String.format(GlobalContext.getContext().getString(R.string.poc_conversation_talk_status_busy), speakerName));
        // modify bug55536,多端登录，非讲话端不显示语音讲话倒计时。
        if (userBehavior == PocBroadReceiver.ROOM_OTHER_REQUEST_TBCP_SUCCESS) {
            // 用户行为是“他人获取到tbcp”，隐藏语音讲话倒计时。
            switchShowAudioEffect(false);
        }
    }

    @Override
    public void resetReleaseStatus(boolean isReleaseTbcp) {
        isExecuteReleaseTbcp = isReleaseTbcp;
        if (isReleaseTbcp) {
            handler.removeCallbacks(null);
            handler.removeMessages(1);
        }
    }

    @SuppressLint("ClickableViewAccessibility")
    @Override
    protected void initEvent() {
        mImgHungUp.setOnClickListener(this);
        mImgMute.setOnClickListener(this);
        llAddMembers.setOnClickListener(this);
        ivForceInsert.setOnClickListener(this);
        $(R.id.img_back).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                activity.onBackPressed();
            }
        });
        mRelTalkOrEnd.setOnTouchListener(new View.OnTouchListener() {
            boolean isRelease = true;

            @SuppressLint("ClickableViewAccessibility")
            @Override
            public boolean onTouch(View v, MotionEvent event) {
                if (event.getAction() == MotionEvent.ACTION_DOWN) {
//                    if (!POCUiKitProxyImpl.getInstance().isCanTalk()) {
//                        String desc = PreferenceHelper.getString(UserConfig.TOAST_TALKING_DESC, "音频被占用");
//                        ToastUtils.showToast(desc);
//                        return false;
//                    }
//                    LogUtils.DLog("[POC_LOG]", "zlq MotionEvent.ACTION_DOWN");
//                    return mPocPresenter.requestTbcp(isForceInsert);
//                    if (getActivity().getPackageName().contains("zfy")) {
//                        if (POCClient.getInstance().isSelfSpeaking(mUserId, group.getRooomId())) {
////                            String tips = PreferenceHelper.getString(UserConfig.POC_SELF_SPEAKING_TIPS, getString(R.string.poc_current_self_speaking));
////                            ToastUtils.showToast(tips);
//                            return false;
//                        }
//                    }
                    if (!POCUiKitProxyImpl.getInstance().isCanTalk()) {
                        String desc = PreferenceHelper.getString(UserConfig.TOAST_TALKING_DESC, getString(R.string.poc_audio_focus_busy));
                        ToastUtils.showToast(desc);
                        return false;
                    }
                    isRelease = false;
                    return takeTbcp();
                } else if (event.getAction() == MotionEvent.ACTION_UP ||
                            event.getAction() == MotionEvent.ACTION_CANCEL ||
                            event.getAction() == MotionEvent.ACTION_OUTSIDE) {
                    isRelease = true;
                    return releaseTbcp();
                }else if (event.getAction() == MotionEvent.ACTION_MOVE){
                    if (event.getX() < -30 || event.getX() -30 > v.getWidth() ||
                        event.getY() < -30 || event.getY() -30 > v.getHeight()){
                        //滑动超出边界 -30是为了容错
                        if (!isRelease){
                            isRelease = true;
                            return releaseTbcp();
                        }
                    }
                }
                return false;
            }
        });
        mImgCancelPhone.setOnClickListener(this);
        mImgAnswerPhone.setOnClickListener(this);
        mMemberInfoAdapter.setOnItemLongClickListener(new RecyclerArrayAdapter.OnItemLongClickListener() {
            @Override
            public boolean onItemLongClick(int position) {
                POCUiKitProxyImpl.getInstance().notifyChannelDetailsItemLongClick(getActivity(), mMemberInfoAdapter.getAllData().get(position), group.getOwnerId());
                return true;
            }
        });
        POCUiKitProxyImpl.getInstance().addRoomEventCallBack(roomEventCallBack);
        POCClient.registerRecordCallBack(recordCallBack);
    }

    private void switchShowAudioEffect(boolean status) {
        if (status) {
            // bug59512：正在讲话中，其它成员进入，对讲倒计时重新开始
            // 修改策略：已经在讲话中，忽略此次刷新
            if (audioEffectPresenter != null && audioEffectPresenter.isRunning()) {
                return;
            }
            tvDelayTime.setText(getString(R.string.poc_tv_delay_time, currentDelayInterval));
            resetParams();
            handler.sendEmptyMessageDelayed(DELAY_MAX_INTERVAL, 1000);
            tvDelayTime.setText(getResources().getString(R.string.poc_tv_delay_time, DELAY_MAX_INTERVAL));
            llAudioAnim.setVisibility(View.VISIBLE);
            assert audioEffectPresenter != null;
            audioEffectPresenter.start();
        } else {
            resetParams();
            llAudioAnim.setVisibility(View.GONE);
            if (audioEffectPresenter == null)return;
            assert audioEffectPresenter != null;
            audioEffectPresenter.stop();
        }
    }

    public boolean takeTbcp() {
        if (!mRelTalkOrEnd.isEnabled()) {
            LogUtils.DLog("[POC_LOG]", "mRelTalkOrEnd unEnable");
            return false;
        }
//        if (!POCClient.isSpeaking(roomId, mUserId)) {
//            return false;
//        }
        LogUtils.DLog("[POC_LOG]", "zlq MotionEvent.ACTION_DOWN");
        return mPocPresenter.requestTbcp(isForceInsert);
    }

    public boolean releaseTbcp() {
        LogUtils.DLog("[POC_LOG]", "zlq MotionEvent.ACTION_UP");
        mPocPresenter.releaseTalkAnimate(mImgServeralCircle);
        EventPropxy.postResetChannelStatus(group.getRooomId());
        if (GroupUtils.isSelfSpeakButOnlyLisener(group.getRooomId())) {
            return false;
        }
        if (POCClient.getAllSpeakers() != null && POCClient.getAllSpeakers().containsKey(roomId) &&
                !isSelfSpeaking) {
            mPocPresenter.setLastCode();
            LogUtils.DLog(TAG, "releaseTbcp current speak is not self");
            handler.removeCallbacks(null);
            handler.removeMessages(1);
            isExecuteReleaseTbcp = false;
            mPocPresenter.bNeedReleaseTBCP = true;
            handler.sendEmptyMessageDelayed(1, 500);
            return false;
        }
        handler.sendEmptyMessageDelayed(1, 1000);
        return mPocPresenter.releaseTbcp();
    }

    @Override
    protected int generateLayout() {
        return R.layout.poc_conversation_fragment;
    }

    @Override
    public void onClick(View v) {
        int i = v.getId();
        if (i == R.id.img_hungup) {
            WarningDialog warningDialog = new WarningDialog();
            warningDialog.showWarningDialog(mContext, R.string.poc_conversation_is_hung_up, new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    warningDialog.dismissDialog();
                }
            }, new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    warningDialog.dismissDialog();
                    POCClient.leaveRoom(PreferenceHelper.getString(UserConfig.LOGIN_ACCOUNT, ""), group.getRooomId());
                    POCClient.removeFromReconnectCache(group.getRooomId());
                    getActivity().finish();
                }
            });

        } else if (i == R.id.img_answer_phone) {
            //创建频道,拉人
            mPocPresenter.startNewConversionActivity();
        } else if (i == R.id.img_hungup_phone) {
            mPocPresenter.resetAdapter(mMemberInfoAdapter);
            mPocPresenter.resetAdapter(mSearchAdapter);
            mConsAnswerOrHungupPhone.setVisibility(View.GONE);
            mFramePressTalk.setVisibility(View.VISIBLE);

        } else if (i == R.id.img_mute) {
            if (!Utils.isFastClick(500)) return;
            boolean isMute = group.getIsSilence();
            setMute(!isMute, true);
        } else if (i == R.id.ll_add_members) {
            POCUiKitProxyImpl.getInstance().notifyConversionAddMembers(group);
        } else if (i == R.id.iv_force_insert) {
            boolean netAvailable = NetUtils.isNetworkAvailable(getActivity());
            if (!netAvailable){
                ToastUtils.showToast(getString(R.string.poc_conversation_network_not_available));
                return;
            }
            //add by cga:固定频道不可以强插
            if (group.getOwnerId().equals(mUserId) && !group.isFixedGroup()) {
//                    if(!isSelfSpeaking){
                isForceInsert = !isForceInsert;
                ivForceInsert.setSelected(isForceInsert);
                POCClient.updateForceInsert(group.getRooomId(), isForceInsert);
                canTalk(true);
                if (isSelfSpeaking && !isForceInsert) {
                    resetSpeakView(false);
                }
            } else {
                ToastUtils.showToast(getString(R.string.poc_permission_tips));
            }

        } else if (i == R.id.iv_audio_history) {
            POCHistoryMessageActivity.startPOCHistoryMessageActivity(getActivity(), group);
        }
    }

    @Override
    public void setTalkStatus(String status) {
//        if(GroupUtils.isSelfSpeakButOnlyLisener(group.getRooomId())){
//            status = "您正在其他设备讲话";
//            isExecuteReleaseTbcp = true;
//        }
        mTvTalkStatus.setText(status);
        if (status.equals(String.format(GlobalContext.getContext().getString(R.string.poc_conversation_talk_status_busy), "您"))) {
            isSelfSpeaking = true;
            if (!isExecuteReleaseTbcp) {
                isExecuteReleaseTbcp = true;
                resetStatus();
                mTvTalkStatus.setText(GlobalContext.getContext().getString(R.string.poc_conversation_talk_status_free));
                POCClient.releaseTBCP(roomId);
                switchShowAudioEffect(false);
                handler.sendEmptyMessageDelayed(1, 500);
                switchShowAudioEffect(false);
            } else {
                switchShowAudioEffect(true);
            }
        } else {
            isSelfSpeaking = false;
            switchShowAudioEffect(false);
        }
//        setOnLineCount(0,mMemberInfoAdapter.getAllData().size());
    }

    @Override
    public void roomOtherRequestTbcpSuccess(String talkUserid) {
        mPocPresenter.releaseTalkAnimate(mImgServeralCircle);
        isExecuteReleaseTbcp = true;
        canTalk(false);
        boolean isReset = false;
        for (POCMemberInfo info : mMemberInfoAdapter.getAllData()) {
            if (info.getAccount().equals(mUserId)) {
                // TODO: 2019/1/23 做了修改，去掉了if条件
//                if (!info.isOnLine()) {
                info.setOnLine(true);
//                }
            }
            if (info.getAccount().equals(talkUserid)) {
                if (!info.isOnLine()) {
                    isReset = true;
                    info.setOnLine(true);
                    break;
                }
            }
        }
        if (isReset) {
            List<String> onLineMemberList = POCClient.getOnLineMemberList(Long.valueOf(group.getRooomId()));
            if (onLineMemberList != null) {
                setOnLineCount(onLineMemberList.size(), mMemberInfoAdapter.getAllData().size());
            }
            mPocPresenter.sortAdapter(mMemberInfoAdapter);
        }
    }

    @Override
    public void roomOtherReleaseTbcpSuccess() {
        mRelTalkOrEnd.setPressed(false);
        mPocPresenter.releaseTalkAnimate(mImgServeralCircle);
        isExecuteReleaseTbcp = false;
        canTalk(true);
    }

    @Override
    public void roomSelfRequestTbcpSuccess(String talkUserid) {
        mRelTalkOrEnd.setPressed(true);
        mRelTalkOrEnd.setEnabled(true);
        mPocPresenter.startTalkAnimate(mImgServeralCircle);
    }

    @Override
    public void roomSelfReleaseTbcpSuccess() {
        mRelTalkOrEnd.setPressed(false);
        mPocPresenter.releaseTalkAnimate(mImgServeralCircle);
        resetButton();
    }

    @Override
    public void roomSelfRequestTbcpFailed() {
        mRelTalkOrEnd.setPressed(false);
    }

    @Override
    public void roomSelfReleaseTbcpFailed() {
        mRelTalkOrEnd.setPressed(false);
        mPocPresenter.releaseTalkAnimate(mImgServeralCircle);
        resetButton();
    }

    @Override
    public void setOnlineNumerCount(String str) {
//        mTvPeopleCount.setText(str);
        mTvPeopleCount.setVisibility(View.GONE);
    }

    @Override
    public void setOnLineCount(int onLineCount, int totalCount) {
        if (onLineCount > totalCount) {
            onLineCount = totalCount;
        }
        boolean isSelfOnLine = false;
        for (POCMemberInfo memberInfo : mMemberInfoAdapter.getAllData()) {
            if (memberInfo.getAccount().equals(mUserId)) {
                if (memberInfo.isOnLine()) {
                    isSelfOnLine = true;
                    break;
                }
            }
        }
        if (onLineCount == 0 && isSelfOnLine) {
            onLineCount = 1;
        }
        String memberStatus = "<font color='#808080'>" + "参与人数" + "</font> " + "<font color='#00bae1'>" + onLineCount + "</font> / " + "<font color='#808080'>" + totalCount + "</font>";
        mTvShowPeople.setText(Html.fromHtml(memberStatus));
    }

    @Override
    public void setAdapterData(List<POCMemberInfo> infos) {
        mMemberInfoAdapter.clear();
        mMemberInfoAdapter.addAll(infos);
        mMemberInfoAdapter.notifyDataSetChanged();
    }

    @Override
    public void subscribeSelfEnterRoom() {
//        int pocision = -1;
        for (POCMemberInfo info : mMemberInfoAdapter.getAllData()) {
            if (info.getAccount().equals(mUserId)) {
//                pocision = mMemberInfoAdapter.getPosition(info);
                info.setOnLine(true);
                break;
            }
        }
//        if (pocision != -1)
        mMemberInfoAdapter.notifyDataSetChanged();
        setOnLineCount(1, mMemberInfoAdapter.getAllData().size());
        canTalk(true);
        mPocPresenter.cancelConnectTimeOut();
    }

    @Override
    public void updateOnLineMember() {
        mPocPresenter.sortAdapter(mMemberInfoAdapter);
        setStatus();
        Map<String, String> allSpeakers = POCClient.getAllSpeakers();
        if (allSpeakers != null && allSpeakers.containsKey(group.getRooomId())) {
            String speakId = allSpeakers.get(group.getRooomId());
            String speakName = mPocPresenter.generateUserName(speakId);
            showSpeakStatus(speakId, speakName, -1);
//            if (group.getIsSilence() && !isInitMute) {
//                isInitMute = true;
//                setMute(true, false);
//            }
        }
    }

    @Override
    public void setSelectMember(List<POCMemberInfo> selectMember) {
        if (selectMember.size() > 0) {
            mConsAnswerOrHungupPhone.setVisibility(View.VISIBLE);
            mFramePressTalk.setVisibility(View.INVISIBLE);
        } else {
            mConsAnswerOrHungupPhone.setVisibility(View.GONE);
            mFramePressTalk.setVisibility(View.VISIBLE);
        }
    }

    @Override
    public void getSearchResult(List<POCMemberInfo> pocGroups) {
        if (pocGroups == null || pocGroups.size() <= 0) {
            mRecycleView.setEmptyView(R.layout.poc_search_no_result);
            mRecycleView.showEmpty();
        } else {
            mRecycleView.setAdapter(mSearchAdapter);
            mSearchAdapter.clear();
            mSearchAdapter.addAll(pocGroups);
        }
    }

    @Override
    public void subscribeSelfLeaveEvent() {
        canTalk(false);
        for (POCMemberInfo memberInfo : mMemberInfoAdapter.getAllData()) {
            memberInfo.setOnLine(false);
        }
        mMemberInfoAdapter.notifyDataSetChanged();
    }

    @Override
    public void startNewConversionActivity(ArrayList<POCMemberInfo> mSelectedMemberList) {
        if (mConsAnswerOrHungupPhone.getVisibility() == View.VISIBLE) {
            mConsAnswerOrHungupPhone.setVisibility(View.GONE);
            mFramePressTalk.setVisibility(View.VISIBLE);
            if (!TextUtils.isEmpty(mSearchView.getEditText().getText().toString())) {
                mSearchView.clear();
            }
        }

    }

    @Override
    public void onMyPause() {
        mPocPresenter.releaseTalkAnimate(mImgServeralCircle);
    }

    @Override
    public void subscribeUserChange() {
        canTalk(true);
    }

    @Override
    public void searchNotifyMemberAdapterToUpdate(RecyclerArrayAdapter<POCMemberInfo> mAdapter, POCMemberInfo pocMemberInfo, boolean isChecked) {
        serachNotifyMemberAdapter(mAdapter, pocMemberInfo, isChecked);
    }

//    @Override
//    public void onCallDelayToast() {
//        if (isAdded()) {
//            List<POCMemberInfo> allData = mMemberInfoAdapter.getAllData();
//            if (allData != null && allData.size() > 0) {
//                String lastUser = "";
//                for (POCMemberInfo memberInfo : allData) {
//                    if (!memberInfo.isOnLine() && memberInfo.getCallTipsStatus() == 0) {
//                        lastUser = memberInfo.getName();
//                    }
//                }
//                if (!StringUtils.isEmpty(lastUser)) {
//                    ToastUtils.showToast(lastUser + getString(R.string.poc_user_busy));
//                }
//            }
//        }
//
//    }

    @Override
    public void onChangeCallTipStatus(String mRoomId, String userId) {
        for (POCMemberInfo memberInfo : mMemberInfoAdapter.getAllData()) {
            if (this.roomId.equals(mRoomId)) {
                if (userId.equals(memberInfo.getAccount())) {
                    memberInfo.setCallTipsStatus(1);
                    break;
                }
            }
        }
        mMemberInfoAdapter.notifyDataSetChanged();
    }

    @Override
    public void updateMute(DBGroupEntity entity) {
//        if (entity != null) {
//            boolean isMute = group.getIsSilence();
//            setMute(isMute, false);
//        }
    }

    @Override
    public void finish() {
        getActivity().finish();
    }

    @Override
    public void setPttKey(boolean pttStatus) {
        if (group != null)
            group.setIsPttKey(pttStatus ? 1 : 0);
        if (mListener != null)
            mListener.onPttKey(pttStatus);
    }

    @Override
    public void setRoomName(String channelName) {
        if (group != null)
            group.setRoomName(channelName);
        if (mListener != null)
            mListener.onUpdateName(channelName);
    }

    @Override
    public void setChannelPwd(String channelPwd) {
        if (group != null)
            group.setChannelPwd(channelPwd);
        if (mListener != null)
            mListener.onUpdatePwd(channelPwd);
    }

    @Override
    public void setChannelPwdMode(boolean channelPwdMode) {
        if (group != null)
            group.setChannelPwdMode(channelPwdMode ? 1 : 0);
        if (mListener != null)
            mListener.onUpdatePwdMode(channelPwdMode);
    }

    @Override
    public Map<String, POCMemberInfo> getUserInfos() {
        return userInfosCache;
    }

    @Override
    public void removeFromCallList(String speakerId, String speakerName) {
        ((POCConversionActivity) getActivity()).removeFromCallList(speakerId, speakerName);
    }

    @Override
    public void leaveRoom(String speakerName) {
        //修改bug44942 在频道详情收到群主解散的推送消息，还有“XX已离开的toast提示”
        //修改策略：收到用户离开消息，拉取群组信息，拉取失败（群组不存在）不提示，否则提示用户已离开
//        if (!isDialogShowing){
//            ToastUtils.showToast(String.format(GlobalContext.getContext().getString(R.string.poc_conversation_who_has_leave_the_room), speakerName));
//        }
        isDialogShowing = false;
    }

    /**
     * 用户离开房间，用roomId查询频道信息接收事件
     *
     * @param event
     */
    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onCheckChannelNotExistEvent(ChannelIsExistEvent event) {
        //判断房间是否存在，存在则提示“XX用户已离开”
        if (event.isExist()) {
            ToastUtils.showToast(String.format(GlobalContext.getContext().getString(R.string.poc_conversation_who_has_leave_the_room), event.getSpeakName()));
        }
    }

    @Override
    public void onConnectTimeOut() {
        //first leave room.
        POCClient.leaveRoom(mUserId, group.getRooomId());
        if (isAdded()) {
            getActivity().runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    LogUtils.ELog(TAG, "onConnectTimeOut: 60sec is timeOut finished");
                    canTalk(false);
                    reconnectServer();
                    mPocPresenter.cancelConnectTimeOut();
                }
            });
        }
    }

    @Override
    public void resetButton() {
        mPocPresenter.releaseTalkAnimate(mImgServeralCircle);
        canTalk(true);
    }

    @Override
    protected void switchViewStatus(int status) {

    }

    /**
     * 真正可以讲话后的view操作
     *
     * @param enable
     */
    private void canTalk(boolean enable) {
        Map<String, String> speakIds = POCClient.getAllSpeakers();
        if (enable && speakIds != null && speakIds.containsKey(roomId) && !TextUtils.isEmpty(speakIds.get(roomId))) {
            enable = false;
        }
        resetSpeakView(enable);
        if (isOwner && isForceInsert) {
            mRelTalkOrEnd.setBackground(GlobalContext.getContext().getDrawable(R.drawable.poc_conversation_press_talk_or_end_selector));
            tvSpeanBtnStatus.setText(getString(R.string.poc_start_speak));
            mRelTalkOrEnd.setEnabled(true);
        }
        if (!isNetConnected) {
            resetSpeakView(false);
        }
    }

    private void resetSpeakView(boolean enable) {
        if (enable) {
            mRelTalkOrEnd.setBackground(GlobalContext.getContext().getDrawable(R.drawable.poc_conversation_press_talk_or_end_selector));
            mRelTalkOrEnd.setEnabled(true);
            tvSpeanBtnStatus.setText(R.string.poc_start_speak);
        } else {
            mRelTalkOrEnd.setEnabled(false);
            tvSpeanBtnStatus.setText(R.string.poc_speak_waiting);
            mRelTalkOrEnd.setBackground(GlobalContext.getContext().getDrawable(R.drawable.poc_conversation_press_talk_wait));
        }
    }
//
//    @Subscribe(threadMode = ThreadMode.MAIN)
//    public void onPOCCallDelayMessage(POCCallDelayMessage delayMessage) {
//        ToastUtils.showToast(delayMessage.getUserName() + "  在忙");
//    }

    private void serachNotifyMemberAdapter(RecyclerArrayAdapter<POCMemberInfo> mAdapter, POCMemberInfo pocMemberInfo, boolean isChecked) {
        if (mAdapter == mSearchAdapter) {
            List<POCMemberInfo> allData = mMemberInfoAdapter.getAllData();
            for (POCMemberInfo info : allData) {
                if (pocMemberInfo.getId().equals(info.getId())) {
                    int position = mAdapter.getPosition(info);
                    if (position != -1) {
                        allData.get(position).setChecked(isChecked);
                        mMemberInfoAdapter.notifyItemChanged(position);
                    }
                    break;
                }
            }
        }
    }

    private void setMute(boolean isMute, boolean showToast) {
        if (isMute) {
            if (showToast) {
                ToastUtils.showToast(getString(R.string.poc_conversation_is_mute));
            }
            POCClient.muteAndNotifyUI(Long.valueOf(roomId), true);
        } else {
            if (showToast) {
                ToastUtils.showToast(getString(R.string.poc_conversation_no_mute));
            }
            POCClient.muteAndNotifyUI(Long.valueOf(roomId), false);
        }
    }

    /**
     * @param netWorkConnectEvent true:连接 false 断开
     */
    @Override
    protected void onNetChanged(NetWorkConnectEvent netWorkConnectEvent) {

        super.onNetChanged(netWorkConnectEvent);
        if (isAdded()) {
            if (!((boolean) netWorkConnectEvent.getT())) {
                isForceInsert = false;
                POCClient.updateForceInsert(group.getRooomId(), isForceInsert);
                ivForceInsert.setSelected(isForceInsert);
                canTalk(false);
                mPocPresenter.releaseTalkAnimate(mImgServeralCircle);
                mTvTalkStatus.setText(getString(R.string.poc_conversation_network_interrupt));
                setOnLineCount(0, mMemberInfoAdapter.getAllData().size());
                for (POCMemberInfo memberInfo : mMemberInfoAdapter.getAllData()) {
                    memberInfo.setOnLine(false);
                }
                mMemberInfoAdapter.notifyDataSetChanged();
                if (mConsAnswerOrHungupPhone.getVisibility() == View.VISIBLE) {
                    mConsAnswerOrHungupPhone.setVisibility(View.GONE);
                    mFramePressTalk.setVisibility(View.VISIBLE);
                }
                group.setStatus(GroupConfig.GROUP_HANGUP);
                mPocPresenter.releaseTalkAnimate(mImgServeralCircle);
                switchShowAudioEffect(false);
            } else {
                mPocPresenter.netChanged();
                if (mConsAnswerOrHungupPhone.getVisibility() == View.VISIBLE) {
                    mConsAnswerOrHungupPhone.setVisibility(View.GONE);
                    mFramePressTalk.setVisibility(View.VISIBLE);
                }
//                recoverData(false);
            }
        }

    }

    public void dispatchTouchEvent(Activity activity, MotionEvent ev) {
        if (mSearchView.getEditText().hasFocus()) {
            mPocPresenter.hideSoftKeyboard(activity, ev);
        }
    }

    @Override
    public void onResume() {
        super.onResume();
        isOnPause = false;
        //POCClient.registerRoomEventCallBack(roomEventCallBack);
        if (!TextUtils.isEmpty(mSearchView.getEditText().getText().toString())) {
            mSearchView.clear();
        }
    }

    @Override
    public void onPause() {
        super.onPause();
        isOnPause = true;
        mPocPresenter.onMyPause();
    }

    @Override
    public void onDestroy() {
        if (audioEffectPresenter != null){
            audioEffectPresenter.release();
        }
        if (handler != null) {
            handler.removeCallbacks(null);
            handler.removeMessages(1);
        }
        super.onDestroy();
        POCUiKitProxyImpl.getInstance().removeRoomEventCallBack(roomEventCallBack);
        POCClient.unregisterRecordCallBack(recordCallBack);
        mPocPresenter.delayCancel(true);
        if (isSelfSpeaking && !Constants.isSelfRequestOnOtherDevice) {
            POCClient.releaseTBCP(group.getRooomId());
        }
    }

    public static POCConversationFragment newInstance() {
        return new POCConversationFragment();
    }

    private IPOCAbstractRoomEventCallBack roomEventCallBack = new IPOCAbstractRoomEventCallBack() {
        /**
         * 自己成功离开频道后的回调
         *
         * @param selfLeaveEvent
         */
        @Override
        public void onSelfLeaveRoomCallBack(POCSelfLeaveEvent selfLeaveEvent) {
            super.onSelfLeaveRoomCallBack(selfLeaveEvent);
            mPocPresenter.subscribeSelfLeaveEvent(selfLeaveEvent);
        }

        /**
         * 监听频道中其他用户是否申请到TBCP或释放TBCP
         */
        @Override
        public void onTBCPEventCallBack(POCConverationTbcpStatusEvent tbcpStatusEvent) {
            super.onTBCPEventCallBack(tbcpStatusEvent);
            mPocPresenter.subscribeRoomTbcpStatusChange(tbcpStatusEvent);
        }

        /**
         * 自己进入频道
         */
        @Override
        public void onMeIncomeRoomCallBack(POCConversationMeIncomeRoom meIncomeRoom) {
            super.onMeIncomeRoomCallBack(meIncomeRoom);
            mPocPresenter.subscribeSelfEnterRoom(meIncomeRoom);

        }

        /**
         * 用户进入或离开的回调
         */
        @Override
        public void onMemberEventCallBack(POCMemberEvent memberEvent) {
            super.onMemberEventCallBack(memberEvent);
            if (memberEvent.getRoomId().equals(group.getRooomId())) {
                LogUtils.DLog("POCListPresenter", "onMemberEventCallBack: " + memberEvent.getUserBehavior());
                if (memberEvent.getUserBehavior() == Constants.ROOM_SEVER_CONNECT_FAILED ||
                    memberEvent.getUserBehavior() == Constants.ROOM_SERVER_TOKEN_ERROR) {
                    mPocPresenter.cancelConnectTimeOut();
                    LogUtils.DLog(TAG, "onMemberEventCallBack: removeCallbacks(connectRunnable)");
                    canTalk(false);
                    reconnectServer();
                    //add by cga remind users check phone time
                    if (memberEvent.getUserBehavior() == Constants.ROOM_SERVER_TOKEN_ERROR){
                        ToastUtils.showToast(mContext.getString(R.string.poc_conversation_token_error));
                    }
                    return;
                }
                mPocPresenter.updateOnLineMember(memberEvent, mMemberInfoAdapter.getAllData());
            }
        }

        /**
         * 对讲界面创建临时频道
         * */
        @Override
        public void onCreateTempRooomCallBack(DBGroupEntity entity, String channelName, boolean status) {
            super.onCreateTempRooomCallBack(entity, channelName, status);
            if (status) {
                AMnager.startPOCConversionActivity(mContext, entity, channelName, -1, false);
            } else {
                ToastUtils.showToast(getString(R.string.poc_create_temp_failed));
            }
        }

        @Override
        public void onUserChangedCallBack(POCConversationUserChangeEvent userChangeEvent) {
            super.onUserChangedCallBack(userChangeEvent);
            mPocPresenter.subscribeUserChange(userChangeEvent);
        }

        @Override
        public void onDeleteServerRoomCallBack(GroupEvent event, boolean status) {
            super.onDeleteServerRoomCallBack(event, status);
            if (!event.getRoomId().equals(group.getRooomId())) {
                return;
            }
            try {
                if (!StringUtils.isEmpty(event.getFrom()) && event.getFrom().equals(mUserId)) {
                    LogUtils.ELog(TAG, "onDeleteServerRoomCallBack but from is self  and member is self ");
                    getActivity().finish();
                } else {
                    if (isOnPause) {
                        getActivity().finish();
                    } else {
                        showWarningDialog(event.getRoomId(), getString(R.string.poc_channel_deleted));
                    }
                }
            } catch (Exception e) {
                LogUtils.ELog(TAG, "onDeleteServerRoomCallBack: " + e.getLocalizedMessage());
            }
        }

        @Override
        public void onRemoveMembersCallBack(GroupEvent event, boolean status) {
            super.onRemoveMembersCallBack(event, status);
            if (event.getRoomId().equals(group.getRooomId())) {
                EventBus.getDefault().post(new POCChannelInfoResult(true));
                if (event.getFrom().equals(mUserId) && event.getMembers().equals(mUserId)) {
                    LogUtils.ELog(TAG, "onRemoveMembersCallBack but from is self  and member is self ");
                    POCClient.getInstance().removeCacheRoom(roomId);
                    getActivity().finish();
                } else {
                    if (event.getMembers().equals(POCConversationFragment.this.mUserId)) {
                        POCClient.getInstance().removeCacheRoom(roomId);
                        if (isOnPause) {
                            getActivity().finish();
                        }
                        POCConversationFragment.this.showWarningDialog(event.getRoomId(), getString(R.string.poc_force_remove_from_channel));
                    } else {
                        ((POCConversionActivity) getActivity()).removeFromCallList(event.getMembers(), "");
                        POCConversationFragment.this.onMemberRemoved(event.getRoomId(), event.getMembers());
                    }
                }
            }

        }

        @Override
        public void onAddMembersCallBack(GroupEvent event, boolean status) {
            super.onAddMembersCallBack(event, status);
            if (event.getRoomId().equals(roomId)) {
                // TODO: 2018/10/26新增成员
                String members = event.getMembers();
                Map<String, POCMemberInfo> userInfo = event.getUserInfo();
                List<String> mList = new ArrayList<>();
                if (!StringUtils.isEmpty(members)) {
                    String[] split = members.split(",");
                    List<POCMemberInfo> allData = mMemberInfoAdapter.getAllData();
                    List<POCMemberInfo> memberInfoList = new ArrayList<>();
                    Collections.addAll(mList, split);
                    for (String member : split) {
                        boolean isHas = false;
                        for (POCMemberInfo memberInfo : allData) {
                            if (memberInfo.getAccount().equals(member)) {
                                userInfosCache = POCUiKitProxyImpl.getInstance().getUserInfosCache();
                                if (userInfosCache != null && userInfosCache.containsKey(member)) {
                                    memberInfo.setName(userInfosCache.get(member).getName());
                                    memberInfo.setIcon(userInfosCache.get(member).getIcon());
                                }
                                isHas = true;
                                break;
                            }
                        }
                        if (!isHas) {
                            POCMemberInfo info = new POCMemberInfo();
                            info.setAccount(member);
                            userInfosCache = POCUiKitProxyImpl.getInstance().getUserInfosCache();
                            if (userInfosCache != null && userInfosCache.containsKey(member)) {
                                info.setName(userInfosCache.get(member).getName());
                                info.setIcon(userInfosCache.get(member).getIcon());
                            } else {
                                if (userInfosCache == null) {
                                    userInfosCache = new HashMap<>();
                                }
                                if (userInfo != null && userInfo.size() > 0 && userInfo.containsKey(member)) {
                                    info.setName(userInfo.get(member).getName());
                                    info.setIcon(userInfo.get(member).getIcon());
                                }
                            }
                            info.setMobile(member);
                            info.setRoomId(event.getRoomId());
                            memberInfoList.add(info);
                        }

                    }
                    mMemberInfoAdapter.addAll(memberInfoList);
                }
                String s = POCClient.getInstance().generateListString(mMemberInfoAdapter.getAllData());
                ((POCConversionActivity) getActivity()).group.setMemeberIds(s);
                List<String> onLineMemberList = POCClient.getOnLineMemberList(Long.parseLong(roomId));
                mPocPresenter.refreshAdapter(onLineMemberList == null ? 0 : onLineMemberList.size(), mMemberInfoAdapter.getAllData());
                List<String> mTemp = new ArrayList<>();
                for (POCMemberInfo info : mMemberInfoAdapter.getAllData()) {
                    for (String userId : mList) {
                        if (info.getAccount().equals(userId)) {
                            if (!info.isOnLine()) {
                                mTemp.add(userId);
                            }
                            break;
                        }
                    }
                }
                ((POCConversionActivity) getActivity()).handleCallMessage(true, mTemp, group.getRooomId());
            }
        }
    };

    private IPOCRecordCallBack recordCallBack = new IPOCRecordCallBack() {

        @Override
        public void onRecordCompleted(String roomId, String mp3RecordUri) {
            LogUtils.DLog(TAG, "onRecordCompleted: roomId = " + roomId +
                    " mp3RecordUri = " + mp3RecordUri);
        }

        @Override
        public void onRecordUploadResult(String mp3RecordUri, String fileId, int errorCode) {
            LogUtils.DLog(TAG, "onRecordUploadResult: fileId = " + fileId +
                    " mp3RecordUri = " + mp3RecordUri + " errorCode =  " + errorCode);
            if (errorCode == Constants.CODE_UPLOAD_FILE_TIME_EXCEPTION) {
                ToastUtils.showToast("请校验您当前手机时间");
            }
        }

        @Override
        public void onRecordCommitResult(String mp3RecordUri, int errorCode) {
            LogUtils.DLog(TAG, "onRecordCommitResult:" +
                    " mp3RecordUri = " + mp3RecordUri + " errorCode =  " + errorCode);
        }
    };

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onDimissDialogEvent(DimissDialogEvent dimissDialogEvent) {
        /**
         * 已经弹出移除频道的弹框了;
         * 但是紧接着又收到了加入频道的通知;
         * 则消失弹框
         */
        if (isDialogShowing && roomDestroyDialog != null) {
            roomDestroyDialog.dismiss();
            getActivity().finish();
        }
    }

    private POCConversionActivity.ICallBack callBack;

    public void setCallBack(POCConversionActivity.ICallBack callBack) {
        this.callBack = callBack;
    }

    private void updateChannelName() {
        if (callBack != null) {
            callBack.onCallBack(this.group);
        }
    }

    private void showWarningDialog(String roomId, String content) {
        isDialogShowing = true;
        if (roomDestroyDialog == null) {
            roomDestroyDialog = new ChannelDeletedTipDialog(getActivity());
            roomDestroyDialog.setConfirmClickListener(new ChannelDeletedTipDialog.onConfirmClickListener() {
                @Override
                public void onConfirm() {
                    roomDestroyDialog.dismiss();
                    if (getActivity().getPackageName().equals(UserConfig.AN_TONG_PACKNAME)) {
                        AMnager.startPOCMainActivity(getActivity(), true, "");
                    }
                    POCClient.getInstance().removeCacheRoom(roomId);
                    finish();
                }
            });
        }
        // TODO: 2019/1/24  new Add
        POCClient.removeFromReconnectCache(roomId);
        POCClient.leaveRoom(mUserId, roomId);
        POCClient.deleteLocalRoomById(mUserId, roomId);
        if (roomDestroyDialog.isShowing()) {
            return;
        }
        roomDestroyDialog.setCancelable(false);
        roomDestroyDialog.setCanceledOnTouchOutside(false);
        roomDestroyDialog.showD(content);
//        POCClient.leaveRoom(mUserId, roomId);
//        POCClient.deleteLocalRoomById(mUserId, roomId);
    }

    private void onMemberRemoved(String roomId, String members) {
        if (!StringUtils.isEmpty(members)) {
            String[] split = members.split(",");
            for (String id : split) {
                for (POCMemberInfo memberInfo : mMemberInfoAdapter.getAllData()) {
                    if (this.roomId.equals(roomId)) {
                        if (id.equals(memberInfo.getAccount())) {
                            mMemberInfoAdapter.remove(memberInfo);
                            break;
                        }
                    }
                }
            }
            String s = POCClient.getInstance().generateListString(mMemberInfoAdapter.getAllData());
            ((POCConversionActivity) getActivity()).group.setMemeberIds(s);
            mMemberInfoAdapter.notifyDataSetChanged();
//            updateChannelName();
            List<String> onLineMemberList = POCClient.getOnLineMemberList(Long.parseLong(roomId));
            mPocPresenter.refreshAdapter(onLineMemberList == null ? 0 : onLineMemberList.size(), mMemberInfoAdapter.getAllData());
            // TODO: 2018/10/23 需要设置在线人数和总人数
//            mTvPeopleCount.setText();
        }
    }

    // TODO: 2018/10/19 SDK: 群被删除的回调处理
    private void reconnectServer() {
        mPocPresenter.releaseTalkAnimate(mImgServeralCircle);
        mTvTalkStatus.setText(getString(R.string.poc_conversation_network_interrupt));
        setOnLineCount(0, mMemberInfoAdapter.getAllData().size());
        for (POCMemberInfo memberInfo : mMemberInfoAdapter.getAllData()) {
            memberInfo.setOnLine(false);
        }
        mMemberInfoAdapter.notifyDataSetChanged();
        switchShowAudioEffect(false);
    }

    /**
     * 添加成员
     *
     * @param addEvent
     */
    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onGroupMemberAddEvent(GroupMemberAddEvent addEvent) {
        String[] members = addEvent.getMemberIds();
        String roomId = addEvent.getRoomId();
        if (members != null && members.length > 0) {
            List<POCMemberInfo> pocGroupUserInfos = POCUiKitProxyImpl.getInstance().getPOCGroupUserInfos(members);
            mMemberInfoAdapter.addAll(pocGroupUserInfos);
        } else {
            LogUtils.ELog(TAG, "GroupMemberAddEvent : members is null");
        }
    }

//    @Subscribe(threadMode = ThreadMode.MAIN)
//    public void onGroupDeleteEvent(GroupDeleteEvent deleteEvent) {
//        DBGroupEntity entity = (DBGroupEntity) deleteEvent.getT();
//        mPocPresenter.deleteRoom(entity);
//    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onPOCMuteEvent(POCMuteEvent event) {
        String roomId = event.getRoomId();
        LogUtils.DLog(TAG, "mute status " + " roomId: " + event.getRoomId() + " : " + event.isSilence());
        if (roomId.equals(group.getRooomId())) {
            boolean silence = event.isSilence();
            group.setIsSilence(silence ? 1 : 0);
            mImgMute.setSelected(silence);
        }
    }

    public void setUpdateListener(IUpdateGroupListener listener) {
        mListener = listener;
    }

    public void resetStatus() {
        mPocPresenter.removeTimeoutRunnable("PocBroadReceiver.ROOM_RELEASE_TBCP_SUCCESS");
        mPocPresenter.bPeopleTalking = false;
        mPocPresenter.resetControlParmeter();
        roomSelfReleaseTbcpSuccess();
    }

    public boolean releaseStatus() {
        return mPocPresenter.releaseStaus;
    }

    public interface IUpdateGroupListener {
        void onPttKey(boolean pttStatus);

        void onUpdateName(String channelName);

        void onUpdatePwd(String channelPwd);

        void onUpdatePwdMode(boolean channelPwdMode);
    }

    /**
     * @param memberInfoEvent
     */
    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onUpdateMemberInfo(UpdateMemberInfoEvent memberInfoEvent) {
        if (memberInfoEvent.getT() == null) {
            LogUtils.ELog(TAG, "onUpdateMemberInfo: memberInfoEvent is null");
            return;
        }
        DBGroupEntity entity = memberInfoEvent.getT();
        if (!entity.getRooomId().equals(group.getRooomId())) {
            return;
        }
        if (!memberInfoEvent.isChannelExist()) {
            //频道不存在
            POCClient.removeFromReconnectCache(entity.getRooomId());
            POCClient.hangUpRoom(entity.getRooomId());
            showWarningDialog(entity.getRooomId(), getString(R.string.poc_channel_deleted));
            return;
        }
        this.group = entity;
        this.group.setIsSilence(entity.getIsSilence() ? 1 : 0);
        setStatus();
        updateChannelName();
        List<POCMemberInfo> pocMemberInfos = POCClient.getInstance().generateStringToList(entity.getMemeberIds());
        if (pocMemberInfos == null) {
            return;
        }
        mPocPresenter.updateTotalCount(pocMemberInfos.size());
        List<String> onLineMemberList = POCClient.getOnLineMemberList(Long.valueOf(group.getRooomId()));
        setOnLineCount(onLineMemberList != null ? onLineMemberList.size() : 0, pocMemberInfos.size());
        Iterator<POCMemberInfo> allMemberList = pocMemberInfos.iterator();
        List<POCMemberInfo> allData = mMemberInfoAdapter.getAllData();
        List<POCMemberInfo> memberInfoList = new ArrayList<>();
        boolean isContainsSelf = false;//是否包含自己
        try {
            while (allMemberList.hasNext()) {
                POCMemberInfo next = allMemberList.next();
                boolean isHas = false;
                //如果adapter有数据，则用adapter数据
                for (POCMemberInfo info : allData) {
                    if (next.getAccount().equals(info.getAccount())) {
                        isHas = true;
                        memberInfoList.add(info);
                        break;
                    }
                }
                //如果不在adapter，则添加该数据到adapter
                if (!isHas) {
                    next.setOnLine(false);
                    if (onLineMemberList != null && onLineMemberList.size() > 0) {
                        for (String account : onLineMemberList) {
                            if (next.getAccount().equals(account)) {
                                next.setOnLine(true);
                                break;
                            }
                        }
                    }
                    if (!StringUtils.isEmpty(next.getIcon())) {
                        next.setIcon(GlideUtils.checkImagePath(next.getIcon()));
                    }
                    if (userInfosCache != null && userInfosCache.containsKey(next.getAccount())) {
                        POCMemberInfo info = userInfosCache.get(next.getAccount());
                        if (info != null) {
                            next.setName(info.getName());
                        }
                    }
                    memberInfoList.add(next);
                }
                if (next.getAccount().equals(mUserId)) {
                    isContainsSelf = true;
                }
            }
            if (!isContainsSelf && entity.getRooomId().equals(roomId)) {
                POCClient.removeFromReconnectCache(entity.getRooomId());
                POCClient.hangUpRoom(entity.getRooomId());
                showWarningDialog(group.getRooomId(), getString(R.string.poc_force_remove_from_channel));
                return;
            }
            mMemberInfoAdapter.clear();
            mMemberInfoAdapter.addAll(memberInfoList);
            mPocPresenter.sortAdapter(mMemberInfoAdapter);
        } catch (Exception e) {
            LogUtils.ELog(TAG, e.getLocalizedMessage());
        }


//        while (iterator1.hasNext()) {
//            POCMemberInfo next1 = iterator1.next();
//            boolean isHas = false;//是否包含;不包含,则移出;
//            Iterator<POCMemberInfo> iterator = pocMemberInfos.iterator();
//            while (iterator.hasNext()) {
//                POCMemberInfo next = iterator.next();
//                if (next.getAccount().equals(next1.getAccount())) {
//                    isHas = true;
//                    break;
//                }
//            }
//            if (!isHas && iterator1 != null) {
//                if (next1.getAccount().equals(mUserId)) {
//                    isContainsSelf = true;
//                }
//                iterator1.remove();
//            }
//        }
//        mMemberInfoAdapter.clear();
//        mMemberInfoAdapter.addAll(allData);
//        mMemberInfoAdapter.notifyDataSetChanged();

        //        RefreshGroupList refreshGroupList = new RefreshGroupList();
//        refreshGroupList.setT(group);
//        if (group != null) {
//            refreshGroupList.setExist(true);
//        } else {
//            refreshGroupList.setExist(false);
//        }
//        EventBus.getDefault().post(refreshGroupList);

    }

    @Override
    protected void onPermissionResult(boolean result) {
        super.onPermissionResult(result);
        // modify by cga : ptt 默认不关联
        /*if (POCClient.getInstance().getPttCode(mUserId) == 0 &&
                PreferenceHelper.getBoolean(Constants.IS_CUSTOM_PTT_TIPS, false)) {
            POCClient.getInstance().setPttKeytCode(mUserId,KeyEvent.KEYCODE_VOLUME_DOWN);
        }*/
        if (result) {
            if (group != null)
                roomId = group.getRooomId();
            LinearLayout.LayoutParams params = (LinearLayout.LayoutParams) ivAudioEffect.getLayoutParams();
            int realHeight = (int) (DisplayUtil.getScreenHeight(getContext()) / getContext().getResources().getDisplayMetrics().density);
            params.topMargin = DisplayUtil.dip2px(getContext(), 20 * realHeight / 640);
            params.height = DisplayUtil.dip2px(getContext(), 260 * realHeight / 640);
            audioEffectPresenter = new AudioEffectPresenter(getActivity(), ivAudioEffect, roomId);
            audioEffectPresenter.init();
            EventPropxy.postSetPttKey(group.getRooomId(), true);
            //todo submit topic
            ArrayList<DBGroupEntity> topics = new ArrayList<>();
            topics.add(group);
            POCUiKitProxyImpl.getInstance().notifySubscribeTopic(topics);
            recoverData(true);

        } else {
            ChannelDeletedTipDialog roomDestroyDialog = new ChannelDeletedTipDialog(getActivity());
            roomDestroyDialog.setConfirmClickListener(new ChannelDeletedTipDialog.onConfirmClickListener() {
                @Override
                public void onConfirm() {
                    Intent localIntent = new Intent();
                    localIntent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                    localIntent.setAction("android.settings.APPLICATION_DETAILS_SETTINGS");
                    localIntent.setData(Uri.fromParts("package", getActivity().getPackageName(), null));
                    startActivity(localIntent);
                    getActivity().finish();
                }
            });
            roomDestroyDialog.setOnDismissListener(new DialogInterface.OnDismissListener() {
                @Override
                public void onDismiss(DialogInterface dialog) {
                    getActivity().finish();
                }
            });
            roomDestroyDialog.showD(getString(R.string.poc_guide_set_permission));
        }
    }


    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onUpdateUserInfoEvent(UpdateUserInfoEvent updateUserInfoEvent) {
        POCMemberInfo memberInfo = updateUserInfoEvent.getT();
        userInfosCache = POCUiKitProxyImpl.getInstance().getUserInfosCache();
        mPocPresenter.setUserInfo(userInfosCache);
        if (memberInfo != null) {
            List<POCMemberInfo> allData = mMemberInfoAdapter.getAllData();
            if (allData != null && allData.size() > 0 && !StringUtils.isEmpty(memberInfo.getAccount())) {
                for (POCMemberInfo info : allData) {
                    if (info.getAccount().equals(memberInfo.getAccount())) {
                        String name = memberInfo.getName();
                        if (StringUtils.isEmpty(name)) {
                            if (userInfosCache != null && userInfosCache.size() > 0 && userInfosCache.containsKey(memberInfo.getAccount())) {
                                name = userInfosCache.get(memberInfo.getAccount()).getName();
                            } else {
                                if (userInfosCache == null) {
                                    userInfosCache = new HashMap<>();
                                }
                                if (UserConfig.userNameMap != null && UserConfig.userNameMap.size() > 0 && UserConfig.userNameMap.containsKey(group.getRooomId())) {
                                    Map<String, POCMemberInfo> map = UserConfig.userNameMap.get(group.getRooomId());
                                    if (map != null && map.size() > 0 && map.containsKey(memberInfo.getAccount())) {
                                        POCMemberInfo info1 = map.get(memberInfo.getAccount());
                                        name = info1.getName();
                                        POCMemberInfo pocMemberInfo = new POCMemberInfo();
                                        pocMemberInfo.setAccount(memberInfo.getAccount());
                                        pocMemberInfo.setName(name);
                                        pocMemberInfo.setIcon(StringUtils.isEmpty(info1.getIcon()) ? "" : info1.getIcon());
                                        userInfosCache.put(memberInfo.getAccount(), pocMemberInfo);
                                    }
                                }
                            }
                        }
                        info.setName(name);
                        info.setIcon(StringUtils.isEmpty(memberInfo.getIcon()) ? info.getIcon() : memberInfo.getIcon());
                        info.setPinyin(PinyinUtil.getPingYin(name));
                        break;
                    }
                }
                mPocPresenter.sortAdapter(mMemberInfoAdapter);
            } else {
                LogUtils.ELog(TAG, "mMemberInfoAdapter data is null");
            }
        } else {
            LogUtils.ELog(TAG, "onUpdateUserInfoEvent: memberInfo is null ");
        }
    }

    /**
     * 设置当前会话的状态
     */
    public void setStatus() {
        boolean b = GroupUtils.resetGroupStatus(group);
        group.setStatus(b ? GroupConfig.GROUP_FREE : GroupConfig.GROUP_HANGUP);
        Map<String, String> map = POCClient.getAllSpeakers();
        if (map != null && map.containsKey(group.getRooomId())) {
            group.setStatus(GroupConfig.GROUP_BUSY);
            mPocPresenter.generateUserName(map.get(group.getRooomId()));
        }
        ((POCConversionActivity) getActivity()).group.setStatus(group.getStatus());
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onPOCCallEvent(POCCallEvent pocCallEvent) {
        String userName = "";
        if (userInfosCache != null && userInfosCache.size() > 0 && userInfosCache.containsKey(pocCallEvent.getUserId())) {
            userName = userInfosCache.get(pocCallEvent.getUserId()).getName();
        }
        if (StringUtils.isEmpty(userName)) {
            if (UserConfig.userNameMap != null && UserConfig.userNameMap.size() > 0 && UserConfig.userNameMap.containsKey(group.getRooomId())) {
                Map<String, POCMemberInfo> map = UserConfig.userNameMap.get(group.getRooomId());
                if (map != null && map.size() > 0 && map.containsKey(pocCallEvent.getUserId())) {
                    userName = map.get(pocCallEvent.getUserId()).getDeptName();
                    userInfosCache.put(pocCallEvent.getUserId(), map.get(pocCallEvent.getUserId()));
                }
            }
        }
        if (StringUtils.isEmpty(userName)) {
            userName = pocCallEvent.getUserId();
        }
        switch (pocCallEvent.getEventType()) {
            case POCCallEvent.POC_CALL_DELAY:
//                ToastUtils.showToast(userName + getString(R.string.poc_user_busy));
                LogUtils.DLog(TAG, userName + getString(R.string.poc_user_busy));
                break;
            case POCCallEvent.POC_CALL_REJECT:
                ((POCConversionActivity) getActivity()).removeFromCallList(pocCallEvent.getUserId(), userName);
                break;
        }
    }

    @SuppressLint("HandlerLeak")
    private Handler handler = new Handler() {
        @Override
        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            switch (msg.what) {
                case DELAY_MAX_INTERVAL:
                    if (!isAdded()) {
                        return;
                    }
                    currentDelayInterval--;
                    if (currentDelayInterval <= 0) {
                        resetParams();
                        llAudioAnim.setVisibility(View.GONE);
                        assert audioEffectPresenter != null;
                        audioEffectPresenter.stop();
                        switchShowAudioEffect(false);
                        releaseTbcp();
                        return;
                    }
                    handler.sendEmptyMessageDelayed(DELAY_MAX_INTERVAL, 1000);
                    tvDelayTime.setText(getResources().getString(R.string.poc_tv_delay_time, currentDelayInterval));
                    break;
                default:
                    handlerOtherEvent();
                    break;
            }

        }
    };

    private void handlerOtherEvent() {
        if (isExecuteReleaseTbcp) {
            return;
        }
        if (!isAdded()) {
            handler.removeMessages(1);
            handler.removeCallbacks(null);
            return;
        }
        if (!releaseStatus()) {
            LogUtils.DLog(TAG, "release timeOut ,handle release");
            resetStatus();
            Map<String, String> allSpeakers = POCClient.getAllSpeakers();
            if (allSpeakers != null && allSpeakers.containsKey(roomId) && !TextUtils.isEmpty(allSpeakers.get(roomId))) {
                LogUtils.DLog(TAG, "release timeOut ,speakId: " + allSpeakers.get(roomId));
                if (allSpeakers.get(roomId).equals(mUserId)) {
                    setTalkStatus(String.format(GlobalContext.getContext().getString(R.string.poc_conversation_talk_status_busy), "您"));
                }
            } else {
                setTalkStatus(GlobalContext.getContext().getString(R.string.poc_conversation_talk_status_free));
                POCClient.releaseTBCP(roomId);
            }
            handler.removeMessages(1);
            handler.removeCallbacks(null);
        } else {

        }

    }

    private void resetParams() {
        handler.removeMessages(DELAY_MAX_INTERVAL);
        currentDelayInterval = DELAY_MAX_INTERVAL;
    }

    @Override
    public boolean isExist() {
        return isAdded();
    }
}

