package com.xdja.poc.sdk.utils;

import android.app.ActivityManager;
import android.content.Context;

import com.xdja.poc.common.utils.GlobalContext;

import java.util.List;

public class ProcessUtils {

    private static final String POC_PROCESS_NAME = GlobalContext.getContext().getPackageName() + ":poc";

    private ProcessUtils() {
    }

    public static boolean pocessIsExist() {
        boolean isExist = false;
        ActivityManager activityManager = (ActivityManager) GlobalContext.getContext()
                .getSystemService(Context.ACTIVITY_SERVICE);
        List<ActivityManager.RunningAppProcessInfo> processInfoList = activityManager
                .getRunningAppProcesses();
        if (processInfoList == null || processInfoList.isEmpty()) {
            return isExist;
        }
        for (int i = 0; i < processInfoList.size(); i++) {
            if (processInfoList.get(i).processName.equalsIgnoreCase(POC_PROCESS_NAME)) {
                isExist = true;
                break;
            }
        }
        return isExist;
    }
}
