package com.xdja.poc.sdk.utils.glide;

import com.bumptech.glide.Priority;
import com.bumptech.glide.load.data.DataFetcher;
import com.bumptech.glide.load.model.GlideUrl;
import com.bumptech.glide.util.ContentLengthInputStream;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map.Entry;

import okhttp3.Call;
import okhttp3.Call.Factory;
import okhttp3.Request;
import okhttp3.Request.Builder;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class OkHttpStreamFetcher implements DataFetcher<InputStream> {
    private final Factory client;
    private final GlideUrl url;
    private InputStream stream;
    private ResponseBody responseBody;
    private Call call;

    public OkHttpStreamFetcher(Factory client, GlideUrl url) {
        this.client = client;
        this.url = url;
    }
    @Override
    public InputStream loadData(Priority priority) throws Exception {
        Builder requestBuilder = (new Builder()).url(this.url.toStringUrl());
        Iterator it = this.url.getHeaders().entrySet().iterator();

        while(it.hasNext()) {
            Entry<String, String> headerEntry = (Entry)it.next();
            String key = headerEntry.getKey();
            requestBuilder.addHeader(key,headerEntry.getValue());
        }

        Request request = requestBuilder.build();
        this.call = this.client.newCall(request);
        Response response = this.call.execute();
        this.responseBody = response.body();
        if(!response.isSuccessful()) {
            throw new IOException("Request failed with code: " + response.code());
        } else {
            if (this.responseBody != null){
                long contentLength = this.responseBody.contentLength();
                this.stream = ContentLengthInputStream.obtain(this.responseBody.byteStream(), contentLength);
                return this.stream;
            }
            return null;
        }
    }
    @Override
    public void cleanup() {
        try {
            if(this.stream != null) {
                this.stream.close();
            }
        } catch (IOException var2) {

        }

        if(this.responseBody != null) {
            this.responseBody.close();
        }

    }
    @Override
    public String getId() {
        return this.url.getCacheKey();
    }
    @Override
    public void cancel() {
        Call local = this.call;
        if(local != null) {
            local.cancel();
        }

    }
}
