/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.business;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.common.utils.PreferenceHelper;
import com.xdja.poc.common.utils.StringUtils;
import com.xdja.poc.sdk.POCClient;
import com.xdja.poc.sdk.bean.GroupList;
import com.xdja.poc.sdk.bean.POCMemberInfo;
import com.xdja.poc.sdk.business.MessageProxy;
import com.xdja.poc.sdk.config.UserConfig;
import com.xdja.poc.sdk.db.entity.DBGroupEntity;
import com.xdja.poc.sdk.db.manager.PocDaoGroupManager;
import com.xdja.poc.sdk.event.POCMuteEvent;
import com.xdja.poc.sdk.proxy.POCUiKitProxyImpl;
import com.xdja.poc.sdk.utils.GroupUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.greenrobot.eventbus.EventBus;

public class POCHandlerService
extends IntentService {
    private static final String INSERT_OR_REPLACE_GROUP_DATA_LIST = "insert_or_replace_group_data_list";
    private static final String INSERT_OR_REPLACE_SINGLE_DATA = "insert_or_replace_single_data";
    private static final String UPDATE_MEMBER_INFOS = "update_member_infos";
    private static final String GET_ALL_POC_ROOM = "get_all_poc_room";
    private static final String UPDATE_GROUP_IS_SILENCE = "update_group_is_silence";
    public static final String UPDATE_GROUP_IS_TOP_STICK = "update_group_is_top_stick";
    private static final String DELETE_ROOM_BY_KEY = "delete_room_by_key";
    private static final String GROUP_TEMP_ENTITY = "group_temp_entity";
    private static final String DELETE_ROOM_BY_KEY_WITH_NOTIFY_UI = "delete_room_by_key_with_notify_ui";
    private static final String OWNERID = "owner_id";
    private static final String GROUP_DB_KEY = "group_db_key";
    private static final String GROUP_UI_POSITION = "group_ui_position";
    private static final String GROUP_SERVER_LIST = "group_server_list";
    private static final String DB_GROUP_LIST = "db_group_list";
    private static final String IS_PTT = "is_ptt";
    private static final String UPDATE_GROUP_IS_PTT = "update_group_is_ptt";
    private static final String UPDATE_GROUP_NAME = "update_group_name";
    private static final String GROUP_PWD = "group_pwd";
    private static final String UPDATE_GROUP_PWD = "update_group_pwd";
    private static final String GROUP_PWD_MODE = "group_pwd_mode";
    private static final String UPDATE_GROUP_PWD_MODE = "update_group_pwd_mode";
    private static final String INTENT_DB_CLEAR_CHANNEL_INFO = "intent_db_clear_channel_info";
    private static String TAG = "POCHandlerService";
    private static String USERID = "userId";
    private static String ROOMID = "roomId";
    private static String GROUP_NAME = "group_name";
    private static String IS_SILENCE = "isSilence";
    private static String IS_TOP_STICK = "is_top_stick";
    private static String GROUP = "group";
    private static String GROUP_JSON = "group_json";
    private static String MEMBER_INFOS = "member_infos";

    public POCHandlerService() {
        super("DBHandlerService");
    }

    protected void onHandleIntent(@Nullable Intent intent) {
        if (intent == null || StringUtils.isEmpty((String)intent.getAction())) {
            return;
        }
        String userId = PreferenceHelper.getString((String)"login_account", (String)"");
        String roomId = intent.getStringExtra(ROOMID);
        switch (intent.getAction()) {
            case "insert_or_replace_single_data": {
                String groupJson = intent.getStringExtra(GROUP_JSON);
                break;
            }
            case "insert_or_replace_group_data_list": {
                Object s;
                ArrayList severData = (ArrayList)intent.getSerializableExtra(GROUP_SERVER_LIST);
                ArrayList<POCMemberInfo> memberInfoListTemp = new ArrayList<POCMemberInfo>();
                ArrayList mDbEntity = new ArrayList();
                List<DBGroupEntity> mLocalList = PocDaoGroupManager.getInstance((Context)this).getAllPocGroup(userId);
                String mUserId = PreferenceHelper.getString((String)"login_account", (String)"");
                if (severData != null && severData.size() > 0) {
                    for (Iterator<DBGroupEntity> groupData : severData) {
                        memberInfoListTemp.clear();
                        DBGroupEntity entity = new DBGroupEntity();
                        entity.setUserId(userId);
                        String roomId_ = ((GroupList.GroupData)((Object)groupData)).getGroupUri();
                        entity.setRooomId(roomId_);
                        entity.setIsSilence(0);
                        entity.setGroupType(((GroupList.GroupData)((Object)groupData)).transGroupType(((GroupList.GroupData)((Object)groupData)).getGroupType()));
                        entity.setOnLineCount(0);
                        entity.setMaxInviteMembersCount(StringUtils.isEmpty((String)((GroupList.GroupData)((Object)groupData)).getMaxInviteMembersCount()) ? 0 : Integer.valueOf(((GroupList.GroupData)((Object)groupData)).getMaxInviteMembersCount()));
                        entity.setChannelPwdMode(((GroupList.GroupData)((Object)groupData)).getIsPassword().equals("Y") ? 1 : 0);
                        entity.setChannelPwd(StringUtils.generateContent((String)((GroupList.GroupData)((Object)groupData)).getPassword()));
                        entity.setKey(GroupUtils.generatePOCGroupDbKey(userId, roomId_));
                        entity.setOwnerId(((GroupList.GroupData)((Object)groupData)).getOwner());
                        entity.setCreateTime(((GroupList.GroupData)((Object)groupData)).getCreateTime());
                        DBGroupEntity localEntity = null;
                        if (mLocalList != null && mLocalList.size() > 0) {
                            for (DBGroupEntity _entity : mLocalList) {
                                if (!_entity.getRooomId().equals(entity.getRooomId())) continue;
                                localEntity = _entity;
                            }
                        }
                        if (localEntity != null) {
                            entity.setIsSilence(localEntity.getIsSilence() ? 1 : 0);
                            entity.setTopStickTime(localEntity.getTopStickTime());
                            entity.setIsTopStick(localEntity.getIsTopStick() ? 1 : 0);
                            entity.setStatus(localEntity.getStatus());
                            entity.setIsPttKey(localEntity.getIsPttKey() ? 1 : 0);
                        }
                        for (GroupList.GroupMember member : ((GroupList.GroupData)((Object)groupData)).getTalkGroupMembers()) {
                            POCMemberInfo memberInfo_ = new POCMemberInfo();
                            memberInfo_.setId(member.getMember());
                            memberInfo_.setOnLine(false);
                            memberInfo_.setRoomId(roomId_);
                            memberInfo_.setName(member.getName());
                            memberInfo_.setAccount(member.getMember());
                            memberInfo_.setRealName(member.getName());
                            if (!TextUtils.isEmpty((CharSequence)member.getIcon())) {
                                memberInfo_.setIcon(member.getIcon());
                            } else {
                                memberInfo_.setIcon("");
                            }
                            memberInfoListTemp.add(memberInfo_);
                        }
                        entity.setRoomName(GroupUtils.convertString(((GroupList.GroupData)((Object)groupData)).getDisplayName()));
                        if (memberInfoListTemp.size() > 0) {
                            s = POCClient.getInstance().generateListString(memberInfoListTemp);
                            entity.setMemeberIds((String)s);
                        }
                        mDbEntity.add(entity);
                    }
                } else if (mLocalList != null && mLocalList.size() > 0) {
                    mDbEntity = (ArrayList)mLocalList;
                }
                HashMap<String, POCMemberInfo> memberNameMaps = new HashMap<String, POCMemberInfo>();
                for (DBGroupEntity entity : mDbEntity) {
                    String memeberIds = entity.getMemeberIds();
                    List<POCMemberInfo> memberInfoList = POCClient.getInstance().generateStringToList(memeberIds);
                    s = memberInfoList.iterator();
                    while (s.hasNext()) {
                        POCMemberInfo info = s.next();
                        memberNameMaps.put(info.getAccount(), info);
                    }
                    UserConfig.userNameMap.put(entity.getRooomId(), memberNameMaps);
                    entity.setUserNames("");
                    entity.setPinyin(GroupUtils.generatePinYin(entity));
                    List<String> onLineMemberList = POCClient.getOnLineMemberList(Long.parseLong(entity.getRooomId()));
                    entity.setOnLineCount(onLineMemberList == null ? 0 : onLineMemberList.size());
                    boolean b = GroupUtils.resetGroupStatus(entity);
                    entity.setStatus(b ? 1 : 0);
                }
                if (mLocalList != null && mLocalList.size() > 0) {
                    for (DBGroupEntity entity : mLocalList) {
                        boolean isDelete = true;
                        for (DBGroupEntity _entity : mDbEntity) {
                            if (!_entity.getRooomId().equals(entity.getRooomId())) continue;
                            isDelete = false;
                        }
                        if (!isDelete) continue;
                        mDbEntity.remove(entity);
                        PocDaoGroupManager.getInstance((Context)this).deleteGroup(entity.getKey());
                        LogUtils.DLog((String)TAG, (String)("POCHandleService: removeFromReconnectCache roomId: " + roomId));
                        POCClient.removeFromReconnectCache(entity.getRooomId());
                        POCClient.leaveRoom(mUserId, entity.getRooomId());
                    }
                }
                MessageProxy.sendGetPocAllRoom(mDbEntity);
                if (mDbEntity.size() > 0) {
                    PocDaoGroupManager.getInstance((Context)this).insertOrReplaceGroup(mDbEntity);
                }
                POCClient.getInstance().removeAllCacheRoom();
                POCUiKitProxyImpl.getInstance().notifyChannelInfoInsertToDBFinished();
                break;
            }
            case "update_member_infos": {
                break;
            }
            case "delete_room_by_key": {
                String key1 = intent.getStringExtra(GROUP_DB_KEY);
                PocDaoGroupManager.getInstance((Context)this).deleteGroup(key1);
                break;
            }
            case "delete_room_by_key_with_notify_ui": {
                break;
            }
            case "get_all_poc_room": {
                break;
            }
            case "update_group_is_silence": {
                boolean isSilence = intent.getBooleanExtra(IS_SILENCE, false);
                PocDaoGroupManager.getInstance((Context)this).updateGroupIsSilence(userId, roomId, isSilence);
                POCMuteEvent pocMuteEvent = new POCMuteEvent();
                pocMuteEvent.setRoomId(roomId);
                pocMuteEvent.setSilence(isSilence);
                EventBus.getDefault().post((Object)pocMuteEvent);
                break;
            }
            case "update_group_is_ptt": {
                ArrayList entities = (ArrayList)intent.getSerializableExtra(DB_GROUP_LIST);
                boolean isPtt = intent.getBooleanExtra(IS_PTT, false);
                PocDaoGroupManager.getInstance((Context)this).updateGroupIsPttKey(entities, userId, roomId, isPtt);
                break;
            }
            case "update_group_is_top_stick": {
                boolean isTopStick = intent.getBooleanExtra(IS_TOP_STICK, false);
                PocDaoGroupManager.getInstance((Context)this).updateGroupIsTopStick(userId, roomId, isTopStick);
                break;
            }
            case "update_group_name": {
                String groupName = intent.getStringExtra(GROUP_NAME);
                PocDaoGroupManager.getInstance((Context)this).updateGroupNanme(userId, roomId, groupName);
                break;
            }
            case "update_group_pwd": {
                String pwd = intent.getStringExtra(GROUP_PWD);
                PocDaoGroupManager.getInstance((Context)this).updateGroupPwd(userId, roomId, pwd);
                break;
            }
            case "update_group_pwd_mode": {
                boolean channelPwdMode = intent.getBooleanExtra(GROUP_PWD_MODE, false);
                PocDaoGroupManager.getInstance((Context)this).updateGroupPwdMode(userId, roomId, channelPwdMode);
                break;
            }
            case "intent_db_clear_channel_info": {
                PocDaoGroupManager.getInstance((Context)this).clearChannelInfo(userId);
            }
        }
    }

    public static void insertOrReplaceGroupData(Context context, String json) {
        LogUtils.ILog((String)TAG, (String)"\u542f\u52a8 insertOrReplaceGroupData service");
        Intent intent = new Intent(context.getApplicationContext(), POCHandlerService.class);
        intent.setAction(INSERT_OR_REPLACE_SINGLE_DATA);
        intent.putExtra(GROUP_JSON, json);
        context.startService(intent);
    }

    public static void insertOrReplaceGroupData(Context context, ArrayList<GroupList.GroupData> groupEntities) {
        LogUtils.ILog((String)TAG, (String)"\u542f\u52a8 insertOrReplaceGroupData service");
        Intent intent = new Intent(context.getApplicationContext(), POCHandlerService.class);
        intent.setAction(INSERT_OR_REPLACE_GROUP_DATA_LIST);
        intent.putExtra(GROUP_SERVER_LIST, groupEntities);
        context.startService(intent);
    }

    public static void updateMemberInfos(Context context, String mUserId, String roomId, String memberInfos) {
        Intent intent = new Intent(context.getApplicationContext(), POCHandlerService.class);
        intent.setAction(UPDATE_MEMBER_INFOS);
        intent.putExtra(USERID, mUserId);
        intent.putExtra(ROOMID, roomId);
        String MEMBER_INFOS_STRING = "member_infos_string";
        intent.putExtra(MEMBER_INFOS_STRING, memberInfos);
        context.startService(intent);
    }

    public static void getAllPocRoom(Context context, String mUserId) {
    }

    public static void updateGroupIsSilence(Context mContext, String mUserId, String rooomId, boolean isSilence) {
        Intent intent = new Intent(mContext.getApplicationContext(), POCHandlerService.class);
        intent.setAction(UPDATE_GROUP_IS_SILENCE);
        intent.putExtra(USERID, mUserId);
        intent.putExtra(ROOMID, rooomId);
        intent.putExtra(IS_SILENCE, isSilence);
        mContext.startService(intent);
    }

    public static void updateGroupPttKey(Context mContext, ArrayList<DBGroupEntity> entityList, String mUserId, String channelId, boolean isPtt) {
        Intent intent = new Intent(mContext.getApplicationContext(), POCHandlerService.class);
        intent.setAction(UPDATE_GROUP_IS_PTT);
        intent.putExtra(USERID, mUserId);
        intent.putExtra(DB_GROUP_LIST, entityList);
        intent.putExtra(ROOMID, channelId);
        intent.putExtra(IS_PTT, isPtt);
        mContext.startService(intent);
    }

    public static void updateGroupIsTopStick(Context mContext, String mUserId, String rooomId, boolean isStick) {
        Intent intent = new Intent(mContext.getApplicationContext(), POCHandlerService.class);
        intent.setAction(UPDATE_GROUP_IS_TOP_STICK);
        intent.putExtra(USERID, mUserId);
        intent.putExtra(ROOMID, rooomId);
        intent.putExtra(IS_TOP_STICK, isStick);
        mContext.startService(intent);
    }

    public static void deleteRoomByRoomId(Context context, String key) {
        Intent intent = new Intent(context.getApplicationContext(), POCHandlerService.class);
        intent.setAction(DELETE_ROOM_BY_KEY);
        intent.putExtra(GROUP_DB_KEY, key);
        context.startService(intent);
    }

    public static void deleteRoomByIdWithNotifyUI(Context context, String userId, String roomId, int position) {
        Intent intent = new Intent(context.getApplicationContext(), POCHandlerService.class);
        intent.setAction(DELETE_ROOM_BY_KEY_WITH_NOTIFY_UI);
        intent.putExtra(GROUP_DB_KEY, GroupUtils.generatePOCGroupDbKey(userId, roomId));
        intent.putExtra(ROOMID, roomId);
        intent.putExtra(GROUP_UI_POSITION, position);
        context.startService(intent);
    }

    public static void updateGroupName(Context mContext, String mUserId, String channelId, String channelName) {
        Intent intent = new Intent(mContext, POCHandlerService.class);
        intent.setAction(UPDATE_GROUP_NAME);
        intent.putExtra(USERID, mUserId);
        intent.putExtra(GROUP_NAME, channelName);
        intent.putExtra(ROOMID, channelId);
        mContext.startService(intent);
    }

    public static void updateGroupPwd(Context mContext, String mUserId, String channelId, String channelPwd) {
        Intent intent = new Intent(mContext, POCHandlerService.class);
        intent.setAction(UPDATE_GROUP_PWD);
        intent.putExtra(USERID, mUserId);
        intent.putExtra(GROUP_PWD, channelPwd);
        intent.putExtra(ROOMID, channelId);
        mContext.startService(intent);
    }

    public static void updateGroupPwdMode(Context mContext, String mUserId, String channelId, boolean channelPwdMode) {
        Intent intent = new Intent(mContext, POCHandlerService.class);
        intent.setAction(UPDATE_GROUP_PWD_MODE);
        intent.putExtra(USERID, mUserId);
        intent.putExtra(GROUP_PWD_MODE, channelPwdMode);
        intent.putExtra(ROOMID, channelId);
        mContext.startService(intent);
    }

    public static void clearChannelInfo(Context mContext, String mUserId) {
        Intent intent = new Intent(mContext, POCHandlerService.class);
        intent.setAction(INTENT_DB_CLEAR_CHANNEL_INFO);
        intent.putExtra(USERID, mUserId);
        mContext.startService(intent);
    }
}

