/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.business;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Handler;
import android.text.TextUtils;
import com.xdja.poc.common.event.NetWorkConnectEvent;
import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.common.utils.UiUtils;
import com.xdja.poc.sdk.POCClient;
import com.xdja.poc.sdk.config.Constants;
import com.xdja.poc.sdk.event.POCConverationTbcpStatusEvent;
import com.xdja.poc.sdk.event.POCConversationMeIncomeRoom;
import com.xdja.poc.sdk.event.POCConversationUserChangeEvent;
import com.xdja.poc.sdk.event.POCMemberEvent;
import com.xdja.poc.sdk.event.POCSelfLeaveEvent;
import com.xdja.poc.sdk.proxy.POCUiKitProxyImpl;
import org.greenrobot.eventbus.EventBus;

public class PocBroadReceiver
extends BroadcastReceiver {
    public static final String TAG = "PocBroadReceiver";
    public static PocBroadReceiver pocBroadReceiver = new PocBroadReceiver();
    public static final String ACTION = "com.xdja.poc.service";
    public static final String ACTION_NET_CHANGED = "android.net.conn.CONNECTIVITY_CHANGE";
    public static final String FLAG = "flag";
    public static final String MEMBER_INFO = "member_info";
    public static final String STATUS = "status";
    public static final String BEHAVIOR = "Behavior";
    public static final String INTENT_KEY_LOGIN_MUTEX = "login_mutex";
    public static final String INTENT_KEY_NET_CHANGED = "net_changed";
    public static final String STATUS_ROOM_USER_LEAVE_OR_JOIN = "room_user_behavior";
    public static final String MP3_RECORD_URI = "mp3_record_uri";
    public static final String UPLOAD_MP3_FILEID = "mp3_upload_fileid";
    public static final String UPLOAD_MP3_EOORCODE = "mp3_record_error";
    public static final int UPDATE_POC_CONVERSION_STATUS = 1;
    public static final int ROOM_OTHER_REQUEST_TBCP_SUCCESS = 2;
    public static final int ROOM_OTHER_RELEASE_TBCP_SUCCESS = 1;
    public static final int ROOM_RELEASE_TBCP_SUCCESS = 1005;
    public static final int ROOM_RELEASE_TBCP_FAILED = 1006;
    public static final int ROOM_REQUEST_TBCP_SUCCESS = 1007;
    public static final int ROOM_REQUEST_TBCP_FAILED = 1008;
    public static final int UPDATE_POC_CONVERSION_USER_CHANGED = 1009;
    public static final int UPDATE_POC_GROUP_EVENT_CHANGED = 1010;
    public static final int UPDATE_POC_CONVERSION_SELF_LEAVE = 1011;
    public static final int FLAG_NET_CHANGED = 1012;
    public static final int FLAG_REBIND_SERVICE = 1013;
    public static final int FLAG_POC_CONVERATION_TBCP_STATUS = 1014;
    public static final int FLAG_ME_INCOMING_ROOM = 1016;
    public static final int FLAG_USER_INCOME_OR_LEAVE = 1015;
    public static final int FLAG_CLOSE_CURRENT_GROUP = 1017;
    public static final int ROOM_USER_LEAVE_SUCCESS = 0;
    public static final int ROOM_USER_JOIN_SUCCESS = 1;
    public static boolean isRegister = false;
    public static final int CUSTOM_RECORD_COMPLETED = 2001;
    public static final int CUSTOM_RECORD_UPLOAD_COMPLETED = 2002;
    public static final int CUSTOM_RECORD_COMMIT_COMPLETED = 2003;
    public static int currentNetState = -1;
    public NetworkInfo lastNetworkInfo;
    private boolean isReconectChannel = false;

    public void onReceive(Context context, Intent intent) {
        if (intent == null || TextUtils.isEmpty((CharSequence)intent.getAction())) {
            return;
        }
        if (intent.getAction().equals(ACTION_NET_CHANGED)) {
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            assert (connectivityManager != null);
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            boolean netStatus = false;
            this.isReconectChannel = false;
            try {
                long lastTime = System.currentTimeMillis();
                if (networkInfo != null && networkInfo.isConnected()) {
                    LogUtils.ILog((String)("netWorkStatus:" + networkInfo.getType() + ", typeName:" + networkInfo.getTypeName() + ",currentNetState: " + currentNetState));
                    int networkState = networkInfo.getType();
                    netStatus = true;
                    if (networkState != currentNetState || this.lastNetworkInfo != null && !this.lastNetworkInfo.getTypeName().equals(networkInfo.getTypeName())) {
                        this.isReconectChannel = true;
                        LogUtils.DLog((String)TAG, (String)("currentProcess: " + UiUtils.getCurrentProcessName((Context)context)));
                        if (!Constants.isViewExist && UiUtils.getCurrentProcessName((Context)context).equals(context.getPackageName())) {
                            LogUtils.ILog((String)"start  POCClient.handleNetConnectSuccess():");
                            POCClient.handleNetConnectSuccess();
                        }
                    }
                    currentNetState = networkState;
                } else {
                    LogUtils.ILog((String)"netWorkStatus disconnect");
                    currentNetState = -1;
                }
            }
            catch (Exception e) {
                LogUtils.ELog((String)TAG, (String)e.getLocalizedMessage());
            }
            this.lastNetworkInfo = networkInfo;
            LogUtils.ILog((String)("PocBroadReceiver: " + netStatus));
            final boolean finalNetStatus = netStatus;
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    NetWorkConnectEvent netWorkConnectEvent = new NetWorkConnectEvent((Object)finalNetStatus);
                    netWorkConnectEvent.setAvailable(PocBroadReceiver.this.isReconectChannel);
                    EventBus.getDefault().post((Object)netWorkConnectEvent);
                }
            }, 1300L);
            return;
        }
        String userID = intent.getStringExtra("userId");
        String roomId = intent.getStringExtra("roomId");
        String onLineMemberInfo = intent.getStringExtra(MEMBER_INFO);
        POCMemberEvent pocMemberEvent = new POCMemberEvent();
        switch (intent.getIntExtra(FLAG, -1)) {
            case 1: {
                int status = intent.getIntExtra(STATUS, -1);
                int behavious = intent.getIntExtra(BEHAVIOR, -1);
                POCConverationTbcpStatusEvent mTbcpMessage = new POCConverationTbcpStatusEvent();
                mTbcpMessage.setRoomId(roomId);
                mTbcpMessage.setUserId(userID);
                mTbcpMessage.setStatus(status);
                mTbcpMessage.setUserBehavior(behavious);
                mTbcpMessage.setOnLineMemberList(onLineMemberInfo);
                POCUiKitProxyImpl.getInstance().notifyTBCPEvent(mTbcpMessage);
                break;
            }
            case 1009: {
                pocMemberEvent.setMemberInfos(onLineMemberInfo);
                pocMemberEvent.setRoomId(roomId);
                POCUiKitProxyImpl.getInstance().notifyMemberEvent(pocMemberEvent);
                break;
            }
            case 1010: {
                pocMemberEvent.setMemberInfos(onLineMemberInfo);
                pocMemberEvent.setRoomId(roomId);
                pocMemberEvent.setStatus(intent.getIntExtra("group_event_type", 0));
                pocMemberEvent.setUserBehavior(intent.getIntExtra(STATUS_ROOM_USER_LEAVE_OR_JOIN, 0));
                POCUiKitProxyImpl.getInstance().notifyMemberEvent(pocMemberEvent);
                break;
            }
            case 1011: {
                POCSelfLeaveEvent selfLeaveEvent = new POCSelfLeaveEvent(roomId);
                selfLeaveEvent.setStatus(0);
                POCUiKitProxyImpl.getInstance().notifySelfLeave(selfLeaveEvent);
                break;
            }
            case 1014: {
                int status2 = intent.getIntExtra(STATUS, -1);
                int Behavior = intent.getIntExtra(BEHAVIOR, -1);
                POCConverationTbcpStatusEvent mTbcpMessage2 = new POCConverationTbcpStatusEvent();
                mTbcpMessage2.setRoomId(roomId);
                mTbcpMessage2.setUserId(userID);
                mTbcpMessage2.setStatus(status2);
                mTbcpMessage2.setUserBehavior(Behavior);
                mTbcpMessage2.setOnLineMemberList(onLineMemberInfo);
                POCUiKitProxyImpl.getInstance().notifyTBCPEvent(mTbcpMessage2);
                break;
            }
            case 1013: {
                POCClient.getInstance().bindService();
                break;
            }
            case 1016: {
                POCConversationMeIncomeRoom pocConversationMeIncomeRoom = new POCConversationMeIncomeRoom();
                pocConversationMeIncomeRoom.setMemberInfos(intent.getStringExtra(MEMBER_INFO));
                pocConversationMeIncomeRoom.setRoomId(roomId);
                POCUiKitProxyImpl.getInstance().notifyMeIncomeRoom(pocConversationMeIncomeRoom);
                break;
            }
            case 1017: {
                break;
            }
            case 1015: {
                POCConversationUserChangeEvent event = new POCConversationUserChangeEvent();
                event.setRoomId(roomId);
                event.setUserId(onLineMemberInfo);
                event.setStatus(intent.getIntExtra(STATUS_ROOM_USER_LEAVE_OR_JOIN, 0));
                POCUiKitProxyImpl.getInstance().notifyUserChanged(event);
                break;
            }
            case 2001: {
                LogUtils.DLog((String)TAG, (String)"\u5e7f\u64ad\uff1a\u5f55\u97f3\u7ed3\u675f");
                POCUiKitProxyImpl.getInstance().notifyRecordComplete(roomId, intent.getStringExtra(MP3_RECORD_URI));
                break;
            }
            case 2002: {
                LogUtils.DLog((String)TAG, (String)"\u5e7f\u64ad\uff1a\u4e0a\u4f20\u5f55\u97f3\u7ed3\u675f");
                POCUiKitProxyImpl.getInstance().notifyRecordUploadResult(intent.getStringExtra(MP3_RECORD_URI), intent.getStringExtra(UPLOAD_MP3_FILEID), intent.getIntExtra(UPLOAD_MP3_EOORCODE, 0));
                break;
            }
            case 2003: {
                LogUtils.DLog((String)TAG, (String)"\u5e7f\u64ad\uff1a\u63d0\u4ea4\u5f55\u97f3\u7ed3\u675f");
                POCUiKitProxyImpl.getInstance().notifyRecordCommitResult(intent.getStringExtra(MP3_RECORD_URI), intent.getIntExtra(UPLOAD_MP3_EOORCODE, 0));
            }
        }
    }

    public static void registerPushReceiver(Context context) {
        if (isRegister) {
            return;
        }
        isRegister = true;
        try {
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction(ACTION);
            intentFilter.addAction(ACTION_NET_CHANGED);
            context.getApplicationContext().registerReceiver((BroadcastReceiver)pocBroadReceiver, intentFilter);
        }
        catch (Exception e) {
            LogUtils.ELog((Throwable)e);
        }
    }

    public static void unregisterPushReceiver(Context context) {
        isRegister = false;
        try {
            if (pocBroadReceiver != null) {
                context.getApplicationContext().unregisterReceiver((BroadcastReceiver)pocBroadReceiver);
            }
        }
        catch (Exception e) {
            LogUtils.ELog((Throwable)e);
        }
    }
}

