/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.business.webrtc.apprtc;

import android.os.Handler;
import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.sdk.business.webrtc.apprtc.util.AsyncHttpURLConnection;
import de.tavendo.autobahn.WebSocket;
import de.tavendo.autobahn.WebSocketConnection;
import de.tavendo.autobahn.WebSocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class WebSocketChannelClient {
    private static final String TAG = "WSChannelRTCClient";
    private static final int CLOSE_TIMEOUT = 1000;
    private final WebSocketChannelEvents events;
    private final Handler handler;
    private WebSocketConnection ws;
    private String wsServerUrl;
    private String postServerUrl;
    private String roomID;
    private String clientID;
    private WebSocketConnectionState state;
    private final Object closeEventLock = new Object();
    private boolean closeEvent;
    private final List<String> wsSendQueue = new ArrayList<String>();

    public WebSocketChannelClient(Handler handler, WebSocketChannelEvents events) {
        this.handler = handler;
        this.events = events;
        this.roomID = null;
        this.clientID = null;
        this.state = WebSocketConnectionState.NEW;
    }

    public WebSocketConnectionState getState() {
        return this.state;
    }

    public void connect(String wsUrl, String postUrl) {
        this.checkIfCalledOnValidThread();
        if (this.state != WebSocketConnectionState.NEW) {
            LogUtils.ELog((String)TAG, (String)"WebSocket is already connected.");
            return;
        }
        this.wsServerUrl = wsUrl;
        this.postServerUrl = postUrl;
        this.closeEvent = false;
        LogUtils.DLog((String)TAG, (String)("Connecting WebSocket to: " + wsUrl + ". Post URL: " + postUrl));
        this.ws = new WebSocketConnection();
        WebSocketObserver wsObserver = new WebSocketObserver();
        try {
            this.ws.connect(new URI(this.wsServerUrl), wsObserver);
        }
        catch (URISyntaxException e) {
            this.reportError("URI error: " + e.getMessage());
        }
        catch (WebSocketException e) {
            this.reportError("WebSocket connection error: " + e.getMessage());
        }
    }

    public void register(String roomID, String clientID) {
        this.checkIfCalledOnValidThread();
        this.roomID = roomID;
        this.clientID = clientID;
        if (this.state != WebSocketConnectionState.CONNECTED) {
            LogUtils.WLog((String)TAG, (String)("WebSocket register() in state " + (Object)((Object)this.state)));
            return;
        }
        LogUtils.DLog((String)TAG, (String)("Registering WebSocket for room " + roomID + ". ClientID: " + clientID));
        JSONObject json = new JSONObject();
        try {
            json.put("cmd", (Object)"register");
            json.put("roomid", (Object)roomID);
            json.put("clientid", (Object)clientID);
            LogUtils.DLog((String)TAG, (String)("C->WSS: " + json.toString()));
            this.ws.sendTextMessage(json.toString());
            this.state = WebSocketConnectionState.REGISTERED;
            for (String sendMessage : this.wsSendQueue) {
                this.send(sendMessage);
            }
            this.wsSendQueue.clear();
        }
        catch (JSONException e) {
            this.reportError("WebSocket register JSON error: " + e.getMessage());
        }
    }

    public void send(String message) {
        this.checkIfCalledOnValidThread();
        switch (this.state) {
            case NEW: 
            case CONNECTED: {
                LogUtils.DLog((String)TAG, (String)("WS ACC: " + message));
                this.wsSendQueue.add(message);
                return;
            }
            case ERROR: 
            case CLOSED: {
                LogUtils.ELog((String)TAG, (String)("WebSocket send() in error or closed state : " + message));
                return;
            }
            case REGISTERED: {
                JSONObject json = new JSONObject();
                try {
                    json.put("cmd", (Object)"send");
                    json.put("msg", (Object)message);
                    message = json.toString();
                    LogUtils.DLog((String)TAG, (String)("C->WSS: " + message));
                    this.ws.sendTextMessage(message);
                    break;
                }
                catch (JSONException e) {
                    this.reportError("WebSocket send JSON error: " + e.getMessage());
                }
            }
        }
    }

    public void post(String message) {
        this.checkIfCalledOnValidThread();
        this.sendWSSMessage("POST", message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(boolean waitForComplete) {
        this.checkIfCalledOnValidThread();
        LogUtils.DLog((String)TAG, (String)("Disconnect WebSocket. State: " + (Object)((Object)this.state)));
        if (this.state == WebSocketConnectionState.REGISTERED) {
            this.send("{\"type\": \"bye\"}");
            this.state = WebSocketConnectionState.CONNECTED;
            this.sendWSSMessage("DELETE", "");
        }
        if (this.state == WebSocketConnectionState.CONNECTED || this.state == WebSocketConnectionState.ERROR) {
            this.ws.disconnect();
            this.state = WebSocketConnectionState.CLOSED;
            if (waitForComplete) {
                Object object = this.closeEventLock;
                synchronized (object) {
                    while (!this.closeEvent) {
                        try {
                            this.closeEventLock.wait(1000L);
                            break;
                        }
                        catch (InterruptedException e) {
                            LogUtils.ELog((String)TAG, (String)("Wait error: " + e.toString()));
                        }
                    }
                }
            }
        }
        LogUtils.DLog((String)TAG, (String)"Disconnecting WebSocket done.");
    }

    private void reportError(final String errorMessage) {
        LogUtils.ELog((String)TAG, (String)errorMessage);
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                if (WebSocketChannelClient.this.state != WebSocketConnectionState.ERROR) {
                    WebSocketChannelClient.this.state = WebSocketConnectionState.ERROR;
                    WebSocketChannelClient.this.events.onWebSocketError(errorMessage);
                }
            }
        });
    }

    private void sendWSSMessage(final String method, String message) {
        String postUrl = this.postServerUrl + "/" + this.roomID + "/" + this.clientID;
        LogUtils.DLog((String)TAG, (String)("WS " + method + " : " + postUrl + " : " + message));
        AsyncHttpURLConnection httpConnection = new AsyncHttpURLConnection(method, postUrl, message, new AsyncHttpURLConnection.AsyncHttpEvents(){

            @Override
            public void onHttpError(String errorMessage) {
                WebSocketChannelClient.this.reportError("WS " + method + " error: " + errorMessage);
            }

            @Override
            public void onHttpComplete(String response) {
            }
        });
        httpConnection.send();
    }

    private void checkIfCalledOnValidThread() {
        if (Thread.currentThread() != this.handler.getLooper().getThread()) {
            throw new IllegalStateException("WebSocket method is not called on valid thread");
        }
    }

    private class WebSocketObserver
    implements WebSocket.WebSocketConnectionObserver {
        private WebSocketObserver() {
        }

        @Override
        public void onOpen() {
            LogUtils.DLog((String)WebSocketChannelClient.TAG, (String)("WebSocket connection opened to: " + WebSocketChannelClient.this.wsServerUrl));
            WebSocketChannelClient.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    WebSocketChannelClient.this.state = WebSocketConnectionState.CONNECTED;
                    if (WebSocketChannelClient.this.roomID != null && WebSocketChannelClient.this.clientID != null) {
                        WebSocketChannelClient.this.register(WebSocketChannelClient.this.roomID, WebSocketChannelClient.this.clientID);
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onClose(WebSocket.WebSocketConnectionObserver.WebSocketCloseNotification code, String reason) {
            LogUtils.DLog((String)WebSocketChannelClient.TAG, (String)("WebSocket connection closed. Code: " + (Object)((Object)code) + ". Reason: " + reason + ". State: " + (Object)((Object)WebSocketChannelClient.this.state)));
            Object object = WebSocketChannelClient.this.closeEventLock;
            synchronized (object) {
                WebSocketChannelClient.this.closeEvent = true;
                WebSocketChannelClient.this.closeEventLock.notify();
            }
            WebSocketChannelClient.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    if (WebSocketChannelClient.this.state != WebSocketConnectionState.CLOSED) {
                        WebSocketChannelClient.this.state = WebSocketConnectionState.CLOSED;
                        WebSocketChannelClient.this.events.onWebSocketClose();
                    }
                }
            });
        }

        @Override
        public void onTextMessage(String payload) {
            LogUtils.DLog((String)WebSocketChannelClient.TAG, (String)("WSS->C: " + payload));
            final String message = payload;
            WebSocketChannelClient.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    if (WebSocketChannelClient.this.state == WebSocketConnectionState.CONNECTED || WebSocketChannelClient.this.state == WebSocketConnectionState.REGISTERED) {
                        WebSocketChannelClient.this.events.onWebSocketMessage(message);
                    }
                }
            });
        }

        @Override
        public void onRawTextMessage(byte[] payload) {
        }

        @Override
        public void onBinaryMessage(byte[] payload) {
        }

        @Override
        public void onError(Exception e) {
        }
    }

    public static interface WebSocketChannelEvents {
        public void onWebSocketMessage(String var1);

        public void onWebSocketClose();

        public void onWebSocketError(String var1);
    }

    public static enum WebSocketConnectionState {
        NEW,
        CONNECTED,
        REGISTERED,
        CLOSED,
        ERROR;

    }
}

