/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.business.webrtc.janusclientapi;

import android.os.Handler;
import android.os.HandlerThread;
import com.xdja.poc.common.utils.GlobalContext;
import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.IJanusMessageObserver;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.IJanusMessenger;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.JanusMessengerType;
import com.xdja.poc.sdk.utils.Utils;
import de.tavendo.autobahn.WebSocket;
import de.tavendo.autobahn.WebSocketConnection;
import de.tavendo.autobahn.WebSocketException;
import de.tavendo.autobahn.WebSocketOptions;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import org.json.JSONException;
import org.json.JSONObject;

public class JanusWebSocketClient
implements IJanusMessenger {
    private static final String TAG = "JanusWebSocketClient";
    public static final int NETWORK_ERROR = -1;
    public static final int INTERNAL_ERROR = -2;
    public static final int JSON_ERROR = -3;
    public static final int TOKEN_ERROR = -4;
    private final Handler handler;
    private final IJanusMessageObserver eventHandler;
    private final String uri;
    private WebSocketConnection ws;
    private WebSocketObserver wsObserver;
    private final JanusMessengerType type = JanusMessengerType.websocket;

    public JanusWebSocketClient(String uri, IJanusMessageObserver events) {
        this.eventHandler = events;
        this.uri = uri;
        HandlerThread handlerThread = new HandlerThread(TAG);
        handlerThread.start();
        this.handler = new Handler(handlerThread.getLooper());
    }

    private void reportError(final int err, final String errorMessage) {
        LogUtils.ELog((String)TAG, (String)errorMessage);
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                JanusWebSocketClient.this.eventHandler.onError(err, errorMessage);
            }
        });
    }

    @Override
    public void connect() {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                try {
                    JanusWebSocketClient.this.checkIfCalledOnValidThread();
                    JanusWebSocketClient.this.ws = new WebSocketConnection(GlobalContext.getContext());
                    JanusWebSocketClient.this.wsObserver = new WebSocketObserver();
                    JanusWebSocketClient.this.ws.connect(new URI(JanusWebSocketClient.this.uri), new String[]{"janus-protocol"}, JanusWebSocketClient.this.wsObserver, new WebSocketOptions());
                }
                catch (URISyntaxException e) {
                    JanusWebSocketClient.this.reportError(-1, "URI error: " + e.getMessage());
                }
                catch (WebSocketException e) {
                    JanusWebSocketClient.this.reportError(-1, "WebSocket connection error: " + e.getMessage());
                }
                catch (IllegalStateException e) {
                    JanusWebSocketClient.this.reportError(-1, "current thread not equals handler thread" + e.getMessage());
                }
            }
        });
    }

    @Override
    public void disconnect() {
        try {
            this.checkIfCalledOnValidThread();
            if (this.ws != null) {
                this.ws.disconnect();
            }
        }
        catch (Exception e) {
            this.reportError(-2, "current thread not equals handler thread" + e.getMessage());
        }
    }

    @Override
    public void sendMessage(String message) {
        try {
            JSONObject obj = new JSONObject(message);
            obj.put("token", (Object)Utils.genToken(message));
            message = obj.toString();
            LogUtils.DLog((String)TAG, (String)("sendMessage ---with token :" + message));
            this.ws.sendTextMessage(message);
        }
        catch (JSONException e) {
            this.reportError(-3, "json is wrong");
            e.printStackTrace();
        }
    }

    @Override
    public void sendMessage(String message, BigInteger session_id) {
        this.sendMessage(message);
    }

    @Override
    public void sendMessage(String message, BigInteger session_id, BigInteger handle_id) {
        this.sendMessage(message);
    }

    @Override
    public void receivedMessage(String message) {
        LogUtils.DLog((String)TAG, (String)("receivedMessage  message :" + message));
        try {
            JSONObject obj = new JSONObject(message);
            this.eventHandler.receivedNewMessage(obj);
        }
        catch (Exception ex) {
            this.eventHandler.onError(-3, ex.getMessage());
        }
    }

    @Override
    public JanusMessengerType getMessengerType() {
        return this.type;
    }

    private void checkIfCalledOnValidThread() {
        if (Thread.currentThread() != this.handler.getLooper().getThread()) {
            // empty if block
        }
    }

    private class WebSocketObserver
    implements WebSocket.WebSocketConnectionObserver {
        private WebSocketObserver() {
        }

        @Override
        public void onOpen() {
            LogUtils.DLog((String)JanusWebSocketClient.TAG, (String)"WebSocket connection opened---");
            JanusWebSocketClient.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    JanusWebSocketClient.this.eventHandler.onOpen();
                }
            });
        }

        @Override
        public void onClose(WebSocket.WebSocketConnectionObserver.WebSocketCloseNotification webSocketCloseNotification, String s) {
            LogUtils.DLog((String)JanusWebSocketClient.TAG, (String)("WebSocketObserver WebSocket " + s));
            JanusWebSocketClient.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    JanusWebSocketClient.this.eventHandler.onClose();
                }
            });
        }

        @Override
        public void onTextMessage(String payload) {
            LogUtils.DLog((String)JanusWebSocketClient.TAG, (String)("WebSocketObserver onTextMessage " + payload));
            final String message = payload;
            JanusWebSocketClient.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    JanusWebSocketClient.this.receivedMessage(message);
                }
            });
        }

        @Override
        public void onRawTextMessage(byte[] bytes) {
        }

        @Override
        public void onBinaryMessage(byte[] bytes) {
        }

        @Override
        public void onError(Exception e) {
            JanusWebSocketClient.this.eventHandler.onError(-1, e.getMessage());
        }
    }
}

