/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.record.fdfs;

import android.os.Binder;
import android.os.IBinder;
import android.support.annotation.Keep;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.SparseArray;
import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.sdk.config.Constants;
import com.xdja.poc.sdk.record.fdfs.BaseCoreService;
import com.xdja.poc.sdk.record.fdfs.IFdfsService;
import com.xdja.poc.sdk.record.fdfs.ThreadPoolManager;
import com.xdja.poc.sdk.record.fdfs.UploadItem;
import com.xdja.poc.sdk.record.http.HttpClientFactory;
import com.xdja.poc.sdk.record.http.HttpRequest;
import com.xdja.poc.sdk.record.http.HttpUploadFileRequest;
import com.xdja.poc.sdk.record.http.HttpsUtils;
import com.xdja.poc.sdk.record.http.IHttpClient;
import com.xdja.poc.sdk.utils.IPHost;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Calendar;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;

@Keep
public class FdfsService
extends BaseCoreService {
    private static final String TAG = FdfsService.class.getSimpleName();
    public static final String SERVERTIMESTAMP = "server_timestamp";
    public static final String BOOTTIMESTAMP = "boot_timestamp";
    public static final long DEFAULT_BLOCK_SIZE = 0x800000L;
    private static final String HEADER_FILENAME = "filename";
    private static final String HEADER_PERM = "perm";
    private static final String HEADER_FILESIZE = "filesize";
    private static final String HEADER_FILEID = "fileid";
    public static final String PARAM_USERID = "userid=";
    public static final String PARAM_TS = "ts=";
    public static final String PARAM_SIGN = "sign=";
    public static final String PARAM_TYPE = "mvdp=";
    public static final String PARAM_MARK = "&";
    public static final int E_GET_INFO_ERROR = 3;
    private FdfsUploadBinder binder;
    private IHttpClient httpClient;
    private Map<Long, UploadData> uploadDataMap;
    private SparseArray<UploadData> uploadingCacheDataMap;
    private IHttpClient.UploadFileCallback uploadFileCallback;
    private Gson gson;
    private static final int MAX_UPLOAD_THREAD = 3;
    private Semaphore semaphore;
    public static final int UPLOAD_SUCCESS = 0;
    public static final int UPLOAD_E_PATH_EMPTY = -1;
    public static final int UPLOAD_E_FILE_NOT_EXISTS = -2;
    public static final int UPLOAD_E_INTERRUPTED = -3;
    private static final int OP_PROGRESS = 1;
    private static final int OP_SUCCESS = 2;
    private static final int OP_FAILED = 3;

    @Override
    public void onCreate() {
        super.onCreate();
        this.binder = new FdfsUploadBinder();
        this.httpClient = HttpClientFactory.createHttpClient();
        this.uploadDataMap = new ConcurrentHashMap<Long, UploadData>();
        this.uploadFileCallback = new UploadFileCallback();
        this.uploadingCacheDataMap = new SparseArray();
        this.semaphore = new Semaphore(3);
        this.gson = new Gson();
    }

    private int uploadInner(long uploadId, String filePath, String fileId, UploadCallback callback) {
        try {
            ThreadPoolManager.getInstance().execute(new UploadTask(uploadId, filePath, fileId, callback));
        }
        catch (RejectedExecutionException e) {
            e.printStackTrace();
            LogUtils.DLog((String)TAG, (String)("uploadInner: error: " + e));
        }
        return 0;
    }

    private void getLastUploadSize(final UploadData data) {
        final UploadItem uploadItem = data.uploadItem;
        HttpRequest request = new HttpRequest(IPHost.getFastDfsUrl() + "/info/" + uploadItem.getFileId());
        request.setMethod("GET");
        this.httpClient.request(request, new IHttpClient.Callback(){

            @Override
            public void onSuccess(int requestId, String response) {
                LogUtils.DLog((String)TAG, (String)("getLastUploadSize: onSuccess:" + response));
                FdfsResponse fdfsResponse = (FdfsResponse)FdfsService.this.gson.fromJson(response, FdfsResponse.class);
                if (fdfsResponse.size == uploadItem.getSize()) {
                    uploadItem.setStatus(5);
                    FdfsService.this.semaphore.release();
                    if (data.uploadCallback != null) {
                        data.uploadCallback.onSuccess(uploadItem.getId(), fdfsResponse.getFileId());
                    }
                } else {
                    FdfsService.this.realUpload(uploadItem, fdfsResponse.size);
                }
            }

            @Override
            public void onFailed(int requestId, int code, String msg) {
                LogUtils.ELog((String)TAG, (String)("getLastUploadSize: onFailed: requestId: " + requestId + ", code: " + code + ", msg: " + msg));
                UploadData data2 = (UploadData)FdfsService.this.uploadDataMap.get(uploadItem.getId());
                FdfsService.this.semaphore.release();
                if (data2 != null && data2.uploadCallback != null) {
                    data2.uploadCallback.onError(uploadItem.getId(), 3);
                }
            }
        });
    }

    private void realUpload(UploadItem uploadItem, long lastUploadSize) {
        block6: {
            StringBuilder sb = new StringBuilder(IPHost.getFastDfsUrl() + "/trunkupload");
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(System.currentTimeMillis());
            calendar.add(12, 10);
            long timeStamp = calendar.getTimeInMillis();
            String originalStr = IPHost.getFastDfsAppId() + timeStamp;
            String sign = HttpsUtils.getSignature(IPHost.getFastDfsSecret(), originalStr);
            sb.append("?userid=").append(IPHost.getFastDfsAppId()).append("&ts=").append(timeStamp).append("&sign=").append(sign);
            String url = sb.toString();
            String filePath = uploadItem.getFilePath();
            File file = new File(filePath);
            HttpUploadFileRequest request = new HttpUploadFileRequest(url, filePath);
            request.setLastUploadSize(lastUploadSize);
            request.setBlockSize(0x800000L);
            ArrayMap headers = new ArrayMap();
            try {
                String fileName = file.getName();
                if (fileName.length() > 256) {
                    fileName = fileName.substring(0, 256);
                }
                headers.put(HEADER_FILENAME, URLEncoder.encode(fileName, "UTF-8"));
                headers.put(HEADER_PERM, "1");
                headers.put(HEADER_FILESIZE, String.valueOf(file.length()));
                if (!TextUtils.isEmpty((CharSequence)uploadItem.getFileId())) {
                    headers.put(HEADER_FILEID, uploadItem.getFileId());
                }
                request.setHeaders((Map<String, String>)headers);
                LogUtils.DLog((String)TAG, (String)("realUpload: uploadId: " + uploadItem.getId()));
                UploadData data = this.uploadDataMap.get(uploadItem.getId());
                uploadItem.setStatus(1);
                int requestId = this.httpClient.uploadFile(request, this.uploadFileCallback);
                if (data == null) {
                    LogUtils.ELog((String)TAG, (String)"realUpload: data is null");
                } else {
                    data.requestId = requestId;
                }
                LogUtils.DLog((String)TAG, (String)("requestId: " + requestId));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                UploadData data = this.uploadDataMap.get(uploadItem.getId());
                this.semaphore.release();
                if (data.uploadCallback == null) break block6;
                data.uploadCallback.onError(uploadItem.getId(), -1);
            }
        }
    }

    private void handleUploadFileCallback(int op, int requestId, String ... params) {
        UploadData data = (UploadData)this.uploadingCacheDataMap.get(requestId);
        if (data == null) {
            data = this.findUploadDataByRequestId(requestId);
            this.uploadingCacheDataMap.put(requestId, (Object)data);
        }
        if (data == null) {
            return;
        }
        if (data.uploadItem.getStatus() == 2 && op == 1) {
            this.uploadingCacheDataMap.delete(requestId);
            LogUtils.DLog((String)TAG, (String)("handleUploadFileCallback: requestId: " + requestId + " canceled"));
            return;
        }
        if (op == 1) {
            this.handleUploadProgress(data.uploadItem, data.uploadCallback, Long.parseLong(params[0]), Long.parseLong(params[1]));
        } else if (op == 2) {
            this.uploadingCacheDataMap.delete(requestId);
            this.handleUploadSuccess(data.uploadItem, data.uploadCallback, params[0]);
        } else if (op == 3) {
            this.uploadingCacheDataMap.delete(requestId);
            this.handleUploadFailed(data.uploadItem, data.uploadCallback, Integer.parseInt(params[0]), params[1]);
        }
    }

    private void handleUploadFailed(UploadItem uploadItem, UploadCallback callback, int errorCode, String msg) {
        LogUtils.ELog((String)TAG, (String)("onFailed: code: " + errorCode + ", msg: " + msg));
        uploadItem.setStatus(4);
        this.semaphore.release();
        if (callback != null) {
            if (msg != null && msg.contains(Constants.URL_TIMESTAMP_OVER_DEADLINE)) {
                errorCode = Constants.CODE_UPLOAD_FILE_TIME_EXCEPTION;
            }
            callback.onError(uploadItem.getId(), errorCode);
        }
    }

    private void handleUploadSuccess(UploadItem uploadItem, UploadCallback callback, String response) {
        boolean uploadFinish;
        LogUtils.DLog((String)TAG, (String)("handleUploadSuccess: " + response));
        FdfsResponse fdfsResponse = (FdfsResponse)this.gson.fromJson(response, FdfsResponse.class);
        uploadItem.setFileId(fdfsResponse.getFileId());
        uploadItem.setUploadSize(fdfsResponse.size);
        int lastStatus = uploadItem.getStatus();
        boolean bl = uploadFinish = uploadItem.getSize() == uploadItem.getUploadSize();
        if (lastStatus == 2) {
            uploadItem.setStatus(3);
        } else if (uploadFinish) {
            uploadItem.setStatus(5);
        }
        if (lastStatus == 1) {
            if (uploadFinish) {
                this.semaphore.release();
                if (callback != null) {
                    callback.onSuccess(uploadItem.getId(), uploadItem.getFileId());
                }
            } else {
                this.realUpload(uploadItem, uploadItem.getUploadSize());
            }
        }
    }

    private void handleUploadProgress(UploadItem uploadItem, UploadCallback callback, long uploadSize, long totalSize) {
        LogUtils.DLog((String)TAG, (String)("handleUploadProgress: uploadSize: " + uploadSize + ", totalSize: " + totalSize));
        uploadItem.setUploadSize(uploadSize);
        if (callback != null) {
            callback.onProgress(uploadItem.getId(), uploadSize, totalSize);
        }
    }

    private UploadData findUploadDataByRequestId(int requestId) {
        for (Map.Entry<Long, UploadData> longUploadDataEntry : this.uploadDataMap.entrySet()) {
            UploadData data = longUploadDataEntry.getValue();
            if (data.requestId != requestId) continue;
            return data;
        }
        return null;
    }

    private void stopInner(long uploadId) {
        LogUtils.DLog((String)TAG, (String)("stopInner: uploadId: " + uploadId));
        UploadData data = this.uploadDataMap.get(uploadId);
        if (data == null) {
            LogUtils.ELog((String)TAG, (String)("stopInner: uploadId: " + uploadId + " data is null"));
            return;
        }
        data.uploadItem.setStatus(2);
        this.httpClient.cancelRequest(data.requestId);
    }

    @Override
    public IBinder getBinder() {
        return this.binder;
    }

    @Keep
    private class FdfsResponse {
        private long size;
        @SerializedName(value="fileid")
        private String fileId;

        private FdfsResponse() {
        }

        public String getFileId() {
            if (!TextUtils.isEmpty((CharSequence)this.fileId)) {
                return this.fileId.replace("\\", "").replace("}", "").replace("\"", "");
            }
            return this.fileId;
        }
    }

    private class UploadData {
        private UploadItem uploadItem;
        private UploadCallback uploadCallback;
        private int requestId;

        public UploadData(UploadItem uploadItem, UploadCallback uploadCallback) {
            this.uploadItem = uploadItem;
            this.uploadCallback = uploadCallback;
        }
    }

    public static interface UploadCallback {
        public void onProgress(long var1, long var3, long var5);

        public void onSuccess(long var1, String var3);

        public void onError(long var1, int var3);
    }

    private class UploadFileCallback
    implements IHttpClient.UploadFileCallback {
        private UploadFileCallback() {
        }

        @Override
        public void onProgress(int requestId, long uploadSize, long totalSize) {
            FdfsService.this.handleUploadFileCallback(1, requestId, new String[]{String.valueOf(uploadSize), String.valueOf(totalSize)});
        }

        @Override
        public void onSuccess(int requestId, String response) {
            FdfsService.this.handleUploadFileCallback(2, requestId, new String[]{response});
        }

        @Override
        public void onFailed(int requestId, int code, String msg) {
            FdfsService.this.handleUploadFileCallback(3, requestId, new String[]{String.valueOf(code), msg});
        }
    }

    private class UploadTask
    implements Runnable {
        private long uploadId;
        private String filePath;
        private String fileId;
        private UploadCallback callback;

        public UploadTask(long uploadId, String filePath, String fileId, UploadCallback callback) {
            this.uploadId = uploadId;
            this.filePath = filePath;
            this.fileId = fileId;
            this.callback = callback;
        }

        @Override
        public void run() {
            try {
                if (TextUtils.isEmpty((CharSequence)this.filePath)) {
                    LogUtils.DLog((String)TAG, (String)"UploadTask: filePath is empty");
                    this.sendErrorMessage(-1);
                    return;
                }
                File file = new File(this.filePath);
                if (!file.exists()) {
                    LogUtils.DLog((String)TAG, (String)"UploadTask: file not found");
                    this.sendErrorMessage(-2);
                    return;
                }
                FdfsService.this.semaphore.acquire();
                UploadItem uploadItem = new UploadItem(this.filePath, file.length());
                uploadItem.setId(this.uploadId);
                UploadData uploadData = new UploadData(uploadItem, this.callback);
                FdfsService.this.uploadDataMap.put(this.uploadId, uploadData);
                LogUtils.DLog((String)TAG, (String)("UploadTask: uploadId: " + uploadItem.getId() + ", filePath: " + this.filePath));
                if (TextUtils.isEmpty((CharSequence)this.fileId)) {
                    FdfsService.this.realUpload(uploadItem, 0L);
                } else {
                    FdfsService.this.getLastUploadSize(uploadData);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                this.sendErrorMessage(-3);
            }
        }

        private void sendErrorMessage(int code) {
            if (this.callback != null) {
                this.callback.onError(this.uploadId, code);
            }
        }
    }

    private class FdfsUploadBinder
    extends Binder
    implements IFdfsService {
        private FdfsUploadBinder() {
        }

        @Override
        public int upload(long uploadId, String filePath, UploadCallback callback) {
            return FdfsService.this.uploadInner(uploadId, filePath, null, callback);
        }

        @Override
        public int upload(long uploadId, String filePath, String fileId, UploadCallback callback) {
            return FdfsService.this.uploadInner(uploadId, filePath, fileId, callback);
        }

        @Override
        public void stopUpload(long uploadId) {
            FdfsService.this.stopInner(uploadId);
        }
    }
}

