/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.record.http;

import android.support.annotation.Nullable;
import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.sdk.record.http.IHttpClient;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;

public class UploadFileRequestBody
extends RequestBody {
    private static final String TAG = UploadFileRequestBody.class.getSimpleName();
    private static final int DEFAULT_READ_LENGTH = 53248;
    private IHttpClient.UploadFileCallback callback;
    private File file;
    private long fileSize;
    private long endIndex;
    private volatile boolean canceled;
    private long writeLength;
    private int requestId;
    private long trunkLength;

    public UploadFileRequestBody(int requestId, File file, long startIndex, long blockSize, IHttpClient.UploadFileCallback callback) {
        this.requestId = requestId;
        this.callback = callback;
        this.file = file;
        this.fileSize = file.length();
        this.writeLength = startIndex;
        long blockIndex = startIndex + blockSize;
        this.endIndex = Math.min(blockIndex, this.fileSize);
        this.trunkLength = this.getTrunkLength(startIndex, blockSize, this.fileSize);
        LogUtils.DLog((String)TAG, (String)("UploadFileRequestBody: startIndex: " + startIndex + ", blockSize: " + blockSize + ", endIndex: " + this.endIndex));
    }

    @Nullable
    public MediaType contentType() {
        return MediaType.parse((String)"application/octet-stream");
    }

    public long contentLength() throws IOException {
        return this.trunkLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(BufferedSink sink) throws IOException {
        BufferedInputStream bis = null;
        try {
            int readLength;
            bis = new BufferedInputStream(new FileInputStream(this.file));
            bis.skip(this.writeLength);
            byte[] bytes = new byte[53248];
            int shouldReadLength = 53248;
            while (this.writeLength < this.endIndex && (readLength = bis.read(bytes, 0, shouldReadLength)) > 0) {
                sink.buffer().write(bytes, 0, readLength);
                sink.flush();
                this.writeLength += (long)readLength;
                if (this.callback != null) {
                    this.callback.onProgress(this.requestId, this.writeLength, this.fileSize);
                }
                if (this.canceled) {
                    LogUtils.DLog((String)TAG, (String)"writeTo: canceled upload");
                    break;
                }
                shouldReadLength = (int)Math.min(this.endIndex - this.writeLength, 53248L);
            }
        }
        catch (Exception e) {
            LogUtils.ELog((String)TAG, (String)("writeTo: error: " + e));
            e.printStackTrace();
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (Exception e) {
                    LogUtils.ELog((String)TAG, (String)("writeTo: closeFileError: " + e));
                    e.printStackTrace();
                }
            }
        }
    }

    public void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    private long getTrunkLength(long startIndex, long blockSize, long fileSize) {
        if (fileSize < blockSize) {
            return fileSize;
        }
        long difference = fileSize - startIndex;
        if (difference >= blockSize) {
            return blockSize;
        }
        return difference;
    }
}

