/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.ui.conversion;

import android.annotation.SuppressLint;
import android.app.KeyguardManager;
import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.PowerManager;
import com.xdja.poc.common.base.BaseActivity;
import com.xdja.poc.sdk.config.Constants;
import com.xdja.poc.sdk.manager.ScreenObserverManager;

public abstract class BaseScreenActivity
extends BaseActivity
implements ScreenObserverManager.OnScreenStateUpdateListener,
SensorEventListener {
    private static final String TAG = BaseScreenActivity.class.getSimpleName();
    protected PowerManager.WakeLock wakeLock;
    protected SensorManager sensorManager;
    protected KeyguardManager keyguardManager;
    protected Sensor mSensor;
    protected boolean isInLockScreen = false;
    private ScreenObserverManager mScreenObserverManager;

    protected void initView() {
        this.init();
    }

    public void init() {
        PowerManager mPowerManager = (PowerManager)this.getSystemService("power");
        assert (mPowerManager != null);
        this.wakeLock = mPowerManager.newWakeLock(0x1000000A, TAG);
        this.sensorManager = (SensorManager)this.getSystemService("sensor");
        assert (this.sensorManager != null);
        this.mSensor = this.sensorManager.getDefaultSensor(8);
        this.keyguardManager = (KeyguardManager)this.getSystemService("keyguard");
        this.updateWindowFlags();
        this.mScreenObserverManager = new ScreenObserverManager((Context)this);
        this.mScreenObserverManager.register(this);
    }

    private void updateWindowFlags() {
        if (this.keyguardManager.inKeyguardRestrictedInputMode()) {
            this.getWindow().addFlags(0x680000);
            this.isInLockScreen = true;
        } else {
            this.getWindow().clearFlags(0x680000);
            this.isInLockScreen = false;
        }
    }

    protected void onResume() {
        super.onResume();
        if (Constants.isScreenOn) {
            this.screenOn();
        }
    }

    protected void onPause() {
        super.onPause();
        this.screenOff();
    }

    protected void onDestroy() {
        super.onDestroy();
        this.release();
    }

    @SuppressLint(value={"WakelockTimeout"})
    private void screenOn() {
        if (this.wakeLock != null && !this.wakeLock.isHeld()) {
            this.wakeLock.acquire();
        }
        if (this.sensorManager != null) {
            this.sensorManager.registerListener((SensorEventListener)this, this.mSensor, 3);
        }
    }

    private void screenOff() {
        if (this.wakeLock != null && this.wakeLock.isHeld()) {
            this.wakeLock.release();
        }
        if (this.sensorManager != null) {
            this.sensorManager.unregisterListener((SensorEventListener)this);
        }
    }

    public void release() {
        this.screenOff();
        this.wakeLock = null;
        if (this.isInLockScreen) {
            this.updateWindowFlags();
        }
        if (this.mScreenObserverManager != null) {
            this.mScreenObserverManager.unregister(this);
            this.mScreenObserverManager = null;
        }
    }

    @SuppressLint(value={"WakelockTimeout"})
    public void onSensorChanged(SensorEvent event) {
        float[] its = event.values;
        if (its != null && event.sensor.getType() == 8) {
            if ((double)its[0] == 0.0) {
                if (!(this.wakeLock != null && this.wakeLock.isHeld() || this.wakeLock == null)) {
                    this.wakeLock.acquire();
                }
            } else if (!(this.wakeLock != null && this.wakeLock.isHeld() || this.wakeLock == null)) {
                this.wakeLock.setReferenceCounted(false);
                this.wakeLock.release();
            }
        }
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }

    @Override
    public void onScreenOn() {
    }

    @Override
    public void onScreenOff() {
    }

    @Override
    public void onUserPresent() {
    }
}

