/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.ui.history;

import android.content.Context;
import android.graphics.drawable.AnimationDrawable;
import android.support.v4.app.FragmentActivity;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.jude.easyrecyclerview.adapter.BaseViewHolder;
import com.jude.easyrecyclerview.adapter.RecyclerArrayAdapter;
import com.xdja.poc.common.utils.DisplayUtil;
import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.common.utils.PreferenceHelper;
import com.xdja.poc.common.utils.StringUtils;
import com.xdja.poc.common.utils.ToastUtils;
import com.xdja.poc.sdk.R;
import com.xdja.poc.sdk.bean.POCMemberInfo;
import com.xdja.poc.sdk.db.entity.User;
import com.xdja.poc.sdk.proxy.POCUiKitProxyImpl;
import com.xdja.poc.sdk.ui.history.HistoryVoicePlayer;
import com.xdja.poc.sdk.ui.history.POCHistoryMessage;
import com.xdja.poc.sdk.utils.GlideUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class POCHistoryMessageAdapter
extends RecyclerArrayAdapter<POCHistoryMessage> {
    private AnimationDrawable drawAnim;
    private User mCacheUserinfo = null;
    private String upMessageTime;
    private static final int MAX_MESSAGE_TIME_INTERVAL = 120000;
    private int upSelectIndex = -1;
    private ImageView ivLastSelected = null;
    private AppCompatActivity appCompatActivity;
    private int currentPlayPosition = -1;
    private Map<String, POCMemberInfo> pocMemberInfoMap = new HashMap<String, POCMemberInfo>();

    public POCHistoryMessageAdapter(AppCompatActivity activity, Context context, List<POCMemberInfo> pocMemberInfos) {
        super(context);
        this.appCompatActivity = activity;
        this.mCacheUserinfo = POCUiKitProxyImpl.getInstance().getUserInfo();
        Object result = null;
        for (POCMemberInfo info : pocMemberInfos) {
            this.pocMemberInfoMap.put(info.getAccount(), info);
        }
    }

    public BaseViewHolder OnCreateViewHolder(ViewGroup parent, int viewType) {
        return new MessageViewHolder(parent);
    }

    public void OnBindViewHolder(final BaseViewHolder holder, final int position) {
        super.OnBindViewHolder(holder, position);
        if (holder instanceof MessageViewHolder) {
            ((MessageViewHolder)holder).mMineVoiceLayout.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    POCHistoryMessageAdapter.this.restoreVoice(position);
                    POCHistoryMessage pocHistoryMessage = HistoryVoicePlayer.getInstance().getMessage();
                    if (pocHistoryMessage != null && pocHistoryMessage.getFileUrl().equals(((POCHistoryMessage)POCHistoryMessageAdapter.this.getAllData().get(position)).getFileUrl())) {
                        POCHistoryMessageAdapter.this.stopMineAnim((MessageViewHolder)holder, position);
                        return;
                    }
                    POCHistoryMessageAdapter.this.stopAllAnim();
                    HistoryVoicePlayer.getInstance().startPlay((POCHistoryMessage)POCHistoryMessageAdapter.this.getAllData().get(position), new HistoryVoicePlayer.PlayVoiceCallBack(){

                        @Override
                        public void onPlayFailed() {
                            ToastUtils.showToast((String)"\u64ad\u653e\u5931\u8d25");
                            POCHistoryMessageAdapter.this.stopAnim();
                            POCHistoryMessageAdapter.this.ivLastSelected = null;
                        }

                        @Override
                        public void onPlayStart() {
                            POCHistoryMessageAdapter.this.currentPlayPosition = position;
                            ((MessageViewHolder)holder).mMineVoice.setBackground(POCHistoryMessageAdapter.this.getContext().getDrawable(R.drawable.poc_anim_history_record_voice_white));
                            POCHistoryMessageAdapter.this.drawAnim = (AnimationDrawable)((MessageViewHolder)holder).mMineVoice.getBackground();
                            POCHistoryMessageAdapter.this.drawAnim.start();
                            POCHistoryMessageAdapter.this.ivLastSelected = ((MessageViewHolder)holder).mMineVoice;
                        }

                        @Override
                        public void onPlayStop() {
                            POCHistoryMessageAdapter.this.stopMineAnim((MessageViewHolder)holder, position);
                            POCHistoryMessageAdapter.this.ivLastSelected = null;
                        }
                    });
                }
            });
            ((MessageViewHolder)holder).mOtherVoiceLayout.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    POCHistoryMessageAdapter.this.restoreVoice(position);
                    POCHistoryMessage pocHistoryMessage = HistoryVoicePlayer.getInstance().getMessage();
                    if (pocHistoryMessage != null && pocHistoryMessage.getFileUrl().equals(((POCHistoryMessage)POCHistoryMessageAdapter.this.getAllData().get(position)).getFileUrl())) {
                        POCHistoryMessageAdapter.this.stopOtherAnim((MessageViewHolder)holder, position);
                        return;
                    }
                    POCHistoryMessageAdapter.this.stopAllAnim();
                    HistoryVoicePlayer.getInstance().startPlay((POCHistoryMessage)POCHistoryMessageAdapter.this.getAllData().get(position), new HistoryVoicePlayer.PlayVoiceCallBack(){

                        @Override
                        public void onPlayFailed() {
                            POCHistoryMessageAdapter.this.stopOtherAnim((MessageViewHolder)holder, position);
                            ToastUtils.showToast((String)"\u64ad\u653e\u5931\u8d25");
                            ((MessageViewHolder)holder).mOtherVoice.setBackground(POCHistoryMessageAdapter.this.getContext().getDrawable(R.drawable.poc_history_record_voice_blue_3));
                            POCHistoryMessageAdapter.this.ivLastSelected = null;
                        }

                        @Override
                        public void onPlayStart() {
                            POCHistoryMessageAdapter.this.currentPlayPosition = position;
                            ((MessageViewHolder)holder).mOtherVoice.setBackground(POCHistoryMessageAdapter.this.getContext().getDrawable(R.drawable.poc_anim_history_record_voice_blue));
                            POCHistoryMessageAdapter.this.drawAnim = (AnimationDrawable)((MessageViewHolder)holder).mOtherVoice.getBackground();
                            POCHistoryMessageAdapter.this.drawAnim.start();
                            POCHistoryMessageAdapter.this.ivLastSelected = ((MessageViewHolder)holder).mOtherVoice;
                        }

                        @Override
                        public void onPlayStop() {
                            POCHistoryMessageAdapter.this.stopOtherAnim((MessageViewHolder)holder, position);
                            POCHistoryMessageAdapter.this.ivLastSelected = null;
                        }
                    });
                }
            });
        }
    }

    private void stopAllAnim() {
        HistoryVoicePlayer.getInstance().releasePlay();
        HistoryVoicePlayer.getInstance().resetMessage();
    }

    private void stopMineAnim(MessageViewHolder holder, int position) {
        this.stopAnim();
        holder.mMineVoice.setBackground(this.getContext().getDrawable(R.drawable.poc_history_record_voice_white_3));
        HistoryVoicePlayer.getInstance().releasePlay();
        HistoryVoicePlayer.getInstance().resetMessage();
    }

    private void stopOtherAnim(MessageViewHolder holder, int position) {
        this.stopAnim();
        holder.mOtherVoice.setBackground(this.getContext().getDrawable(R.drawable.poc_history_record_voice_blue_3));
        HistoryVoicePlayer.getInstance().releasePlay();
        HistoryVoicePlayer.getInstance().resetMessage();
    }

    private void restoreVoice(int position) {
        if (!HistoryVoicePlayer.getInstance().isDownloading()) {
            this.stopAnim();
            if (position != this.upSelectIndex) {
                this.resetVoiceState(this.ivLastSelected);
            }
            this.upSelectIndex = position;
        }
    }

    private void resetVoiceState(ImageView iv) {
        if (iv == null) {
            return;
        }
        iv.setBackground(this.getContext().getDrawable(R.drawable.poc_history_record_voice_blue_3));
    }

    private POCHistoryMessage stopOtherPlay() {
        if (HistoryVoicePlayer.getInstance().isPlaying()) {
            this.stopAnim();
            return HistoryVoicePlayer.getInstance().getMessage();
        }
        return null;
    }

    private int computeVoiceTime(POCHistoryMessage message) {
        return Integer.valueOf(message.getFileSize()) / 1000 + 1;
    }

    private int computeLayoutWidth(int voiceTime) {
        if (voiceTime > 60) {
            voiceTime = 60;
        }
        if (voiceTime == 0) {
            voiceTime = 1;
        }
        int maxItemWidth = (int)((float)DisplayUtil.getScreenWidth((Context)this.getContext()) * 0.4f);
        return (int)((float)DisplayUtil.dip2px((Context)this.getContext(), (float)64.0f) + (float)maxItemWidth / 60.0f * (float)voiceTime);
    }

    private boolean computeMessageTimeInterval(String currMsgTime) {
        SimpleDateFormat sourceFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.CHINA);
        try {
            Date currMsgDate = sourceFormat.parse(currMsgTime);
            Date upMsgDate = sourceFormat.parse(this.upMessageTime);
            if (currMsgDate.getTime() - upMsgDate.getTime() > 120000L) {
                return true;
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return false;
    }

    private POCMemberInfo transation(String messageAccount) {
        if (this.pocMemberInfoMap == null) {
            return null;
        }
        return this.pocMemberInfoMap.get(messageAccount);
    }

    private String formatTime(String sourceTime) {
        SimpleDateFormat sourceFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.CHINA);
        SimpleDateFormat destFormat = new SimpleDateFormat("HH:mm", Locale.CHINA);
        try {
            Date date = sourceFormat.parse(sourceTime);
            return this.getAppendTime(date) + destFormat.format(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return sourceTime;
        }
    }

    private String getAppendTime(Date messageDate) throws ParseException {
        String append;
        SimpleDateFormat msgDateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.CHINA);
        String msgDateStr = msgDateFormat.format(messageDate);
        Date msgResultDate = msgDateFormat.parse(msgDateStr);
        Date phoneDate = new Date();
        String phoneDateStr = msgDateFormat.format(phoneDate);
        Date phoneResultDate = msgDateFormat.parse(phoneDateStr);
        if (phoneResultDate.getTime() - msgResultDate.getTime() == 0L) {
            append = "";
        } else if (phoneResultDate.getTime() - msgResultDate.getTime() <= 86400000L) {
            append = "\u6628\u5929 ";
        } else {
            SimpleDateFormat resultFormat = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5", Locale.CHINA);
            append = resultFormat.format(msgResultDate) + " ";
        }
        return append;
    }

    public void stopAnim() {
        if (this.drawAnim != null && this.drawAnim.isRunning()) {
            this.drawAnim.stop();
        }
        this.drawAnim = null;
    }

    public class MessageViewHolder
    extends BaseViewHolder<POCHistoryMessage> {
        ImageView mMineIcon;
        ImageView mOtherIcon;
        TextView mMineTime;
        TextView mOtherTime;
        TextView mMineName;
        TextView mOtherName;
        RelativeLayout mMineLayout;
        RelativeLayout mOtherLayout;
        TextView mNotSupportLayout;
        TextView mTime;
        RelativeLayout mMineVoiceLayout;
        RelativeLayout mOtherVoiceLayout;
        ImageView mMineVoice;
        ImageView mOtherVoice;

        public MessageViewHolder(ViewGroup group) {
            super(group, R.layout.poc_item_history_message);
            this.mMineIcon = (ImageView)this.$(R.id.iv_mine_message_icon);
            this.mMineLayout = (RelativeLayout)this.$(R.id.rl_mine);
            this.mMineTime = (TextView)this.$(R.id.tv_mine_message_time);
            this.mMineName = (TextView)this.$(R.id.tv_mine_name);
            this.mMineVoiceLayout = (RelativeLayout)this.$(R.id.rl_mine_voice_bg);
            this.mMineVoice = (ImageView)this.$(R.id.iv_mine_voice);
            this.mOtherIcon = (ImageView)this.$(R.id.iv_other_message_icon);
            this.mOtherLayout = (RelativeLayout)this.$(R.id.rl_other);
            this.mOtherTime = (TextView)this.$(R.id.tv_other_message_time);
            this.mOtherName = (TextView)this.$(R.id.tv_other_name);
            this.mOtherVoiceLayout = (RelativeLayout)this.$(R.id.rl_other_voice_bg);
            this.mOtherVoice = (ImageView)this.$(R.id.iv_other_voice);
            this.mNotSupportLayout = (TextView)this.$(R.id.tv_not_support);
            this.mTime = (TextView)this.$(R.id.iv_interval_time);
        }

        public void setData(POCHistoryMessage message) {
            POCHistoryMessageAdapter.this.upMessageTime = ((POCHistoryMessage)POCHistoryMessageAdapter.this.getItem(this.getDataPosition() > 0 ? this.getDataPosition() - 1 : this.getDataPosition())).getCreateTime();
            String userAccount = POCHistoryMessageAdapter.this.mCacheUserinfo != null ? POCHistoryMessageAdapter.this.mCacheUserinfo.getAccount() : "";
            final String messageAccount = message.owner;
            if (StringUtils.isEmpty((String)messageAccount) || StringUtils.isEmpty((String)userAccount)) {
                this.mNotSupportLayout.setVisibility(0);
                this.mOtherLayout.setVisibility(8);
                this.mMineLayout.setVisibility(8);
                return;
            }
            this.mTime.setText((CharSequence)POCHistoryMessageAdapter.this.formatTime(message.createTime));
            this.mTime.setVisibility(POCHistoryMessageAdapter.this.computeMessageTimeInterval(message.createTime) || this.getDataPosition() == 0 ? 0 : 8);
            if (userAccount.equals(messageAccount)) {
                this.mOtherLayout.setVisibility(8);
                this.mNotSupportLayout.setVisibility(8);
                this.mMineLayout.setVisibility(0);
                final POCMemberInfo transation = POCHistoryMessageAdapter.this.transation(messageAccount);
                this.mMineName.setText((CharSequence)(transation == null ? messageAccount : transation.getName()));
                POCHistoryMessage message1 = HistoryVoicePlayer.getInstance().getMessage();
                if (message1 == null || !message1.getFileUrl().equals(message.getFileUrl())) {
                    this.mMineVoice.setBackground(this.getContext().getDrawable(R.drawable.poc_history_record_voice_white_3));
                } else {
                    if (POCHistoryMessageAdapter.this.drawAnim != null && POCHistoryMessageAdapter.this.drawAnim.isRunning()) {
                        POCHistoryMessageAdapter.this.drawAnim.stop();
                    }
                    this.mMineVoice.setBackground(this.getContext().getDrawable(R.drawable.poc_anim_history_record_voice_white));
                    POCHistoryMessageAdapter.this.drawAnim = (AnimationDrawable)this.mMineVoice.getBackground();
                    POCHistoryMessageAdapter.this.drawAnim.start();
                }
                int voiceTime = POCHistoryMessageAdapter.this.computeVoiceTime(message);
                this.mMineTime.setText((CharSequence)String.format(this.getContext().getString(R.string.poc_history_record_format_time), (voiceTime > 60 ? 60 : voiceTime) + ""));
                RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)this.mMineVoiceLayout.getLayoutParams();
                params.width = POCHistoryMessageAdapter.this.computeLayoutWidth(voiceTime);
                this.mMineVoiceLayout.setLayoutParams((ViewGroup.LayoutParams)params);
                GlideUtils.setImageUseNetWithCircle(this.getContext(), transation == null ? "" : GlideUtils.checkImagePath(transation.getIcon()), this.mMineIcon);
                this.mMineIcon.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        POCMemberInfo memberInfo = new POCMemberInfo();
                        memberInfo.setAccount(PreferenceHelper.getString((String)"login_account", (String)""));
                        memberInfo.setIcon(transation == null ? "" : transation.getIcon());
                        memberInfo.setName(PreferenceHelper.getString((String)"pref_key_userinfo_name", (String)""));
                        POCUiKitProxyImpl.getInstance().notigyUserDetailsClick((FragmentActivity)POCHistoryMessageAdapter.this.appCompatActivity, memberInfo);
                    }
                });
                return;
            }
            this.mMineLayout.setVisibility(8);
            this.mNotSupportLayout.setVisibility(8);
            this.mOtherLayout.setVisibility(0);
            final POCMemberInfo transation = POCHistoryMessageAdapter.this.transation(messageAccount);
            this.mOtherName.setText((CharSequence)(transation == null ? messageAccount : transation.getName()));
            int voiceTime = POCHistoryMessageAdapter.this.computeVoiceTime(message);
            this.mOtherTime.setText((CharSequence)String.format(this.getContext().getString(R.string.poc_history_record_format_time), (voiceTime > 60 ? 60 : voiceTime) + ""));
            RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)this.mOtherVoiceLayout.getLayoutParams();
            params.width = POCHistoryMessageAdapter.this.computeLayoutWidth(voiceTime);
            this.mOtherVoiceLayout.setLayoutParams((ViewGroup.LayoutParams)params);
            GlideUtils.setImageUseNetWithCircle(this.getContext(), transation == null ? "" : GlideUtils.checkImagePath(transation.getIcon()), this.mOtherIcon);
            this.mOtherIcon.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    POCMemberInfo memberInfo = new POCMemberInfo();
                    memberInfo.setAccount(messageAccount);
                    memberInfo.setIcon(transation == null ? "" : GlideUtils.checkImagePath(transation.getIcon()));
                    memberInfo.setName(transation == null ? messageAccount : transation.getName());
                    POCUiKitProxyImpl.getInstance().notigyUserDetailsClick((FragmentActivity)POCHistoryMessageAdapter.this.appCompatActivity, memberInfo);
                }
            });
            POCHistoryMessage message1 = HistoryVoicePlayer.getInstance().getMessage();
            if (message1 == null || !message1.getFileUrl().equals(message.getFileUrl())) {
                this.mOtherVoice.setBackground(this.getContext().getDrawable(R.drawable.poc_history_record_voice_blue_3));
            } else {
                if (POCHistoryMessageAdapter.this.drawAnim != null && POCHistoryMessageAdapter.this.drawAnim.isRunning()) {
                    POCHistoryMessageAdapter.this.drawAnim.stop();
                }
                this.mOtherVoice.setBackground(this.getContext().getDrawable(R.drawable.poc_anim_history_record_voice_blue));
                POCHistoryMessageAdapter.this.drawAnim = (AnimationDrawable)this.mOtherVoice.getBackground();
                POCHistoryMessageAdapter.this.drawAnim.start();
                LogUtils.DLog((String)"wwq", (String)" start anim ");
            }
        }
    }
}

