/*
 * Decompiled with CFR 0.152.
 */
package de.tavendo.autobahn;

import android.support.annotation.NonNull;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class ByteBufferInputStream
extends InputStream {
    private final ByteBuffer mBuffer;

    public ByteBufferInputStream(ByteBuffer buffer) {
        this.mBuffer = buffer;
    }

    @Override
    public synchronized int read() throws IOException {
        return !this.mBuffer.hasRemaining() ? -1 : this.mBuffer.get() & 0xFF;
    }

    @Override
    public synchronized int read(@NonNull byte[] bytes, int off, int len) throws IOException {
        if (bytes == null) {
            throw new NullPointerException();
        }
        if (off >= 0 && len >= 0 && len <= bytes.length - off) {
            if (len == 0) {
                return 0;
            }
            int length = Math.min(this.mBuffer.remaining(), len);
            if (length == 0) {
                return -1;
            }
            this.mBuffer.get(bytes, off, length);
            return length;
        }
        throw new IndexOutOfBoundsException();
    }
}

