/*
 * Decompiled with CFR 0.152.
 */
package de.tavendo.autobahn;

import android.annotation.SuppressLint;
import android.content.Context;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class SSLFactorys {
    private final Context mContext;

    public SSLFactorys(Context context) {
        this.mContext = context;
    }

    public SocketFactory getSSLSocketFactory() {
        try {
            InputStream stream = this.getCertificates("janus.jks");
            CertificateFactory instance = CertificateFactory.getInstance("X.509", "BC");
            Certificate certificate = instance.generateCertificate(stream);
            String defaultType = KeyStore.getDefaultType();
            KeyStore keyStore = KeyStore.getInstance(defaultType);
            keyStore.load(null);
            keyStore.setCertificateEntry("janus", certificate);
            String algorithm = TrustManagerFactory.getDefaultAlgorithm();
            TrustManagerFactory trustFactory = TrustManagerFactory.getInstance(algorithm);
            trustFactory.init(keyStore);
            TrustManager[] trustManagers = trustFactory.getTrustManagers();
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, trustManagers, null);
            return sc.getSocketFactory();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (NoSuchProviderException e) {
            e.printStackTrace();
        }
        return null;
    }

    public SocketFactory getSocketFactory() {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }

                @Override
                @SuppressLint(value={"TrustAllX509TrustManager"})
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                @SuppressLint(value={"TrustAllX509TrustManager"})
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            return sc.getSocketFactory();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
        return null;
    }

    private InputStream getCertificates(String certName) {
        try {
            return this.mContext.getResources().getAssets().open(certName);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

