/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.business.webrtc.janusclientapi;

import com.xdja.poc.sdk.business.webrtc.janusclientapi.IJanusAttachPluginCallbacks;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.IJanusPluginCallbacks;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.ITransactionCallbacks;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.JanusMessageType;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.JanusSupportedPluginPackages;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.TransactionType;
import org.json.JSONException;
import org.json.JSONObject;

public class JanusAttachPluginTransaction
implements ITransactionCallbacks {
    private final IJanusAttachPluginCallbacks callbacks;
    private final JanusSupportedPluginPackages plugin;
    private final IJanusPluginCallbacks pluginCallbacks;

    public JanusAttachPluginTransaction(IJanusAttachPluginCallbacks callbacks, JanusSupportedPluginPackages plugin, IJanusPluginCallbacks pluginCallbacks) {
        this.callbacks = callbacks;
        this.plugin = plugin;
        this.pluginCallbacks = pluginCallbacks;
    }

    @Override
    public TransactionType getTransactionType() {
        return TransactionType.attach;
    }

    @Override
    public void reportSuccess(JSONObject obj) {
        try {
            JanusMessageType type = JanusMessageType.fromString(obj.getString("janus"));
            if (type != JanusMessageType.success) {
                this.callbacks.onCallbackError(obj.getJSONObject("error").getString("reason"));
            } else {
                this.callbacks.attachPluginSuccess(obj, this.plugin, this.pluginCallbacks);
            }
        }
        catch (JSONException ex) {
            this.callbacks.onCallbackError(ex.getMessage());
        }
    }
}

