/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.record.play;

import android.annotation.SuppressLint;
import android.content.Context;
import android.media.AudioManager;
import android.os.Build;
import android.os.PowerManager;
import com.xdja.poc.common.utils.GlobalContext;
import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.sdk.config.Constants;
import com.xdja.poc.sdk.ui.history.HistoryVoicePlayer;

public class MediaManger {
    private static String TAG = "MediaManger";
    private static final int VERSION = Build.VERSION.SDK_INT;
    private AudioManager mAudioManager;
    private PowerManager.WakeLock mWakeLock;
    private boolean isWakeAcquire = false;
    private boolean isReceiverMode = false;
    private boolean isHeadsetOn = false;

    public boolean isReceiverMode() {
        return this.isReceiverMode;
    }

    public void setReceiverMode(boolean receiverMode) {
        this.isReceiverMode = receiverMode;
    }

    @SuppressLint(value={"InlinedApi"})
    private MediaManger() {
        try {
            Context context = GlobalContext.getContext();
            this.mAudioManager = (AudioManager)context.getSystemService("audio");
            if (VERSION >= 21) {
                PowerManager pManager = (PowerManager)context.getSystemService("power");
                this.mWakeLock = pManager.newWakeLock(32, TAG);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static MediaManger getInstance() {
        return SingletonInstance.mInstance;
    }

    public void setHeadsetOn(boolean headsetOn) {
        this.isHeadsetOn = headsetOn;
    }

    public void onSensorChanged(boolean isReceiverMode) {
        if (!HistoryVoicePlayer.getInstance().isPlaying()) {
            if (this.isWakeAcquire) {
                this.wakeLockBrightRelease();
            }
            LogUtils.DLog((String)TAG, (String)"onSensorChanged return");
            return;
        }
        if (isReceiverMode) {
            this.setReceiverModeOn();
        } else {
            this.setReceiverModeOff();
        }
    }

    public boolean isHeadsetOn() {
        return Constants.IS_HEADSET_PLUG || this.mAudioManager.isWiredHeadsetOn();
    }

    public void setReceiverModeOn() {
        this.mAudioManager.setMode(3);
        this.mAudioManager.setSpeakerphoneOn(false);
    }

    public void setReceiverModeOff() {
        this.setSpeakOn();
        this.mAudioManager.setMode(0);
    }

    public void setSpeakOn() {
        if (!this.isHeadsetOn) {
            this.mAudioManager.setSpeakerphoneOn(true);
        }
    }

    public void wakeLockBrightAcquire() {
        if (this.mWakeLock != null && !this.mWakeLock.isHeld()) {
            this.isWakeAcquire = true;
            this.mWakeLock.setReferenceCounted(false);
            this.mWakeLock.acquire(600000L);
        }
    }

    public void wakeLockBrightRelease() {
        if (this.mWakeLock != null && this.mWakeLock.isHeld()) {
            this.isWakeAcquire = false;
            this.mWakeLock.release();
        }
    }

    public void releaseWakeLock() {
        if (this.mWakeLock != null && this.mWakeLock.isHeld()) {
            this.isWakeAcquire = false;
            this.mWakeLock.release();
        }
    }

    public boolean isWakeAcquire() {
        return this.isWakeAcquire;
    }

    private static class SingletonInstance {
        private static final MediaManger mInstance = new MediaManger();

        private SingletonInstance() {
        }
    }
}

