/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.record.play;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.bluetooth.BluetoothAdapter;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Bundle;
import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.common.utils.StringUtils;
import com.xdja.poc.sdk.record.play.IPlayState;
import com.xdja.poc.sdk.record.play.MediaManger;
import com.xdja.poc.sdk.ui.history.HistoryVoicePlayer;

public class ReceiverModeManger
implements SensorEventListener,
Application.ActivityLifecycleCallbacks {
    private String TAG = "ReceiverModeManger";
    private Activity mActivity;
    private float voiceMode = -1.0f;
    private static final int DEFAULT_MODE_CODE = -1;
    private SensorManager mSensorManager;
    private Sensor mSensor;
    private IPlayState iPlayState;
    private BroadcastReceiver headsetPlugReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.intent.action.HEADSET_PLUG".equals(action)) {
                int state = intent.getIntExtra("state", 0);
                if (state == 1) {
                    LogUtils.DLog((String)ReceiverModeManger.this.TAG, (String)"WZ Current HeadSet State : On");
                    MediaManger.getInstance().setHeadsetOn(true);
                    MediaManger.getInstance().setReceiverModeOn();
                } else if (state == 0) {
                    LogUtils.DLog((String)ReceiverModeManger.this.TAG, (String)"WZ Current HeadSet State : Off");
                    MediaManger.getInstance().setHeadsetOn(false);
                    MediaManger.getInstance().setReceiverModeOff();
                }
            } else if (action.equals("android.intent.action.PHONE_STATE")) {
                String state = intent.getStringExtra("state");
                if (StringUtils.isEmpty((String)state)) {
                    return;
                }
                if (state.equals("RINGING") && ReceiverModeManger.this.iPlayState != null) {
                    ReceiverModeManger.this.iPlayState.stop();
                }
            } else if ("android.bluetooth.adapter.action.STATE_CHANGED".equals(action) || "android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED".equals(action)) {
                BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
                int bluetoothState = adapter.getProfileConnectionState(1);
                if (bluetoothState == 0) {
                    LogUtils.DLog((String)ReceiverModeManger.this.TAG, (String)" Current blueteeth State : Off");
                    MediaManger.getInstance().setReceiverModeOff();
                    MediaManger.getInstance().setHeadsetOn(false);
                } else {
                    LogUtils.DLog((String)ReceiverModeManger.this.TAG, (String)" Current blueteeth State : On");
                    MediaManger.getInstance().setReceiverModeOn();
                    MediaManger.getInstance().setHeadsetOn(true);
                }
            }
        }
    };

    public void init(Activity activity, IPlayState playState) {
        this.mActivity = activity;
        this.iPlayState = playState;
        this.mSensorManager = (SensorManager)activity.getSystemService("sensor");
        this.mSensor = this.mSensorManager.getDefaultSensor(8);
        this.mActivity.getApplication().registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        this.initAudioMode(this.mActivity);
    }

    @SuppressLint(value={"NewApi"})
    public void initAudioMode(Activity activity) {
        this.mActivity = activity;
    }

    private void registerSensor() {
        this.mSensorManager.registerListener((SensorEventListener)this, this.mSensor, 3);
    }

    private void unRegisterSensor() {
        this.mSensorManager.unregisterListener((SensorEventListener)this);
    }

    private void registerHeadset() {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.HEADSET_PLUG");
        intentFilter.addAction("android.media.AUDIO_BECOMING_NOISY");
        intentFilter.addAction("android.intent.action.PHONE_STATE");
        intentFilter.addAction("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED");
        intentFilter.addAction("android.bluetooth.adapter.action.STATE_CHANGED");
        this.mActivity.registerReceiver(this.headsetPlugReceiver, intentFilter);
    }

    private void unRegisterHeadset() {
        try {
            this.mActivity.unregisterReceiver(this.headsetPlugReceiver);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean assetActivity(Activity activity) {
        return this.mActivity.getClass().getName().equals(activity.getClass().getName());
    }

    public void onSensorChanged(SensorEvent event) {
        if (this.voiceMode == event.values[0] && HistoryVoicePlayer.getInstance().isPlaying()) {
            return;
        }
        if (MediaManger.getInstance().isHeadsetOn()) {
            if (event.values[0] >= this.mSensor.getMaximumRange()) {
                MediaManger.getInstance().setReceiverMode(false);
                MediaManger.getInstance().onSensorChanged(false);
            }
            MediaManger.getInstance().wakeLockBrightRelease();
            return;
        }
        if (HistoryVoicePlayer.getInstance().isPlaying()) {
            if (event.values[0] >= this.mSensor.getMaximumRange()) {
                MediaManger.getInstance().wakeLockBrightRelease();
            } else {
                MediaManger.getInstance().wakeLockBrightAcquire();
            }
        } else {
            MediaManger.getInstance().wakeLockBrightRelease();
        }
        this.voiceMode = event.values[0];
        if (event.values[0] >= this.mSensor.getMaximumRange()) {
            MediaManger.getInstance().setReceiverMode(false);
            MediaManger.getInstance().onSensorChanged(false);
            LogUtils.DLog((String)this.TAG, (String)"onSensorChanged 111111");
        } else {
            MediaManger.getInstance().setReceiverMode(true);
            MediaManger.getInstance().onSensorChanged(true);
            LogUtils.DLog((String)this.TAG, (String)"onSensorChanged 22222");
        }
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
    }

    public void onActivityStarted(Activity activity) {
    }

    public void onActivityResumed(Activity activity) {
        if (this.assetActivity(activity)) {
            this.registerSensor();
            this.registerHeadset();
        }
    }

    public void onActivityPaused(Activity activity) {
        if (this.assetActivity(activity)) {
            this.unRegisterSensor();
            this.unRegisterHeadset();
            if (this.iPlayState != null) {
                this.iPlayState.stop();
            }
        }
    }

    public void onActivityStopped(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
        if (this.assetActivity(activity)) {
            MediaManger.getInstance().releaseWakeLock();
            this.mActivity.getApplication().unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        }
    }
}

