/*
 * Decompiled with CFR 0.152.
 */
package de.tavendo.autobahn;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Base64;
import com.xdja.poc.common.utils.LogUtils;
import de.tavendo.autobahn.WebSocketException;
import de.tavendo.autobahn.WebSocketMessage;
import de.tavendo.autobahn.WebSocketOptions;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.Random;

public class WebSocketWriter
extends Thread {
    private static final String TAG = WebSocketWriter.class.getCanonicalName();
    private static final int WEB_SOCKETS_VERSION = 13;
    private static final String CRLF = "\r\n";
    private final Random mRandom = new Random();
    private final Handler mWebSocketConnectionHandler;
    private final WebSocketOptions mWebSocketOptions;
    private final ByteBuffer mApplicationBuffer;
    private final Socket mSocket;
    private OutputStream mOutputStream;
    private Handler mHandler;

    public WebSocketWriter(Handler master, Socket socket, WebSocketOptions options, String threadName) {
        super(threadName);
        this.mWebSocketConnectionHandler = master;
        this.mWebSocketOptions = options;
        this.mSocket = socket;
        this.mApplicationBuffer = ByteBuffer.allocate(options.getMaxFramePayloadSize() + 14);
        LogUtils.DLog((String)TAG, (String)"WebSocket writer created.");
    }

    public boolean forward(Object message) {
        if (this.mHandler == null || this.mHandler.getLooper() == null || !this.mHandler.getLooper().getThread().isAlive()) {
            return false;
        }
        Message msg = this.mHandler.obtainMessage();
        msg.obj = message;
        try {
            this.mHandler.sendMessage(msg);
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    private void notify(Object message) {
        Message msg = this.mWebSocketConnectionHandler.obtainMessage();
        msg.obj = message;
        this.mWebSocketConnectionHandler.sendMessage(msg);
    }

    private String newHandshakeKey() {
        byte[] ba = new byte[16];
        this.mRandom.nextBytes(ba);
        return Base64.encodeToString((byte[])ba, (int)2);
    }

    private byte[] newFrameMask() {
        byte[] ba = new byte[4];
        this.mRandom.nextBytes(ba);
        return ba;
    }

    private void sendClientHandshake(WebSocketMessage.ClientHandshake message) throws IOException {
        String query;
        String path = message.getURI().getPath();
        if (path == null || path.length() == 0) {
            path = "/";
        }
        if ((query = message.getURI().getQuery()) != null && query.length() > 0) {
            path = path + "?" + query;
        }
        this.mApplicationBuffer.put(("GET " + path + " HTTP/1.1\r\n").getBytes());
        this.mApplicationBuffer.put(("Host: " + message.getURI().getHost() + CRLF).getBytes());
        this.mApplicationBuffer.put("Upgrade: WebSocket\r\n".getBytes());
        this.mApplicationBuffer.put("Connection: Upgrade\r\n".getBytes());
        this.mApplicationBuffer.put(("Sec-WebSocket-Key: " + this.newHandshakeKey() + CRLF).getBytes());
        this.mApplicationBuffer.put("Origin: https://www.google.com\r\n".getBytes());
        if (message.getSubprotocols() != null && message.getSubprotocols().length > 0) {
            this.mApplicationBuffer.put("Sec-WebSocket-Protocol: ".getBytes());
            for (int i = 0; i < message.getSubprotocols().length; ++i) {
                this.mApplicationBuffer.put(message.getSubprotocols()[i].getBytes());
                this.mApplicationBuffer.put(", ".getBytes());
            }
            this.mApplicationBuffer.put(CRLF.getBytes());
        }
        this.mApplicationBuffer.put("Sec-WebSocket-Version: 13\r\n".getBytes());
        this.mApplicationBuffer.put(CRLF.getBytes());
    }

    private void sendClose(WebSocketMessage.Close message) throws IOException, WebSocketException {
        if (message.getCode() > 0) {
            byte[] payload;
            if (message.getReason() != null && message.getReason().length() <= 0) {
                byte[] pReason = message.getReason().getBytes("UTF-8");
                payload = new byte[2 + pReason.length];
                System.arraycopy(pReason, 0, payload, 2, pReason.length);
            } else {
                payload = new byte[2];
            }
            if (payload.length > 125) {
                throw new WebSocketException("close payload exceeds 125 octets");
            }
            payload[0] = (byte)(message.getCode() >> 8 & 0xFF);
            payload[1] = (byte)(message.getCode() & 0xFF);
            this.sendFrame(8, true, payload);
        } else {
            this.sendFrame(8, true, null);
        }
    }

    private void sendPing(WebSocketMessage.Ping message) throws IOException, WebSocketException {
        if (message.mPayload != null && message.mPayload.length > 125) {
            throw new WebSocketException("ping payload exceeds 125 octets");
        }
        this.sendFrame(9, true, message.mPayload);
    }

    private void sendPong(WebSocketMessage.Pong message) throws IOException, WebSocketException {
        if (message.mPayload != null && message.mPayload.length > 125) {
            throw new WebSocketException("pong payload exceeds 125 octets");
        }
        this.sendFrame(10, true, message.mPayload);
    }

    private void sendBinaryMessage(WebSocketMessage.BinaryMessage message) throws IOException, WebSocketException {
        if (message.mPayload.length > this.mWebSocketOptions.getMaxMessagePayloadSize()) {
            throw new WebSocketException("message payload exceeds payload limit");
        }
        this.sendFrame(2, true, message.mPayload);
    }

    private void sendTextMessage(WebSocketMessage.TextMessage message) throws IOException, WebSocketException {
        byte[] payload = message.mPayload.getBytes("UTF-8");
        if (payload.length > this.mWebSocketOptions.getMaxMessagePayloadSize()) {
            throw new WebSocketException("message payload exceeds payload limit");
        }
        this.sendFrame(1, true, payload);
    }

    private void sendRawTextMessage(WebSocketMessage.RawTextMessage message) throws IOException, WebSocketException {
        if (message.mPayload.length > this.mWebSocketOptions.getMaxMessagePayloadSize()) {
            throw new WebSocketException("message payload exceeds payload limit");
        }
        this.sendFrame(1, true, message.mPayload);
    }

    protected void sendFrame(int opcode, boolean fin, byte[] payload) throws IOException {
        if (payload != null) {
            this.sendFrame(opcode, fin, payload, 0, payload.length);
        } else {
            this.sendFrame(opcode, fin, null, 0, 0);
        }
    }

    protected void sendFrame(int opcode, boolean fin, byte[] payload, int offset, int length) throws IOException {
        long len;
        byte b0 = 0;
        if (fin) {
            b0 = (byte)(b0 | 0xFFFFFF80);
        }
        b0 = (byte)(b0 | (byte)opcode);
        this.mApplicationBuffer.put(b0);
        byte b1 = 0;
        if (this.mWebSocketOptions.getMaskClientFrames()) {
            b1 = -128;
        }
        if ((len = (long)length) <= 125L) {
            b1 = (byte)(b1 | (byte)len);
            this.mApplicationBuffer.put(b1);
        } else if (len <= 65535L) {
            b1 = (byte)(b1 | 0x7E);
            this.mApplicationBuffer.put(b1);
            this.mApplicationBuffer.put(new byte[]{(byte)(len >> 8 & 0xFFL), (byte)(len & 0xFFL)});
        } else {
            b1 = (byte)(b1 | 0x7F);
            this.mApplicationBuffer.put(b1);
            this.mApplicationBuffer.put(new byte[]{(byte)(len >> 56 & 0xFFL), (byte)(len >> 48 & 0xFFL), (byte)(len >> 40 & 0xFFL), (byte)(len >> 32 & 0xFFL), (byte)(len >> 24 & 0xFFL), (byte)(len >> 16 & 0xFFL), (byte)(len >> 8 & 0xFFL), (byte)(len & 0xFFL)});
        }
        byte[] mask = null;
        if (this.mWebSocketOptions.getMaskClientFrames()) {
            mask = this.newFrameMask();
            this.mApplicationBuffer.put(mask[0]);
            this.mApplicationBuffer.put(mask[1]);
            this.mApplicationBuffer.put(mask[2]);
            this.mApplicationBuffer.put(mask[3]);
        }
        if (len > 0L) {
            if (this.mWebSocketOptions.getMaskClientFrames()) {
                int i = 0;
                while ((long)i < len) {
                    assert (mask != null);
                    int n = i + offset;
                    payload[n] = (byte)(payload[n] ^ mask[i % 4]);
                    ++i;
                }
            }
            this.mApplicationBuffer.put(payload, offset, length);
        }
    }

    protected void processMessage(Object msg) throws IOException, WebSocketException {
        if (msg instanceof WebSocketMessage.TextMessage) {
            this.sendTextMessage((WebSocketMessage.TextMessage)msg);
        } else if (msg instanceof WebSocketMessage.RawTextMessage) {
            this.sendRawTextMessage((WebSocketMessage.RawTextMessage)msg);
        } else if (msg instanceof WebSocketMessage.BinaryMessage) {
            this.sendBinaryMessage((WebSocketMessage.BinaryMessage)msg);
        } else if (msg instanceof WebSocketMessage.Ping) {
            this.sendPing((WebSocketMessage.Ping)msg);
        } else if (msg instanceof WebSocketMessage.Pong) {
            this.sendPong((WebSocketMessage.Pong)msg);
        } else if (msg instanceof WebSocketMessage.Close) {
            this.sendClose((WebSocketMessage.Close)msg);
        } else if (msg instanceof WebSocketMessage.ClientHandshake) {
            this.sendClientHandshake((WebSocketMessage.ClientHandshake)msg);
        } else if (msg instanceof WebSocketMessage.Quit) {
            Looper.myLooper().quit();
            LogUtils.DLog((String)TAG, (String)"WebSocket writer ended.");
        } else {
            this.processAppMessage(msg);
        }
    }

    public void writeMessageToBuffer(Message message) {
        try {
            this.mApplicationBuffer.clear();
            this.processMessage(message.obj);
            this.mApplicationBuffer.flip();
            this.mOutputStream.write(this.mApplicationBuffer.array(), this.mApplicationBuffer.position(), this.mApplicationBuffer.limit());
        }
        catch (SocketException var3) {
            LogUtils.ELog((String)TAG, (String)("run() : SocketException (" + var3.toString() + ")"));
            this.mHandler.removeCallbacksAndMessages(null);
            this.notify(new WebSocketMessage.ConnectionLost());
        }
        catch (IOException var4) {
            LogUtils.ELog((String)TAG, (String)("run() : IOException (" + var4.toString() + ")"));
            this.notify(new WebSocketMessage.Error(var4));
        }
        catch (Exception var5) {
            this.notify(new WebSocketMessage.Error(var5));
        }
    }

    protected void processAppMessage(Object msg) throws WebSocketException, IOException {
        throw new WebSocketException("unknown message received by WebSocketWriter");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        OutputStream outputStream = null;
        try {
            outputStream = this.mSocket.getOutputStream();
        }
        catch (IOException var4) {
            LogUtils.ELog((String)TAG, (String)var4.getLocalizedMessage());
        }
        this.mOutputStream = outputStream;
        Looper.prepare();
        this.mHandler = new ThreadHandler(this);
        WebSocketWriter webSocketWriter = this;
        synchronized (webSocketWriter) {
            LogUtils.DLog((String)TAG, (String)"WebSocker writer running.");
            this.notifyAll();
        }
        Looper.loop();
    }

    private static class ThreadHandler
    extends Handler {
        private final WeakReference<WebSocketWriter> mWebSocketWriterReference;

        public ThreadHandler(WebSocketWriter webSocketWriter) {
            this.mWebSocketWriterReference = new WeakReference<WebSocketWriter>(webSocketWriter);
        }

        public void handleMessage(Message message) {
            WebSocketWriter webSocketWriter = (WebSocketWriter)this.mWebSocketWriterReference.get();
            if (webSocketWriter != null) {
                webSocketWriter.writeMessageToBuffer(message);
            }
        }
    }
}

