package com.xdja.poc.sdk.bean;

import android.support.annotation.Keep;

import com.xdja.poc.sdk.config.GroupConfig;

import java.io.Serializable;
import java.util.List;

/**
 * janus-gateway-android-master
 * 功能
 * 描述
 * created by Wwq : 2018/9/4
 */
@SuppressWarnings("ALL")
@Keep
public class GroupList {
    private String result;
    private String errInfo;
    private String errCode;
    private List<GroupData> data;

    public String getResult() {
        return result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public String getErrInfo() {
        return errInfo;
    }

    public void setErrInfo(String errInfo) {
        this.errInfo = errInfo;
    }

    public String getErrCode() {
        return errCode;
    }

    public void setErrCode(String errCode) {
        this.errCode = errCode;
    }

    @Keep
    public static class GroupData implements Serializable {
        private static final long serialVersionUID = 8437973201944598301L;
        private static final String GROUPTYPE_PUTONG = "PuTong";
        private static final String GROUPTYPE_GUDING = "GuDing";
        private String id;//
        private String groupUri;//
        private String owner;//归属
        private String devNo;//设备编号
        private String clientType;//
        private String groupType;//群组类型
        private String displayName;//名称
        private String groupLevel;//群组级别 1 高, 2 中,3 低
        private String maxInviteMembersCount;//最大邀请用户数
        private String maxTalkTime;//最大讲话时长 秒 0为不限制
        private String isHide;//是否隐藏
        private String headPortrait;//头像地址
        private String sign;//签名
        private String createTime;//创建时间
        private String isPassword;//是否密码验证
        private String password;//密码
        private List<GroupMember> talkGroupMembers;//成员列表

        public GroupData() {
        }

        public String getId() {
            return id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getGroupUri() {
            return groupUri;
        }

        public void setGroupUri(String groupUri) {
            this.groupUri = groupUri;
        }

        public String getOwner() {
            return owner;
        }

        public void setOwner(String owner) {
            this.owner = owner;
        }

        public String getDevNo() {
            return devNo;
        }

        public void setDevNo(String devNo) {
            this.devNo = devNo;
        }

        public String getClientType() {
            return clientType;
        }

        public void setClientType(String clientType) {
            this.clientType = clientType;
        }

        public String getGroupType() {
            return groupType;
        }

        public void setGroupType(String groupType) {
            this.groupType = groupType;
        }

        public String getDisplayName() {
            return displayName;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public String getGroupLevel() {
            return groupLevel;
        }

        public void setGroupLevel(String groupLevel) {
            this.groupLevel = groupLevel;
        }

        public String getMaxInviteMembersCount() {
            return maxInviteMembersCount;
        }

        public void setMaxInviteMembersCount(String maxInviteMembersCount) {
            this.maxInviteMembersCount = maxInviteMembersCount;
        }

        public String getMaxTalkTime() {
            return maxTalkTime;
        }

        public void setMaxTalkTime(String maxTalkTime) {
            this.maxTalkTime = maxTalkTime;
        }

        public String getIsHide() {
            return isHide;
        }

        public void setIsHide(String isHide) {
            this.isHide = isHide;
        }

        public String getHeadPortrait() {
            return headPortrait;
        }

        public void setHeadPortrait(String headPortrait) {
            this.headPortrait = headPortrait;
        }

        public String getSign() {
            return sign;
        }

        public void setSign(String sign) {
            this.sign = sign;
        }

        public String getCreateTime() {
            return createTime;
        }

        public void setCreateTime(String createTime) {
            this.createTime = createTime;
        }

        public List<GroupMember> getTalkGroupMembers() {
            return talkGroupMembers;
        }

        public void setTalkGroupMembers(List<GroupMember> talkGroupMembers) {
            this.talkGroupMembers = talkGroupMembers;
        }

        public String getIsPassword() {
            return isPassword;
        }

        public void setIsPassword(String isPassword) {
            this.isPassword = isPassword;
        }

        public String getPassword() {
            return password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        /**
         * 返回数据为String,使用的是int
         * @param type
         * @return
         */
        public int transGroupType(String type){
            switch (type){
                case GROUPTYPE_GUDING:
                    return GroupConfig.GROUP_TYPE_FIXED;
                case GROUPTYPE_PUTONG:
                    return GroupConfig.GROUP_TYPE_COMMON;
            }
            return GroupConfig.GROUP_TYPE_TEMP;
        }
    }

    public static class GroupMember implements Serializable {
        private static final long serialVersionUID = -2120059422821461266L;
        private String memberType;//成员类型 1 账号,2 商户,3 部门
        private String member;//成员成员
        private String talkLevel;//优先级 1 高,2 中,3 低
        private String power;//权限 All 完全控制,Talk 讲,Listen 听
        private String unDisturb;//免打扰 1 是,2 否
        private String joinTime;//加入时间
        private String isPpt;//
        private String name;//姓名
        private String icon;
        private String account;

        private String talkOnlineStatus;// 成员会场内在线状态 Y:在线 N:不在线


        public GroupMember() {
        }

        public String getIcon() {
            return icon;
        }

        public void setIcon(String icon) {
            this.icon = icon;
        }

        public String getMemberType() {
            return memberType;
        }

        public void setMemberType(String memberType) {
            this.memberType = memberType;
        }

        public String getMember() {
            return member;
        }

        public void setMember(String member) {
            this.member = member;
        }

        public String getTalkLevel() {
            return talkLevel;
        }

        public void setTalkLevel(String talkLevel) {
            this.talkLevel = talkLevel;
        }

        public String getPower() {
            return power;
        }

        public void setPower(String power) {
            this.power = power;
        }

        public String getUnDisturb() {
            return unDisturb;
        }

        public void setUnDisturb(String unDisturb) {
            this.unDisturb = unDisturb;
        }

        public String getJoinTime() {
            return joinTime;
        }

        public void setJoinTime(String joinTime) {
            this.joinTime = joinTime;
        }

        public String getIsPpt() {
            return isPpt;
        }

        public void setIsPpt(String isPpt) {
            this.isPpt = isPpt;
        }

        public String getTalkOnlineStatus() {
            return talkOnlineStatus;
        }

        public void setTalkOnlineStatus(String talkOnlineStatus) {
            this.talkOnlineStatus = talkOnlineStatus;
        }


        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getAccount() {
            return account;
        }

        public void setAccount(String account) {
            this.account = account;
        }
    }

    public List<GroupData> getData() {
        return data;
    }

    public void setData(List<GroupData> data) {
        this.data = data;
    }

    @Override
    public String toString() {
        return "GroupList{" +
                "result='" + result + '\'' +
                ", data=" + data +
                '}';
    }
}
