package com.xdja.poc.sdk.business;

import android.bluetooth.le.AdvertiseData;
import android.util.Log;

/**
 * @author ChengGaoAng
 * @time 2020/9/8 9:06
 * @des
 */
public class AddressPortMap {

    public String srcIp;
    public String srcPort;
    public long srcPortMin;
    public long srcPortMax;

    public String desIp;
    public String desPort;
    public long dstPortMin;
    public long dstPortMax;


    public AddressPortMap(String srcIp, String srcPort, String desIp, String desPort){
        this.srcIp = srcIp;
        this.srcPort = srcPort;
        this.desIp = desIp;
        this.desPort = desPort;

        if (srcPort.contains("-")){
            String[] ports = srcPort.split("-");
            if (ports.length == 2) {
                srcPortMin = Integer.valueOf(ports[0]);
                srcPortMax = Integer.valueOf(ports[1]);
            }
        }else{
            this.srcPortMin = Integer.valueOf(srcPort);
            this.srcPortMax = Integer.valueOf(srcPort);
        }
    }

    //for 陕西省厅地址替换
    static AddressPortMap gloablePortMap[] = {
            new AddressPortMap("10.172.25.133", "8188", "192.168.20.39", "11009"),
            new AddressPortMap("10.172.25.133", "8189", "192.168.20.39", "11010"),
            new AddressPortMap("10.172.25.133", "8190", "192.168.20.39", "11011"),
            new AddressPortMap("10.172.25.133", "8090", "192.168.20.39", "11012"),
            new AddressPortMap("10.172.25.133", "5555", "192.168.20.39", "11006"),
            new AddressPortMap("10.172.25.133", "30000-30199", "192.168.20.39", "30000-30199")
    };
    //end

    public static AvailableIp findIpAndPort(String srcIp, String srcPort){
        AvailableIp availableIp = new AvailableIp();
        availableIp.desIp = "";
        availableIp.desPort = "";

        for (AddressPortMap item : gloablePortMap){
            if (srcIp.equals(item.srcIp) &&
                srcPort.equals(item.srcPort)){
                availableIp.desIp = item.desIp;
                availableIp.desPort = item.desPort;
                Log.i(AddressPortMap.class.getName(), "IP:"+availableIp.desIp+", port:"+availableIp.desPort);
                return availableIp;
            }
            if (item.srcPort.contains("-")) {
                long port = Integer.valueOf(srcPort);
                if (port >= item.srcPortMin && port <= item.srcPortMax) {
                    availableIp.desIp = item.desIp;
                    availableIp.desPort = srcPort;
                    return availableIp;
                }
            }
        }

        return null;
    }

    public  static class AvailableIp{
        public String desIp;
        public String desPort;
    }
}
