package com.xdja.poc.sdk.business.webrtc.janusclientapi;

import android.content.Context;
import android.os.AsyncTask;
import android.util.Log;

import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.sdk.business.AddressPortMap;
import com.xdja.poc.sdk.business.webrtc.apprtc.AppRTCClient;
import com.xdja.poc.sdk.business.webrtc.apprtc.PeerConnectionClient;
import com.xdja.poc.sdk.utils.IPHost;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.webrtc.Camera1Enumerator;
import org.webrtc.CameraEnumerator;
import org.webrtc.EglBase;
import org.webrtc.IceCandidate;
import org.webrtc.Logging;
import org.webrtc.MediaStream;
import org.webrtc.PeerConnection;
import org.webrtc.PeerConnectionFactory;
import org.webrtc.SessionDescription;
import org.webrtc.StatsReport;
import org.webrtc.VideoCapturer;
import org.webrtc.VideoSink;

import java.lang.ref.WeakReference;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;


/**
 * Created by ben.trent on 6/25/2015.
 */
@SuppressWarnings("ALL")
public class JanusPluginHandleWithWebrtc implements AppRTCClient.SignalingEvents,
        PeerConnectionClient.PeerConnectionEvents {

    public static String TAG = "JanusPluginHandle";
    private volatile PeerConnectionClient peerConnectionClient;
    private volatile boolean started = false;
    private volatile boolean userStop = false;
    private MediaStream myStream = null;
    private MediaStream remoteStream = null;
    String localSdp = null;
    String localSdpType = null;
    private boolean trickle = true;
    private boolean iceDone = false;
    private volatile boolean sdpSent = false;
    private int ice_candidate = 0;

    @Override
    public void onConnectedToRoom(AppRTCClient.SignalingParameters params) {

    }

    @Override
    public void onRemoteDescription(SessionDescription sdp) {

    }

    @Override
    public void onRemoteIceCandidate(IceCandidate candidate) {

    }

    @Override
    public void onRemoteIceCandidatesRemoved(IceCandidate[] candidates) {

    }

    @Override
    public void onChannelClose() {

    }

    @Override
    public void onChannelError(String description) {

    }

    @Override
    public void onLocalDescription(SessionDescription sdp) {

        Log.v(TAG, "On onLocalDescription  sdp :" + sdp.description);
        onLocalSdp(sdp, mCallbacks);
    }

    @Override
    public void onSetRemoteDescriptionSuccess() {
        if (localSdp == null) {
            createSdpInternal(mCallbacks, false);
        }
    }

    int candidateNum = 0;
    List<IceCandidate> localIceCandidates = new ArrayList<>();

    List<IceCandidate> remoteIceCandidatelist = new ArrayList<>();
    SessionDescription remoteSdp = null;

    @Override
    public void onIceCandidate(IceCandidate candidate) {

        Log.i(TAG, "Ice Gathering:" + candidate.toString());
        //a=candidate:1 1 udp 2013266431 11.12.115.200 52215 typ host\r\na=candidate:4 1 udp 1006633215 11.12.115.200 62679 typ relay raddr 11.12.115.200 rport 52215\r\na=end-of-candidates\r\n"
//        if(!trickle) {
//            sendSdp(mCallbacks);
//        } else {
//            sendTrickleCandidate(candidate);
//        }
        sendTrickleCandidate(candidate);
//        localIceCandidates.add(candidate);
        //if (++candidateNum == candidate.networkNums)
        {
            iceDone = true;

//            if (localSdp != null && localIceCandidates.size() > 0){
//                StringBuffer sb = new StringBuffer(localSdp);
//
//                for (IceCandidate temp:localIceCandidates){
//                    sb.append("a=");
//                    sb.append(temp.sdp);
//                    sb.append("\r\n");
//                }
//                sb.append("a=end-of-candidates");
//                sb.append("\r\n");
//                localSdp = sb.toString();
//            }
            sendSdp(mCallbacks);

//            for (IceCandidate temp : remoteIceCandidatelist) {
//                peerConnectionClient.addRemoteIceCandidate(temp);
//            }
        }
    }

    @Override
    public void onIceCandidatesRemoved(IceCandidate[] candidates) {

    }

    @Override
    public void onIceConnected() {

        Log.i(TAG, "onIceConnected Success");
        if (callbacks != null) {
            callbacks.onDataOpen(null);
        }
    }

    @Override
    public void onIceDisconnected() {
        //当前频道讲话通道断开的回调
        Log.i(TAG, "onIceDisconnected Success");
        if (callbacks != null) {
            if (userStop) {
                callbacks.onCleanup();
            } else {
                callbacks.onCallbackError("ICE connection failed");
            }
        }
    }

    @Override
    public void onPeerConnectionClosed() {

        Log.i(TAG, "onPeerConnectionClosed Success");
        if (callbacks != null) {
            callbacks.onCleanup();
        }
    }

    @Override
    public void onPeerConnectionStatsReady(StatsReport[] reports) {

    }

    @Override
    public void onPeerConnectionError(String description) {
        if (callbacks != null) {
            callbacks.onCallbackError("connection failed");
        }
    }

    @Override
    public void onDataChannelRcvData(String rcv) {

        JSONObject obj;
        try {
            obj = new JSONObject(rcv);
            if (callbacks != null) {
                callbacks.onData(obj);
            }
        } catch (JSONException e) {
            e.printStackTrace();
        }
    }


    public void pause() {

        if (peerConnectionClient != null) {
//            peerConnectionClient.stopVideoSource();
        }
    }

    public void resume() {
        if (peerConnectionClient != null) {
//            peerConnectionClient.startVideoSource();
        }
    }

    private final JanusServer server;
    public final JanusSupportedPluginPackages plugin;
    public final BigInteger id;
    private final IJanusPluginCallbacks callbacks;
    private boolean bOfferFlag;

    private static class AsyncPrepareWebRtc extends AsyncTask<IPluginHandleWebRTCCallbacks, Void, Void> {
        private final WeakReference<JanusPluginHandleWithWebrtc> janusPluginHandleWithWebrtcWeakReference;
        public AsyncPrepareWebRtc(JanusPluginHandleWithWebrtc janusPluginHandleWithWebrtc, boolean offerFlg) {
            janusPluginHandleWithWebrtcWeakReference= new WeakReference<>(janusPluginHandleWithWebrtc);
            janusPluginHandleWithWebrtc.bOfferFlag = offerFlg;
        }

        @Override
        protected Void doInBackground(IPluginHandleWebRTCCallbacks... params) {
            if(janusPluginHandleWithWebrtcWeakReference.get() != null){
                JanusPluginHandleWithWebrtc pluginHandleWithWebrtc= janusPluginHandleWithWebrtcWeakReference.get();
                IPluginHandleWebRTCCallbacks cb = params[0];
                pluginHandleWithWebrtc.prepareWebRtc(cb, pluginHandleWithWebrtc.bOfferFlag);
            }

            return null;
        }

        @Override
        protected void onPostExecute(Void aVoid) {
            super.onPostExecute(aVoid);
            LogUtils.ELog("AsyncPrepareWebRtc", "cancel");
            try {
                this.cancel(true);
            } catch (Exception e) {
                LogUtils.ELog(e);
            }
        }
    }

    private static class AsyncHandleRemoteJsep extends AsyncTask<IPluginHandleWebRTCCallbacks, Void, Void> {
        private final WeakReference<JanusPluginHandleWithWebrtc> webrtcWeakReference;

        public AsyncHandleRemoteJsep(JanusPluginHandleWithWebrtc janusPluginHandleWithWebrtc) {
            webrtcWeakReference = new WeakReference<>(janusPluginHandleWithWebrtc);
        }

        @Override
        protected Void doInBackground(IPluginHandleWebRTCCallbacks... params) {
            if(webrtcWeakReference.get() != null){
                JanusPluginHandleWithWebrtc janusPluginHandleWithWebrtc = webrtcWeakReference.get();
                IPluginHandleWebRTCCallbacks webrtcCallbacks = params[0];
                if (janusPluginHandleWithWebrtc.peerConnectionClient == null) {
                    webrtcCallbacks.onCallbackError("WebRtc PeerFactory is not initialized. Please call initializeMediaContext");
                    return null;
                }
                JSONObject jsep = webrtcCallbacks.getJsep();
                if (jsep != null) {
                    try {

                        String sdpString = jsep.getString("sdp");
                        Log.i(TAG, "sdpString:" + sdpString);
                        SessionDescription.Type type = SessionDescription.Type.fromCanonicalForm(jsep.getString("type"));
                        SessionDescription sdp = new SessionDescription(type, sdpString);
                        janusPluginHandleWithWebrtc.peerConnectionClient.setRemoteDescription(sdp);
                    } catch (JSONException ex) {
                        Log.i(TAG, ex.getMessage());
                        webrtcCallbacks.onCallbackError(ex.getMessage());
                    }
                }
            }

            return null;
        }

        @Override
        protected void onPostExecute(Void aVoid) {
            super.onPostExecute(aVoid);
            LogUtils.ELog("AsyncHandleRemoteJsep", "cancel");
            try {
                this.cancel(true);
            } catch (Exception e) {
                LogUtils.ELog(e);
            }
        }
    }

    private VideoCapturer createCameraCapturer(CameraEnumerator enumerator) {
        final String[] deviceNames = enumerator.getDeviceNames();

        // First, try to find front facing camera
        Logging.d(TAG, "Looking for front facing cameras.");
        for (String deviceName : deviceNames) {
            if (enumerator.isFrontFacing(deviceName)) {
                Logging.d(TAG, "Creating front facing camera capturer.");
                VideoCapturer videoCapturer = enumerator.createCapturer(deviceName, null);

                if (videoCapturer != null) {
                    return videoCapturer;
                }
            }
        }

        // Front facing camera not found, try something else
        Logging.d(TAG, "Looking for other cameras.");
        for (String deviceName : deviceNames) {
            if (!enumerator.isFrontFacing(deviceName)) {
                Logging.d(TAG, "Creating other camera capturer.");
                VideoCapturer videoCapturer = enumerator.createCapturer(deviceName, null);

                if (videoCapturer != null) {
                    return videoCapturer;
                }
            }
        }

        return null;
    }


    private LinkedList<PeerConnection.IceServer> iceServersFromPCConfigJSON() {
        try {
            //final String iceServer = "{\"iceServers\":[{\"urls\": \"stun:192.168.105.169\"}, {\"credential\": \"1234\", \"urls\": \"turn:xdja@192.168.105.169\"}]}";
//		final String iceServer = "{\"iceServers\": [{\"urls\": \"stun:11.12.112.12\"}, {\"urls\": \"turn:gbc@11.12.112.12\", \"credential\": \"1234\"}]}";
//            final String iceServer_1 = "{\"iceServers\": [{\"urls\": \"stun:11.12.112.10\"}, {\"urls\": \"turn:xdja@11.12.112.10\", \"credential\": \"1234\"}]}";
//            final String iceServer_2 = "{\"iceServers\": [{\"urls\": \"stun:122.114.93.51\"}, {\"urls\": \"turn:xdja@122.114.93.51\", \"credential\": \"1234\"}]}";
            //final String iceServer = "{\"iceServers\": [{\"urls\": \"stun:11.12.115.200\"}, {\"urls\": \"turn:xdja@11.12.115.200\", \"credential\": \"1234\"}]}";
            //122.114.93.51

            String stunServer = IPHost.getStunServer();
            String stunUrl = IPHost.getStunUrls();
            final String iceServer = "{\"iceServers\": [{\"urls\": \"" + stunServer + "\"}, {\"urls\": \"" + stunUrl + "\", \"credential\": \"1234\"}]}";

            Log.i(TAG, "iceServer:" + iceServer);
            JSONObject json = new JSONObject(iceServer);
            JSONArray servers = json.getJSONArray("iceServers");
            LinkedList<PeerConnection.IceServer> ret = new LinkedList<>();
            for (int i = 0; i < servers.length(); ++i) {
                JSONObject server = servers.getJSONObject(i);
                Log.i(TAG, "server:" + server.toString());
                String url = server.getString("urls");
                String credential = server.has("credential") ? server.getString("credential") : "";
                PeerConnection.IceServer turnServer =
                        PeerConnection.IceServer.builder(url)
                                .setPassword(credential)
                                .createIceServer();
                ret.add(turnServer);
            }
            return ret;
        } catch (Exception ex) {
            Log.e(TAG, "ex:" + ex.getMessage());
        }
        return new LinkedList<>();
    }

    VideoSink localVideoSink = null;
    VideoSink remoteVideoSink = null;

    public JanusPluginHandleWithWebrtc(JanusServer server, JanusSupportedPluginPackages plugin, BigInteger handle_id, IJanusPluginCallbacks callbacks,
                                       Context context, PeerConnectionClient.PeerConnectionParameters peerConnectionParameters, VideoSink localVideoSink, VideoSink remoteVideoSink, EglBase eglBase, boolean flag) {
        this.server = server;
        this.plugin = plugin;
        id = handle_id;
        this.callbacks = callbacks;

        this.localVideoSink = localVideoSink;
        this.remoteVideoSink = remoteVideoSink;
        if (flag) {

            // Create peer connection client.
            peerConnectionClient = new PeerConnectionClient(
                    context.getApplicationContext(), eglBase, peerConnectionParameters, this);
            PeerConnectionFactory.Options options = new PeerConnectionFactory.Options();
//        options.disableEncryption = true;
            options.networkIgnoreMask = 16;//Options.ADAPTER_TYPE_LOOPBACK  ;
            peerConnectionClient.createPeerConnectionFactory(options);
        }
    }

    public void onMessage(String msg) {
        try {
            JSONObject obj = new JSONObject(msg);
            callbacks.onMessage(obj, null);
        } catch (JSONException ex) {
            //TODO do we want to notify the GatewayHandler?
        }
    }

    public void onMessage(JSONObject msg, JSONObject jsep) {
        callbacks.onMessage(msg, jsep);
    }

    private void onLocalStream(MediaStream stream) {
        callbacks.onLocalStream(stream);
    }

    private void onRemoteStream(MediaStream stream) {
        callbacks.onRemoteStream(stream);
    }

    public void onDataOpen(Object data) {
        callbacks.onDataOpen(data);
    }

    public void onData(Object data) {
        callbacks.onData(data);
    }

    public void onCleanup() {
        callbacks.onCleanup();
    }

    public void onDetached() {
        callbacks.onDetached();
    }

    public void sendMessage(IPluginHandleSendMessageCallbacks obj) {
        server.sendMessage(TransactionType.plugin_handle_message, id, obj, plugin);
    }

    public void createOffer(IPluginHandleWebRTCCallbacks webrtcCallbacks) {
        if (peerConnectionClient != null) {
            new AsyncPrepareWebRtc(this,true).execute(webrtcCallbacks);
        }
    }

    public void createAnswer(IPluginHandleWebRTCCallbacks webrtcCallbacks) {
        if (peerConnectionClient != null) {
            new AsyncPrepareWebRtc(this, false).execute(webrtcCallbacks);
        }
    }

    public void sendMsgOverDataChannel(String msg) {
        if (peerConnectionClient != null) {
            peerConnectionClient.sendDataWithChannel(msg);
        }
    }

    public void startPlayer(boolean enable) {
        LogUtils.ILog(TAG + ":" + enable);
        if (peerConnectionClient != null) {
            peerConnectionClient.startPlayOut(enable);
        }
    }

    public void mute(boolean enable) {
        if (peerConnectionClient != null) {
            peerConnectionClient.mute(enable);
        }
    }

    public boolean getMuteState() {
        return peerConnectionClient == null || peerConnectionClient.getMuteState();
    }

    public void takenTBCP() {

        if (peerConnectionClient != null) {
            peerConnectionClient.setAudioEnabled(true);
        }
    }

    public void releaseTBCP() {
        if (peerConnectionClient != null) {
            peerConnectionClient.setAudioEnabled(false);
        }
    }

    synchronized private void prepareWebRtc(IPluginHandleWebRTCCallbacks callbacks, boolean bOfferFlg) {
        if (peerConnectionClient == null) {
            return;
        }
        if (callbacks.getMedia().getRecvVideo()) {
            Log.i("VIDEO_ROOM", "Receiving video");
        }
        VideoCapturer videoCapturer = null;
        if (callbacks.getMedia().getSendVideo()) {
            videoCapturer = createCameraCapturer(new Camera1Enumerator(true));
        }

        if (callbacks.getJsep() != null) {
            try {
                JSONObject jsep = callbacks.getJsep();

                String sdpString = jsep.getString("sdp");
                Log.i(TAG, "On jsep  sdp :" + sdpString);
                //a=candidate:1 1 udp 2013266431 11.12.115.200 56477 typ host\r\na=candidate:4 1 udp 1006633215 11.12.115.200 61276 typ relay raddr 11.12.115.200 rport 56477
                if (sdpString.contains("a=candidate")) {
                    final String[] lines = sdpString.split("\r\n");
                    final List<String> codecPayloadTypes = new ArrayList<>();
                    // a=rtpmap:<payload type> <encoding name>/<clock rate> [/<encoding parameters>]
                    int index = 0;
                    for (String line : lines) {
                        if (line.contains("a=candidate:")) {
                            String data = line.substring(2);

                            //陕西省厅地址更换 add
                            String[] candidatas = data.split(" ");
                            String ip = candidatas[4];
                            String port = candidatas[5];
                            AddressPortMap.AvailableIp availableIp = AddressPortMap.findIpAndPort(ip, port);
                            ip = availableIp.desIp;
                            port = availableIp.desPort;

                            Log.i(TAG, "On jsep  ip :" + ip + ", port:"+ port);
                            Log.i(TAG, "old candidatte :" + data);
                            StringBuffer sb = new StringBuffer();
                            for (String item : candidatas){
                                sb.append(item);
                                sb.append(" ");
                            }
                            data = sb.toString();
                            Log.i(TAG, "new candidatte :" + data);
                            //add end

                            try {
                                IceCandidate candidate = new IceCandidate(
                                        "video", index++, data);
                                remoteIceCandidatelist.add(candidate);
                            } catch (Exception ex) {

                            }
                        }
                    }

                }
                SessionDescription.Type type = SessionDescription.Type.fromCanonicalForm(jsep.getString("type"));
                remoteSdp = new SessionDescription(type, sdpString);
            } catch (JSONException ex) {

            }
        }
        trickle = callbacks.getTrickle() != null ? callbacks.getTrickle() : false;
        AppRTCClient.SignalingParameters signalingParameters = new AppRTCClient.SignalingParameters(/*new LinkedList<PeerConnection.IceServer>()*/iceServersFromPCConfigJSON(), bOfferFlg,
                "", "", "", null,
                new ArrayList<>());

        peerConnectionClient.setVideoRecvFlag(callbacks.getMedia().getRecvVideo());
        peerConnectionClient.setAudioRecvFlag(callbacks.getMedia().getRecvAudio());

        //update remote sink
        if (callbacks.getRemoteSink() != null) {
            remoteVideoSink = callbacks.getRemoteSink();
        }
        started = true;

        peerConnectionClient.setAudioCodec(callbacks.getMedia().getAudioCodec());//lyz@xdja.com add

        peerConnectionClient.createPeerConnection(
                localVideoSink, remoteVideoSink, videoCapturer, signalingParameters);

        if (callbacks.getMedia().getSendVideo()) {
            peerConnectionClient.setVideoEnabled(true);
        } else {
            peerConnectionClient.setVideoEnabled(false);
        }
        if (callbacks.getMedia().getSendAudio()) {
            peerConnectionClient.setAudioEnabled(true);
        } else {
            peerConnectionClient.setAudioEnabled(false);
        }
        //defualt set false;
        peerConnectionClient.setAudioEnabled(false);
        peerConnectionClient.startPlayOut(false);//lyz@xdja.com add for tbcp player

        mCallbacks = callbacks;
        if (remoteSdp == null) {
            createSdpInternal(callbacks, true);
        } else {
            //wait candidate end.
            if (remoteSdp != null && remoteIceCandidatelist != null) {
                peerConnectionClient.setRemoteDescription(remoteSdp);
            }
        }
    }


    IPluginHandleWebRTCCallbacks mCallbacks;

    private void createSdpInternal(IPluginHandleWebRTCCallbacks callbacks, Boolean isOffer) {
        mCallbacks = callbacks;
        if (isOffer) {
            peerConnectionClient.createOffer();
        } else {
            peerConnectionClient.createAnswer();
        }
    }

    public void handleRemoteJsep(IPluginHandleWebRTCCallbacks webrtcCallbacks) {
        new AsyncHandleRemoteJsep(this).execute(webrtcCallbacks);
    }

    public synchronized void hangUp() {
        if (!started) {
            return;
        }
        userStop = true;
        started = false;
        if (remoteStream != null) {
            remoteStream.dispose();
            remoteStream = null;
        }
        if (myStream != null) {
            myStream.dispose();
            myStream = null;
        }
        if (peerConnectionClient != null) {
            peerConnectionClient.close();
        }
        peerConnectionClient = null;
        localSdp = null;
        trickle = true;
        iceDone = false;
        sdpSent = false;
    }

    public void detach() {
        hangUp();
        JSONObject obj = new JSONObject();
        server.sendMessage(obj, JanusMessageType.detach, id);
    }

    private void onLocalSdp(SessionDescription sdp, IPluginHandleWebRTCCallbacks callbacks) {
        if (peerConnectionClient != null) {
            if (localSdp == null) {
                localSdp = sdp.description;
                localSdpType = sdp.type.canonicalForm();
            }
            if (!iceDone && !trickle) {
                Log.e(TAG, "onLocalSdp:" + false + ", trickle:" + false);
                return;
            }
            if (sdpSent) {
                return;
            }
            if (localIceCandidates.size() > 0) {
                StringBuilder sb = new StringBuilder(localSdp);

                for (IceCandidate candidate : localIceCandidates) {
                    sb.append("a=");
                    sb.append(candidate.sdp);
                    sb.append("\r\n");
                }
                sb.append("a=end-of-candidates");
                sb.append("\r\n");
                localSdp = sb.toString();
            }
            try {
                sdpSent = true;
                JSONObject obj = new JSONObject();
                obj.put("sdp", localSdp);
                obj.put("type", localSdpType);
                if (null != callbacks) {
                    callbacks.onSuccess(obj);
                }
            } catch (JSONException ex) {
                if (null != callbacks) {
                    callbacks.onCallbackError(ex.getMessage());
                }
            }
        }
    }

    private void sendTrickleCandidate(IceCandidate candidate) {
        try {
            JSONObject message = new JSONObject();
            JSONObject cand = new JSONObject();
            if (candidate == null)
                cand.put("completed", true);
            else {
                cand.put("candidate", candidate.sdp);
                cand.put("sdpMid", candidate.sdpMid);
                cand.put("sdpMLineIndex", candidate.sdpMLineIndex);
            }
            message.put("candidate", cand);

            server.sendMessage(message, JanusMessageType.trickle, id);
        } catch (JSONException ex) {

        }
    }

    private void sendSdp(IPluginHandleWebRTCCallbacks callbacks) {
        if (localSdp != null) {
            if (!sdpSent) {
                sdpSent = true;
                try {
                    JSONObject obj = new JSONObject();
                    obj.put("sdp", localSdp);
                    obj.put("type", localSdpType);
                    if (null != callbacks) {
                        callbacks.onSuccess(obj);
                    }
                } catch (JSONException ex) {
                    if (null != callbacks) {
                        callbacks.onCallbackError(ex.getMessage());
                    }
                }
            }
        }
    }
}
