package com.xdja.poc.sdk.greendao.dao;

import java.util.Map;

import org.greenrobot.greendao.AbstractDao;
import org.greenrobot.greendao.AbstractDaoSession;
import org.greenrobot.greendao.database.Database;
import org.greenrobot.greendao.identityscope.IdentityScopeType;
import org.greenrobot.greendao.internal.DaoConfig;

import com.xdja.poc.sdk.record.RecordMessage;
import com.xdja.poc.sdk.ui.history.POCHistoryMessage;

import com.xdja.poc.sdk.greendao.dao.RecordMessageDao;
import com.xdja.poc.sdk.greendao.dao.POCHistoryMessageDao;

// THIS CODE IS GENERATED BY greenDAO, DO NOT EDIT.

/**
 * {@inheritDoc}
 * 
 * @see org.greenrobot.greendao.AbstractDaoSession
 */
public class DaoSession extends AbstractDaoSession {

    private final DaoConfig recordMessageDaoConfig;
    private final DaoConfig pOCHistoryMessageDaoConfig;

    private final RecordMessageDao recordMessageDao;
    private final POCHistoryMessageDao pOCHistoryMessageDao;

    public DaoSession(Database db, IdentityScopeType type, Map<Class<? extends AbstractDao<?, ?>>, DaoConfig>
            daoConfigMap) {
        super(db);

        recordMessageDaoConfig = daoConfigMap.get(RecordMessageDao.class).clone();
        recordMessageDaoConfig.initIdentityScope(type);

        pOCHistoryMessageDaoConfig = daoConfigMap.get(POCHistoryMessageDao.class).clone();
        pOCHistoryMessageDaoConfig.initIdentityScope(type);

        recordMessageDao = new RecordMessageDao(recordMessageDaoConfig, this);
        pOCHistoryMessageDao = new POCHistoryMessageDao(pOCHistoryMessageDaoConfig, this);

        registerDao(RecordMessage.class, recordMessageDao);
        registerDao(POCHistoryMessage.class, pOCHistoryMessageDao);
    }
    
    public void clear() {
        recordMessageDaoConfig.clearIdentityScope();
        pOCHistoryMessageDaoConfig.clearIdentityScope();
    }

    public RecordMessageDao getRecordMessageDao() {
        return recordMessageDao;
    }

    public POCHistoryMessageDao getPOCHistoryMessageDao() {
        return pOCHistoryMessageDao;
    }

}
