package com.xdja.poc.sdk.record.http;

import android.annotation.SuppressLint;

import com.xdja.net.ssl.CertificateHelper;
import com.xdja.poc.common.utils.GlobalContext;
import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.common.utils.PreferenceHelper;

import java.util.concurrent.TimeUnit;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;

import okhttp3.OkHttpClient;

/**
 * Created by gouhao on 5/28/2018.
 */

@SuppressWarnings("ALL")
public class HttpsClient extends BaseHttpClient {
    private static HttpsUtils.SSLParams sslParams = HttpsUtils.getSslSocketFactory();

    HttpsClient() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.connectTimeout(DEFAULT_HTTP_TIMEOUT, TimeUnit.SECONDS);
        builder.readTimeout(DEFAULT_HTTP_TIMEOUT, TimeUnit.SECONDS);
        builder.writeTimeout(DEFAULT_HTTP_TIMEOUT, TimeUnit.SECONDS);
//        builder.dispatcher(new Dispatcher(ThreadPoolManager.getInstance().getHttpRequestExecutorService()));
        //add https host and certificate verifier
        //生产环境证书 / 项目证书
        boolean isProduct = PreferenceHelper.getBoolean("poc_product", false);
        if (isProduct){
            builder.sslSocketFactory(CertificateHelper.makeSSLSocketFactory(GlobalContext.getContext()));
        }else {
            builder.sslSocketFactory(sslParams.sSLSocketFactory,sslParams.trustManager);
        }

        builder.hostnameVerifier(new HostnameVerifier() {
            @SuppressLint("BadHostnameVerifier")
            @Override
            public boolean verify(String hostname, SSLSession session) {
                // TODO: 2018/5/18 check hostname
                LogUtils.DLog(TAG,"hostname:"+hostname+" session:"+session.toString());
                return true;
            }
        });
        httpClient = builder.build();
    }

    HttpsClient(long timeout) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.connectTimeout(timeout, TimeUnit.SECONDS);
        builder.readTimeout(timeout, TimeUnit.SECONDS);
        builder.writeTimeout(timeout, TimeUnit.SECONDS);
//        builder.dispatcher(new Dispatcher(ThreadPoolManager.getInstance().getHttpRequestExecutorService()));
        //add https host and certificate verifier
        //生产环境证书 / 项目证书
        boolean isProduct = PreferenceHelper.getBoolean("poc_product", false);
        if (isProduct){
            builder.sslSocketFactory(CertificateHelper.makeSSLSocketFactory(GlobalContext.getContext()));
        }else {
            builder.sslSocketFactory(sslParams.sSLSocketFactory,sslParams.trustManager);
        }
        builder.hostnameVerifier(new HostnameVerifier() {
            @SuppressLint("BadHostnameVerifier")
            @Override
            public boolean verify(String hostname, SSLSession session) {
                // TODO: 2018/5/18 check hostname
                LogUtils.DLog(TAG,"hostname:"+hostname+" session:"+session.toString());
                return true;
            }
        });
        httpClient = builder.build();
    }
}
