package com.xdja.poc.sdk.ui.conversion.audioview;

import java.util.LinkedList;

/**
 * PoliceLauncher
 * 功能
 * 描述
 * created by Wwq : 2019/4/1
 */

@SuppressWarnings("ALL")
abstract class ObjectPool<O> {
    private int mCurrentSize = 0;
    private LinkedList<O> mPoolList = new LinkedList();
    private final Object mSync = new Object();

    protected abstract O createNewObject();

    public O getObject() {
        O obj;
        synchronized (this.mSync) {
            if (this.mCurrentSize > 0) {
                obj = this.mPoolList.removeFirst();
                this.mCurrentSize--;
            } else {
                obj = createNewObject();
            }
        }
        return obj;
    }

    public void removeObject(O obj) {
        if (mPoolList != null && mPoolList.size() > 0) {
            this.mPoolList.remove(obj);
            this.mCurrentSize--;
        }
    }

    public void release() {
        synchronized (this.mSync) {
            this.mCurrentSize = 0;
            this.mPoolList.clear();
        }
    }

}
