package com.xdja.poc.sdk.ui.main.holder;

import android.annotation.SuppressLint;
import android.support.annotation.IdRes;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import com.jude.easyrecyclerview.adapter.BaseViewHolder;
import com.xdja.poc.common.utils.StringUtils;
import com.xdja.poc.common.utils.ViewUtils;
import com.xdja.poc.sdk.R;
import com.xdja.poc.common.utils.PreferenceHelper;
import com.xdja.poc.sdk.bean.POCMemberInfo;
import com.xdja.poc.sdk.config.UserConfig;
import com.xdja.poc.sdk.utils.GlideUtils;

/**
 * Created by zhangsen on 2018/9/12.
 */

@SuppressWarnings("ALL")
public class PocConversationSearchHolder extends BaseViewHolder<POCMemberInfo> {
    private TextView mTvName, mTvPart, mTvId;
    private ImageView mImgHeadIcon, mImgIsSelected;
    private View mRelItemRoot;
    private IHolderClickLinstener mListener;

    public PocConversationSearchHolder(ViewGroup itemView, IHolderClickLinstener listener) {
        super(itemView, R.layout.poc_conversation_list_item_layout);
        this.mListener = listener;
        String account = PreferenceHelper.getString(UserConfig.LOGIN_ACCOUNT, "");
        mRelItemRoot = $(R.id.rel_item_root);
        mImgHeadIcon = $(R.id.img_head_icon);
        mTvName = $(R.id.tv_name);
        mTvPart = $(R.id.tv_part);
        mTvId = $(R.id.tv_small_text);
        mImgIsSelected = $(R.id.img_is_select);

    }

    @SuppressLint("SetTextI18n")
    @Override
    public void setData(POCMemberInfo data) {
        super.setData(data);
        if (!StringUtils.isEmpty(data.getIcon())) {
            if (data.isOnLine()) {
                ViewUtils.intoView(getContext(), mImgHeadIcon, R.drawable.poc_icon_default_avatar, GlideUtils.checkImagePath(data.getIcon()));
            } else {
                ViewUtils.intoView(getContext(), mImgHeadIcon, R.drawable.poc_icon_hungup, GlideUtils.checkImagePath(data.getIcon()));
            }
        } else {
            if (data.isOnLine()) {
                mImgHeadIcon.setImageDrawable(getContext().getDrawable(R.drawable.poc_icon_default_avatar));
                mRelItemRoot.setBackground(getContext().getDrawable(R.drawable.poc_list_select_on_bg));
            } else {
                mImgHeadIcon.setImageDrawable(getContext().getDrawable(R.drawable.poc_icon_hungup));
                mRelItemRoot.setBackground(getContext().getDrawable(R.drawable.poc_list_select_off_bg));
//                mRelItemRoot.setBackgroundColor(getContext().getResources().getColor(R.color.poc_conversation_item_selected));
            }
        }
        //}
        mTvName.setText(data.getName());
        if (!TextUtils.isEmpty(data.getDeptName())) {
            mTvPart.setText(data.getDeptName());
            mTvPart.setVisibility(View.VISIBLE);
        } else {
            mTvPart.setVisibility(View.GONE);
        }
        if (!TextUtils.isEmpty(data.getAccount())) {
            mTvId.setText("ID: " + data.getAccount());
        }

        mImgIsSelected.setVisibility(View.INVISIBLE);
//        if (data.getAccount().equals(account) ) {//|| !data.isOnLine()
//            } else {
//                mImgIsSelected.setVisibility(View.VISIBLE);
//            }
//        mImgIsSelected.setOnClickListener(new View.OnClickListener() {
//            @Override
//            public void onClick(View v) {
//                if(mListener!=null){
//                    mListener.OnClick(v.getId(), getAdapterPosition());
//                }
//            }
//        });
        mImgHeadIcon.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (mListener != null)
                    mListener.OnClick(v.getId(), getAdapterPosition());
            }
        });
        if (data.isChecked()) {
            mImgIsSelected.setImageDrawable(getContext().getDrawable(R.drawable.poc_member_selected));
        } else {
            mImgIsSelected.setImageDrawable(getContext().getDrawable(R.drawable.poc_member_noselect));
        }
    }

    public interface IHolderClickLinstener {
        void OnClick(@IdRes int id, int position);
    }

}
