package com.xdja.poc.sdk.ui.main.mvp;

import android.app.Activity;
import android.view.MotionEvent;
import android.view.View;

import com.jude.easyrecyclerview.adapter.RecyclerArrayAdapter;
import com.xdja.poc.sdk.bean.POCMemberInfo;
import com.xdja.poc.sdk.db.entity.DBGroupEntity;
import com.xdja.poc.sdk.event.GroupEvent;
import com.xdja.poc.sdk.event.POCConverationTbcpStatusEvent;
import com.xdja.poc.sdk.event.POCConversationMeIncomeRoom;
import com.xdja.poc.sdk.event.POCConversationUserChangeEvent;
import com.xdja.poc.sdk.event.POCMemberEvent;
import com.xdja.poc.sdk.event.POCSelfLeaveEvent;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Created by zhangsen on 2018/9/28.
 */

@SuppressWarnings("ALL")
public interface POCConversationContract {
    interface IPOCConversationView {
        //设置状态栏显示状态
        void setTalkStatus(String status);

        //频道其他人请求话权成功
        void roomOtherRequestTbcpSuccess(String talkUserid);

        //频道其他人释放话权成功
        void roomOtherReleaseTbcpSuccess();

        //自己请求话权成功
        void roomSelfRequestTbcpSuccess(String talkUserid);

        //自己释放话权成功
        void roomSelfReleaseTbcpSuccess();

        //自己请求话权失败
        void roomSelfRequestTbcpFailed();

        //自己释放话权失败
        void roomSelfReleaseTbcpFailed();

        //设置频道在线人数
        void setOnlineNumerCount(String str);

        void setOnLineCount(int onLineCount, int totalCount);

        //设置频道人员列表数据
        void setAdapterData(List<POCMemberInfo> infos);

        //自己进入频道
        void subscribeSelfEnterRoom();

        //更新频道人员状态
        void updateOnLineMember();

        //频道内人员列表选中的人员
        void setSelectMember(List<POCMemberInfo> selectMember);

        //返回搜索的结果
        void getSearchResult(List<POCMemberInfo> searchData);

        //自己离开频道
        void subscribeSelfLeaveEvent();

        //用户进入或离开的事件
        void subscribeUserChange();

        //对讲内开启新会话
        void startNewConversionActivity(ArrayList<POCMemberInfo> mSelectedMemberList);

        void onMyPause();

        //重置按钮状态
        void resetButton();

        //搜索结果与频道列表的数据状态保持一致,如选中
        void searchNotifyMemberAdapterToUpdate(RecyclerArrayAdapter<POCMemberInfo> mAdapter, POCMemberInfo pocMemberInfo, boolean isChecked);


        void onChangeCallTipStatus(String roomId, String userId);

        void updateMute(DBGroupEntity group);

        void finish();

        void setPttKey(boolean pttStatus);

        void setRoomName(String channelName);

        void setChannelPwd(String channelPwd);

        void setChannelPwdMode(boolean channelPwdMode);

        Map<String, POCMemberInfo> getUserInfos();

        void removeFromCallList(String speakerId, String speakerName);

        void leaveRoom(String speakerName);

        void onConnectTimeOut();

        void showSpeakStatus(String speakerId, String speakerName, int userBehavior);

        void resetReleaseStatus(boolean isReleaseTbcp);

        boolean isExist();
    }

    interface IPOCConversationPersenter {
        void resetAdapter(RecyclerArrayAdapter<POCMemberInfo> madapter);

        //设置频道内点击事件
        void setSelectMemeber(RecyclerArrayAdapter<POCMemberInfo> mAdapter, int position);

        //搜索
        void doSearch(String searchKey, List<POCMemberInfo> data);

        boolean requestTbcp(boolean isForce);

        boolean releaseTbcp();

        //隐藏键盘
        void hideSoftKeyboard(Activity activity, MotionEvent ev);

        //开启按住说话动画
        void startTalkAnimate(View target);

        void releaseTalkAnimate(View target);

        void resetButton(String status);

        //对频道排序
        void sortAdapter(RecyclerArrayAdapter<POCMemberInfo> mMemberInfoAdapter);

        void subscribeRoomTbcpStatusChange(POCConverationTbcpStatusEvent receiverMessage);

        void startNewConversionActivity();

        void subscribeSelfLeaveEvent(POCSelfLeaveEvent selfLeaveEvent);

        void onMyPause();

        void subscribeSelfEnterRoom(POCConversationMeIncomeRoom pocConversationMeIncomeRoom);

        void subscribeUserChange(POCConversationUserChangeEvent event);

        void updateOnLineMember(POCMemberEvent event, List<POCMemberInfo> infos);

        void setAdapterData();

        void netChanged();

        void deleteRoom(DBGroupEntity entity);

        void addMembers(GroupEvent event);

        void updateMemberInfo(DBGroupEntity entity);

        void setUserInfo(Map<String, POCMemberInfo> userInfosCache);

        String generateUserName(String speakerId);

        void handleTimeOut(String roomId);

        void cancelConnectTimeOut();
    }
}
