package com.xdja.poc.sdk.utils;

import android.text.TextUtils;

import com.xdja.poc.sdk.config.GroupConfig;
import com.xdja.poc.sdk.db.entity.DBGroupEntity;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;

/**
 * janus-gateway-android-master
 * 功能
 * 描述
 * created by Wwq : 2018/9/19
 */

public class POCGroupOrderComparator implements Comparator<DBGroupEntity> {
    @Override
    public int compare(DBGroupEntity current, DBGroupEntity another) {
        int top = current.getIsTopStick() ? 1 : 0;
        int anotherTop = another.getIsTopStick() ? 1 : 0;
        if (top > anotherTop) {//若置顶
            return -1;
        } else if (top < anotherTop) {
            return 1;
        } else {
            int currentStatus = current.getStatus() > 0 ? 1 : 0;
            int anotherStatus = another.getStatus() > 0 ? 1 : 0;
            if (currentStatus > anotherStatus) {// 若在线
                return -1;
            } else if (currentStatus < anotherStatus) {
                return 1;
            } else {
                if (current.getGroupType() < another.getGroupType()) {// 若都在线/
                    // 固定 --- 普通 ---临时
                    return -1;
                } else if (current.getGroupType() > another.getGroupType()) {
                    return 1;
                } else {
                    //固定 创建时间倒序
                    if (current.getGroupType() == GroupConfig.GROUP_TYPE_FIXED &&
                            another.getGroupType() == GroupConfig.GROUP_TYPE_FIXED) {
                        return TimeCompare(current.getCreateTime(), another.getCreateTime());
                    }

                    // 字母顺序
                    if (current.getPinyin().equals("#") && !another.getPinyin().equals("#")) {
                        return 1;
                    } else if (!current.getPinyin().equals("#") && another.getPinyin().equals("#")){
                        return -1;
                    } else {
                        return current.getPinyin().compareToIgnoreCase(another.getPinyin());
                    }

//                    if (current.getOnLineCount() > (another.getOnLineCount())) {
//                        return -1;
//                    } else if (current.getOnLineCount() < (another.getOnLineCount())) {
//                        return 1;
//                    } else {
////                        if (current.getRoomName().equals(another.getRoomName())) {// 若名字相同
////                            // 名字一样的情况下id升序
////                            if (current.getOnLineCount() > (another.getOnLineCount())) {
////                                return -1;
////                            }else if (current.getOnLineCount() < (another.getOnLineCount())) {
////                                return 1;
////                            }
////                        }else{
////
////                        }
//                        if (Long.valueOf(current.getRooomId()) > Long.valueOf(current.getRooomId())) {
//                            return -1;
//                        }
//                    }

                }
            }
        }
    }

    /**
     * 时间比较，最新排前面
     * @param time1
     * @param time2
     * @return -1/1
     */
    public int TimeCompare(String time1,String time2) {
        if(TextUtils.isEmpty(time1)){
            return 1;
        }
        if (TextUtils.isEmpty(time2)){
            return -1;
        }
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date date1 = format.parse(time1);
            Date date2 = format.parse(time2);
            return (date1.getTime() - date2.getTime() < 0) ? 1 : -1;
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return -1;
    }


}
