package com.xdja.poc.sdk.utils;

import com.xdja.poc.sdk.POCClient;
import com.xdja.poc.sdk.business.MessageProxy;
import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.common.utils.PreferenceHelper;
import com.xdja.poc.sdk.config.UserConfig;
import com.xdja.poc.sdk.db.entity.User;
/**
 * janus-gateway-android-master
 * 功能
 * 描述
 * created by Wwq : 2018/9/12
 */

@SuppressWarnings("ALL")
public class UserInfoUtils {

    public static void logOut() {
        POCClient.getInstance().unbindFromService();
        //记得清空用户数据
//        PreferenceHelper.setString(UserConfig.LOGIN_ACCOUNT, "");//account 不清除,切换帐户切换
        PreferenceHelper.setString(UserConfig.LOGIN_PWD, "");
        PreferenceHelper.setString(UserConfig.PREF_KEY_TOKEN, "");
        MessageProxy.notifyUserLogOut();
    }
    public static void saveUserInfoMessage(User user){
        try {
            //保存常用的几个值
            PreferenceHelper.setString(UserConfig.PREF_KEY_COMPANY_CODE, user.getCompanyCode());
            PreferenceHelper.setString(UserConfig.LOGIN_ACCOUNT, user.getAccount());
            PreferenceHelper.setString(UserConfig.USER_INFO_NAME, user.getName());
            PreferenceHelper.setString(UserConfig.USER_INFO_ICON, user.getIcon());
            PreferenceHelper.setString(UserConfig.USER_INFO_DEP_CODE, user.getOrgStructure());
        }catch (Exception e){
            LogUtils.ELog("UserInfoUtils","save uerInfo common error");
        }
    }

}
