/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.business;

import android.util.Log;

public class AddressPortMap {
    public String srcIp;
    public String srcPort;
    public long srcPortMin;
    public long srcPortMax;
    public String desIp;
    public String desPort;
    public long dstPortMin;
    public long dstPortMax;
    static AddressPortMap[] gloablePortMap = new AddressPortMap[]{new AddressPortMap("10.172.25.133", "8188", "192.168.20.39", "11009"), new AddressPortMap("10.172.25.133", "8189", "192.168.20.39", "11010"), new AddressPortMap("10.172.25.133", "8190", "192.168.20.39", "11011"), new AddressPortMap("10.172.25.133", "8090", "192.168.20.39", "11012"), new AddressPortMap("10.172.25.133", "5555", "192.168.20.39", "11006"), new AddressPortMap("10.172.25.133", "30000-30199", "192.168.20.39", "30000-30199")};

    public AddressPortMap(String srcIp, String srcPort, String desIp, String desPort) {
        this.srcIp = srcIp;
        this.srcPort = srcPort;
        this.desIp = desIp;
        this.desPort = desPort;
        if (srcPort.contains("-")) {
            String[] ports = srcPort.split("-");
            if (ports.length == 2) {
                this.srcPortMin = Integer.valueOf(ports[0]).intValue();
                this.srcPortMax = Integer.valueOf(ports[1]).intValue();
            }
        } else {
            this.srcPortMin = Integer.valueOf(srcPort).intValue();
            this.srcPortMax = Integer.valueOf(srcPort).intValue();
        }
    }

    public static AvailableIp findIpAndPort(String srcIp, String srcPort) {
        AvailableIp availableIp = new AvailableIp();
        availableIp.desIp = "";
        availableIp.desPort = "";
        for (AddressPortMap item : gloablePortMap) {
            long port;
            if (srcIp.equals(item.srcIp) && srcPort.equals(item.srcPort)) {
                availableIp.desIp = item.desIp;
                availableIp.desPort = item.desPort;
                Log.i((String)AddressPortMap.class.getName(), (String)("IP:" + availableIp.desIp + ", port:" + availableIp.desPort));
                return availableIp;
            }
            if (!item.srcPort.contains("-") || (port = (long)Integer.valueOf(srcPort).intValue()) < item.srcPortMin || port > item.srcPortMax) continue;
            availableIp.desIp = item.desIp;
            availableIp.desPort = srcPort;
            return availableIp;
        }
        return null;
    }

    public static class AvailableIp {
        public String desIp;
        public String desPort;
    }
}

