/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.business.webrtc.apprtc.util;

import android.annotation.SuppressLint;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Scanner;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.X509TrustManager;

public class AsyncHttpURLConnection {
    private static final int HTTP_TIMEOUT_MS = 8000;
    private static final String HTTP_ORIGIN = "http://192.168.105.169:8080";
    private final String method;
    private final String url;
    private final String message;
    private final AsyncHttpEvents events;
    private String contentType;

    public AsyncHttpURLConnection(String method, String url, String message, AsyncHttpEvents events) {
        this.method = method;
        this.url = url;
        this.message = message;
        this.events = events;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void send() {
        Runnable runHttp = new Runnable(){

            @Override
            public void run() {
                AsyncHttpURLConnection.this.sendHttpMessage();
            }
        };
        new Thread(runHttp).start();
    }

    private void sendHttpMessage() {
        try {
            int responseCode;
            HttpURLConnection connection = (HttpURLConnection)new URL(this.url).openConnection();
            byte[] postData = new byte[]{};
            if (this.message != null) {
                postData = this.message.getBytes("UTF-8");
            }
            try {
                if (this.url.startsWith("https")) {
                    HttpsURLConnection httpsURLConnection = (HttpsURLConnection)connection;
                    SSLContext sc = SSLContext.getInstance("SSL");
                    javax.net.ssl.TrustManager[] tm = new TrustManager[]{new TrustManager()};
                    sc.init(null, tm, new SecureRandom());
                    httpsURLConnection.setSSLSocketFactory(sc.getSocketFactory());
                    httpsURLConnection.setHostnameVerifier(new HostnameVerifier(){

                        @Override
                        @SuppressLint(value={"BadHostnameVerifier"})
                        public boolean verify(String hostname, SSLSession session) {
                            return true;
                        }
                    });
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            connection.setRequestMethod(this.method);
            connection.setUseCaches(false);
            connection.setDoInput(true);
            connection.setConnectTimeout(8000);
            connection.setReadTimeout(8000);
            connection.addRequestProperty("origin", HTTP_ORIGIN);
            boolean doOutput = false;
            if (this.method.equals("POST")) {
                doOutput = true;
                connection.setDoOutput(true);
                connection.setFixedLengthStreamingMode(postData.length);
            }
            if (this.contentType == null) {
                connection.setRequestProperty("Content-Type", "text/plain; charset=utf-8");
            } else {
                connection.setRequestProperty("Content-Type", this.contentType);
            }
            if (doOutput && postData.length > 0) {
                OutputStream outStream = connection.getOutputStream();
                outStream.write(postData);
                outStream.close();
            }
            if ((responseCode = connection.getResponseCode()) != 200) {
                this.events.onHttpError("Non-200 response to " + this.method + " to URL: " + this.url + " : " + connection.getHeaderField(null));
                connection.disconnect();
                return;
            }
            InputStream responseStream = connection.getInputStream();
            String response = AsyncHttpURLConnection.drainStream(responseStream);
            responseStream.close();
            connection.disconnect();
            this.events.onHttpComplete(response);
        }
        catch (SocketTimeoutException e) {
            this.events.onHttpError("HTTP " + this.method + " to " + this.url + " timeout");
        }
        catch (IOException e) {
            this.events.onHttpError("HTTP " + this.method + " to " + this.url + " error: " + e.getMessage());
        }
        catch (Exception e) {
            this.events.onHttpError(" error: " + e.getMessage());
        }
    }

    private static String drainStream(InputStream in) {
        Scanner s = new Scanner(in, "UTF-8").useDelimiter("\\A");
        return s.hasNext() ? s.next() : "";
    }

    public static class TrustManager
    implements X509TrustManager {
        @Override
        @SuppressLint(value={"TrustAllX509TrustManager"})
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        @SuppressLint(value={"TrustAllX509TrustManager"})
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }

    public static interface AsyncHttpEvents {
        public void onHttpError(String var1);

        public void onHttpComplete(String var1);
    }
}

