/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.ui.main.fragment;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.support.v4.app.FragmentActivity;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.Html;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.jude.easyrecyclerview.EasyRecyclerView;
import com.jude.easyrecyclerview.adapter.BaseViewHolder;
import com.jude.easyrecyclerview.adapter.RecyclerArrayAdapter;
import com.jude.easyrecyclerview.decoration.DividerDecoration;
import com.xdja.poc.common.base.BaseFragment;
import com.xdja.poc.common.event.NetWorkConnectEvent;
import com.xdja.poc.common.utils.DisplayUtil;
import com.xdja.poc.common.utils.GlobalContext;
import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.common.utils.NetUtils;
import com.xdja.poc.common.utils.PinyinUtil;
import com.xdja.poc.common.utils.PreferenceHelper;
import com.xdja.poc.common.utils.StringUtils;
import com.xdja.poc.common.utils.ToastUtils;
import com.xdja.poc.common.view.ISearchCallBack;
import com.xdja.poc.common.view.SearchEditView;
import com.xdja.poc.common.view.WarningDialog;
import com.xdja.poc.sdk.POCClient;
import com.xdja.poc.sdk.R;
import com.xdja.poc.sdk.bean.POCMemberInfo;
import com.xdja.poc.sdk.business.EventPropxy;
import com.xdja.poc.sdk.business.PocBroadReceiver;
import com.xdja.poc.sdk.config.Constants;
import com.xdja.poc.sdk.config.UserConfig;
import com.xdja.poc.sdk.db.entity.DBGroupEntity;
import com.xdja.poc.sdk.event.ChannelIsExistEvent;
import com.xdja.poc.sdk.event.DimissDialogEvent;
import com.xdja.poc.sdk.event.GroupEvent;
import com.xdja.poc.sdk.event.GroupMemberAddEvent;
import com.xdja.poc.sdk.event.POCCallEvent;
import com.xdja.poc.sdk.event.POCChannelInfoResult;
import com.xdja.poc.sdk.event.POCConverationTbcpStatusEvent;
import com.xdja.poc.sdk.event.POCConversationMeIncomeRoom;
import com.xdja.poc.sdk.event.POCConversationUserChangeEvent;
import com.xdja.poc.sdk.event.POCMemberEvent;
import com.xdja.poc.sdk.event.POCMuteEvent;
import com.xdja.poc.sdk.event.POCSelfLeaveEvent;
import com.xdja.poc.sdk.event.UpdateMemberInfoEvent;
import com.xdja.poc.sdk.event.UpdateUserInfoEvent;
import com.xdja.poc.sdk.manager.AMnager;
import com.xdja.poc.sdk.proxy.IPOCAbstractRoomEventCallBack;
import com.xdja.poc.sdk.proxy.IPOCRecordCallBack;
import com.xdja.poc.sdk.proxy.POCUiKitProxyImpl;
import com.xdja.poc.sdk.ui.conversion.POCConversionActivity;
import com.xdja.poc.sdk.ui.conversion.audioview.AudioEffectPresenter;
import com.xdja.poc.sdk.ui.dialog.ChannelDeletedTipDialog;
import com.xdja.poc.sdk.ui.history.POCHistoryMessageActivity;
import com.xdja.poc.sdk.ui.main.holder.PocConversationSearchHolder;
import com.xdja.poc.sdk.ui.main.holder.PocMemberInfoListHolder;
import com.xdja.poc.sdk.ui.main.mvp.POCConversationContract;
import com.xdja.poc.sdk.ui.main.mvp.POCConversationPersenter;
import com.xdja.poc.sdk.ui.main.mvp.POCGroupListPresenter;
import com.xdja.poc.sdk.utils.GlideUtils;
import com.xdja.poc.sdk.utils.GroupUtils;
import com.xdja.poc.sdk.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

public class POCConversationFragment
extends BaseFragment
implements View.OnClickListener,
POCConversationContract.IPOCConversationView {
    private String TAG = "POCConversationFragment";
    private Context mContext;
    private FragmentActivity activity;
    private String roomId;
    private String mUserId;
    private TextView mTvTalkStatus;
    private TextView mTvPeopleCount;
    private TextView mTvShowPeople;
    private TextView tvSpeanBtnStatus;
    private ImageView mImgHungUp;
    private ImageView mImgCancelPhone;
    private ImageView mImgAnswerPhone;
    private ImageView mImgMute;
    private ImageView mImgServeralCircle;
    private LinearLayout llAddMembers;
    private EasyRecyclerView mRecycleView;
    private ImageView ivForceInsert;
    private SearchEditView mSearchView;
    private View mConsAnswerOrHungupPhone;
    private View mFramePressTalk;
    private ImageView mRelTalkOrEnd;
    private DBGroupEntity group;
    private RecyclerArrayAdapter<POCMemberInfo> mMemberInfoAdapter;
    private RecyclerArrayAdapter<POCMemberInfo> mSearchAdapter;
    private PocConversationSearchHolder mSearchHolder;
    private PocMemberInfoListHolder mMemberHolder;
    private POCConversationPersenter mPocPresenter;
    private IUpdateGroupListener mListener;
    private Map<String, POCMemberInfo> userInfosCache = new HashMap<String, POCMemberInfo>();
    private ChannelDeletedTipDialog roomDestroyDialog;
    private boolean isDialogShowing = false;
    private boolean isForceInsert = false;
    private boolean isOwner = false;
    private boolean isSelfSpeaking = false;
    private boolean isExecuteReleaseTbcp = true;
    private boolean isOnPause = false;
    private AudioEffectPresenter audioEffectPresenter;
    private LinearLayout llAudioAnim;
    private ImageView ivAudioEffect;
    private TextView tvDelayTime;
    private final int DELAY_MAX_INTERVAL = 60;
    private int currentDelayInterval = 60;
    private IPOCAbstractRoomEventCallBack roomEventCallBack = new IPOCAbstractRoomEventCallBack(){

        @Override
        public void onSelfLeaveRoomCallBack(POCSelfLeaveEvent selfLeaveEvent) {
            super.onSelfLeaveRoomCallBack(selfLeaveEvent);
            POCConversationFragment.this.mPocPresenter.subscribeSelfLeaveEvent(selfLeaveEvent);
        }

        @Override
        public void onTBCPEventCallBack(POCConverationTbcpStatusEvent tbcpStatusEvent) {
            super.onTBCPEventCallBack(tbcpStatusEvent);
            POCConversationFragment.this.mPocPresenter.subscribeRoomTbcpStatusChange(tbcpStatusEvent);
        }

        @Override
        public void onMeIncomeRoomCallBack(POCConversationMeIncomeRoom meIncomeRoom) {
            super.onMeIncomeRoomCallBack(meIncomeRoom);
            LogUtils.DLog((String)POCConversationFragment.this.TAG, (String)"onMeIncomeRoomCallBack myself income room.");
            POCConversationFragment.this.mPocPresenter.subscribeSelfEnterRoom(meIncomeRoom);
        }

        @Override
        public void onMemberEventCallBack(POCMemberEvent memberEvent) {
            super.onMemberEventCallBack(memberEvent);
            if (memberEvent.getRoomId().equals(POCConversationFragment.this.group.getRooomId())) {
                LogUtils.DLog((String)"POCListPresenter", (String)("onMemberEventCallBack: " + memberEvent.getUserBehavior()));
                if (memberEvent.getUserBehavior() == 1) {
                    LogUtils.DLog((String)POCConversationFragment.this.TAG, (String)"onMemberEventCallBack: connect success,can talk~~");
                    POCConversationFragment.this.realJoinSuccess();
                } else if (memberEvent.getUserBehavior() == 9000 || memberEvent.getUserBehavior() == 9200) {
                    POCConversationFragment.this.mPocPresenter.cancelConnectTimeOut();
                    LogUtils.DLog((String)POCConversationFragment.this.TAG, (String)"onMemberEventCallBack: removeCallbacks(connectRunnable)");
                    POCConversationFragment.this.canTalk(false);
                    POCConversationFragment.this.reconnectServer();
                    if (memberEvent.getUserBehavior() == 9200) {
                        ToastUtils.showToast((String)POCConversationFragment.this.mContext.getString(R.string.poc_conversation_token_error));
                    }
                    return;
                }
                POCConversationFragment.this.mPocPresenter.updateOnLineMember(memberEvent, POCConversationFragment.this.mMemberInfoAdapter.getAllData());
            }
        }

        @Override
        public void onCreateTempRooomCallBack(DBGroupEntity entity, String channelName, boolean status) {
            super.onCreateTempRooomCallBack(entity, channelName, status);
            if (status) {
                AMnager.startPOCConversionActivity(POCConversationFragment.this.mContext, entity, channelName, -1, false);
            } else {
                ToastUtils.showToast((String)POCConversationFragment.this.getString(R.string.poc_create_temp_failed));
            }
        }

        @Override
        public void onUserChangedCallBack(POCConversationUserChangeEvent userChangeEvent) {
            super.onUserChangedCallBack(userChangeEvent);
            POCConversationFragment.this.mPocPresenter.subscribeUserChange(userChangeEvent);
        }

        @Override
        public void onDeleteServerRoomCallBack(GroupEvent event, boolean status) {
            super.onDeleteServerRoomCallBack(event, status);
            if (!event.getRoomId().equals(POCConversationFragment.this.group.getRooomId())) {
                return;
            }
            try {
                if (!StringUtils.isEmpty((String)event.getFrom()) && event.getFrom().equals(POCConversationFragment.this.mUserId)) {
                    LogUtils.ELog((String)POCConversationFragment.this.TAG, (String)"onDeleteServerRoomCallBack but from is self  and member is self ");
                    POCConversationFragment.this.getActivity().finish();
                } else if (POCConversationFragment.this.isOnPause) {
                    POCConversationFragment.this.getActivity().finish();
                } else {
                    POCConversationFragment.this.showWarningDialog(event.getRoomId(), POCConversationFragment.this.getString(R.string.poc_channel_deleted));
                }
            }
            catch (Exception e) {
                LogUtils.ELog((String)POCConversationFragment.this.TAG, (String)("onDeleteServerRoomCallBack: " + e.getLocalizedMessage()));
            }
        }

        @Override
        public void onRemoveMembersCallBack(GroupEvent event, boolean status) {
            super.onRemoveMembersCallBack(event, status);
            if (event.getRoomId().equals(POCConversationFragment.this.group.getRooomId())) {
                EventBus.getDefault().post((Object)new POCChannelInfoResult(true));
                if (event.getFrom().equals(POCConversationFragment.this.mUserId) && event.getMembers().equals(POCConversationFragment.this.mUserId)) {
                    LogUtils.ELog((String)POCConversationFragment.this.TAG, (String)"onRemoveMembersCallBack but from is self  and member is self ");
                    POCClient.getInstance().removeCacheRoom(POCConversationFragment.this.roomId);
                    POCConversationFragment.this.getActivity().finish();
                } else if (event.getMembers().equals(POCConversationFragment.this.mUserId)) {
                    POCClient.getInstance().removeCacheRoom(POCConversationFragment.this.roomId);
                    if (POCConversationFragment.this.isOnPause) {
                        POCConversationFragment.this.getActivity().finish();
                    }
                    POCConversationFragment.this.showWarningDialog(event.getRoomId(), POCConversationFragment.this.getString(R.string.poc_force_remove_from_channel));
                } else {
                    ((POCConversionActivity)POCConversationFragment.this.getActivity()).removeFromCallList(event.getMembers(), "");
                    POCConversationFragment.this.onMemberRemoved(event.getRoomId(), event.getMembers());
                }
            }
        }

        @Override
        public void onAddMembersCallBack(GroupEvent event, boolean status) {
            super.onAddMembersCallBack(event, status);
            if (event.getRoomId().equals(POCConversationFragment.this.roomId)) {
                String members = event.getMembers();
                Map<String, POCMemberInfo> userInfo = event.getUserInfo();
                ArrayList mList = new ArrayList();
                if (!StringUtils.isEmpty((String)members)) {
                    String[] split = members.split(",");
                    List allData = POCConversationFragment.this.mMemberInfoAdapter.getAllData();
                    ArrayList<POCMemberInfo> memberInfoList = new ArrayList<POCMemberInfo>();
                    Collections.addAll(mList, split);
                    for (String member : split) {
                        boolean isHas = false;
                        for (POCMemberInfo memberInfo : allData) {
                            if (!memberInfo.getAccount().equals(member)) continue;
                            POCConversationFragment.this.userInfosCache = POCUiKitProxyImpl.getInstance().getUserInfosCache();
                            if (POCConversationFragment.this.userInfosCache != null && POCConversationFragment.this.userInfosCache.containsKey(member)) {
                                memberInfo.setName(((POCMemberInfo)POCConversationFragment.this.userInfosCache.get(member)).getName());
                                memberInfo.setIcon(((POCMemberInfo)POCConversationFragment.this.userInfosCache.get(member)).getIcon());
                            }
                            isHas = true;
                            break;
                        }
                        if (isHas) continue;
                        POCMemberInfo info = new POCMemberInfo();
                        info.setAccount(member);
                        POCConversationFragment.this.userInfosCache = POCUiKitProxyImpl.getInstance().getUserInfosCache();
                        if (POCConversationFragment.this.userInfosCache != null && POCConversationFragment.this.userInfosCache.containsKey(member)) {
                            info.setName(((POCMemberInfo)POCConversationFragment.this.userInfosCache.get(member)).getName());
                            info.setIcon(((POCMemberInfo)POCConversationFragment.this.userInfosCache.get(member)).getIcon());
                        } else {
                            if (POCConversationFragment.this.userInfosCache == null) {
                                POCConversationFragment.this.userInfosCache = new HashMap();
                            }
                            if (userInfo != null && userInfo.size() > 0 && userInfo.containsKey(member)) {
                                info.setName(userInfo.get(member).getName());
                                info.setIcon(userInfo.get(member).getIcon());
                            }
                        }
                        info.setMobile(member);
                        info.setRoomId(event.getRoomId());
                        memberInfoList.add(info);
                    }
                    POCConversationFragment.this.mMemberInfoAdapter.addAll(memberInfoList);
                }
                String s = POCClient.getInstance().generateListString(POCConversationFragment.this.mMemberInfoAdapter.getAllData());
                ((POCConversionActivity)POCConversationFragment.this.getActivity()).group.setMemeberIds(s);
                List<String> onLineMemberList = POCClient.getOnLineMemberList(Long.parseLong(POCConversationFragment.this.roomId));
                POCConversationFragment.this.mPocPresenter.refreshAdapter(onLineMemberList == null ? 0 : onLineMemberList.size(), POCConversationFragment.this.mMemberInfoAdapter.getAllData());
                ArrayList<String> mTemp = new ArrayList<String>();
                block2: for (POCMemberInfo info : POCConversationFragment.this.mMemberInfoAdapter.getAllData()) {
                    for (String userId : mList) {
                        if (!info.getAccount().equals(userId)) continue;
                        if (info.isOnLine()) continue block2;
                        mTemp.add(userId);
                        continue block2;
                    }
                }
                ((POCConversionActivity)POCConversationFragment.this.getActivity()).handleCallMessage(true, mTemp, POCConversationFragment.this.group.getRooomId());
            }
        }
    };
    private IPOCRecordCallBack recordCallBack = new IPOCRecordCallBack(){

        @Override
        public void onRecordCompleted(String roomId, String mp3RecordUri) {
            LogUtils.DLog((String)POCConversationFragment.this.TAG, (String)("onRecordCompleted: roomId = " + roomId + " mp3RecordUri = " + mp3RecordUri));
        }

        @Override
        public void onRecordUploadResult(String mp3RecordUri, String fileId, int errorCode) {
            LogUtils.DLog((String)POCConversationFragment.this.TAG, (String)("onRecordUploadResult: fileId = " + fileId + " mp3RecordUri = " + mp3RecordUri + " errorCode =  " + errorCode));
            if (errorCode == Constants.CODE_UPLOAD_FILE_TIME_EXCEPTION) {
                ToastUtils.showToast((String)"\u8bf7\u6821\u9a8c\u60a8\u5f53\u524d\u624b\u673a\u65f6\u95f4");
            }
        }

        @Override
        public void onRecordCommitResult(String mp3RecordUri, int errorCode) {
            LogUtils.DLog((String)POCConversationFragment.this.TAG, (String)("onRecordCommitResult: mp3RecordUri = " + mp3RecordUri + " errorCode =  " + errorCode));
        }
    };
    private POCConversionActivity.ICallBack callBack;
    @SuppressLint(value={"HandlerLeak"})
    private Handler handler = new Handler(){

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            switch (msg.what) {
                case 60: {
                    if (!POCConversationFragment.this.isAdded()) {
                        return;
                    }
                    POCConversationFragment.this.currentDelayInterval--;
                    if (POCConversationFragment.this.currentDelayInterval <= 0) {
                        POCConversationFragment.this.resetParams();
                        POCConversationFragment.this.llAudioAnim.setVisibility(8);
                        assert (POCConversationFragment.this.audioEffectPresenter != null);
                        POCConversationFragment.this.audioEffectPresenter.stop();
                        POCConversationFragment.this.switchShowAudioEffect(false);
                        POCConversationFragment.this.releaseTbcp();
                        return;
                    }
                    POCConversationFragment.this.handler.sendEmptyMessageDelayed(60, 1000L);
                    POCConversationFragment.this.tvDelayTime.setText((CharSequence)POCConversationFragment.this.getResources().getString(R.string.poc_tv_delay_time, new Object[]{POCConversationFragment.this.currentDelayInterval}));
                    break;
                }
                default: {
                    POCConversationFragment.this.handlerOtherEvent();
                }
            }
        }
    };

    public void onAttach(Context context) {
        super.onAttach(context);
        Bundle arguments = this.getArguments();
        this.group = (DBGroupEntity)arguments.getSerializable("DBGroupEntity");
        this.mContext = context;
        this.activity = this.getActivity();
    }

    protected void initView() {
        this.mUserId = PreferenceHelper.getString((String)"login_account", (String)"");
        this.mTvTalkStatus = (TextView)this.$(R.id.text_talk_status);
        this.mTvPeopleCount = (TextView)this.$(R.id.text_people_count);
        this.mTvShowPeople = (TextView)this.$(R.id.tv_show_people);
        TextView tvForceInsert = (TextView)this.$(R.id.tv_poc_force_insert);
        this.llAudioAnim = (LinearLayout)this.$(R.id.ll_audio_anim);
        this.ivAudioEffect = (ImageView)this.$(R.id.wait_result_imageview);
        this.mImgHungUp = (ImageView)this.$(R.id.img_hungup);
        this.mSearchView = (SearchEditView)this.$(R.id.search_edit_view);
        this.mRecycleView = (EasyRecyclerView)this.$(R.id.recycleView_member);
        this.mRelTalkOrEnd = (ImageView)this.$(R.id.img_microphone);
        this.mImgServeralCircle = (ImageView)this.$(R.id.img_several_circle);
        this.mConsAnswerOrHungupPhone = this.$(R.id.cons_answer_or_hungup_phone);
        this.mFramePressTalk = this.$(R.id.rel_talk_and_back_and_mute);
        this.mImgCancelPhone = (ImageView)this.$(R.id.img_hungup_phone);
        this.mImgAnswerPhone = (ImageView)this.$(R.id.img_answer_phone);
        this.llAddMembers = (LinearLayout)this.$(R.id.ll_add_members);
        this.ivForceInsert = (ImageView)this.$(R.id.iv_force_insert);
        this.tvSpeanBtnStatus = (TextView)this.$(R.id.tv_speak_btn_status);
        ImageView ivHistoryAudio = (ImageView)this.$(R.id.iv_audio_history);
        this.mImgMute = (ImageView)this.$(R.id.img_mute);
        this.tvDelayTime = (TextView)this.$(R.id.tv_delay_time);
        this.mSearchView.setSHintText(this.getString(R.string.poc_conversation_input_member_name));
        tvForceInsert.setText((CharSequence)"\u662f\u5426\n\u5f3a\u63d2");
        this.mRecycleView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.mContext));
        DividerDecoration decoration = new DividerDecoration(this.getResources().getColor(R.color.common_item_divider_bg), 1, 0, 0);
        decoration.setDrawLastItem(true);
        this.mRecycleView.addItemDecoration((RecyclerView.ItemDecoration)decoration);
        this.mRecycleView.getRecyclerView().setOverScrollMode(2);
        this.initRecycleView();
        this.initData(this.group);
        if (PreferenceHelper.getBoolean((String)"poc_is_show_history_record_enter", (boolean)true)) {
            ivHistoryAudio.setVisibility(0);
            ivHistoryAudio.setOnClickListener((View.OnClickListener)this);
        }
    }

    private void initRecycleView() {
        this.mSearchAdapter = new RecyclerArrayAdapter<POCMemberInfo>(this.mContext){

            public BaseViewHolder OnCreateViewHolder(ViewGroup parent, int viewType) {
                POCConversationFragment.this.mSearchHolder = new PocConversationSearchHolder(parent, new PocConversationSearchHolder.IHolderClickLinstener(){

                    @Override
                    public void OnClick(int id2, int position) {
                        if (id2 == R.id.img_is_select) {
                            POCConversationFragment.this.mPocPresenter.setSelectMemeber((RecyclerArrayAdapter<POCMemberInfo>)POCConversationFragment.this.mSearchAdapter, position);
                        } else if (id2 == R.id.img_head_icon) {
                            if (position == -1) {
                                return;
                            }
                            POCUiKitProxyImpl.getInstance().notigyUserDetailsClick(POCConversationFragment.this.getActivity(), (POCMemberInfo)POCConversationFragment.this.mSearchAdapter.getAllData().get(position));
                        }
                    }
                });
                return POCConversationFragment.this.mSearchHolder;
            }
        };
        this.mSearchView.addTextChangeWatcher(new ISearchCallBack(){

            public void onStartSearch(String keyWords) {
                POCConversationFragment.this.mPocPresenter.doSearch(keyWords, POCConversationFragment.this.mMemberInfoAdapter.getAllData());
            }

            public void onEndSearch() {
                POCConversationFragment.this.mRecycleView.setEmptyView(R.layout.poc_group_list_empty);
                POCConversationFragment.this.mRecycleView.setAdapter((RecyclerView.Adapter)POCConversationFragment.this.mMemberInfoAdapter);
                POCConversationFragment.this.mMemberInfoAdapter.notifyDataSetChanged();
            }
        });
        this.mMemberInfoAdapter = new RecyclerArrayAdapter<POCMemberInfo>(this.mContext){

            public BaseViewHolder OnCreateViewHolder(ViewGroup parent, int viewType) {
                POCConversationFragment.this.mMemberHolder = new PocMemberInfoListHolder(parent, new PocMemberInfoListHolder.IHolderClickLinstener(){

                    @Override
                    public void OnClick(int id2, int position) {
                        if (id2 == R.id.img_is_select) {
                            POCConversationFragment.this.mPocPresenter.setSelectMemeber((RecyclerArrayAdapter<POCMemberInfo>)POCConversationFragment.this.mMemberInfoAdapter, position);
                        } else if (id2 == R.id.img_head_icon) {
                            if (position == -1) {
                                LogUtils.ELog((String)POCConversationFragment.this.TAG, (String)"click header position=-1");
                                return;
                            }
                            POCUiKitProxyImpl.getInstance().notigyUserDetailsClick(POCConversationFragment.this.getActivity(), (POCMemberInfo)POCConversationFragment.this.mMemberInfoAdapter.getAllData().get(position));
                        }
                    }
                });
                return POCConversationFragment.this.mMemberHolder;
            }
        };
        this.mRecycleView.setAdapter(this.mMemberInfoAdapter);
    }

    public void initData(DBGroupEntity group) {
        this.group = group;
        if (PreferenceHelper.getInt((String)"max_channel_count", (int)-1) <= 1) {
            POCClient.getInstance().leaveAllRoom(this.group.getRooomId());
        }
        try {
            Map<String, String> allSpeakers = POCClient.getAllSpeakers();
            if (allSpeakers != null && allSpeakers.size() > 0) {
                for (String roomId : allSpeakers.keySet()) {
                    String s;
                    if (roomId.equals(group.getRooomId()) || !(s = allSpeakers.get(roomId)).equals(this.mUserId)) continue;
                    POCClient.releaseTBCP(roomId);
                }
            }
        }
        catch (Exception e) {
            LogUtils.ELog((Throwable)e);
        }
        if (group != null) {
            this.isOwner = group.getOwnerId().equals(this.mUserId);
        }
        if (this.mPocPresenter != null) {
            this.mPocPresenter = null;
        }
        this.userInfosCache = POCUiKitProxyImpl.getInstance().getUserInfosCache();
        this.llAddMembers.setVisibility(group.isFixedGroup() ? 8 : 0);
        this.mPocPresenter = new POCConversationPersenter(this, this.mContext, group, this.userInfosCache);
        this.checkPermision(new String[]{"android.permission.RECORD_AUDIO"});
        PocBroadReceiver.registerPushReceiver((Context)this.getActivity());
    }

    private void recoverData(boolean isCreate) {
        if (this.group != null) {
            this.mPocPresenter.setAdapterData();
            this.mImgMute.setSelected(this.group.getIsSilence());
            if (this.group.isFixedGroup()) {
                this.ivForceInsert.setImageResource(R.drawable.poc_insert_un);
            } else if (this.group.getOwnerId().equals(this.mUserId)) {
                this.ivForceInsert.setImageResource(R.drawable.poc_bg_insert_selector);
            } else {
                this.ivForceInsert.setImageResource(R.drawable.poc_insert_un);
            }
            int status = this.group.getStatus();
            LogUtils.DLog((String)this.TAG, (String)("recoverData: group status " + (status == 0 ? "hangup" : (status == 2 ? "busy" : "free"))));
            if (status == 0) {
                this.canTalk(false);
                this.mPocPresenter.handleTimeOut(this.roomId);
                if (isCreate) {
                    this.mTvTalkStatus.setText((CharSequence)this.getString(R.string.poc_conversation_on_connection));
                    if (POCClient.getInstance().wasRemoved(this.group.getRooomId())) {
                        if (this.isOnPause) {
                            this.getActivity().finish();
                        }
                        this.showWarningDialog(this.group.getRooomId(), this.getString(R.string.poc_force_remove_from_channel));
                        return;
                    }
                    LogUtils.DLog((String)this.TAG, (String)"recoverData isCreate is true,connction");
                    POCClient.createRoom(Long.valueOf(this.roomId), "xdja_1234", "xdja_4321", this.mUserId, PreferenceHelper.getString((String)"login_account", (String)""), this.group.getRoomName(), false, false);
                } else {
                    LogUtils.ELog((String)this.TAG, (String)"isCreate is false,is no need reconnect from view");
                }
            } else if (this.group.getStatus() == 2) {
                this.canTalk(false);
                boolean isMute = this.group.getIsSilence();
                this.setMute(isMute, false);
                this.initForceInsertStatus();
                if (POCGroupListPresenter.selfSpeakRoomInfo != null && POCGroupListPresenter.selfSpeakRoomInfo.containsKey(this.roomId)) {
                    this.resetSpeakView(false);
                }
                LogUtils.DLog((String)this.TAG, (String)"recoverData: room is busy");
            } else {
                this.canTalk(true);
                boolean isMute = this.group.getIsSilence();
                this.setMute(isMute, false);
                this.mTvTalkStatus.setText((CharSequence)this.getString(R.string.poc_conversation_talk_status_free));
                this.initForceInsertStatus();
                LogUtils.DLog((String)this.TAG, (String)"recoverData: can talk");
            }
        } else {
            this.mPocPresenter.handleTimeOut(this.roomId);
            LogUtils.ELog((String)this.TAG, (String)"recoverData: group is null");
        }
    }

    private void initForceInsertStatus() {
        this.isForceInsert = POCClient.getInstance().getCacheRoomInsertState(this.roomId);
        LogUtils.DLog((String)this.TAG, (String)("room id " + this.roomId + ",isOwner " + this.isOwner + ",forceInsertStatus " + this.isForceInsert));
        if (this.isOwner && this.isForceInsert) {
            this.ivForceInsert.setSelected(true);
            this.mRelTalkOrEnd.setBackground(GlobalContext.getContext().getDrawable(R.drawable.poc_conversation_press_talk_or_end_selector));
            this.mRelTalkOrEnd.setEnabled(true);
            this.tvSpeanBtnStatus.setText(R.string.poc_start_speak);
        }
    }

    @Override
    public void showSpeakStatus(String speakerId, String speakerName, int userBehavior) {
        if (speakerId != null && speakerId.equals(this.mUserId)) {
            speakerName = "\u60a8";
        }
        this.setTalkStatus(String.format(GlobalContext.getContext().getString(R.string.poc_conversation_talk_status_busy), speakerName));
        if (userBehavior == 2) {
            this.switchShowAudioEffect(false);
        }
    }

    @Override
    public void resetReleaseStatus(boolean isReleaseTbcp) {
        this.isExecuteReleaseTbcp = isReleaseTbcp;
        if (isReleaseTbcp) {
            this.handler.removeCallbacks(null);
            this.handler.removeMessages(1);
        }
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    protected void initEvent() {
        this.mImgHungUp.setOnClickListener((View.OnClickListener)this);
        this.mImgMute.setOnClickListener((View.OnClickListener)this);
        this.llAddMembers.setOnClickListener((View.OnClickListener)this);
        this.ivForceInsert.setOnClickListener((View.OnClickListener)this);
        this.$(R.id.img_back).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                POCConversationFragment.this.activity.onBackPressed();
            }
        });
        this.mRelTalkOrEnd.setOnTouchListener(new View.OnTouchListener(){
            boolean isRelease = true;

            @SuppressLint(value={"ClickableViewAccessibility"})
            public boolean onTouch(View v, MotionEvent event) {
                if (event.getAction() == 0) {
                    if (!POCUiKitProxyImpl.getInstance().isCanTalk()) {
                        String desc = PreferenceHelper.getString((String)"toast_talking_desc", (String)POCConversationFragment.this.getString(R.string.poc_audio_focus_busy));
                        ToastUtils.showToast((String)desc);
                        return false;
                    }
                    this.isRelease = false;
                    return POCConversationFragment.this.takeTbcp();
                }
                if (event.getAction() == 1 || event.getAction() == 3 || event.getAction() == 4) {
                    this.isRelease = true;
                    return POCConversationFragment.this.releaseTbcp();
                }
                if (event.getAction() == 2 && (event.getX() < -30.0f || event.getX() - 30.0f > (float)v.getWidth() || event.getY() < -30.0f || event.getY() - 30.0f > (float)v.getHeight()) && !this.isRelease) {
                    this.isRelease = true;
                    return POCConversationFragment.this.releaseTbcp();
                }
                return false;
            }
        });
        this.mImgCancelPhone.setOnClickListener((View.OnClickListener)this);
        this.mImgAnswerPhone.setOnClickListener((View.OnClickListener)this);
        this.mMemberInfoAdapter.setOnItemLongClickListener(new RecyclerArrayAdapter.OnItemLongClickListener(){

            public boolean onItemLongClick(int position) {
                POCUiKitProxyImpl.getInstance().notifyChannelDetailsItemLongClick((Activity)POCConversationFragment.this.getActivity(), (POCMemberInfo)POCConversationFragment.this.mMemberInfoAdapter.getAllData().get(position), POCConversationFragment.this.group.getOwnerId());
                return true;
            }
        });
        POCUiKitProxyImpl.getInstance().addRoomEventCallBack(this.roomEventCallBack);
        POCClient.registerRecordCallBack(this.recordCallBack);
    }

    private void switchShowAudioEffect(boolean status) {
        if (status) {
            if (this.audioEffectPresenter != null && this.audioEffectPresenter.isRunning()) {
                return;
            }
            this.tvDelayTime.setText((CharSequence)this.getString(R.string.poc_tv_delay_time, new Object[]{this.currentDelayInterval}));
            this.resetParams();
            this.handler.sendEmptyMessageDelayed(60, 1000L);
            this.tvDelayTime.setText((CharSequence)this.getResources().getString(R.string.poc_tv_delay_time, new Object[]{60}));
            this.llAudioAnim.setVisibility(0);
            assert (this.audioEffectPresenter != null);
            this.audioEffectPresenter.start();
        } else {
            this.resetParams();
            this.llAudioAnim.setVisibility(8);
            if (this.audioEffectPresenter == null) {
                return;
            }
            assert (this.audioEffectPresenter != null);
            this.audioEffectPresenter.stop();
        }
    }

    public boolean takeTbcp() {
        if (!this.mRelTalkOrEnd.isEnabled()) {
            LogUtils.DLog((String)"[POC_LOG]", (String)"mRelTalkOrEnd unEnable");
            return false;
        }
        LogUtils.DLog((String)"[POC_LOG]", (String)"zlq MotionEvent.ACTION_DOWN");
        return this.mPocPresenter.requestTbcp(this.isForceInsert);
    }

    public boolean releaseTbcp() {
        LogUtils.DLog((String)"[POC_LOG]", (String)"zlq MotionEvent.ACTION_UP");
        this.mPocPresenter.releaseTalkAnimate((View)this.mImgServeralCircle);
        EventPropxy.postResetChannelStatus(this.group.getRooomId());
        if (GroupUtils.isSelfSpeakButOnlyLisener(this.group.getRooomId())) {
            return false;
        }
        if (POCClient.getAllSpeakers() != null && POCClient.getAllSpeakers().containsKey(this.roomId) && !this.isSelfSpeaking) {
            this.mPocPresenter.setLastCode();
            LogUtils.DLog((String)this.TAG, (String)"releaseTbcp current speak is not self");
            this.handler.removeCallbacks(null);
            this.handler.removeMessages(1);
            this.isExecuteReleaseTbcp = false;
            this.mPocPresenter.bNeedReleaseTBCP = true;
            this.handler.sendEmptyMessageDelayed(1, 500L);
            return false;
        }
        this.handler.sendEmptyMessageDelayed(1, 1000L);
        return this.mPocPresenter.releaseTbcp();
    }

    protected int generateLayout() {
        return R.layout.poc_conversation_fragment;
    }

    public void onClick(View v) {
        int i = v.getId();
        if (i == R.id.img_hungup) {
            final WarningDialog warningDialog = new WarningDialog();
            warningDialog.showWarningDialog(this.mContext, R.string.poc_conversation_is_hung_up, new View.OnClickListener(){

                public void onClick(View v) {
                    warningDialog.dismissDialog();
                }
            }, new View.OnClickListener(){

                public void onClick(View v) {
                    warningDialog.dismissDialog();
                    POCClient.leaveRoom(PreferenceHelper.getString((String)"login_account", (String)""), POCConversationFragment.this.group.getRooomId());
                    POCClient.removeFromReconnectCache(POCConversationFragment.this.group.getRooomId());
                    POCConversationFragment.this.getActivity().finish();
                }
            });
        } else if (i == R.id.img_answer_phone) {
            this.mPocPresenter.startNewConversionActivity();
        } else if (i == R.id.img_hungup_phone) {
            this.mPocPresenter.resetAdapter(this.mMemberInfoAdapter);
            this.mPocPresenter.resetAdapter(this.mSearchAdapter);
            this.mConsAnswerOrHungupPhone.setVisibility(8);
            this.mFramePressTalk.setVisibility(0);
        } else if (i == R.id.img_mute) {
            if (!Utils.isFastClick(500)) {
                return;
            }
            boolean isMute = this.group.getIsSilence();
            this.setMute(!isMute, true);
        } else if (i == R.id.ll_add_members) {
            POCUiKitProxyImpl.getInstance().notifyConversionAddMembers(this.group);
        } else if (i == R.id.iv_force_insert) {
            boolean netAvailable = NetUtils.isNetworkAvailable((Context)this.getActivity());
            if (!netAvailable) {
                ToastUtils.showToast((String)this.getString(R.string.poc_conversation_network_not_available));
                return;
            }
            if (this.group.getOwnerId().equals(this.mUserId) && !this.group.isFixedGroup()) {
                this.isForceInsert = !this.isForceInsert;
                this.ivForceInsert.setSelected(this.isForceInsert);
                POCClient.updateForceInsert(this.group.getRooomId(), this.isForceInsert);
                this.canTalk(true);
                if (this.isSelfSpeaking && !this.isForceInsert) {
                    this.resetSpeakView(false);
                }
            } else {
                ToastUtils.showToast((String)this.getString(R.string.poc_permission_tips));
            }
        } else if (i == R.id.iv_audio_history) {
            POCHistoryMessageActivity.startPOCHistoryMessageActivity((Context)this.getActivity(), this.group);
        }
    }

    @Override
    public void setTalkStatus(String status) {
        this.mTvTalkStatus.setText((CharSequence)status);
        this.ivForceInsert.setSelected(this.isForceInsert);
        if (status.equals(String.format(GlobalContext.getContext().getString(R.string.poc_conversation_talk_status_busy), "\u60a8"))) {
            this.isSelfSpeaking = true;
            if (!this.isExecuteReleaseTbcp) {
                this.isExecuteReleaseTbcp = true;
                this.resetStatus();
                this.mTvTalkStatus.setText((CharSequence)GlobalContext.getContext().getString(R.string.poc_conversation_talk_status_free));
                POCClient.releaseTBCP(this.roomId);
                this.switchShowAudioEffect(false);
                this.handler.sendEmptyMessageDelayed(1, 500L);
                this.switchShowAudioEffect(false);
            } else {
                this.switchShowAudioEffect(true);
            }
        } else {
            this.isSelfSpeaking = false;
            this.switchShowAudioEffect(false);
        }
    }

    @Override
    public void roomOtherRequestTbcpSuccess(String talkUserid) {
        this.mPocPresenter.releaseTalkAnimate((View)this.mImgServeralCircle);
        this.isExecuteReleaseTbcp = true;
        this.canTalk(false);
        boolean isReset = false;
        for (POCMemberInfo info : this.mMemberInfoAdapter.getAllData()) {
            if (info.getAccount().equals(this.mUserId)) {
                info.setOnLine(true);
            }
            if (!info.getAccount().equals(talkUserid) || info.isOnLine()) continue;
            isReset = true;
            info.setOnLine(true);
            break;
        }
        if (isReset) {
            List<String> onLineMemberList = POCClient.getOnLineMemberList(Long.valueOf(this.group.getRooomId()));
            if (onLineMemberList != null) {
                this.setOnLineCount(onLineMemberList.size(), this.mMemberInfoAdapter.getAllData().size());
            }
            this.mPocPresenter.sortAdapter(this.mMemberInfoAdapter);
        }
    }

    @Override
    public void roomOtherReleaseTbcpSuccess() {
        this.mRelTalkOrEnd.setPressed(false);
        this.mPocPresenter.releaseTalkAnimate((View)this.mImgServeralCircle);
        this.isExecuteReleaseTbcp = false;
        this.canTalk(true);
    }

    @Override
    public void roomSelfRequestTbcpSuccess(String talkUserid) {
        this.mRelTalkOrEnd.setPressed(true);
        this.mRelTalkOrEnd.setEnabled(true);
        this.mPocPresenter.startTalkAnimate((View)this.mImgServeralCircle);
    }

    @Override
    public void roomSelfReleaseTbcpSuccess() {
        this.mRelTalkOrEnd.setPressed(false);
        this.mPocPresenter.releaseTalkAnimate((View)this.mImgServeralCircle);
        this.resetButton();
    }

    @Override
    public void roomSelfRequestTbcpFailed() {
        this.mRelTalkOrEnd.setPressed(false);
    }

    @Override
    public void roomSelfReleaseTbcpFailed() {
        this.mRelTalkOrEnd.setPressed(false);
        this.mPocPresenter.releaseTalkAnimate((View)this.mImgServeralCircle);
        this.resetButton();
    }

    @Override
    public void setOnlineNumerCount(String str) {
        this.mTvPeopleCount.setVisibility(8);
    }

    @Override
    public void setOnLineCount(int onLineCount, int totalCount) {
        if (onLineCount > totalCount) {
            onLineCount = totalCount;
        }
        boolean isSelfOnLine = false;
        for (POCMemberInfo memberInfo : this.mMemberInfoAdapter.getAllData()) {
            if (!memberInfo.getAccount().equals(this.mUserId) || !memberInfo.isOnLine()) continue;
            isSelfOnLine = true;
            break;
        }
        if (onLineCount == 0 && isSelfOnLine) {
            onLineCount = 1;
        }
        String memberStatus = "<font color='#808080'>\u53c2\u4e0e\u4eba\u6570</font> <font color='#00bae1'>" + onLineCount + "</font> / <font color='#808080'>" + totalCount + "</font>";
        this.mTvShowPeople.setText((CharSequence)Html.fromHtml((String)memberStatus));
    }

    @Override
    public void setAdapterData(List<POCMemberInfo> infos) {
        this.mMemberInfoAdapter.clear();
        this.mMemberInfoAdapter.addAll(infos);
        this.mMemberInfoAdapter.notifyDataSetChanged();
    }

    @Override
    public void subscribeSelfEnterRoom() {
        for (POCMemberInfo info : this.mMemberInfoAdapter.getAllData()) {
            if (!info.getAccount().equals(this.mUserId)) continue;
            info.setOnLine(true);
            break;
        }
        this.mMemberInfoAdapter.notifyDataSetChanged();
        this.setOnLineCount(1, this.mMemberInfoAdapter.getAllData().size());
        this.canTalk(true);
        this.mPocPresenter.cancelConnectTimeOut();
    }

    @Override
    public void updateOnLineMember() {
        this.mPocPresenter.sortAdapter(this.mMemberInfoAdapter);
        this.setStatus();
        Map<String, String> allSpeakers = POCClient.getAllSpeakers();
        if (allSpeakers != null && allSpeakers.containsKey(this.group.getRooomId())) {
            String speakId = allSpeakers.get(this.group.getRooomId());
            String speakName = this.mPocPresenter.generateUserName(speakId);
            this.showSpeakStatus(speakId, speakName, -1);
        }
    }

    @Override
    public void setSelectMember(List<POCMemberInfo> selectMember) {
        if (selectMember.size() > 0) {
            this.mConsAnswerOrHungupPhone.setVisibility(0);
            this.mFramePressTalk.setVisibility(4);
        } else {
            this.mConsAnswerOrHungupPhone.setVisibility(8);
            this.mFramePressTalk.setVisibility(0);
        }
    }

    @Override
    public void getSearchResult(List<POCMemberInfo> pocGroups) {
        if (pocGroups == null || pocGroups.size() <= 0) {
            this.mRecycleView.setEmptyView(R.layout.poc_search_no_result);
            this.mRecycleView.showEmpty();
        } else {
            this.mRecycleView.setAdapter(this.mSearchAdapter);
            this.mSearchAdapter.clear();
            this.mSearchAdapter.addAll(pocGroups);
        }
    }

    @Override
    public void subscribeSelfLeaveEvent() {
        this.canTalk(false);
        for (POCMemberInfo memberInfo : this.mMemberInfoAdapter.getAllData()) {
            memberInfo.setOnLine(false);
        }
        this.mMemberInfoAdapter.notifyDataSetChanged();
    }

    @Override
    public void startNewConversionActivity(ArrayList<POCMemberInfo> mSelectedMemberList) {
        if (this.mConsAnswerOrHungupPhone.getVisibility() == 0) {
            this.mConsAnswerOrHungupPhone.setVisibility(8);
            this.mFramePressTalk.setVisibility(0);
            if (!TextUtils.isEmpty((CharSequence)this.mSearchView.getEditText().getText().toString())) {
                this.mSearchView.clear();
            }
        }
    }

    @Override
    public void onMyPause() {
        this.mPocPresenter.releaseTalkAnimate((View)this.mImgServeralCircle);
    }

    @Override
    public void subscribeUserChange() {
        this.canTalk(true);
    }

    @Override
    public void searchNotifyMemberAdapterToUpdate(RecyclerArrayAdapter<POCMemberInfo> mAdapter, POCMemberInfo pocMemberInfo, boolean isChecked) {
        this.serachNotifyMemberAdapter(mAdapter, pocMemberInfo, isChecked);
    }

    @Override
    public void onChangeCallTipStatus(String mRoomId, String userId) {
        for (POCMemberInfo memberInfo : this.mMemberInfoAdapter.getAllData()) {
            if (!this.roomId.equals(mRoomId) || !userId.equals(memberInfo.getAccount())) continue;
            memberInfo.setCallTipsStatus(1);
            break;
        }
        this.mMemberInfoAdapter.notifyDataSetChanged();
    }

    @Override
    public void updateMute(DBGroupEntity entity) {
    }

    @Override
    public void finish() {
        this.getActivity().finish();
    }

    @Override
    public void setPttKey(boolean pttStatus) {
        if (this.group != null) {
            this.group.setIsPttKey(pttStatus ? 1 : 0);
        }
        if (this.mListener != null) {
            this.mListener.onPttKey(pttStatus);
        }
    }

    @Override
    public void setRoomName(String channelName) {
        if (this.group != null) {
            this.group.setRoomName(channelName);
        }
        if (this.mListener != null) {
            this.mListener.onUpdateName(channelName);
        }
    }

    @Override
    public void setChannelPwd(String channelPwd) {
        if (this.group != null) {
            this.group.setChannelPwd(channelPwd);
        }
        if (this.mListener != null) {
            this.mListener.onUpdatePwd(channelPwd);
        }
    }

    @Override
    public void setChannelPwdMode(boolean channelPwdMode) {
        if (this.group != null) {
            this.group.setChannelPwdMode(channelPwdMode ? 1 : 0);
        }
        if (this.mListener != null) {
            this.mListener.onUpdatePwdMode(channelPwdMode);
        }
    }

    @Override
    public Map<String, POCMemberInfo> getUserInfos() {
        return this.userInfosCache;
    }

    @Override
    public void removeFromCallList(String speakerId, String speakerName) {
        ((POCConversionActivity)this.getActivity()).removeFromCallList(speakerId, speakerName);
    }

    @Override
    public void leaveRoom(String speakerName) {
        this.isDialogShowing = false;
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onCheckChannelNotExistEvent(ChannelIsExistEvent event) {
        if (event.isExist()) {
            ToastUtils.showToast((String)String.format(GlobalContext.getContext().getString(R.string.poc_conversation_who_has_leave_the_room), event.getSpeakName()));
        }
    }

    @Override
    public void onConnectTimeOut() {
        POCClient.leaveRoom(this.mUserId, this.group.getRooomId());
        if (this.isAdded()) {
            this.getActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    LogUtils.ELog((String)POCConversationFragment.this.TAG, (String)"onConnectTimeOut: 60sec is timeOut finished");
                    POCConversationFragment.this.canTalk(false);
                    POCConversationFragment.this.reconnectServer();
                    POCConversationFragment.this.mPocPresenter.cancelConnectTimeOut();
                }
            });
        }
    }

    @Override
    public void resetButton() {
        this.mPocPresenter.releaseTalkAnimate((View)this.mImgServeralCircle);
        this.canTalk(true);
    }

    protected void switchViewStatus(int status) {
    }

    private void canTalk(boolean enable) {
        Map<String, String> speakIds = POCClient.getAllSpeakers();
        if (enable && speakIds != null && speakIds.containsKey(this.roomId) && !TextUtils.isEmpty((CharSequence)speakIds.get(this.roomId))) {
            enable = false;
        }
        this.resetSpeakView(enable);
        if (this.isOwner && this.isForceInsert) {
            this.resetSpeakView(true);
        }
        if (!this.isNetConnected) {
            this.resetSpeakView(false);
        }
    }

    private void resetSpeakView(boolean enable) {
        if (enable) {
            this.mRelTalkOrEnd.setEnabled(true);
            this.tvSpeanBtnStatus.setText(R.string.poc_start_speak);
            this.mRelTalkOrEnd.setBackground(GlobalContext.getContext().getDrawable(R.drawable.poc_conversation_press_talk_or_end_selector));
        } else {
            this.mRelTalkOrEnd.setEnabled(false);
            this.tvSpeanBtnStatus.setText(R.string.poc_speak_waiting);
            this.mRelTalkOrEnd.setBackground(GlobalContext.getContext().getDrawable(R.drawable.poc_conversation_press_talk_wait));
        }
    }

    private void serachNotifyMemberAdapter(RecyclerArrayAdapter<POCMemberInfo> mAdapter, POCMemberInfo pocMemberInfo, boolean isChecked) {
        if (mAdapter == this.mSearchAdapter) {
            List allData = this.mMemberInfoAdapter.getAllData();
            for (POCMemberInfo info : allData) {
                if (!pocMemberInfo.getId().equals(info.getId())) continue;
                int position = mAdapter.getPosition((Object)info);
                if (position == -1) break;
                ((POCMemberInfo)allData.get(position)).setChecked(isChecked);
                this.mMemberInfoAdapter.notifyItemChanged(position);
                break;
            }
        }
    }

    private void setMute(boolean isMute, boolean showToast) {
        if (isMute) {
            if (showToast) {
                ToastUtils.showToast((String)this.getString(R.string.poc_conversation_is_mute));
            }
            POCClient.muteAndNotifyUI(Long.valueOf(this.roomId), true);
        } else {
            if (showToast) {
                ToastUtils.showToast((String)this.getString(R.string.poc_conversation_no_mute));
            }
            POCClient.muteAndNotifyUI(Long.valueOf(this.roomId), false);
        }
    }

    protected void onNetChanged(NetWorkConnectEvent netWorkConnectEvent) {
        super.onNetChanged(netWorkConnectEvent);
        LogUtils.DLog((String)this.TAG, (String)("janus onNetChanged " + (Boolean)netWorkConnectEvent.getT()));
        if (this.isAdded()) {
            if (!((Boolean)netWorkConnectEvent.getT()).booleanValue()) {
                this.ivForceInsert.setSelected(false);
                this.canTalk(false);
                this.mPocPresenter.releaseTalkAnimate((View)this.mImgServeralCircle);
                this.mTvTalkStatus.setText((CharSequence)this.getString(R.string.poc_conversation_network_interrupt));
                this.setOnLineCount(0, this.mMemberInfoAdapter.getAllData().size());
                for (POCMemberInfo memberInfo : this.mMemberInfoAdapter.getAllData()) {
                    memberInfo.setOnLine(false);
                }
                this.mMemberInfoAdapter.notifyDataSetChanged();
                if (this.mConsAnswerOrHungupPhone.getVisibility() == 0) {
                    this.mConsAnswerOrHungupPhone.setVisibility(8);
                    this.mFramePressTalk.setVisibility(0);
                }
                this.group.setStatus(0);
                this.mPocPresenter.releaseTalkAnimate((View)this.mImgServeralCircle);
                this.switchShowAudioEffect(false);
            } else {
                this.mPocPresenter.netChanged();
                if (this.mConsAnswerOrHungupPhone.getVisibility() == 0) {
                    this.mConsAnswerOrHungupPhone.setVisibility(8);
                    this.mFramePressTalk.setVisibility(0);
                }
            }
        }
    }

    public void dispatchTouchEvent(Activity activity, MotionEvent ev) {
        if (this.mSearchView.getEditText().hasFocus()) {
            this.mPocPresenter.hideSoftKeyboard(activity, ev);
        }
    }

    public void onResume() {
        super.onResume();
        this.isOnPause = false;
        if (!TextUtils.isEmpty((CharSequence)this.mSearchView.getEditText().getText().toString())) {
            this.mSearchView.clear();
        }
    }

    public void onPause() {
        super.onPause();
        this.isOnPause = true;
        this.mPocPresenter.onMyPause();
    }

    public void onDestroy() {
        if (this.audioEffectPresenter != null) {
            this.audioEffectPresenter.release();
        }
        if (this.handler != null) {
            this.handler.removeCallbacks(null);
            this.handler.removeMessages(1);
        }
        super.onDestroy();
        POCUiKitProxyImpl.getInstance().removeRoomEventCallBack(this.roomEventCallBack);
        POCClient.unregisterRecordCallBack(this.recordCallBack);
        this.mPocPresenter.delayCancel(true);
        if (this.isSelfSpeaking && !Constants.isSelfRequestOnOtherDevice) {
            POCClient.releaseTBCP(this.group.getRooomId());
        }
    }

    public static POCConversationFragment newInstance() {
        return new POCConversationFragment();
    }

    private void realJoinSuccess() {
        Map<String, String> map = POCClient.getAllSpeakers();
        if (map != null && map.containsKey(this.group.getRooomId())) {
            this.group.setStatus(2);
            this.mPocPresenter.generateUserName(map.get(this.group.getRooomId()));
            ((POCConversionActivity)this.getActivity()).group.setStatus(this.group.getStatus());
            this.showSpeakStatus(null, this.group.getSpeakerUserName(), -1);
            this.resetSpeakView(this.isOwner && this.isForceInsert);
        } else {
            this.setTalkStatus(GlobalContext.getContext().getString(R.string.poc_conversation_talk_status_free));
            this.resetButton();
            ((POCConversionActivity)this.getActivity()).group.setStatus(this.group.getStatus());
        }
        this.updateOnLineMember();
        this.subscribeSelfEnterRoom();
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onDimissDialogEvent(DimissDialogEvent dimissDialogEvent) {
        if (this.isDialogShowing && this.roomDestroyDialog != null) {
            this.roomDestroyDialog.dismiss();
            this.getActivity().finish();
        }
    }

    public void setCallBack(POCConversionActivity.ICallBack callBack) {
        this.callBack = callBack;
    }

    private void updateChannelName() {
        if (this.callBack != null) {
            this.callBack.onCallBack(this.group);
        }
    }

    private void showWarningDialog(final String roomId, String content) {
        this.isDialogShowing = true;
        if (this.roomDestroyDialog == null) {
            this.roomDestroyDialog = new ChannelDeletedTipDialog((Context)this.getActivity());
            this.roomDestroyDialog.setConfirmClickListener(new ChannelDeletedTipDialog.onConfirmClickListener(){

                @Override
                public void onConfirm() {
                    POCConversationFragment.this.roomDestroyDialog.dismiss();
                    if (POCConversationFragment.this.getActivity().getPackageName().equals("com.xdja.poc")) {
                        AMnager.startPOCMainActivity((Context)POCConversationFragment.this.getActivity(), true, "");
                    }
                    POCClient.getInstance().removeCacheRoom(roomId);
                    POCConversationFragment.this.finish();
                }
            });
        }
        POCClient.removeFromReconnectCache(roomId);
        POCClient.leaveRoom(this.mUserId, roomId);
        POCClient.deleteLocalRoomById(this.mUserId, roomId);
        if (this.roomDestroyDialog.isShowing()) {
            return;
        }
        this.roomDestroyDialog.setCancelable(false);
        this.roomDestroyDialog.setCanceledOnTouchOutside(false);
        this.roomDestroyDialog.showD(content);
    }

    private void onMemberRemoved(String roomId, String members) {
        if (!StringUtils.isEmpty((String)members)) {
            String[] split;
            block0: for (String id2 : split = members.split(",")) {
                for (POCMemberInfo memberInfo : this.mMemberInfoAdapter.getAllData()) {
                    if (!this.roomId.equals(roomId) || !id2.equals(memberInfo.getAccount())) continue;
                    this.mMemberInfoAdapter.remove((Object)memberInfo);
                    continue block0;
                }
            }
            String s = POCClient.getInstance().generateListString(this.mMemberInfoAdapter.getAllData());
            ((POCConversionActivity)this.getActivity()).group.setMemeberIds(s);
            this.mMemberInfoAdapter.notifyDataSetChanged();
            List<String> onLineMemberList = POCClient.getOnLineMemberList(Long.parseLong(roomId));
            this.mPocPresenter.refreshAdapter(onLineMemberList == null ? 0 : onLineMemberList.size(), this.mMemberInfoAdapter.getAllData());
        }
    }

    private void reconnectServer() {
        this.mPocPresenter.releaseTalkAnimate((View)this.mImgServeralCircle);
        this.mTvTalkStatus.setText((CharSequence)this.getString(R.string.poc_conversation_network_interrupt));
        this.setOnLineCount(0, this.mMemberInfoAdapter.getAllData().size());
        for (POCMemberInfo memberInfo : this.mMemberInfoAdapter.getAllData()) {
            memberInfo.setOnLine(false);
        }
        this.mMemberInfoAdapter.notifyDataSetChanged();
        this.switchShowAudioEffect(false);
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onGroupMemberAddEvent(GroupMemberAddEvent addEvent) {
        String[] members = addEvent.getMemberIds();
        String roomId = addEvent.getRoomId();
        if (members != null && members.length > 0) {
            List<POCMemberInfo> pocGroupUserInfos = POCUiKitProxyImpl.getInstance().getPOCGroupUserInfos(members);
            this.mMemberInfoAdapter.addAll(pocGroupUserInfos);
        } else {
            LogUtils.ELog((String)this.TAG, (String)"GroupMemberAddEvent : members is null");
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onPOCMuteEvent(POCMuteEvent event) {
        String roomId = event.getRoomId();
        LogUtils.DLog((String)this.TAG, (String)(" roomId: " + event.getRoomId() + "mute status  : " + event.isSilence()));
        if (roomId.equals(this.group.getRooomId())) {
            boolean silence = event.isSilence();
            this.group.setIsSilence(silence ? 1 : 0);
            this.mImgMute.setSelected(silence);
        }
    }

    public void setUpdateListener(IUpdateGroupListener listener) {
        this.mListener = listener;
    }

    public void resetStatus() {
        this.mPocPresenter.removeTimeoutRunnable("PocBroadReceiver.ROOM_RELEASE_TBCP_SUCCESS");
        this.mPocPresenter.bPeopleTalking = false;
        this.mPocPresenter.resetControlParmeter();
        this.roomSelfReleaseTbcpSuccess();
    }

    public boolean releaseStatus() {
        return this.mPocPresenter.releaseStaus;
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onUpdateMemberInfo(UpdateMemberInfoEvent memberInfoEvent) {
        if (memberInfoEvent.getT() == null) {
            LogUtils.ELog((String)this.TAG, (String)"onUpdateMemberInfo: memberInfoEvent is null");
            return;
        }
        DBGroupEntity entity = (DBGroupEntity)memberInfoEvent.getT();
        if (!entity.getRooomId().equals(this.group.getRooomId())) {
            return;
        }
        if (!memberInfoEvent.isChannelExist()) {
            POCClient.removeFromReconnectCache(entity.getRooomId());
            POCClient.hangUpRoom(entity.getRooomId());
            this.showWarningDialog(entity.getRooomId(), this.getString(R.string.poc_channel_deleted));
            return;
        }
        this.group = entity;
        this.group.setIsSilence(entity.getIsSilence() ? 1 : 0);
        this.setStatus();
        this.updateChannelName();
        List<POCMemberInfo> pocMemberInfos = POCClient.getInstance().generateStringToList(entity.getMemeberIds());
        if (pocMemberInfos == null) {
            return;
        }
        this.mPocPresenter.updateTotalCount(pocMemberInfos.size());
        List<String> onLineMemberList = POCClient.getOnLineMemberList(Long.valueOf(this.group.getRooomId()));
        this.setOnLineCount(onLineMemberList != null ? onLineMemberList.size() : 0, pocMemberInfos.size());
        Iterator<POCMemberInfo> allMemberList = pocMemberInfos.iterator();
        List allData = this.mMemberInfoAdapter.getAllData();
        ArrayList<POCMemberInfo> memberInfoList = new ArrayList<POCMemberInfo>();
        boolean isContainsSelf = false;
        try {
            while (allMemberList.hasNext()) {
                POCMemberInfo next = allMemberList.next();
                boolean isHas = false;
                for (POCMemberInfo info : allData) {
                    if (!next.getAccount().equals(info.getAccount())) continue;
                    isHas = true;
                    memberInfoList.add(info);
                    break;
                }
                if (!isHas) {
                    POCMemberInfo info;
                    next.setOnLine(false);
                    if (onLineMemberList != null && onLineMemberList.size() > 0) {
                        for (String account : onLineMemberList) {
                            if (!next.getAccount().equals(account)) continue;
                            next.setOnLine(true);
                            break;
                        }
                    }
                    if (!StringUtils.isEmpty((String)next.getIcon())) {
                        next.setIcon(GlideUtils.checkImagePath(next.getIcon()));
                    }
                    if (this.userInfosCache != null && this.userInfosCache.containsKey(next.getAccount()) && (info = this.userInfosCache.get(next.getAccount())) != null) {
                        next.setName(info.getName());
                    }
                    memberInfoList.add(next);
                }
                if (!next.getAccount().equals(this.mUserId)) continue;
                isContainsSelf = true;
            }
            if (!isContainsSelf && entity.getRooomId().equals(this.roomId)) {
                POCClient.removeFromReconnectCache(entity.getRooomId());
                POCClient.hangUpRoom(entity.getRooomId());
                this.showWarningDialog(this.group.getRooomId(), this.getString(R.string.poc_force_remove_from_channel));
                return;
            }
            this.mMemberInfoAdapter.clear();
            this.mMemberInfoAdapter.addAll(memberInfoList);
            this.mPocPresenter.sortAdapter(this.mMemberInfoAdapter);
        }
        catch (Exception e) {
            LogUtils.ELog((String)this.TAG, (String)e.getLocalizedMessage());
        }
    }

    protected void onPermissionResult(boolean result) {
        super.onPermissionResult(result);
        if (result) {
            if (this.group != null) {
                this.roomId = this.group.getRooomId();
            }
            LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)this.ivAudioEffect.getLayoutParams();
            int realHeight = (int)((float)DisplayUtil.getScreenHeight((Context)this.getContext()) / this.getContext().getResources().getDisplayMetrics().density);
            params.topMargin = DisplayUtil.dip2px((Context)this.getContext(), (float)(20 * realHeight / 640));
            params.height = DisplayUtil.dip2px((Context)this.getContext(), (float)(260 * realHeight / 640));
            this.audioEffectPresenter = new AudioEffectPresenter((Context)this.getActivity(), this.ivAudioEffect, this.roomId);
            this.audioEffectPresenter.init();
            EventPropxy.postSetPttKey(this.group.getRooomId(), true);
            ArrayList<DBGroupEntity> topics = new ArrayList<DBGroupEntity>();
            topics.add(this.group);
            POCUiKitProxyImpl.getInstance().notifySubscribeTopic(topics);
            this.recoverData(true);
        } else {
            ChannelDeletedTipDialog roomDestroyDialog = new ChannelDeletedTipDialog((Context)this.getActivity());
            roomDestroyDialog.setConfirmClickListener(new ChannelDeletedTipDialog.onConfirmClickListener(){

                @Override
                public void onConfirm() {
                    Intent localIntent = new Intent();
                    localIntent.addFlags(0x10000000);
                    localIntent.setAction("android.settings.APPLICATION_DETAILS_SETTINGS");
                    localIntent.setData(Uri.fromParts((String)"package", (String)POCConversationFragment.this.getActivity().getPackageName(), null));
                    POCConversationFragment.this.startActivity(localIntent);
                    POCConversationFragment.this.getActivity().finish();
                }
            });
            roomDestroyDialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

                public void onDismiss(DialogInterface dialog) {
                    POCConversationFragment.this.getActivity().finish();
                }
            });
            roomDestroyDialog.showD(this.getString(R.string.poc_guide_set_permission));
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onUpdateUserInfoEvent(UpdateUserInfoEvent updateUserInfoEvent) {
        POCMemberInfo memberInfo = (POCMemberInfo)updateUserInfoEvent.getT();
        this.userInfosCache = POCUiKitProxyImpl.getInstance().getUserInfosCache();
        this.mPocPresenter.setUserInfo(this.userInfosCache);
        if (memberInfo != null) {
            List allData = this.mMemberInfoAdapter.getAllData();
            if (allData != null && allData.size() > 0 && !StringUtils.isEmpty((String)memberInfo.getAccount())) {
                for (POCMemberInfo info : allData) {
                    if (!info.getAccount().equals(memberInfo.getAccount())) continue;
                    String name = memberInfo.getName();
                    if (StringUtils.isEmpty((String)name)) {
                        if (this.userInfosCache != null && this.userInfosCache.size() > 0 && this.userInfosCache.containsKey(memberInfo.getAccount())) {
                            name = this.userInfosCache.get(memberInfo.getAccount()).getName();
                        } else {
                            Map<String, POCMemberInfo> map;
                            if (this.userInfosCache == null) {
                                this.userInfosCache = new HashMap<String, POCMemberInfo>();
                            }
                            if (UserConfig.userNameMap != null && UserConfig.userNameMap.size() > 0 && UserConfig.userNameMap.containsKey(this.group.getRooomId()) && (map = UserConfig.userNameMap.get(this.group.getRooomId())) != null && map.size() > 0 && map.containsKey(memberInfo.getAccount())) {
                                POCMemberInfo info1 = map.get(memberInfo.getAccount());
                                name = info1.getName();
                                POCMemberInfo pocMemberInfo = new POCMemberInfo();
                                pocMemberInfo.setAccount(memberInfo.getAccount());
                                pocMemberInfo.setName(name);
                                pocMemberInfo.setIcon(StringUtils.isEmpty((String)info1.getIcon()) ? "" : info1.getIcon());
                                this.userInfosCache.put(memberInfo.getAccount(), pocMemberInfo);
                            }
                        }
                    }
                    info.setName(name);
                    info.setIcon(StringUtils.isEmpty((String)memberInfo.getIcon()) ? info.getIcon() : memberInfo.getIcon());
                    info.setPinyin(PinyinUtil.getPingYin((String)name));
                    break;
                }
                this.mPocPresenter.sortAdapter(this.mMemberInfoAdapter);
            } else {
                LogUtils.ELog((String)this.TAG, (String)"mMemberInfoAdapter data is null");
            }
        } else {
            LogUtils.ELog((String)this.TAG, (String)"onUpdateUserInfoEvent: memberInfo is null ");
        }
    }

    public void setStatus() {
        boolean b = GroupUtils.resetGroupStatus(this.group);
        this.group.setStatus(b ? 1 : 0);
        Map<String, String> map = POCClient.getAllSpeakers();
        if (map != null && map.containsKey(this.group.getRooomId())) {
            this.group.setStatus(2);
            this.mPocPresenter.generateUserName(map.get(this.group.getRooomId()));
        }
        ((POCConversionActivity)this.getActivity()).group.setStatus(this.group.getStatus());
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onPOCCallEvent(POCCallEvent pocCallEvent) {
        Map<String, POCMemberInfo> map;
        String userName = "";
        if (this.userInfosCache != null && this.userInfosCache.size() > 0 && this.userInfosCache.containsKey(pocCallEvent.getUserId())) {
            userName = this.userInfosCache.get(pocCallEvent.getUserId()).getName();
        }
        if (StringUtils.isEmpty((String)userName) && UserConfig.userNameMap != null && UserConfig.userNameMap.size() > 0 && UserConfig.userNameMap.containsKey(this.group.getRooomId()) && (map = UserConfig.userNameMap.get(this.group.getRooomId())) != null && map.size() > 0 && map.containsKey(pocCallEvent.getUserId())) {
            userName = map.get(pocCallEvent.getUserId()).getDeptName();
            this.userInfosCache.put(pocCallEvent.getUserId(), map.get(pocCallEvent.getUserId()));
        }
        if (StringUtils.isEmpty((String)userName)) {
            userName = pocCallEvent.getUserId();
        }
        switch (pocCallEvent.getEventType()) {
            case 0: {
                LogUtils.DLog((String)this.TAG, (String)(userName + this.getString(R.string.poc_user_busy)));
                break;
            }
            case 1: {
                ((POCConversionActivity)this.getActivity()).removeFromCallList(pocCallEvent.getUserId(), userName);
            }
        }
    }

    private void handlerOtherEvent() {
        if (this.isExecuteReleaseTbcp) {
            return;
        }
        if (!this.isAdded()) {
            this.handler.removeMessages(1);
            this.handler.removeCallbacks(null);
            return;
        }
        if (!this.releaseStatus()) {
            LogUtils.DLog((String)this.TAG, (String)"release timeOut ,handle release");
            this.resetStatus();
            Map<String, String> allSpeakers = POCClient.getAllSpeakers();
            if (allSpeakers != null && allSpeakers.containsKey(this.roomId) && !TextUtils.isEmpty((CharSequence)allSpeakers.get(this.roomId))) {
                LogUtils.DLog((String)this.TAG, (String)("release timeOut ,speakId: " + allSpeakers.get(this.roomId)));
                if (allSpeakers.get(this.roomId).equals(this.mUserId)) {
                    this.setTalkStatus(String.format(GlobalContext.getContext().getString(R.string.poc_conversation_talk_status_busy), "\u60a8"));
                }
            } else {
                this.setTalkStatus(GlobalContext.getContext().getString(R.string.poc_conversation_talk_status_free));
                POCClient.releaseTBCP(this.roomId);
            }
            this.handler.removeMessages(1);
            this.handler.removeCallbacks(null);
        }
    }

    private void resetParams() {
        this.handler.removeMessages(60);
        this.currentDelayInterval = 60;
    }

    @Override
    public boolean isExist() {
        return this.isAdded();
    }

    private void showViewState(int state, int onlineCount, String talkState) {
        switch (state) {
            case 3: {
                this.mTvTalkStatus.setText((CharSequence)this.getString(R.string.poc_conversation_on_connection));
                this.setOnLineCount(0, this.mMemberInfoAdapter.getAllData().size());
                this.resetSpeakView(false);
                break;
            }
            case 1: {
                this.mTvTalkStatus.setText((CharSequence)GlobalContext.getContext().getString(R.string.poc_conversation_talk_status_free));
                this.setOnLineCount(onlineCount, this.mMemberInfoAdapter.getAllData().size());
                this.resetSpeakView(true);
                break;
            }
            case 2: {
                this.mTvTalkStatus.setText((CharSequence)talkState);
                this.setOnLineCount(onlineCount, this.mMemberInfoAdapter.getAllData().size());
                this.resetSpeakView(this.isOwner && this.isForceInsert);
                break;
            }
            case 0: {
                this.mTvTalkStatus.setText((CharSequence)this.getString(R.string.poc_conversation_network_interrupt));
                this.setOnLineCount(0, this.mMemberInfoAdapter.getAllData().size());
                this.resetSpeakView(false);
            }
        }
    }

    public static interface IUpdateGroupListener {
        public void onPttKey(boolean var1);

        public void onUpdateName(String var1);

        public void onUpdatePwd(String var1);

        public void onUpdatePwdMode(boolean var1);
    }
}

